/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.listener;

import com.artfess.base.exception.WorkFlowException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.Base64;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.cmd.TaskFinishCmd;
import com.artfess.bpm.api.constant.ActionType;
import com.artfess.bpm.api.constant.InterPoseType;
import com.artfess.bpm.api.constant.MultiInstanceType;
import com.artfess.bpm.api.constant.NodeStatus;
import com.artfess.bpm.api.constant.NodeType;
import com.artfess.bpm.api.constant.OpinionStatus;
import com.artfess.bpm.api.constant.ProcessInstanceStatus;
import com.artfess.bpm.api.constant.TaskType;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.event.NodeNotifyEvent;
import com.artfess.bpm.api.event.NodeNotifyModel;
import com.artfess.bpm.api.event.TaskCompleteEvent;
import com.artfess.bpm.api.model.delegate.BpmDelegateTask;
import com.artfess.bpm.api.model.process.def.BpmProcessDef;
import com.artfess.bpm.api.model.process.def.BpmProcessDefExt;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.task.BpmTask;
import com.artfess.bpm.api.model.process.task.BpmTaskTurn;
import com.artfess.bpm.api.model.process.task.SkipResult;
import com.artfess.bpm.api.service.ActiviService;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.api.service.TaskCommuService;
import com.artfess.bpm.engine.inst.DefaultProcessInstCmd;
import com.artfess.bpm.natapi.inst.NatProInstanceService;
import com.artfess.bpm.natapi.task.NatTaskService;
import com.artfess.bpm.persistence.dao.BpmExeStackExecutorDao;
import com.artfess.bpm.persistence.manager.ActExecutionManager;
import com.artfess.bpm.persistence.manager.BpmCheckOpinionManager;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.manager.BpmExeStackExecutorManager;
import com.artfess.bpm.persistence.manager.BpmExeStackManager;
import com.artfess.bpm.persistence.manager.BpmInterposeRecoredManager;
import com.artfess.bpm.persistence.manager.BpmProStatusManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.manager.BpmTaskCandidateManager;
import com.artfess.bpm.persistence.manager.BpmTaskDueTimeManager;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.bpm.persistence.manager.BpmTaskNoticeManager;
import com.artfess.bpm.persistence.manager.BpmTaskTurnManager;
import com.artfess.bpm.persistence.manager.TaskFollowManager;
import com.artfess.bpm.persistence.model.ActExecution;
import com.artfess.bpm.persistence.model.BpmExeStack;
import com.artfess.bpm.persistence.model.BpmExeStackExecutor;
import com.artfess.bpm.persistence.model.BpmInterposeRecored;
import com.artfess.bpm.persistence.model.BpmTaskDueTime;
import com.artfess.bpm.persistence.model.BpmTaskNotice;
import com.artfess.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.bpm.persistence.model.TaskFollow;
import com.artfess.bpm.persistence.util.BpmStackRelationUtil;
import com.artfess.bpm.persistence.util.ServiceUtil;
import com.artfess.bpm.util.BpmCheckOpinionUtil;
import com.artfess.bpm.util.BpmUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;

@Service
public class TaskCompleteEventListener
implements ApplicationListener<TaskCompleteEvent>,
Ordered {
    @Resource
    ActExecutionManager actExecutionManager;
    @Resource
    NatTaskService natTaskService;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmTaskCandidateManager bpmTaskCandidateManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    BpmProStatusManager bpmProStatusManager;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmTaskTurnManager bpmTaskTurnManager;
    @Resource
    TaskCommuService taskCommuService;
    @Resource
    NatProInstanceService natProInstanceService;
    @Resource
    BpmExeStackManager bpmExeStackManager;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmExeStackExecutorManager bpmExeStackExecutorManager;
    @Resource
    BpmTaskDueTimeManager bpmTaskDueTimeManager;
    @Resource
    SystemConfigFeignService systemConfigFeignService;
    @Resource
    TaskFollowManager taskFollowManager;
    @Resource
    BpmExeStackExecutorDao bpmExeStackExecutorDao;
    @Resource
    ActiviService activiService;

    public int getOrder() {
        return 1;
    }

    public void onApplicationEvent(TaskCompleteEvent event) {
        BpmDelegateTask delegateTask = (BpmDelegateTask)event.getSource();
        String currentNodeId = delegateTask.getTaskDefinitionKey();
        String currentExecutionId = delegateTask.getExecutionId();
        String instId = (String)delegateTask.getVariable("instanceId_");
        TaskFinishCmd cmd = (TaskFinishCmd)ContextThreadUtil.getActionCmd();
        String rejectTargetNodeId = cmd.getDestination();
        NodeStatus nodeStatus = this.getNodeStatus(cmd);
        String bpmnTaskId = cmd.getTaskId();
        DefaultBpmTask bpmTask = this.bpmTaskManager.getByRelateTaskId(bpmnTaskId);
        BpmDelegateTask task = this.natTaskService.getByTaskId(bpmTask.getTaskId());
        if (!task.getExecutionId().equals(bpmTask.getExecId())) {
            bpmTask.setExecId(task.getExecutionId());
            this.bpmTaskManager.update((Model)bpmTask);
        }
        ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
        String skipType = (String)actionCmd.getTransitVars().get("skipType_");
        try {
            this.followTask(cmd, bpmTask.getNodeId());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.delCandidateAndTask(bpmnTaskId);
        try {
            this.updateCheckOpinion(cmd, skipType);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new RuntimeException(e2.getMessage());
        }
        this.updateProcStatus(instId, delegateTask, nodeStatus, actionCmd);
        this.updTaskTurnComplte(cmd.getTaskId());
        this.updTaskCommuComplete(bpmTask.getId());
        this.updStack(bpmTask, actionCmd);
        this.updProcessInstance(cmd);
        BpmNodeDef bpmNodeDef = null;
        try {
            this.updDueTime(bpmTask);
            bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(bpmTask.getProcDefId(), bpmTask.getNodeId());
            if (NodeType.USERTASK.getKey().equals(bpmNodeDef.getType().getKey()) && (BeanUtils.isEmpty((Object)cmd.getTransitVars("IsDoneUnused")) || !((Boolean)cmd.getTransitVars("IsDoneUnused")).booleanValue())) {
                com.artfess.bpm.persistence.util.BpmUtil.autoTrans(bpmNodeDef, instId, bpmTask.getId());
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new WorkFlowException(ExceptionUtils.getRootCauseMessage((Throwable)e1));
        }
        if (actionCmd != null) {
            Object isBackCancelBoject = actionCmd.getTransitVars("isCancleNodePathTask");
            if (isBackCancelBoject != null) {
                Object rejectAfterExecutionId;
                String notIncludeExecuteIds = "";
                ActExecution currentExecution = (ActExecution)this.actExecutionManager.get((Serializable)((Object)currentExecutionId));
                String processInstanceId = delegateTask.getProcessInstanceId();
                Object objToken = this.natProInstanceService.getVariable(currentExecutionId, "token_");
                String currentToken = objToken != null ? objToken.toString() : null;
                boolean isMultiInnerReject = false;
                if (currentToken != null && !StringUtil.isEmpty((String)currentToken) && StringUtil.isNotZeroEmpty((String)currentToken)) {
                    isMultiInnerReject = true;
                    currentExecution = (ActExecution)this.actExecutionManager.get((Serializable)((Object)currentExecution.getParentId()));
                    notIncludeExecuteIds = currentExecutionId + "," + currentExecution.getId();
                    boolean isHaveMultiGateway = false;
                    try {
                        isHaveMultiGateway = BpmStackRelationUtil.isHaveMultiGatewayByBetweenNode(instId, rejectTargetNodeId, currentNodeId);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new WorkFlowException(ExceptionUtils.getRootCauseMessage((Throwable)e));
                    }
                    if (isHaveMultiGateway) {
                        isMultiInnerReject = false;
                        String rejectAfterExecutionId2 = currentExecution.getId();
                        cmd.addTransitVars("rejectAfterExecutionId", rejectAfterExecutionId2);
                    }
                    currentExecution = (ActExecution)this.actExecutionManager.get((Serializable)((Object)currentExecution.getParentId()));
                    notIncludeExecuteIds = notIncludeExecuteIds + "," + currentExecution.getId();
                } else {
                    currentExecution.setParentId(processInstanceId);
                    this.actExecutionManager.update((Model)currentExecution);
                    boolean isHaveGateway = false;
                    try {
                        boolean inGateway;
                        isHaveGateway = BpmStackRelationUtil.isHaveAndOrGateway(instId, currentNodeId, "pre");
                        if (isHaveGateway && (inGateway = this.activiService.inGateway(delegateTask.getBpmnDefId(), currentNodeId, cmd.getDestination()))) {
                            isHaveGateway = false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new WorkFlowException(e.getMessage());
                    }
                    if (isHaveGateway) {
                        String rejectAfterExecutionId3 = currentExecution.getId();
                        cmd.addTransitVars("rejectSingleExecutionId", rejectAfterExecutionId3);
                    }
                }
                String targetNodePath = (String)actionCmd.getTransitVars("targetNodePath") + "%";
                Map<String, BpmNodeDef> betweenNodes = BpmUtil.getDeleteTaskNodes(bpmNodeDef, cmd.getDestination());
                if (notIncludeExecuteIds.equals("")) {
                    notIncludeExecuteIds = currentExecutionId;
                }
                if (!isMultiInnerReject && ((rejectAfterExecutionId = actionCmd.getTransitVars("rejectSingleExecutionId")) == null || StringUtil.isEmpty((String)rejectAfterExecutionId.toString()))) {
                    this.bpmExeStackManager.removeActRuExeCutionByPath(instId, targetNodePath, notIncludeExecuteIds);
                }
                this.bpmExeStackManager.removeBpmTaskCandidateByPath(instId, betweenNodes.keySet());
                this.bpmExeStackManager.removeBpmTaskByPath(instId, betweenNodes.keySet());
                this.handlebpmExeStack(instId, targetNodePath);
                actionCmd.getTransitVars().remove("isCancleNodePathTask");
            } else {
                String handMode;
                String actionName = cmd.getActionName();
                if (StringUtil.isNotEmpty((String)actionName) && ("reject".equals(actionName) || "backToStart".equals(actionName)) && StringUtil.isNotEmpty((String)(handMode = (String)actionCmd.getTransitVars("backHandMode"))) && handMode.equals("direct")) {
                    ActExecution currentExecution = (ActExecution)this.actExecutionManager.get((Serializable)((Object)currentExecutionId));
                    List<BpmNodeDef> listBpmNodeDef = null;
                    try {
                        listBpmNodeDef = BpmStackRelationUtil.getHistoryListBpmNodeDef(instId, currentExecution.getActId(), "pre");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new WorkFlowException(ExceptionUtils.getRootCauseMessage((Throwable)e));
                    }
                    if (BeanUtils.isNotEmpty(listBpmNodeDef) && (listBpmNodeDef.get(0).getType().equals((Object)NodeType.PARALLELGATEWAY) || listBpmNodeDef.get(0).getType().equals((Object)NodeType.INCLUSIVEGATEWAY)) && currentExecution.isConcurrent()) {
                        cmd.addTransitVars("rejectDirectExecutionId", currentExecution.getId());
                        cmd.addTransitVars("rejectDirectParentId", currentExecution.getParentId());
                    }
                }
            }
            this.updateInstanceSubject(bpmTask.getProcInstId(), bpmTask.getNodeId());
            NodeNotifyModel model = new NodeNotifyModel(bpmTask.getProcDefId(), bpmTask.getNodeId());
            model.setTask(task);
            model.setTiming("complete");
            NodeNotifyEvent ev = new NodeNotifyEvent(model);
            AppUtil.publishEvent((ApplicationEvent)ev);
        }
    }

    private void updateInstanceSubject(String instId, String nodeId) {
        try {
            BpmNodeDef startNode;
            DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
            BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(instance.getProcDefId(), nodeId);
            List<BpmNodeDef> incomeNodes = nodeDef.getIncomeNodes();
            if (BeanUtils.isNotEmpty(incomeNodes) && BeanUtils.isNotEmpty((Object)(startNode = this.bpmDefinitionAccessor.getBpmProcessDef(instance.getProcDefId()).getStartEvent()))) {
                boolean fromStart = false;
                for (BpmNodeDef bpmNodeDef : incomeNodes) {
                    if (!startNode.getNodeId().equals(bpmNodeDef.getNodeId())) continue;
                    fromStart = true;
                    break;
                }
                if (fromStart) {
                    ActionCmd cmd = ContextThreadUtil.getActionCmd();
                    if (BeanUtils.isNotEmpty((Object)instance)) {
                        BpmProcessDef<BpmProcessDefExt> bpmDefinition = this.bpmDefinitionAccessor.getBpmProcessDef(instance.getProcDefId());
                        DefaultProcessInstCmd cInstCmd = new DefaultProcessInstCmd();
                        cInstCmd.setFlowKey(instance.getProcDefKey());
                        cInstCmd.setBusData(cmd.getBusData());
                        cInstCmd.setVariables(cmd.getVariables());
                        cInstCmd.putTransitVars(cmd.getTransitVars());
                        cInstCmd.setInstId(instance.getId());
                        cInstCmd.setBusinessKey(instance.getBizKey());
                        String subject = this.bpmProcessInstanceManager.getSubject(bpmDefinition, cInstCmd, instance);
                        instance.setSubject(subject);
                        this.bpmProcessInstanceManager.update((Model)instance);
                        cmd.addTransitVars("processInstance", instance);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkFlowException("\u66f4\u65b0\u5b9e\u4f8b\u6807\u9898\u5931\u8d25\uff1a" + ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private void handlebpmExeStack(String instId, String targetNodePath) {
        this.updateOpinionByPath(instId, targetNodePath);
        TaskFinishCmd cmd = (TaskFinishCmd)ContextThreadUtil.getActionCmd();
        BpmExeStack bpmExeStack = this.bpmExeStackManager.getByInstIdAndTargetNodePath(instId, targetNodePath.replace("%", ""));
        cmd.addTransitVars("parentStack", (Object)bpmExeStack);
        ContextThreadUtil.putCommonVars("parentStack", (Object)bpmExeStack);
        this.bpmExeStackManager.removeHisByInstId(instId);
        this.bpmExeStackManager.removeStackRelationHisByInstId(instId);
        this.bpmExeStackManager.stackRelation2HisInToStackIdOrFormStackId(instId, targetNodePath);
        this.bpmExeStackManager.stack2HisByPath(instId, targetNodePath);
        this.bpmExeStackManager.removeBpmExeStackRelationInToStackId(instId, targetNodePath);
        this.bpmExeStackManager.removeBpmExeStackRelationInFromStackId(instId, targetNodePath);
        this.bpmExeStackManager.removeByPath(instId, targetNodePath);
    }

    private void updateOpinionByPath(String instId, String targetNodePath) {
        List<String> taskIds = this.bpmExeStackExecutorDao.getTaskIdsByInstIdAndTargetNodePath(instId, targetNodePath);
        taskIds.forEach(taskId -> {
            DefaultBpmCheckOpinion checkOpinion = this.bpmCheckOpinionManager.getByTaskId((String)taskId);
            if (BeanUtils.isNotEmpty((Object)checkOpinion)) {
                checkOpinion.setStatus(OpinionStatus.SIGN_BACK_CANCEL.getKey());
                checkOpinion.setCompleteTime(LocalDateTime.now());
                this.bpmCheckOpinionManager.update((Model)checkOpinion);
                this.bpmTaskManager.delByParentId(checkOpinion.getTaskId());
                this.bpmProStatusManager.createOrUpd(instId, checkOpinion.getProcDefId(), checkOpinion.getTaskKey(), checkOpinion.getTaskName(), NodeStatus.SIGN_BACK_CANCLE);
            }
        });
    }

    public void followTask(TaskFinishCmd cmd, String nodeId) throws Exception {
        if (cmd.getActionName().equals("agree") || cmd.getActionName().equals("reject")) {
            QueryFilter build = QueryFilter.build();
            build.addFilter("PRO_INST_", (Object)cmd.getInstId(), QueryOP.EQUAL);
            build.addFilter("TASK_ID", (Object)nodeId, QueryOP.LIKE);
            PageList list = this.taskFollowManager.query(build);
            if (list.getRows().size() > 0) {
                List rows = list.getRows();
                DefaultBpmTask task = (DefaultBpmTask)cmd.getTransitVars("bpmTask_");
                BpmTaskNoticeManager noticeManager = (BpmTaskNoticeManager)AppUtil.getBean(BpmTaskNoticeManager.class);
                for (TaskFollow follow : rows) {
                    BpmTaskNotice taskNotice = new BpmTaskNotice(task.getName(), task.getSubject(), task.getProcInstId(), task.getProcDefId(), task.getProcDefName(), "", "", TaskType.FOLLOW.getKey(), task.getSupportMobile(), "", "", null, task.getId(), null);
                    taskNotice.setId(UniqueIdUtil.getSuid());
                    taskNotice.setTaskId(task.getId());
                    taskNotice.setNodeId(nodeId);
                    if (StringUtil.isNotEmpty((String)follow.getCreatorId())) {
                        String creatorId = follow.getCreatorId();
                        IUser user = ServiceUtil.getUserById(creatorId);
                        if (BeanUtils.isNotEmpty((Object)user)) {
                            taskNotice.setOwnerName(user.getFullname());
                            taskNotice.setAssigneeName(user.getFullname());
                        }
                        taskNotice.setOwnerId(creatorId);
                        taskNotice.setAssigneeId(creatorId);
                    }
                    taskNotice.setIsRead(0);
                    noticeManager.create((Model)taskNotice);
                }
            }
        }
    }

    private void updDueTime(BpmTask bpmTask) throws Exception {
        BpmTaskDueTime bpmTaskDueTime = this.bpmTaskDueTimeManager.getByTaskId(bpmTask.getId());
        if (BeanUtils.isEmpty((Object)((Object)bpmTaskDueTime))) {
            return;
        }
        int remainingTime = 0;
        if ("caltime".equals(bpmTaskDueTime.getDateType())) {
            remainingTime = TimeUtil.getSecondDiff((LocalDateTime)LocalDateTime.now(), (LocalDateTime)bpmTaskDueTime.getStartTime()) / 60;
        } else {
            ObjectNode params = JsonUtil.getMapper().createObjectNode();
            params.put("userId", bpmTaskDueTime.getUserId());
            params.put("startTime", DateFormatUtil.formaDatetTime((LocalDateTime)bpmTaskDueTime.getStartTime()));
            params.put("endTime", DateFormatUtil.formaDatetTime((LocalDateTime)LocalDateTime.now()));
            remainingTime = (int)(this.systemConfigFeignService.getWorkTimeByUser(params) / 60000L);
        }
        remainingTime = bpmTaskDueTime.getDueTime() - remainingTime;
        if (remainingTime <= 0) {
            remainingTime = 0;
        }
        bpmTaskDueTime.setRemainingTime(remainingTime);
        this.bpmTaskDueTimeManager.update((Model)bpmTaskDueTime);
    }

    private void updProcessInstance(TaskFinishCmd cmd) {
        DefaultBpmProcessInstance bpmProcessInstance = (DefaultBpmProcessInstance)cmd.getTransitVars("processInstance");
        ProcessInstanceStatus status = this.getInstStatus(cmd);
        if (!status.getKey().equals(bpmProcessInstance.getStatus())) {
            bpmProcessInstance.setStatus(status.getKey());
            this.bpmProcessInstanceManager.update((Model)bpmProcessInstance);
        }
        if (ProcessInstanceStatus.STATUS_END.getKey().equals(status.getKey())) {
            this.taskFollowManager.remove((Serializable)((Object)bpmProcessInstance.getId()));
        }
    }

    private void updStack(BpmTask bpmTask, ActionCmd cmd) {
        BpmExeStack bpmExeStack;
        String token;
        if (!(cmd instanceof TaskFinishCmd)) {
            return;
        }
        TaskFinishCmd finishCmd = (TaskFinishCmd)cmd;
        Object isDoneUnused = finishCmd.getTransitVars("IsDoneUnused");
        Object recordStack = finishCmd.getTransitVars("record_stack");
        if (BeanUtils.isNotEmpty((Object)isDoneUnused) && recordStack == null) {
            return;
        }
        if (!ActionType.APPROVE.equals((Object)finishCmd.getActionType())) {
            return;
        }
        Object tokenObj = this.natProInstanceService.getVariable(bpmTask.getExecId(), "token_");
        String string = token = tokenObj == null ? null : tokenObj.toString();
        if (StringUtil.isZeroEmpty((String)token)) {
            BpmDelegateTask task = this.natTaskService.getByTaskId(bpmTask.getTaskId());
            String string2 = token = task.getVariable("token_") != null ? task.getVariable("token_").toString() : null;
        }
        if ((bpmExeStack = this.bpmExeStackManager.getStack(bpmTask.getProcInstId(), bpmTask.getNodeId(), null)) == null) {
            bpmExeStack = this.bpmExeStackManager.getStack(bpmTask.getProcInstId(), bpmTask.getNodeId(), null);
        }
        if (bpmExeStack == null) {
            return;
        }
        bpmExeStack.setEndTime(LocalDateTime.now());
        this.bpmExeStackManager.update((Model)bpmExeStack);
        BpmExeStackExecutor executor = this.bpmExeStackExecutorManager.getByTaskId(bpmTask.getId());
        cmd.addTransitVars("parentStack", (Object)bpmExeStack);
        ContextThreadUtil.putCommonVars("parentStack", (Object)bpmExeStack);
        if (executor == null) {
            List<BpmExeStackExecutor> executorList = this.bpmExeStackExecutorManager.getByStackId(bpmExeStack.getId());
            if (executorList.size() == 1) {
                executor = executorList.get(0);
            } else {
                return;
            }
        }
        executor.setAssigneeId(ContextUtil.getCurrentUserId());
        executor.setEndTime(LocalDateTime.now());
        if (finishCmd.isInterpose()) {
            executor.setStatus(2);
        } else {
            executor.setStatus(1);
        }
        this.bpmExeStackExecutorManager.update((Model)executor);
    }

    private void updTaskCommuComplete(String taskId) {
        this.taskCommuService.finishTask(taskId);
    }

    private void updTaskTurnComplte(String taskId) {
        IUser user = ContextUtil.getCurrentUser();
        this.bpmTaskTurnManager.updComplete(taskId, user);
    }

    private ProcessInstanceStatus getInstStatus(TaskFinishCmd cmd) {
        ProcessInstanceStatus status = ProcessInstanceStatus.STATUS_RUNNING;
        String action = cmd.getActionName();
        switch (cmd.getActionType()) {
            case APPROVE: {
                status = ProcessInstanceStatus.STATUS_RUNNING;
                break;
            }
            case BACK_TO_START: {
                status = ProcessInstanceStatus.STATUS_BACK_TOSTART;
                break;
            }
            case BACK: {
                if ("toStart".equals(action)) {
                    status = ProcessInstanceStatus.STATUS_BACK_TOSTART;
                    break;
                }
                status = ProcessInstanceStatus.STATUS_BACK;
                break;
            }
            case RECOVER: {
                status = "toStart".equals(action) ? ProcessInstanceStatus.STATUS_REVOKE_TOSTART : ProcessInstanceStatus.STATUS_REVOKE;
            }
        }
        return status;
    }

    private NodeStatus getNodeStatus(TaskFinishCmd cmd) {
        NodeStatus nodeStatus = NodeStatus.AGREE;
        String action = cmd.getActionName();
        Object isDoneUnused = cmd.getTransitVars("IsDoneUnused");
        if (isDoneUnused != null) {
            nodeStatus = NodeStatus.RECOVER;
            return nodeStatus;
        }
        switch (cmd.getActionType()) {
            case APPROVE: {
                nodeStatus = NodeStatus.fromKey(cmd.getActionName());
                break;
            }
            case BACK_TO_START: {
                nodeStatus = NodeStatus.BACK_TO_START;
                break;
            }
            case BACK: {
                if ("toStart".equals(action) || "backToStart".equals(action)) {
                    nodeStatus = NodeStatus.BACK_TO_START;
                    break;
                }
                nodeStatus = NodeStatus.BACK;
                break;
            }
            case RECOVER: {
                nodeStatus = "toStart".equals(action) ? NodeStatus.RECOVER_TO_START : NodeStatus.RECOVER;
            }
        }
        return nodeStatus;
    }

    private void updateCheckOpinion(TaskFinishCmd cmd, String skipType) throws Exception {
        boolean isSkip = BeanUtils.isNotEmpty((Object)skipType);
        DefaultBpmTask bpmTask = (DefaultBpmTask)cmd.getTransitVars("bpmTask_");
        DefaultBpmCheckOpinion bpmCheckOpinion = this.bpmCheckOpinionManager.getByTaskId(cmd.getTaskId());
        if (bpmCheckOpinion == null) {
            return;
        }
        BpmCheckOpinionUtil.updateExtraPropCheckOpinion(bpmCheckOpinion, bpmTask);
        if (StringUtil.isNotEmpty((String)cmd.getInterPoseOpinion())) {
            this.bpmCheckOpinionManager.remove((Serializable)((Object)bpmCheckOpinion.getId()));
            BpmInterposeRecored bpmInterposeRecored = new BpmInterposeRecored(bpmTask.getProcInstId(), cmd.getInterPoseOpinion(), InterPoseType.fromKey(cmd.getActionName()), (String)cmd.getTransitVars("bpm_opinion_is_done"));
            BpmInterposeRecoredManager manager = (BpmInterposeRecoredManager)AppUtil.getBean(BpmInterposeRecoredManager.class);
            bpmInterposeRecored.setTaskName(bpmTask.getName());
            bpmInterposeRecored.setFiles(cmd.getFiles());
            manager.create((Model)bpmInterposeRecored);
            return;
        }
        IUser user = ContextUtil.getCurrentUser();
        String status = this.getStatus(cmd, isSkip);
        bpmCheckOpinion.setStatus(status);
        bpmCheckOpinion.setCompleteTime(LocalDateTime.now());
        long durMs = TimeUtil.getTime((LocalDateTime)bpmCheckOpinion.getCompleteTime(), (LocalDateTime)bpmCheckOpinion.getCreateTime());
        bpmCheckOpinion.setDurMs(durMs);
        if (isSkip && SkipResult.SKIP_EMPTY_USER.equals(skipType)) {
            bpmCheckOpinion.setAuditor("");
            bpmCheckOpinion.setAuditorName("");
        } else if (SkipResult.SKIP_APPROVER.equals(skipType)) {
            bpmCheckOpinion.setAuditor(String.valueOf(ContextThreadUtil.getCommuVar("Auditor", "")));
            bpmCheckOpinion.setAuditorName(String.valueOf(ContextThreadUtil.getCommuVar("auditorName", "")));
        } else {
            String userId = "-1";
            String userName = "\u7cfb\u7edf";
            if (user != null) {
                userId = user.getUserId();
                userName = user.getFullname();
            }
            bpmCheckOpinion.setAuditor(userId);
            bpmCheckOpinion.setAuditorName(userName);
        }
        String opinion = cmd.getApprovalOpinion();
        if (isSkip) {
            if (SkipResult.SKIP_FIRST.equals(skipType)) {
                opinion = "\u8df3\u8fc7\u7b2c\u4e00\u4e2a\u4efb\u52a1\u8282\u70b9";
            } else if (SkipResult.SKIP_EMPTY_USER.equals(skipType)) {
                opinion = "\u6267\u884c\u4eba\u4e3a\u7a7a";
            } else if (SkipResult.SKIP_SAME_USER.equals(skipType)) {
                opinion = "\u548c\u4e0a\u4e00\u4e2a\u8282\u70b9\u6267\u884c\u4eba\u76f8\u540c\u8df3\u8fc7!";
            } else if (SkipResult.SKIP_APPROVER.equals(skipType)) {
                opinion = "\u5ba1\u6279\u8df3\u8fc7";
            }
            bpmCheckOpinion.setSkipType(skipType);
            bpmCheckOpinion.setCompleteTime(TimeUtil.getLocalDateTimeByMills((long)TimeUtil.getNextTime((int)0, (int)1, (long)TimeUtil.getCurrentTimeMillis())));
        }
        if (OpinionStatus.BACK_TO_START.getKey().equals(status) || OpinionStatus.REJECT.getKey().equals(status)) {
            Object backHandMode = cmd.getTransitVars("backHandMode");
            if (BeanUtils.isNotEmpty((Object)backHandMode) && "normal".equals(backHandMode)) {
                bpmCheckOpinion.setInterpose(1);
            } else {
                bpmCheckOpinion.setInterpose(2);
            }
        }
        bpmCheckOpinion.setFormName(cmd.getOpinionIdentity());
        bpmCheckOpinion.setOpinion(opinion);
        bpmCheckOpinion.setFiles(cmd.getFiles());
        bpmCheckOpinion.setZfiles(cmd.getZfiles());
        if (StringUtil.isNotEmpty((String)cmd.getAgentLeaderId()) && !"0".equals(cmd.getAgentLeaderId())) {
            bpmCheckOpinion.setAgentLeaderId(cmd.getAgentLeaderId());
        }
        if (StringUtil.isNotEmpty((String)cmd.getBusData())) {
            try {
                bpmCheckOpinion.setFormData(Base64.getBase64((String)cmd.getBusData()));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        cmd.addVariable("pre_bpm_check_opinion_id", bpmCheckOpinion.getId());
        this.bpmCheckOpinionManager.update((Model)bpmCheckOpinion);
    }

    private String getStatus(TaskFinishCmd cmd, boolean isSkip) {
        if (isSkip) {
            return OpinionStatus.SKIP.getKey();
        }
        Object isDoneUnused = cmd.getTransitVars("IsDoneUnused");
        try {
            BpmTaskTurn bpmTaskTurn = this.bpmTaskTurnManager.getByTaskId(cmd.getTaskId());
            if (bpmTaskTurn != null) {
                String status = cmd.getActionName();
                if (status.equals("agree")) {
                    return OpinionStatus.DELIVERTO_AGREE.getKey();
                }
                if (status.equals("oppose")) {
                    return OpinionStatus.DELIVERTO_OPPOSE.getKey();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (isDoneUnused != null) {
            return OpinionStatus.SIGN_RECOVER_CANCEL.getKey();
        }
        return cmd.getActionName();
    }

    private void delCandidateAndTask(String taskId) {
        this.bpmTaskCandidateManager.removeByTaskId(taskId);
        this.bpmTaskManager.remove((Serializable)((Object)taskId));
    }

    private void updateProcStatus(String instId, BpmDelegateTask delegateTask, NodeStatus nodeStatus, ActionCmd actionCmd) {
        String bpmnDefId = delegateTask.getBpmnDefId();
        String nodeId = delegateTask.getTaskDefinitionKey();
        MultiInstanceType type = delegateTask.multiInstanceType();
        if (MultiInstanceType.NO.equals((Object)type)) {
            this.bpmProStatusManager.createOrUpd(instId, bpmnDefId, nodeId, delegateTask.getName(), nodeStatus);
        }
    }
}

