/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.listener;

import com.artfess.base.feign.FormFeignService;
import com.artfess.base.util.Base64;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.cmd.BaseActionCmd;
import com.artfess.bpm.api.constant.OpinionStatus;
import com.artfess.bpm.api.constant.ProcessInstanceStatus;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.event.StartFlowEvent;
import com.artfess.bpm.api.model.delegate.BpmDelegateExecution;
import com.artfess.bpm.api.model.form.FormType;
import com.artfess.bpm.api.model.process.def.BpmProcessDef;
import com.artfess.bpm.api.model.process.def.BpmProcessDefExt;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeForm;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.FormExt;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.api.service.BpmInstService;
import com.artfess.bpm.engine.inst.DefaultProcessInstCmd;
import com.artfess.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.artfess.bpm.model.form.BpmForm;
import com.artfess.bpm.model.form.Form;
import com.artfess.bpm.model.form.FormCategory;
import com.artfess.bpm.model.form.FormModel;
import com.artfess.bpm.persistence.manager.BpmCheckOpinionManager;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.manager.BpmInstFormManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.model.BpmInstForm;
import com.artfess.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.artfess.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.util.BpmCheckOpinionUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.http.client.ClientProtocolException;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;

@Service(value="startFlowEventListener")
public class StartFlowEventListener
implements ApplicationListener<StartFlowEvent>,
Ordered {
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmInstService bpmInstService;
    @Resource
    BpmInstFormManager bpmInstFormManager;
    @Resource
    protected FormFeignService formService;

    public void onApplicationEvent(StartFlowEvent ev) {
        BpmDelegateExecution execution = (BpmDelegateExecution)ev.getSource();
        String currentProcInstId = (String)execution.getVariable("instanceId_");
        Map<String, Object> commuVars = ContextThreadUtil.getCommuVars();
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        if (commuVars.isEmpty()) {
            this.createOpinion(execution, currentProcInstId, null);
        } else {
            String parentProcInstId = (String)commuVars.get("instanceId_");
            BpmProcessInstance parentInstance = (BpmProcessInstance)cmd.getTransitVars("processInstance");
            BpmProcessInstance topInstance = this.bpmProcessInstanceManager.getTopBpmProcessInstance(parentInstance);
            String subject = (String)commuVars.get("subject_");
            if (StringUtil.isEmpty((String)subject)) {
                subject = cmd.getVariables().get("subject_").toString();
            }
            DefaultBpmProcessInstance instance = this.createInstance(execution, commuVars, parentInstance, subject);
            String instId = instance.getId();
            String defId = instance.getProcDefId();
            Form frm = null;
            try {
                BpmNodeForm nodeFrm = this.getFormDefByParentFlowKey(defId, topInstance.getProcDefKey(), false);
                if (nodeFrm != null) {
                    frm = nodeFrm.getForm();
                    this.saveBpmInstForm(frm, instId, defId, null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.converCmd(parentProcInstId, instance);
            commuVars.put("parentInstanceId_", parentProcInstId);
            commuVars.put("instanceId_", instance.getId());
            commuVars.put("processDefId_", instance.getProcDefId());
            commuVars.put("flowKey_", topInstance.getProcDefKey());
            execution.setVariables(commuVars);
            this.createOpinion(execution, instance.getId(), parentProcInstId);
        }
    }

    private void converCmd(String parentProcInstId, BpmProcessInstance instance) {
        BaseActionCmd baseCmd = (BaseActionCmd)ContextThreadUtil.getActionCmd();
        DefaultTaskFinishCmd cmd = new DefaultTaskFinishCmd();
        cmd.setInstId(instance.getId());
        cmd.setActionName(OpinionStatus.AGREE.getKey());
        cmd.setBpmIdentities(baseCmd.getBpmIdentities());
        cmd.putTransitVars(baseCmd.getTransitVars());
        cmd.addTransitVars("processInstance", instance);
        ContextThreadUtil.setActionCmd(cmd);
    }

    private DefaultBpmProcessInstance createInstance(BpmDelegateExecution execution, Map<String, Object> commuVars, BpmProcessInstance parentInstance, String subject) {
        DefaultBpmProcessInstance pInstance;
        String businessKey = (String)commuVars.get("businessKey_");
        String parentProcInstId = (String)commuVars.get("instanceId_");
        String bpmnDefId = execution.getBpmnDefId();
        String defId = this.bpmDefinitionManager.getDefIdByBpmnDefId(bpmnDefId);
        DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getById(defId);
        DefaultBpmProcessInstance instance = new DefaultBpmProcessInstance();
        instance.setId(UniqueIdUtil.getSuid());
        instance.setParentInstId(parentProcInstId);
        instance.setProcDefId(bpmDefinition.getDefId());
        instance.setProcDefKey(bpmDefinition.getDefKey());
        instance.setBpmnDefId(bpmDefinition.getBpmnDefId());
        instance.setProcDefName(bpmDefinition.getName());
        instance.setDataMode(parentInstance.getDataMode());
        if (execution.getSupperExecution() != null) {
            String superNodeId = execution.getSupperExecution().getNodeId();
            instance.setSuperNodeId(superNodeId);
        }
        instance.setBpmnInstId(execution.getBpmnInstId());
        instance.setBizKey(businessKey);
        if (BeanUtils.isNotEmpty((Object)commuVars.get("sysCode_"))) {
            instance.setSysCode((String)commuVars.get("sysCode_"));
        }
        if ("run".equals(bpmDefinition.getTestStatus())) {
            instance.setIsFormmal("Y");
        }
        try {
            ActionCmd subCmd = ContextThreadUtil.getActionCmd();
            DefaultProcessInstCmd cInstCmd = new DefaultProcessInstCmd();
            cInstCmd.setFlowKey(instance.getProcDefKey());
            cInstCmd.setBusData(subCmd.getBusData());
            cInstCmd.setVariables(subCmd.getVariables());
            cInstCmd.putTransitVars(subCmd.getTransitVars());
            cInstCmd.setInstId(instance.getId());
            cInstCmd.setBusinessKey(instance.getBizKey());
            BpmProcessDef<BpmProcessDefExt> bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(instance.getProcDefId());
            subject = this.bpmProcessInstanceManager.getSubject(bpmProcessDef, cInstCmd, instance);
            instance.setSubject(subject);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int supportMobile = bpmDefinition.getSupportMobile();
        if (BeanUtils.isNotEmpty((Object)parentInstance) && BeanUtils.isNotEmpty((Object)(pInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)parentInstance.getId()))))) {
            supportMobile = pInstance.getSupportMobile();
        }
        instance.setSupportMobile(supportMobile);
        IUser currentUser = ContextUtil.getCurrentUser();
        instance.setCreateBy(currentUser.getUserId());
        instance.setCreator(currentUser.getFullname());
        instance.setCreateTime(LocalDateTime.now());
        instance.setStatus(ProcessInstanceStatus.STATUS_RUNNING.getKey());
        IGroup org = ContextUtil.getCurrentGroup();
        if (BeanUtils.isNotEmpty((Object)org)) {
            String orgPath = org.getPath();
            instance.setCreateOrgPath(orgPath);
            instance.setCreateOrgId(org.getGroupId());
        }
        this.bpmProcessInstanceManager.create((Model)instance);
        return instance;
    }

    private void createOpinion(BpmDelegateExecution execution, String procInstId, String parentProcInstId) {
        DefaultBpmCheckOpinion bpmCheckOpinion = BpmCheckOpinionUtil.buildBpmCheckOpinion(execution, procInstId, false);
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        bpmCheckOpinion.setStatus(OpinionStatus.START.getKey());
        bpmCheckOpinion.setOpinion("\u53d1\u8d77\u6d41\u7a0b");
        bpmCheckOpinion.setSupInstId(parentProcInstId);
        if (StringUtil.isNotEmpty((String)parentProcInstId)) {
            try {
                bpmCheckOpinion.setCompleteTime(TimeUtil.getLocalDateTimeByMills((long)TimeUtil.getNextTime((int)0, (int)2, (long)TimeUtil.getCurrentTimeMillis())));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (StringUtil.isNotEmpty((String)cmd.getBusData())) {
            try {
                bpmCheckOpinion.setFormData(Base64.getBase64((String)cmd.getBusData()));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (StringUtil.isNotEmpty((String)cmd.getAgentLeaderId()) && !"0".equals(cmd.getAgentLeaderId())) {
            bpmCheckOpinion.setAgentLeaderId(cmd.getAgentLeaderId());
        }
        this.bpmCheckOpinionManager.create((Model)bpmCheckOpinion);
    }

    public int getOrder() {
        return 1;
    }

    private void saveBpmInstForm(Form form, String instId, String defId, String nodeId) throws ClientProtocolException, IOException {
        if (BeanUtils.isEmpty((Object)form)) {
            return;
        }
        BpmInstForm bpmInstForm = new BpmInstForm();
        bpmInstForm.setInstId(instId);
        bpmInstForm.setDefId(defId);
        bpmInstForm.setNodeId(nodeId);
        bpmInstForm.setFormCategory(form.getType().value());
        bpmInstForm.setFormType(form.getFormType());
        if (FormCategory.INNER.equals((Object)form.getType())) {
            FormModel formModel = (FormModel)JsonUtil.toBean((JsonNode)this.formService.getByFormKey(form.getFormValue()), BpmForm.class);
            if (BeanUtils.isNotEmpty((Object)formModel)) {
                bpmInstForm.setFormValue(formModel.getFormId());
            }
        } else {
            bpmInstForm.setFormValue(form.getFormValue());
        }
        if (StringUtil.isNotEmpty((String)bpmInstForm.getFormValue())) {
            this.bpmInstFormManager.create((Model)bpmInstForm);
        }
    }

    private BpmNodeForm getFormDefByParentFlowKey(String defId, String parentFlowKey, boolean isMobile) throws Exception {
        BpmNodeForm nodeForm = new BpmNodeForm();
        BpmProcessDef<BpmProcessDefExt> bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        BpmNodeDef bpmNodeDef = bpmProcessDef.getStartEvent();
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDef.getProcessDefExt();
        FormExt flowForm = null;
        if (BeanUtils.isNotEmpty((Object)defExt) && BeanUtils.isNotEmpty(defExt.getAllGlobalForm())) {
            FormType formType = isMobile ? FormType.MOBILE : FormType.PC;
            for (FormExt form : defExt.getAllGlobalForm()) {
                if (!form.getParentFlowKey().equals(parentFlowKey) || !form.getFormType().equalsIgnoreCase(formType.toString())) continue;
                flowForm = form;
                break;
            }
        }
        if (this.isNotEmptyForm(flowForm)) {
            nodeForm.setForm(flowForm);
            nodeForm.setBpmNodeDef(bpmNodeDef);
            return nodeForm;
        }
        return null;
    }

    protected boolean isNotEmptyForm(Form form) {
        if (form == null) {
            return false;
        }
        return !form.isFormEmpty();
    }
}

