/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.redis.support;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Lock {
    private static Logger logger = LoggerFactory.getLogger(Lock.class);
    private RedisTemplate<String, Object> redisTemplate;
    private static final long TIME_OUT = 100L;
    private static final int EXPIRE = 60;
    private static final String UNLOCK_LUA = "if redis.call(\"get\",KEYS[1]) == ARGV[1] then     return redis.call(\"del\",KEYS[1]) else     return 0 end ";
    private String lockKey;
    private String lockKeyLog = "";
    private String lockValue;
    private int expireTime = 60;
    private long timeOut = 100L;
    private volatile boolean locked = false;
    private final Random random = new Random();

    public Lock(RedisTemplate<String, Object> redisTemplate, String lockKey) {
        this.redisTemplate = redisTemplate;
        this.lockKey = lockKey + "_lock";
    }

    public Lock(RedisTemplate<String, Object> redisTemplate, String lockKey, int expireTime) {
        this(redisTemplate, lockKey);
        this.expireTime = expireTime;
    }

    public Lock(RedisTemplate<String, Object> redisTemplate, String lockKey, long timeOut) {
        this(redisTemplate, lockKey);
        this.timeOut = timeOut;
    }

    public Lock(RedisTemplate<String, Object> redisTemplate, String lockKey, int expireTime, long timeOut) {
        this(redisTemplate, lockKey, expireTime);
        this.timeOut = timeOut;
    }

    public boolean tryLock() {
        this.lockValue = UUID.randomUUID().toString();
        long timeout = this.timeOut * 1000000L;
        long nowTime = System.nanoTime();
        while (System.nanoTime() - nowTime < timeout) {
            if (this.set(this.lockKey, this.lockValue, this.expireTime)) {
                this.locked = true;
                return this.locked;
            }
            this.seleep(10L, 50000);
        }
        return this.locked;
    }

    public boolean lock() {
        this.lockValue = UUID.randomUUID().toString();
        this.locked = this.set(this.lockKey, this.lockValue, this.expireTime);
        return this.locked;
    }

    public boolean lockBlock() {
        this.lockValue = UUID.randomUUID().toString();
        while (true) {
            this.locked = this.set(this.lockKey, this.lockValue, this.expireTime);
            if (this.locked) {
                return this.locked;
            }
            this.seleep(10L, 50000);
        }
    }

    public Boolean unlock() {
        if (this.locked) {
            try {
                RedisScript script = RedisScript.of((String)UNLOCK_LUA, Long.class);
                ArrayList<String> keys = new ArrayList<String>();
                keys.add(this.lockKey);
                Long result = (Long)this.redisTemplate.execute(script, keys, new Object[]{this.lockValue});
                if (result == 0L && !StringUtils.isEmpty((Object)this.lockKeyLog)) {
                    logger.debug("Redis\u5206\u5e03\u5f0f\u9501\uff0c\u89e3\u9501{}\u5931\u8d25\uff01\u89e3\u9501\u65f6\u95f4\uff1a{}", (Object)this.lockKeyLog, (Object)System.currentTimeMillis());
                }
                this.locked = result == 0L;
                return result == 1L;
            }
            catch (Throwable e) {
                logger.warn("Redis\u4e0d\u652f\u6301EVAL\u547d\u4ee4\uff0c\u4f7f\u7528\u964d\u7ea7\u65b9\u5f0f\u89e3\u9501\uff1a{}", (Object)e.getMessage());
                String value = this.get(this.lockKey, String.class);
                if (this.lockValue.equals(value)) {
                    this.redisTemplate.delete((Object)this.lockKey);
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    private boolean set(String key, String value, long seconds) {
        Assert.isTrue((!StringUtils.isEmpty((Object)key) ? 1 : 0) != 0, (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        Boolean success = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, seconds, TimeUnit.SECONDS);
        if (!StringUtils.isEmpty((Object)this.lockKeyLog) && Objects.nonNull(success) && success.booleanValue()) {
            logger.debug("\u83b7\u53d6\u9501{}\u7684\u65f6\u95f4\uff1a{}", (Object)this.lockKeyLog, (Object)System.currentTimeMillis());
        }
        return Objects.nonNull(success) && success != false;
    }

    private <T> T get(String key, Class<T> aClass) {
        Assert.isTrue((!StringUtils.isEmpty((Object)key) ? 1 : 0) != 0, (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        return (T)this.redisTemplate.opsForValue().get((Object)key);
    }

    public boolean isLock() {
        return this.locked;
    }

    private void seleep(long millis, int nanos) {
        try {
            Thread.sleep(millis, this.random.nextInt(nanos));
        }
        catch (Exception e) {
            logger.debug("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u4f11\u7720\u88ab\u4e2d\u65ad\uff1a", (Throwable)e);
        }
    }

    public String getLockKeyLog() {
        return this.lockKeyLog;
    }

    public void setLockKeyLog(String lockKeyLog) {
        this.lockKeyLog = lockKeyLog;
    }

    public int getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(int expireTime) {
        this.expireTime = expireTime;
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(long timeOut) {
        this.timeOut = timeOut;
    }
}

