/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.redis.support;

import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.springframework.util.CollectionUtils;

public class AwaitThreadContainer {
    private final Map<String, Set<Thread>> threadMap = new ConcurrentHashMap<String, Set<Thread>>();

    public final void await(String key, long milliseconds) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Set<Thread> threadSet = this.threadMap.get(key);
        if (threadSet == null) {
            threadSet = new ConcurrentSkipListSet<Thread>(Comparator.comparing(Thread::toString));
            this.threadMap.put(key, threadSet);
        }
        threadSet.add(Thread.currentThread());
        LockSupport.parkNanos(this, TimeUnit.MILLISECONDS.toNanos(milliseconds));
    }

    public final void signalAll(String key) {
        Set<Thread> threadSet = this.threadMap.get(key);
        if (!CollectionUtils.isEmpty(threadSet)) {
            for (Thread thread : threadSet) {
                LockSupport.unpark(thread);
            }
            threadSet.clear();
        }
    }
}

