/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.manager.impl;

import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.uc.dao.RelAuthDao;
import com.artfess.uc.exception.RequiredException;
import com.artfess.uc.manager.DemensionManager;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.manager.RelAuthManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.manager.UserRelManager;
import com.artfess.uc.model.RelAuth;
import com.artfess.uc.model.User;
import com.artfess.uc.model.UserRel;
import com.artfess.uc.params.common.OrgExportObject;
import com.artfess.uc.params.org.RelAuthVo;
import com.artfess.uc.util.OrgUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RelAuthManagerImpl
extends BaseManagerImpl<RelAuthDao, RelAuth>
implements RelAuthManager {
    @Autowired
    OrgManager orgService;
    @Autowired
    UserManager userService;
    @Autowired
    DemensionManager demService;
    @Autowired
    UserRelManager userRelService;
    @Autowired
    SystemConfigFeignService systemConfigFeignService;

    @Override
    public List<RelAuth> getAllRelAuth(QueryFilter queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage page = this.convert2IPage(pageBean);
        return ((RelAuthDao)this.baseMapper).getAllRelAuth((IPage<RelAuth>)page, (Wrapper<RelAuth>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    @Override
    public RelAuth getByRelIdAndUserId(String orgId, String userId) {
        return ((RelAuthDao)this.baseMapper).getByRelIdAndUserId(orgId, userId);
    }

    @Override
    public List<RelAuth> getByUserId(String userId) {
        List<RelAuth> groupAuthList = ((RelAuthDao)this.baseMapper).getByUserId(userId);
        ArrayList<RelAuth> authList = new ArrayList<RelAuth>();
        for (RelAuth auth : groupAuthList) {
            boolean isChild = false;
            for (RelAuth groupAuth : groupAuthList) {
                boolean flag1 = auth.getId() != groupAuth.getId() && auth.getTypeId().equals(groupAuth.getTypeId()) && auth.getRelPath().startsWith(groupAuth.getRelPath());
                boolean flag2 = false;
                if (!flag1 || !flag2) continue;
                isChild = true;
            }
            if (isChild) continue;
            authList.add(auth);
        }
        return authList;
    }

    @Override
    @Transactional
    public CommonResult<String> addRelAuth(RelAuthVo relAuthVo) throws Exception {
        if (StringUtil.isEmpty((String)relAuthVo.getAccount())) {
            throw new RequiredException("\u6dfb\u52a0\u5206\u7ea7\u6c47\u62a5\u7ebf\u5931\u8d25\uff0c\u7528\u6237\u8d26\u53f7\u3010account\u3011\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)relAuthVo.getRelCode())) {
            throw new RequiredException("\u6dfb\u52a0\u5206\u7ea7\u6c47\u62a5\u7ebf\u5931\u8d25\uff0c\u6c47\u62a5\u7ebf\u7f16\u7801\u3010orgCode\u3011\u5fc5\u586b\uff01");
        }
        RelAuth relAuth = this.getRelAuthCheck(relAuthVo.getAccount(), relAuthVo.getRelCode(), relAuthVo, "");
        relAuth.setId(UniqueIdUtil.getSuid());
        this.create((Model)relAuth);
        return new CommonResult(true, "\u6dfb\u52a0\u5206\u7ea7\u6c47\u62a5\u7ebf\u6210\u529f\uff01", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> addRelAuths(String code, String accounts) throws Exception {
        String[] accountList;
        if (StringUtil.isEmpty((String)code)) {
            throw new RequiredException("\u6dfb\u52a0\u5206\u7ea7\u6c47\u62a5\u7ebf\u7ba1\u7406\u5458\u5931\u8d25\uff0c\u6c47\u62a5\u8282\u70b9\u7f16\u7801\u3010code\u3011\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)accounts)) {
            throw new RequiredException("\u6dfb\u52a0\u5206\u7ea7\u6c47\u62a5\u7ebf\u7ba1\u7406\u5458\u5931\u8d25\uff0c\u7ba1\u7406\u5458\u8d26\u53f7\u3010accounts\u3011\u5fc5\u586b\uff01");
        }
        UserRel rel = this.userRelService.getByAlias(code);
        if (BeanUtils.isEmpty((Object)rel)) {
            throw new RequiredException("\u6dfb\u52a0\u5206\u7ea7\u6c47\u62a5\u7ebf\u7ba1\u7406\u5458\u5931\u8d25\uff0c\u7f16\u7801\u4e3a\u3010" + code + "\u3011\u7684\u6c47\u62a5\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        }
        for (String account : accountList = accounts.split(",")) {
            User user = this.userService.getByAccount(account);
            if (!BeanUtils.isNotEmpty((Object)account) || !BeanUtils.isEmpty((Object)this.getByRelIdAndUserId(rel.getId(), user.getId()))) continue;
            RelAuth relAuth = new RelAuth();
            relAuth.setId(UniqueIdUtil.getSuid());
            relAuth.setRelId(rel.getId());
            relAuth.setUserId(user.getId());
            relAuth.setTypeId(rel.getTypeId());
            this.create((Model)relAuth);
        }
        return new CommonResult(true, "\u6dfb\u52a0\u5206\u7ea7\u6c47\u62a5\u7ebf\u7ba1\u7406\u5458\u6210\u529f\uff01", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> updateRelAuth(RelAuthVo relAuthVo) throws Exception {
        if (StringUtil.isEmpty((String)relAuthVo.getAccount())) {
            throw new RequiredException("\u66f4\u65b0\u5206\u7ea7\u6c47\u62a5\u7ebf\u5931\u8d25\uff0c\u7528\u6237\u8d26\u53f7\u3010account\u3011\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)relAuthVo.getRelCode())) {
            throw new RequiredException("\u66f4\u65b0\u5206\u7ea7\u6c47\u62a5\u7ebf\u5931\u8d25\uff0c\u6c47\u62a5\u7ebf\u7f16\u7801\u3010relCode\u3011\u5fc5\u586b\uff01");
        }
        RelAuth relAuth = this.getRelAuthCheck(relAuthVo.getAccount(), relAuthVo.getRelCode(), null, relAuthVo.getNewAccount());
        this.update((Model)relAuth);
        return new CommonResult(true, "\u66f4\u65b0\u5206\u7ea7\u6c47\u62a5\u7ebf\u6210\u529f\uff01", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> delRelAuth(String relCode, String accounts) throws Exception {
        String[] accountList;
        if (StringUtil.isEmpty((String)relCode)) {
            throw new RequiredException("\u5220\u9664\u5206\u7ea7\u6c47\u62a5\u7ebf\u7ba1\u7406\u5458\u5931\u8d25\uff0c\u6c47\u62a5\u7ebf\u7f16\u7801\u3010relCode\u3011\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)accounts)) {
            throw new RequiredException("\u5220\u9664\u5206\u7ea7\u6c47\u62a5\u7ebf\u7ba1\u7406\u5458\u5931\u8d25\uff0c\u7528\u6237\u8d26\u53f7\u3010accounts\u3011\u5fc5\u586b\uff01");
        }
        for (String account : accountList = accounts.split(",")) {
            RelAuth relAuth = this.getRelAuthCheck(account, relCode, null, "");
            this.remove((Serializable)((Object)relAuth.getId()));
        }
        return new CommonResult(true, "\u5220\u9664\u5206\u7ea7\u6c47\u62a5\u7ebf\u7ba1\u7406\u5458\u6210\u529f\uff01", (Object)"");
    }

    @Override
    public RelAuth getRelAuth(String account, String relCode) throws Exception {
        RelAuth relAuth = this.getRelAuthCheck(account, relCode, null, "");
        return relAuth;
    }

    private RelAuth getRelAuthCheck(String account, String relCode, RelAuthVo relAuthVo, String newAccount) throws Exception {
        User user = this.userService.getByAccount(account);
        if (BeanUtils.isEmpty((Object)user)) {
            throw new RequiredException("\u7528\u6237\u8d26\u53f7\u3010" + account + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        UserRel rel = this.userRelService.getByAlias(relCode);
        if (BeanUtils.isEmpty((Object)rel)) {
            throw new RequiredException("\u6c47\u62a5\u7ebf\u8282\u70b9\u7f16\u7801\u3010" + relCode + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        RelAuth relAuth = ((RelAuthDao)this.baseMapper).getByRelIdAndUserId(rel.getId(), user.getId());
        if (BeanUtils.isNotEmpty((Object)relAuthVo)) {
            if (BeanUtils.isNotEmpty((Object)relAuth)) {
                throw new RequiredException("\u7528\u6237\u8d26\u53f7\u3010" + account + "\u3011\uff0c\u6c47\u62a5\u7ebf\u7f16\u7801\u3010" + relCode + "\u3011\u7684\u5206\u7ea7\u6c47\u62a5\u7ebf\u5df2\u5b58\u5728\uff01");
            }
            ObjectNode proType = this.systemConfigFeignService.getSysTypeById(relAuthVo.getTypeCode());
            if (BeanUtils.isEmpty((Object)proType)) {
                throw new RequiredException("\u7f16\u7801\u6216id\u4e3a\u3010" + relAuthVo.getTypeCode() + "\u3011\u7684\u6c47\u62a5\u7ebf\u5206\u7c7b\u4e0d\u5b58\u5728\uff01");
            }
            if (!rel.getTypeId().equals(proType.get("typeId").asText())) {
                throw new RequiredException("\u8f93\u5165\u7684\u7ef4\u5ea6\u4e0e\u6c47\u62a5\u7ebf\u6240\u5bf9\u5e94\u7684\u7ef4\u5ea6\u4e0d\u4e00\u81f4\uff01");
            }
            relAuth = new RelAuth();
            relAuth.setRelId(rel.getId());
            relAuth.setTypeId(rel.getTypeId());
            relAuth.setUserId(user.getId());
        } else {
            if (BeanUtils.isEmpty((Object)relAuth)) {
                throw new RequiredException("\u6839\u636e\u7528\u6237\u8d26\u53f7\u3010" + account + "\u3011\uff0c\u6c47\u62a5\u7ebf\u7f16\u7801\u3010" + relCode + "\u3011\u672a\u627e\u5230\u5bf9\u5e94\u5206\u7ea7\u6c47\u62a5\u7ebf\uff01");
            }
            if (StringUtil.isNotEmpty((String)newAccount) && !newAccount.equals(account)) {
                User newuser = this.userService.getByAccount(newAccount);
                if (BeanUtils.isEmpty((Object)newuser)) {
                    throw new RequiredException("\u7528\u6237\u8d26\u53f7\u3010" + newAccount + "\u3011\u4e0d\u5b58\u5728\uff01");
                }
                RelAuth relAuth1 = ((RelAuthDao)this.baseMapper).getByRelIdAndUserId(rel.getId(), newuser.getId());
                if (BeanUtils.isNotEmpty((Object)relAuth1)) {
                    throw new RequiredException("\u7528\u6237\u8d26\u53f7\u3010" + newAccount + "\u3011\uff0c\u6c47\u62a5\u7ebf\u7f16\u7801\u3010" + relCode + "\u3011\u7684\u5206\u7ea7\u6c47\u62a5\u7ebf\u5df2\u5b58\u5728\uff0c\u8bf7\u9009\u62e9\u5462\u5176\u5b83\u7528\u6237\uff01");
                }
                relAuth.setUserId(newuser.getId());
                relAuth.setAccount(newuser.getAccount());
                relAuth.setFullname(newuser.getFullname());
            }
        }
        return relAuth;
    }

    @Override
    public List<RelAuth> getRelAuthsByTypeAndUser(String typeId, String userId) throws Exception {
        if (StringUtil.isEmpty((String)typeId) || StringUtil.isEmpty((String)userId)) {
            throw new RequiredException("\u7528\u6237id\u548c\u5206\u7c7bid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return ((RelAuthDao)this.baseMapper).getRelAuthsByTypeAndUser(typeId, userId);
    }

    @Override
    public List<RelAuth> getRelAuthByTime(OrgExportObject exportObject) throws Exception {
        QueryFilter queryFilter = OrgUtil.getDataByTimeFilter(exportObject.getBtime(), exportObject.getEtime());
        return ((RelAuthDao)this.baseMapper).queryOnSync((Wrapper<RelAuth>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    @Override
    @Transactional
    public void delByRelId(String relId) {
        ((RelAuthDao)this.baseMapper).delByRelId(relId, LocalDateTime.now());
    }

    @Override
    public PageList<RelAuth> queryRelAuth(QueryFilter filter) {
        PageList<RelAuth> orgAuthList = this.query((QueryFilter<RelAuth>)filter);
        return orgAuthList;
    }

    @Override
    public List<RelAuth> getLayoutRelAuth(String userId) {
        return ((RelAuthDao)this.baseMapper).getLayoutRelAuth(userId);
    }

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((RelAuthDao)this.baseMapper).removePhysical();
    }

    @Transactional(readOnly=true)
    public PageList<RelAuth> query(QueryFilter<RelAuth> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        queryFilter.addFilter("a.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        queryFilter.addFilter("b.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        queryFilter.addFilter("c.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        IPage<RelAuth> result = ((RelAuthDao)this.baseMapper).query((IPage<RelAuth>)this.convert2IPage(pageBean), (Wrapper<RelAuth>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    public RelAuth get(Serializable id) {
        return ((RelAuthDao)this.baseMapper).get(id);
    }
}

