/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.listener;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.constant.ActionType;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.event.NotifyTaskModel;
import com.artfess.bpm.api.event.TaskNotifyEvent;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.util.BpmUtil;
import com.artfess.bpm.util.MessageUtil;
import com.artfess.bpm.util.PortalDataUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;

@Service
public class TaskNotifyEventListener
implements ApplicationListener<TaskNotifyEvent>,
Ordered {
    private static final Log logger = LogFactory.getLog(TaskNotifyEventListener.class);
    @Resource
    IUserService userServiceImpl;

    public int getOrder() {
        return 1;
    }

    public void onApplicationEvent(TaskNotifyEvent ev) {
        NotifyTaskModel model = (NotifyTaskModel)ev.getSource();
        ActionType actionType = model.getActionType();
        ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
        String notifyType = null;
        try {
            notifyType = BpmUtil.getNotifyType((BpmProcessInstance)taskCmd.getTransitVars("processInstance"), model.getNodeId());
            if (StringUtil.isEmpty((String)notifyType)) {
                return;
            }
            String baseUrl = PortalDataUtil.getPropertyByAlias("baseUrl");
            model.addVars("baseUrl", baseUrl).addVars("taskSubject", model.getSubject()).addVars("taskId", model.getTaskId()).addVars("cause", model.getOpinion()).addVars("nodeName", model.getNodeName()).addVars("agent", BeanUtils.isEmpty((Object)model.getAgent()) ? "" : model.getAgent().getFullname()).addVars("instSubject", model.getSubject()).addVars("instId", taskCmd.getInstId());
            DefaultBpmProcessInstance defaultBpmProcessInstance = (DefaultBpmProcessInstance)taskCmd.getTransitVars().get("processInstance");
            if (BeanUtils.isNotEmpty((Object)defaultBpmProcessInstance)) {
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                model.addVars("bpmName", defaultBpmProcessInstance.getProcDefName()).addVars("date", defaultBpmProcessInstance.getCreateTime().format(dateTimeFormatter)).addVars("creator", defaultBpmProcessInstance.getCreator());
            }
            if (ActionType.APPROVE.equals((Object)model.getActionType())) {
                if (model.isAgent()) {
                    this.handAgent(model, notifyType);
                } else {
                    MessageUtil.send(model, notifyType, "bpmnApproval");
                }
            } else if (ActionType.BACK.equals((Object)actionType) || ActionType.BACK_TO_START.equals((Object)actionType)) {
                MessageUtil.send(model, notifyType, "bpmnBack");
            } else {
                MessageUtil.send(model, notifyType, "bpmnRecover");
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private void handAgent(NotifyTaskModel model, String notifyType) {
        IUser agent = model.getAgent();
        IUser delegateUser = model.getDelegator();
        model.addVars("delegate", delegateUser.getFullname());
        model.addVars("agent", agent.getFullname());
        ArrayList<IUser> agentReceivers = new ArrayList<IUser>();
        agentReceivers.add(agent);
        model.setIdentitys(agentReceivers);
        try {
            MessageUtil.send(model, notifyType, "bpmnAgent");
            ArrayList<IUser> delegateReceivers = new ArrayList<IUser>();
            delegateReceivers.add(delegateUser);
            model.setIdentitys(delegateReceivers);
            MessageUtil.send(model, notifyType, "bpmnDelegate");
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }
}

