/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.workflow.runtime.service;

import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.MapUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.constant.OpinionStatus;
import com.artfess.bpm.api.constant.ProcessInstanceStatus;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.task.BpmTaskTurn;
import com.artfess.bpm.api.model.process.task.SkipResult;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.persistence.manager.BpmCheckOpinionManager;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.manager.BpmExeStackManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.manager.BpmReadRecordManager;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.bpm.persistence.manager.BpmTaskTurnManager;
import com.artfess.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.workflow.runtime.manager.BpmTransReceiverManager;
import com.artfess.workflow.runtime.model.BpmTransReceiver;
import com.artfess.workflow.runtime.params.CustomSignRevokeParam;
import com.artfess.workflow.runtime.service.RevokeService;
import com.artfess.workflow.runtime.service.RevokeServiceFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RevokeHandler {
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmReadRecordManager bpmReadRecordManager;
    @Resource
    BpmExeStackManager bpmExeStackManager;
    @Resource
    BpmTaskTurnManager bpmTaskTurnManager;
    @Resource
    BpmTransReceiverManager bpmTransReceiverManager;

    public void checkRevoke(PageList<Map<String, Object>> pageList) throws Exception {
        if (BeanUtils.isEmpty(pageList) || pageList.getRows().size() == 0) {
            return;
        }
        List oldList = pageList.getRows();
        ArrayList<Map> newList = new ArrayList<Map>();
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("PROC_INST_ID_", (Object)((Map)oldList.get(0)).get("id").toString(), QueryOP.EQUAL);
        queryFilter.withSorter(new FieldSort("CREATE_TIME_", Direction.DESC));
        PageList opinionList = this.bpmCheckOpinionManager.query(queryFilter);
        HashSet<String> awaitingParentTaskIds = new HashSet<String>();
        HashSet<String> doneParentTaskIds = new HashSet<String>();
        HashSet<String> readTaskIds = new HashSet<String>();
        boolean isInstanceEnd = false;
        for (DefaultBpmCheckOpinion opinion : opinionList.getRows()) {
            if (OpinionStatus.AWAITING_CHECK.getKey().equals(opinion.getStatus()) && !doneParentTaskIds.contains(opinion.getParentTaskId())) {
                awaitingParentTaskIds.add(opinion.getParentTaskId());
                if (opinion.getIsRead() == 1) {
                    readTaskIds.add(opinion.getParentTaskId());
                }
            } else if (!OpinionStatus.AWAITING_CHECK.getKey().equals(opinion.getStatus())) {
                doneParentTaskIds.add(opinion.getParentTaskId());
            }
            if (!OpinionStatus.END_REVOKE.getKey().equals(opinion.getStatus())) continue;
        }
        String defId = ((Map)oldList.get(0)).get("procDefId").toString();
        DefaultBpmDefinition def = this.bpmDefinitionManager.getById(defId);
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean(BpmDefinitionAccessor.class);
        BpmProcessInstanceManager bpmProcessInstanceManager = (BpmProcessInstanceManager)AppUtil.getBean(BpmProcessInstanceManager.class);
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)bpmProcessInstanceManager.get((Serializable)((Object)((Map)oldList.get(0)).get("id").toString()));
        if (ProcessInstanceStatus.STATUS_END.getKey().equals(instance.getStatus())) {
            isInstanceEnd = true;
        }
        String isReadRevoke = def.getIsReadRevoke();
        for (Map map : oldList) {
            boolean exist = false;
            if (!map.containsKey("signType") || BeanUtils.isEmpty(map.get("signType"))) {
                for (Map map2 : newList) {
                    if (!map2.containsKey("taskKey") || !map.containsKey("taskKey") || !BeanUtils.isNotEmpty(map2.get("taskKey")) || !map2.get("taskKey").toString().equals(map.get("taskKey"))) continue;
                    exist = true;
                    break;
                }
            }
            String opinionStatus = (String)map.get("opinionStatus");
            if (exist || !map.containsKey("opinionStatus") || BeanUtils.isEmpty(map.get("opinionStatus")) || SkipResult.SKIP_FIRST.equals(map.get("skipType")) && OpinionStatus.SKIP.getKey().equals(opinionStatus)) continue;
            newList.add(map);
            if (OpinionStatus.DELIVERTO.getKey().equals(opinionStatus)) {
                map.put("revoke", false);
                continue;
            }
            if (OpinionStatus.SKIP.getKey().equals(opinionStatus) && !SkipResult.SKIP_FIRST.equals(map.get("skipType")) || OpinionStatus.START.getKey().equals(opinionStatus) || OpinionStatus.REVOKER.getKey().equals(opinionStatus) || OpinionStatus.AWAITING_CHECK.getKey().equals(opinionStatus) || OpinionStatus.COPYTO.getKey().equals(opinionStatus) || OpinionStatus.COPYTO_REPLY.getKey().equals(opinionStatus) || OpinionStatus.INQU.getKey().equals(opinionStatus) || OpinionStatus.TRANS_FORMING.getKey().equals(opinionStatus)) continue;
            String signType = MapUtil.getString((Map)map, (String)"signType");
            if (StringUtil.isNotEmpty((String)signType) && !"AfterSign".equals(signType)) {
                RevokeService revokeService = RevokeServiceFactory.getRevokeService(signType);
                if (revokeService == null) continue;
                revokeService.canRevoke(map, opinionList.getRows(), isReadRevoke);
                continue;
            }
            String status = null;
            if (map.containsKey("status")) {
                status = MapUtil.getString((Map)map, (String)"status");
            }
            OpinionStatus opinionStatusEnum = OpinionStatus.fromKey((String)opinionStatus);
            switch (opinionStatusEnum) {
                case INQU: 
                case DELIVERTO: {
                    map.put("revoke", this.isInquDeliverToApproval(map, isReadRevoke, opinionStatusEnum));
                    break;
                }
                case AGREE: 
                case OPPOSE: 
                case START: 
                case DELIVERTO_AGREE: 
                case DELIVERTO_OPPOSE: 
                case TRANS_AGREE: 
                case SKIP: {
                    map.put("revoke", this.isRevokeNormalApproval(map, status, awaitingParentTaskIds, isReadRevoke, readTaskIds));
                    break;
                }
                case REJECT: 
                case BACK_TO_START: {
                    if (!ProcessInstanceStatus.STATUS_BACK.getKey().equals(status) && !ProcessInstanceStatus.STATUS_BACK_TOSTART.getKey().equals(status)) break;
                    map.put("revoke", this.isRevokeBackApproval(map, opinionList.getRows(), isReadRevoke));
                    break;
                }
            }
        }
        if (isInstanceEnd) {
            String taskId = "";
            for (DefaultBpmCheckOpinion opinion : opinionList.getRows()) {
                if (!OpinionStatus.END.getKey().equals(opinion.getStatus()) || !ContextUtil.getCurrentUserId().equals(opinion.getAuditor())) continue;
                taskId = opinion.getParentTaskId();
                break;
            }
            if (StringUtil.isNotEmpty((String)taskId)) {
                for (Map opinion : newList) {
                    BpmNodeDef bpmNodeDef;
                    String nodeId;
                    if (!taskId.equals(MapUtil.getString((Map)opinion, (String)"taskId")) || !StringUtil.isNotEmpty((String)(nodeId = MapUtil.getString((Map)opinion, (String)"taskKey"))) || !BeanUtils.isEmpty((Object)(bpmNodeDef = bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId)).getParentBpmNodeDef())) continue;
                    opinion.put("revoke", true);
                }
            }
        }
        pageList.setRows(newList);
    }

    private boolean isRevokeBackApproval(Map<String, Object> map, List<DefaultBpmCheckOpinion> list, String isReadRevoke) {
        String instId = map.get("id").toString();
        boolean isRead = false;
        List runningTasks = this.bpmTaskManager.getByInstId(instId);
        if (BeanUtils.isNotEmpty((Object)runningTasks)) {
            List bpmReadRecord = this.bpmReadRecordManager.getByTaskIds(runningTasks);
            if (BeanUtils.isNotEmpty((Object)bpmReadRecord)) {
                isRead = true;
            }
        } else {
            return false;
        }
        return !isRead || !"false".equals(isReadRevoke);
    }

    public boolean isInquDeliverToApproval(Map<String, Object> map, String isReadRevoke, OpinionStatus opinionStatus) {
        if ("true".equals(isReadRevoke)) {
            return true;
        }
        String taskId = MapUtil.getString(map, (String)"taskId");
        if (StringUtil.isEmpty((String)taskId)) {
            return false;
        }
        if (opinionStatus.equals((Object)OpinionStatus.DELIVERTO)) {
            BpmTaskTurn bpmTaskTurn = this.bpmTaskTurnManager.getByTaskId(taskId);
            List bpmReadRecords = this.bpmReadRecordManager.getByTaskIdandrecord(taskId, null);
            if (BeanUtils.isEmpty((Object)bpmReadRecords)) {
                return true;
            }
        } else {
            List<BpmTransReceiver> transReceiverList = this.bpmTransReceiverManager.getByTaskId(taskId);
            if (BeanUtils.isNotEmpty(transReceiverList)) {
                int size = transReceiverList.size();
                String[] receiverIds = new String[size];
                for (int i = 0; i < size; ++i) {
                    receiverIds[i] = transReceiverList.get(i).getReceiverId();
                }
                List bpmReadRecords = this.bpmReadRecordManager.getByTaskIdandrecord(taskId, receiverIds);
                if (BeanUtils.isEmpty((Object)bpmReadRecords)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isRevokeNormalApproval(Map<String, Object> map, String instStatus, Set<String> parentTaskIds, String isReadRevoke, Set<String> readTaskIds) {
        String taskId;
        if (!ProcessInstanceStatus.STATUS_RUNNING.getKey().equals(instStatus) && !ProcessInstanceStatus.STATUS_REVOKE.getKey().equals(instStatus)) {
            return false;
        }
        String curStatus = (String)map.get("opinionStatus");
        String string = taskId = map.containsKey("taskId") ? (String)map.get("taskId") : "";
        if (OpinionStatus.START.getKey().equals(curStatus)) {
            return true;
        }
        return parentTaskIds.contains(taskId) && (!readTaskIds.contains(taskId) || "true".equals(isReadRevoke));
    }

    @Transactional
    public void doRevoke(CustomSignRevokeParam revokeParam) throws Exception {
        RevokeService revokeService;
        String signType = revokeParam.getSignType();
        if (StringUtil.isNotEmpty((String)signType) && !"AfterSign".equals(signType) && (revokeService = RevokeServiceFactory.getRevokeService(signType)) != null) {
            revokeService.doRevoke(revokeParam);
        }
    }
}

