/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataResource.ods.controller;

import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.dataShare.dataResource.ods.manager.BizOdsCatalogsManager;
import com.artfess.dataShare.dataResource.ods.model.BizOdsCatalogs;
import com.artfess.sysConfig.persistence.manager.SysTypeManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6570\u636e\u8d44\u6e90---ODS\u8d44\u6e90\u76ee\u5f55"})
@RequestMapping(value={"/biz/dataResource/odsCatalogs/v1/"})
@ApiGroup(group={"group_biz_dataShare"})
public class BizOdsCatalogsController
extends BaseController<BizOdsCatalogsManager, BizOdsCatalogs> {
    private static final Logger log = LoggerFactory.getLogger(BizOdsCatalogsController.class);
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private BizOdsCatalogsManager odsCatalogsManager;
    @Autowired
    private SysTypeManager sysTypeManager;

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) BizOdsCatalogs t) {
        String id = "";
        t.setIsDele("0");
        if (t.getSn() == null) {
            t.setSn(((BizOdsCatalogsManager)this.baseService).getNextSequence(null));
            id = ((BizOdsCatalogsManager)this.baseService).insertTree(t);
        }
        if (!StringUtils.isNotBlank((CharSequence)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return CommonResult.success((Object)true, (String)"\u6dfb\u52a0\u6210\u529f");
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) BizOdsCatalogs t) {
        BizOdsCatalogs byId = (BizOdsCatalogs)((Object)((BizOdsCatalogsManager)this.baseService).getById((Serializable)((Object)t.getId())));
        ((BizOdsCatalogsManager)this.baseService).updateTree(t, byId.getName());
        return new CommonResult(true, "\u66f4\u65b0\u5206\u7c7b\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        boolean result = ((BizOdsCatalogsManager)this.baseService).removeById((Serializable)((Object)id));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @DeleteMapping(value={"/"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        boolean result = ((BizOdsCatalogsManager)this.baseService).removeByIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult(false, "\u64cd\u4f5c\u6210\u529f", null);
        }
        return new CommonResult(true, "\u64cd\u4f5c\u5931\u8d25", null);
    }

    @PostMapping(value={"/getTree"})
    @ApiOperation(value="\u83b7\u53d6ODS\u8d44\u6e90\u76ee\u5f55\u4e0b\u62c9\u6811")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.QUERY, description="\u83b7\u53d6ODS\u8d44\u6e90\u76ee\u5f55\u4e0b\u62c9\u6811")
    public CommonResult<String> getTree(@ApiParam(name="model", value="\u83b7\u53d6ODS\u8d44\u6e90\u76ee\u5f55\u4e0b\u62c9\u6811") @RequestBody BizOdsCatalogs entity) {
        log.info("\u83b7\u53d6ODS\u8d44\u6e90\u76ee\u5f55\u4e0b\u62c9\u6811\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)((Object)entity)));
        List<BizOdsCatalogs> list = ((BizOdsCatalogsManager)this.baseService).getTree(entity);
        return CommonResult.success(list, null);
    }

    @RequestMapping(value={"updateSequence"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u6392\u5e8f\u53f7", notes="\u6279\u91cf\u4fee\u6539\u6392\u5e8f\u53f7")
    public CommonResult<String> updateSequence(@ApiParam(name="params", value="\u6392\u5e8f\u53c2\u6570\uff1aKey\uff1aID\uff0cValue\uff1a\u6392\u5e8f\u53f7") @RequestBody HashMap<String, Integer> params) throws Exception {
        if (!params.isEmpty()) {
            ((BizOdsCatalogsManager)this.baseService).updateSequence(params);
        }
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", null);
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<BizOdsCatalogs> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizOdsCatalogs> queryFilter) {
        List currentAndChildOrgIds = this.baseContext.getCurrentAndChildOrgIds();
        queryFilter.addFilter("create_company_id_", (Object)currentAndChildOrgIds, QueryOP.IN);
        return ((BizOdsCatalogsManager)this.baseService).query(queryFilter);
    }

    @RequestMapping(value={"moveTree"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u79fb\u52a8\u76ee\u5f55", httpMethod="POST", notes="\u79fb\u52a8\u76ee\u5f55")
    public CommonResult<String> moveDictionaries(@ApiParam(name="id", value="\u8981\u79fb\u52a8\u7684\u8282\u70b9ID") @RequestParam String id, @ApiParam(name="parentId", value="\u76ee\u5f55\u6811ID") @RequestParam String parentId) throws Exception {
        this.odsCatalogsManager.moveTree(id, parentId);
        return new CommonResult(true, "\u79fb\u52a8\u6210\u529f");
    }
}

