/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.constant.DesignerType;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.model.process.def.BpmDefinition;
import com.artfess.bpm.persistence.model.BpmDefData;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.builder.ToStringBuilder;

@XmlRootElement(name="BpmDef")
@XmlAccessorType(value=XmlAccessType.NONE)
@TableName(value="bpm_definition")
public class DefaultBpmDefinition
extends AutoFillModel<DefaultBpmDefinition>
implements BpmDefinition,
Cloneable {
    private static final long serialVersionUID = 3755643685770853878L;
    @TableId(value="def_id_")
    protected String defId;
    @TableField(value="name_")
    @XmlAttribute(name="name")
    protected String name;
    @TableField(value="def_key_")
    @XmlAttribute(name="defKey")
    protected String defKey;
    @TableField(value="desc_")
    @XmlAttribute(name="desc")
    protected String desc;
    @TableField(value="status_")
    @XmlAttribute(name="status")
    protected String status;
    @TableField(value="test_status_")
    @XmlAttribute(name="testStatus")
    protected String testStatus = "test";
    @TableField(value="bpmn_def_id_")
    protected String bpmnDefId;
    @TableField(value="bpmn_deploy_id_")
    protected String bpmnDeployId;
    @TableField(value="version_")
    protected Integer version;
    @TableField(value="main_def_id_")
    protected String mainDefId;
    @TableField(value="is_main_")
    protected String isMain;
    @TableField(value="reason_")
    protected String reason;
    @TableField(value="designer_")
    @XmlAttribute(name="designer")
    protected String designer = DesignerType.FLASH.name();
    @TableField(value="support_mobile_")
    @XmlAttribute(name="supportMobile")
    protected int supportMobile = 0;
    @TableField(value="rev_")
    @XmlAttribute(name="rev")
    protected Integer rev = 0;
    @TableField(value="show_urgent_state_")
    @XmlAttribute(name="showUrgentState")
    protected int showUrgentState = 0;
    @TableField(value="show_modify_record_")
    @XmlAttribute(name="showModifyRecord")
    protected int showModifyRecord = 0;
    @TableField(value="is_read_revoke")
    @XmlAttribute(name="isReadRevoke")
    protected String isReadRevoke = "false";
    @TableField(value="urgent_mail_tel")
    @XmlAttribute(name="urgentMailTel")
    protected String urgentMailTel;
    @TableField(value="urgent_sms_tel")
    @XmlAttribute(name="urgentSmsTel")
    protected String urgentSmsTel;
    @TableField(value="type_id_")
    @XmlAttribute(name="typeId")
    protected String typeId;
    @TableField(value="type_name_")
    @XmlAttribute(name="type_name_")
    protected String typeName;
    @TableField(exist=false)
    protected List<BpmIdentity> leaders;
    @TableField(exist=false)
    protected ObjectNode authorizeRight;
    @XmlElement(name="bpmDefData")
    @TableField(exist=false)
    protected BpmDefData bpmDefData = new BpmDefData();

    public Integer getRev() {
        return this.rev;
    }

    public void setRev(Integer rev) {
        this.rev = rev;
    }

    public void setId(String id) {
        this.setDefId(id);
    }

    @XmlTransient
    public String getId() {
        return this.defId;
    }

    public void setDefId(String defId) {
        this.defId = defId;
    }

    @Override
    public String getDefId() {
        return this.defId;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setDefKey(String defKey) {
        this.defKey = defKey;
    }

    @Override
    public String getDefKey() {
        return this.defKey;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    public void setTestStatus(String testStatus) {
        this.testStatus = testStatus;
    }

    @Override
    public String getTestStatus() {
        return this.testStatus;
    }

    public void setBpmnDefId(String bpmnDefId) {
        this.bpmnDefId = bpmnDefId;
    }

    @Override
    public String getBpmnDefId() {
        return this.bpmnDefId;
    }

    public void setBpmnDeployId(String bpmnDeployId) {
        this.bpmnDeployId = bpmnDeployId;
    }

    @Override
    public String getBpmnDeployId() {
        return this.bpmnDeployId;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    public void setMainDefId(String mainDefId) {
        this.mainDefId = mainDefId;
    }

    @Override
    public String getMainDefId() {
        return this.mainDefId;
    }

    public void setIsMain(String isMain) {
        this.isMain = isMain;
    }

    public String getIsMain() {
        return this.isMain;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    public void setDesigner(String designer) {
        this.designer = designer;
    }

    @Override
    public String getDesigner() {
        return this.designer;
    }

    @Override
    public String getDefJson() {
        return this.bpmDefData.defJson;
    }

    public void setDefJson(String defJson) {
        this.bpmDefData.defJson = defJson;
    }

    @Override
    public String getDefXml() {
        return this.bpmDefData.defXml;
    }

    public void setDefXml(String defXml) {
        this.bpmDefData.defXml = defXml = this.dealPool(defXml);
    }

    @Override
    public String getBpmnXml() {
        return this.bpmDefData.bpmnXml;
    }

    public void setBpmnXml(String bpmnXml) {
        this.bpmDefData.bpmnXml = bpmnXml;
    }

    @Override
    public boolean isMain() {
        return "Y".equals(this.isMain);
    }

    public BpmDefData getBpmDefData() {
        return this.bpmDefData;
    }

    public void setBpmDefData(BpmDefData bpmDefData) {
        if (StringUtil.isNotEmpty((String)this.getDefId())) {
            bpmDefData.setId(this.getDefId());
        }
        this.bpmDefData = bpmDefData;
    }

    public ObjectNode getAuthorizeRight() {
        return this.authorizeRight;
    }

    public void setAuthorizeRight(ObjectNode authorizeRight2) {
        this.authorizeRight = authorizeRight2;
    }

    private String dealPool(String defXml) {
        int v = 1;
        int h = 1;
        Pattern vRegex = Pattern.compile("<bg:VLane\\s*(id=\"\\w+\")\\s*");
        Matcher vRegexMatcher = vRegex.matcher(defXml);
        while (vRegexMatcher.find()) {
            String vLane = "id=\"vLane" + v + "\"";
            defXml = defXml.replaceFirst(vRegexMatcher.group(1), vLane);
            ++v;
        }
        Pattern hRegex = Pattern.compile("<bg:HLane\\s*(id=\"\\w+\")\\s*");
        Matcher hRegexMatcher = hRegex.matcher(defXml);
        while (hRegexMatcher.find()) {
            String hLane = "id=\"hLane" + h + "\"";
            defXml = defXml.replaceFirst(hRegexMatcher.group(1), hLane);
            ++h;
        }
        return defXml;
    }

    public int getSupportMobile() {
        return this.supportMobile;
    }

    public void setSupportMobile(int supportMobile) {
        this.supportMobile = supportMobile;
    }

    @Override
    public int getShowUrgentState() {
        return this.showUrgentState;
    }

    public void setShowUrgentState(int showUrgentState) {
        this.showUrgentState = showUrgentState;
    }

    @Override
    public int getShowModifyRecord() {
        return this.showModifyRecord;
    }

    public void setShowModifyRecord(int showModifyRecord) {
        this.showModifyRecord = showModifyRecord;
    }

    @Override
    public String getIsReadRevoke() {
        return this.isReadRevoke;
    }

    public void setIsReadRevoke(String isReadRevoke) {
        this.isReadRevoke = isReadRevoke;
    }

    @Override
    public String getUrgentMailTel() {
        return this.urgentMailTel;
    }

    public void setUrgentMailTel(String urgentMailTel) {
        this.urgentMailTel = urgentMailTel;
    }

    @Override
    public String getUrgentSmsTel() {
        return this.urgentSmsTel;
    }

    public void setUrgentSmsTel(String urgentSmsTel) {
        this.urgentSmsTel = urgentSmsTel;
    }

    public List<BpmIdentity> getLeaders() {
        return this.leaders;
    }

    public void setLeaders(List<BpmIdentity> leaders) {
        this.leaders = leaders;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("defId", (Object)this.defId).append("name", (Object)this.name).append("rev", (Object)this.rev).append("isReadRevoke", (Object)this.isReadRevoke).append("showUrgentState", this.showUrgentState).append("defKey", (Object)this.defKey).append("desc", (Object)this.desc).append("typeId", (Object)this.typeId).append("status", (Object)this.status).append("testStatus", (Object)this.testStatus).append("bpmnDefId", (Object)this.bpmnDefId).append("bpmnDeployId", (Object)this.bpmnDeployId).append("version", (Object)this.version).append("mainDefId", (Object)this.mainDefId).append("isMain", (Object)this.isMain).append("reason", (Object)this.reason).toString();
    }

    public Object clone() {
        DefaultBpmDefinition obj = null;
        try {
            obj = (DefaultBpmDefinition)super.clone();
            obj.setBpmDefData((BpmDefData)this.bpmDefData.clone());
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return obj;
    }
}

