/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.bpm.persistence.dao.BpmAgentDefDao;
import com.artfess.bpm.persistence.dao.BpmAgentSettingDao;
import com.artfess.bpm.persistence.manager.BpmAgentConditionManager;
import com.artfess.bpm.persistence.manager.BpmAgentSettingManager;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.model.BpmAgentCondition;
import com.artfess.bpm.persistence.model.BpmAgentDef;
import com.artfess.bpm.persistence.model.BpmAgentSetting;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.artfess.bpm.persistence.model.ResultMessage;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmAgentSettingManager")
public class BpmAgentSettingManagerImpl
extends BaseManagerImpl<BpmAgentSettingDao, BpmAgentSetting>
implements BpmAgentSettingManager {
    @Resource
    BpmAgentDefDao bpmAgentDefDao;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmAgentConditionManager bpmAgentConditionManager;
    @Resource
    IUserService userServiceImpl;

    @Transactional
    public void removeByIds(String ... ids) {
        if (ids != null) {
            for (String pk : ids) {
                this.bpmAgentDefDao.removeBySettingId(pk);
                this.bpmAgentConditionManager.removeBySettingId(pk);
            }
        }
        super.removeByIds(ids);
    }

    @Override
    public BpmAgentSetting getById(String id) {
        BpmAgentSetting bpmAgentSetting = (BpmAgentSetting)super.get((Serializable)((Object)id));
        if (bpmAgentSetting != null) {
            if (BpmAgentSetting.TYPE_CONDITION.shortValue() == bpmAgentSetting.getType().shortValue()) {
                DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getMainByDefKey(bpmAgentSetting.getFlowKey());
                if (BeanUtils.isNotEmpty((Object)bpmDefinition)) {
                    bpmAgentSetting.setFlowName(bpmDefinition.getName());
                }
                List<BpmAgentCondition> conditionList = this.bpmAgentConditionManager.getBySettingId(id);
                for (BpmAgentCondition bpmAgentCondition : conditionList) {
                    IUser user = this.userServiceImpl.getUserById(bpmAgentCondition.getAgentId());
                    if (!BeanUtils.isNotEmpty((Object)user)) continue;
                    bpmAgentCondition.setAgentName(user.getFullname());
                }
                bpmAgentSetting.setConditionList(conditionList);
            } else {
                List<BpmAgentDef> defList = this.bpmAgentDefDao.getBySettingId(id);
                for (BpmAgentDef bpmAgentDef : defList) {
                    DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getMainByDefKey(bpmAgentDef.getFlowKey());
                    if (!BeanUtils.isNotEmpty((Object)bpmDefinition)) continue;
                    bpmAgentDef.setFlowName(bpmDefinition.getName());
                }
                bpmAgentSetting.setDefList(defList);
            }
        }
        return bpmAgentSetting;
    }

    @Transactional
    public void create(BpmAgentSetting entity) {
        if (BeanUtils.isEmpty((Object)entity.getId())) {
            String settingId = UniqueIdUtil.getSuid();
            entity.setId(settingId);
        }
        super.create((Model)entity);
        this.saveSub(entity);
    }

    private void saveSub(BpmAgentSetting entity) {
        List<BpmAgentCondition> conditionList;
        String settingId = entity.getId();
        List<BpmAgentDef> defList = entity.getDefList();
        if (BeanUtils.isNotEmpty(defList)) {
            for (BpmAgentDef def : defList) {
                def.setId(UniqueIdUtil.getSuid());
                def.setSettingId(settingId);
                this.bpmAgentDefDao.insert((Object)def);
            }
        }
        if (BeanUtils.isNotEmpty(conditionList = entity.getConditionList())) {
            for (BpmAgentCondition condition : conditionList) {
                condition.setId(UniqueIdUtil.getSuid());
                condition.setSettingId(settingId);
                this.bpmAgentConditionManager.create((Model)condition);
            }
        }
    }

    @Transactional
    public void update(BpmAgentSetting entity) {
        String settingId = entity.getId();
        super.update((Model)entity);
        this.bpmAgentConditionManager.removeBySettingId(settingId);
        this.bpmAgentDefDao.removeBySettingId(settingId);
        this.saveSub(entity);
    }

    @Override
    public BpmAgentSetting getSettingByFlowAndAuthidAndDate(String authId, String flowKey) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("authid", authId);
        params.put("flowkey", flowKey);
        params.put("date", LocalDateTime.now());
        List<BpmAgentSetting> list = ((BpmAgentSettingDao)this.baseMapper).getSettingByFlowAndAuthidAndDate(authId, flowKey, LocalDateTime.now());
        if (BeanUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public ResultMessage checkConflict(BpmAgentSetting setting) {
        String settingId = setting.getId();
        String authId = setting.getAuthId();
        LocalDateTime startDate = setting.getStartDate();
        LocalDateTime endDate = setting.getEndDate();
        short type = setting.getType();
        ResultMessage result = ResultMessage.getSuccess();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("settingId", settingId);
        params.put("authid", authId);
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        Integer rtn = ((BpmAgentSettingDao)this.baseMapper).getByAuthAndDate(params);
        if (rtn > 0) {
            result = ResultMessage.getFail("\u6b64\u65f6\u95f4\u6bb5\u5185\u4e0e\u5df2\u6709\u7684\u6709\u6548\u4ee3\u7406\u51b2\u7a81!");
            return result;
        }
        switch (type) {
            case 1: {
                result = ResultMessage.getSuccess();
                break;
            }
            case 2: {
                String msg = this.checkPart(setting);
                if (!StringUtil.isNotEmpty((String)msg)) break;
                result = ResultMessage.getFail(msg + "\u6d41\u7a0b\u51b2\u7a81!");
                break;
            }
            case 3: {
                boolean isConflict = this.checkCondition(setting);
                if (!isConflict) break;
                result = ResultMessage.getFail("\u6761\u4ef6\u4ee3\u7406\u6709\u51b2\u7a81!");
            }
        }
        return result;
    }

    private boolean checkCondition(BpmAgentSetting setting) {
        boolean rtn = false;
        String settingId = setting.getId();
        String authId = setting.getAuthId();
        LocalDateTime startDate = setting.getStartDate();
        LocalDateTime endDate = setting.getEndDate();
        String flowKey = setting.getFlowKey();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("flowKey", flowKey);
        params.put("authid", authId);
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        params.put("settingId", StringUtil.isEmpty((String)settingId) ? null : settingId);
        Integer i = ((BpmAgentSettingDao)this.baseMapper).getForCondition(params);
        if (i > 0) {
            return true;
        }
        i = ((BpmAgentSettingDao)this.baseMapper).getByAuthDateFlowKey(params);
        if (i > 0) {
            return true;
        }
        return rtn;
    }

    private String checkPart(BpmAgentSetting setting) {
        String settingId = setting.getId();
        String authId = setting.getAuthId();
        LocalDateTime startDate = setting.getStartDate();
        LocalDateTime endDate = setting.getEndDate();
        StringBuffer sb = new StringBuffer();
        List<BpmAgentDef> defList = setting.getDefList();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("authid", authId);
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        params.put("settingId", StringUtil.isEmpty((String)settingId) ? null : settingId);
        for (BpmAgentDef def : defList) {
            params.put("flowKey", def.getFlowKey());
            Integer i = ((BpmAgentSettingDao)this.baseMapper).getByAuthDateFlowKey(params);
            if (i <= 0) continue;
            sb.append(def.getFlowName() + ",");
        }
        return sb.toString();
    }
}

