/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.activiti.persistence;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.support.AbstractLobCreatingPreparedStatementCallback;
import org.springframework.jdbc.core.support.AbstractLobStreamingResultSetExtractor;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.stereotype.Repository;
import org.springframework.util.FileCopyUtils;

@Repository
public class ProDefinitionPersistence {
    private Log logger = LogFactory.getLog(ProDefinitionPersistence.class);
    @Resource
    JdbcTemplate jdbcTemplate;

    public String getDefXmlByDeployId(String deployId) {
        String sql = "select a.* from ACT_GE_BYTEARRAY a where NAME_ LIKE '%bpmn20.xml' and DEPLOYMENT_ID_= ? ";
        DefaultLobHandler lobHandler = new DefaultLobHandler();
        ByteArrayOutputStream contentOs = new ByteArrayOutputStream();
        String defXml = null;
        try {
            this.jdbcTemplate.query(sql, new Object[]{deployId}, (ResultSetExtractor)new AbstractLobStreamingResultSetExtractor((LobHandler)lobHandler, contentOs){
                final /* synthetic */ LobHandler val$lobHandler;
                final /* synthetic */ ByteArrayOutputStream val$contentOs;
                {
                    this.val$lobHandler = lobHandler;
                    this.val$contentOs = byteArrayOutputStream;
                }

                public void streamData(ResultSet rs) throws SQLException, IOException {
                    FileCopyUtils.copy((InputStream)this.val$lobHandler.getBlobAsBinaryStream(rs, "BYTES_"), (OutputStream)this.val$contentOs);
                }
            });
            defXml = new String(contentOs.toByteArray(), "UTF-8");
        }
        catch (Exception ex) {
            this.logger.debug((Object)ex.getMessage());
        }
        return defXml;
    }

    public void writeDefXml(final String deployId, String defXml) {
        try {
            DefaultLobHandler lobHandler = new DefaultLobHandler();
            final byte[] btyesXml = defXml.getBytes("UTF-8");
            String sql = "update ACT_GE_BYTEARRAY set BYTES_=? where NAME_ LIKE '%bpmn20.xml' and DEPLOYMENT_ID_= ? ";
            this.jdbcTemplate.execute(sql, (PreparedStatementCallback)new AbstractLobCreatingPreparedStatementCallback((LobHandler)lobHandler){

                protected void setValues(PreparedStatement ps, LobCreator lobCreator) throws SQLException, DataAccessException {
                    lobCreator.setBlobAsBytes(ps, 1, btyesXml);
                    ps.setString(2, deployId);
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

