/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataShare.manager.impl;

import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.datasource.DatabaseSwitchResult;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.dataShare.dataShare.dao.BizShareTableDao;
import com.artfess.dataShare.dataShare.manager.BizShareApiManager;
import com.artfess.dataShare.dataShare.manager.BizShareFilesManager;
import com.artfess.dataShare.dataShare.manager.BizShareTableFieldManager;
import com.artfess.dataShare.dataShare.manager.BizShareTableManager;
import com.artfess.dataShare.dataShare.model.BizShareApi;
import com.artfess.dataShare.dataShare.model.BizShareFiles;
import com.artfess.dataShare.dataShare.model.BizShareTable;
import com.artfess.dataShare.dataShare.model.BizShareTableField;
import com.artfess.dataShare.factory.TableOperatorFactory;
import com.artfess.dataShare.util.TableFieldVo;
import com.artfess.dataShare.util.TableVo;
import com.artfess.sysConfig.persistence.manager.SysDataSourceManager;
import com.artfess.sysConfig.persistence.model.SysDataSource;
import com.artfess.table.model.Table;
import com.artfess.table.operator.impl.BaseTableOperator;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizShareTableManagerImpl
extends BaseManagerImpl<BizShareTableDao, BizShareTable>
implements BizShareTableManager {
    @Resource
    private DatabaseContext databaseContext;
    @Resource
    private JdbcTemplate jdbcTemplate;
    @Resource
    private BizShareTableFieldManager fieldManager;
    @Resource
    private BizShareApiManager apiManager;
    @Resource
    private BizShareFilesManager filesManager;
    @Resource
    private SysDataSourceManager dataSourceManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deploy(String id) {
        BizShareTable bizShareTable = (BizShareTable)((Object)((BizShareTableDao)this.baseMapper).selectById((Serializable)((Object)id)));
        if ("1".equals(bizShareTable.getIsCreateTable())) {
            // empty if block
        }
        List fields = this.fieldManager.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizShareTableField::getIsDele, (Object)"0")).eq(BizShareTableField::getTableId, (Object)id));
        fields = fields.stream().sorted(Comparator.comparing(BizShareTableField::getSn)).collect(Collectors.toList());
        String dbAlias = bizShareTable.getDbAlias();
        try (DatabaseSwitchResult databaseSwitchResult = this.databaseContext.setDataSource(dbAlias);){
            String dbType = databaseSwitchResult.getDbType();
            TableVo tableVo = new TableVo();
            tableVo.setTableName(bizShareTable.getTableCode());
            tableVo.setComment(bizShareTable.getTableDesc());
            for (BizShareTableField field : fields) {
                String dataType = field.getDataType();
                Integer attrLength = field.getAttrLength();
                Integer decimalLen = field.getDecimalLen();
                String defaultValue = field.getDefaultValue();
                String desc = field.getDesc();
                TableFieldVo fieldVo = new TableFieldVo();
                fieldVo.setFieldName(field.getFieldCode());
                fieldVo.setComment(desc);
                fieldVo.setIsPk("1".equals(field.getIsPk()));
                fieldVo.setColumnType(dataType);
                fieldVo.setFcolumnType(dataType);
                fieldVo.setCharLen(attrLength);
                fieldVo.setIntLen(attrLength);
                fieldVo.setDecimalLen(decimalLen);
                fieldVo.setDefaultValue(defaultValue);
                fieldVo.setTableName(bizShareTable.getTableCode());
                tableVo.addColumn(fieldVo);
            }
            BaseTableOperator tableOperator = TableOperatorFactory.getTableOperator(dbType);
            tableOperator.setJdbcTemplate(this.jdbcTemplate);
            tableOperator.createTable((Table)tableVo);
        }
        catch (Exception e) {
            throw new ApplicationException();
        }
        bizShareTable.setDeployedStatus("1");
        bizShareTable.setIsCreateTable("1");
        bizShareTable.setDeployedTime(LocalDateTime.now());
        bizShareTable.setDeployedUsername(ContextUtil.getCurrentUserName());
        int fieldTotal = this.fieldManager.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizShareTableField::getIsDele, (Object)"0")).eq(BizShareTableField::getTableId, (Object)bizShareTable.getId()));
        bizShareTable.setFieldTotal(fieldTotal);
        ((BizShareTableDao)this.baseMapper).updateById((Object)bizShareTable);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveInfo(BizShareTable table) {
        if (!this.checkName(table)) {
            throw new ApplicationException("\u6539\u76ee\u5f55\u4e0b\u5df2\u521b\u5efa\u3010" + table.getName() + "\u3011\u8d44\u6e90\uff01");
        }
        table.setIsCreateTable("0");
        table.setDeployedStatus("0");
        table.setIsDele("0");
        if (StringUtil.isEmpty((String)table.getIsDatabase())) {
            table.setIsDatabase("0");
        }
        if (StringUtil.isEmpty((String)table.getIsApi())) {
            table.setIsApi("0");
        }
        if (StringUtil.isEmpty((String)table.getIsFile())) {
            table.setIsFile("0");
        }
        table.setTableNameCh(table.getName());
        table.setTableCode("SHARE_" + table.getTableNameEn());
        return this.save((Object)table);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean removeTable(String id) throws Exception {
        List fields = this.fieldManager.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizShareTableField::getIsDele, (Object)"0")).eq(BizShareTableField::getTableId, (Object)id));
        List fieldIds = fields.stream().map(entity -> entity.getId()).collect(Collectors.toList());
        boolean result = this.fieldManager.removeByIds(fieldIds);
        BizShareTable table = (BizShareTable)this.get((Serializable)((Object)id));
        boolean exists = this.checkPhysicsTableExists(table.getId(), table.getTableNameEn());
        if (exists) {
            String dropSql = "drop table " + table.getTableCode();
            JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)table.getDbAlias());
            template.execute(dropSql);
        }
        return ((BizShareTableDao)this.baseMapper).deleteById((Serializable)((Object)id)) > 0;
    }

    @Override
    public String queryTableSql(String id) {
        BizShareTable table = (BizShareTable)this.get((Serializable)((Object)id));
        List<BizShareTableField> fieldList = this.fieldManager.queryFieldByTable(id);
        TableVo tableVo = new TableVo();
        tableVo.setTableName(table.getTableCode());
        tableVo.setComment(table.getTableDesc());
        for (BizShareTableField field : fieldList) {
            String dataType = field.getDataType();
            Integer attrLength = field.getAttrLength();
            Integer decimalLen = field.getDecimalLen();
            String defaultValue = field.getDefaultValue();
            String desc = field.getDesc();
            TableFieldVo fieldVo = new TableFieldVo();
            fieldVo.setFieldName(field.getFieldCode());
            fieldVo.setComment(desc);
            fieldVo.setIsPk("1".equals(field.getIsPk()));
            fieldVo.setColumnType(dataType);
            fieldVo.setFcolumnType(dataType);
            fieldVo.setCharLen(attrLength);
            fieldVo.setIntLen(attrLength);
            fieldVo.setDecimalLen(decimalLen);
            fieldVo.setDefaultValue(defaultValue);
            fieldVo.setTableName(table.getTableCode());
            tableVo.addColumn(fieldVo);
        }
        String tableSql = "";
        String dbAlias = table.getDbAlias();
        try (DatabaseSwitchResult databaseSwitchResult = this.databaseContext.setDataSource(dbAlias);){
            String dbType = databaseSwitchResult.getDbType();
            BaseTableOperator tableOperator = TableOperatorFactory.getTableOperator(dbType);
            tableSql = tableOperator.createTableSql((Table)tableVo);
        }
        catch (Exception e) {
            throw new ApplicationException();
        }
        return tableSql;
    }

    @Override
    public boolean checkTableExists(String tableId, String dbAlias, String tableNameEn) throws Exception {
        String sql;
        BizShareTable table = (BizShareTable)this.get((Serializable)((Object)tableId));
        tableNameEn = "SHARE_" + tableNameEn;
        if (this.checkTable(tableId, tableNameEn)) {
            return true;
        }
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)dbAlias);
        return (Integer)template.queryForObject(sql = "select count(1) from information_schema.TABLES t where table_name ='" + tableNameEn + "'", Integer.class) > 0;
    }

    @Override
    public boolean checkPhysicsTableExists(String tableId, String tableNameEn) throws Exception {
        String sql;
        BizShareTable table = (BizShareTable)this.get((Serializable)((Object)tableId));
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)table.getDbAlias());
        return (Integer)template.queryForObject(sql = "select count(1) from information_schema.TABLES t where table_name ='" + tableNameEn + "'", Integer.class) > 0;
    }

    @Override
    public void deployHaveTable(String tableId) {
        BizShareTable table = (BizShareTable)this.get((Serializable)((Object)tableId));
        if ("1".equals(table.getDeployedStatus())) {
            throw new ApplicationException("\u8868\u5df2\u7ecf\u53d1\u5e03\uff0c\u4e0d\u80fd\u4ece\u91cd\u590d\uff0c\u5982\u679c\u6709\u95ee\u9898\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        table.setIsCreateTable("1");
        table.setDeployedStatus("1");
        table.setDeployedTime(LocalDateTime.now());
        this.update((Model)table);
    }

    @Override
    public void deployDotHaveTable(String tableId, String tableSql) throws Exception {
        BizShareTable table = (BizShareTable)this.get((Serializable)((Object)tableId));
        List<BizShareTableField> fields = this.fieldManager.queryFieldByTable(tableId);
        if ("1".equals(table.getDeployedStatus())) {
            throw new ApplicationException("\u8868\u5df2\u7ecf\u53d1\u5e03\uff0c\u4e0d\u80fd\u4ece\u91cd\u590d\uff0c\u5982\u679c\u6709\u95ee\u9898\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (fields.size() == 0) {
            throw new ApplicationException("\u8868\u5185\u6ca1\u6709\u5b57\u6bb5\u4e0d\u80fd\u53d1\u5e03");
        }
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)table.getDbAlias());
        table.setIsCreateTable("1");
        table.setDeployedStatus("1");
        table.setDeployedTime(LocalDateTime.now());
        table.setCreateTableSql(tableSql);
        template.execute(table.getCreateTableSql());
        this.update((Model)table);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean removeBatch(List<String> ids) throws Exception {
        for (String id : ids) {
            this.removeTable(id);
        }
        return true;
    }

    @Override
    public BizShareTable queryTableField(String id) {
        BizShareTable table = (BizShareTable)this.get((Serializable)((Object)id));
        List<BizShareTableField> fields = this.fieldManager.queryFieldByTable(table.getId());
        table.setTableFieldList(fields);
        return table;
    }

    @Override
    public PageList<BizShareTable> queryPage(QueryFilter<BizShareTable> queryFilter) {
        PageList pageList = this.query(queryFilter);
        List tableList = pageList.getRows();
        for (BizShareTable table : tableList) {
            String tableId = table.getId();
            List<BizShareApi> apis = this.apiManager.queryByTableId(tableId);
            List<BizShareFiles> files = this.filesManager.queryByTableId(tableId);
            table.setApiList(apis);
            table.setFilesList(files);
        }
        return pageList;
    }

    @Override
    public BizShareTable queryTableInfo(String id) {
        BizShareTable table = (BizShareTable)this.get((Serializable)((Object)id));
        SysDataSource dataSource = (SysDataSource)this.dataSourceManager.getOne((Wrapper)new LambdaQueryWrapper().eq(SysDataSource::getAlias, (Object)table.getDbAlias()));
        if (BeanUtils.isNotEmpty((Object)dataSource)) {
            table.setDatabaseId(dataSource.getId());
        }
        return table;
    }

    @Override
    public PageList<BizShareTable> queryAuthPage(QueryFilter<BizShareTable> queryFilter, String consumerId) {
        IPage<BizShareTable> iPage = ((BizShareTableDao)this.baseMapper).queryAuthPage((IPage<BizShareTable>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizShareTable>)this.convert2Wrapper(queryFilter, this.currentModelClass()), consumerId);
        return new PageList(iPage);
    }

    private boolean checkTable(String tableId, String tableNameEn) {
        int count;
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizShareTable::getIsDele, (Object)"0")).eq(BizShareTable::getTableCode, (Object)tableNameEn);
        if (StringUtil.isNotEmpty((String)tableId)) {
            queryWrapper.ne(BizShareTable::getId, (Object)tableId);
        }
        return (count = this.count((Wrapper)queryWrapper)) > 0;
    }

    private boolean checkName(BizShareTable table) {
        Integer count;
        String id = table.getId();
        String name = table.getName();
        String catalogId = table.getCatalogId();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BizShareTable::getCatalogId, (Object)catalogId);
        queryWrapper.eq(BizShareTable::getName, (Object)name);
        if (StringUtil.isNotEmpty((String)id)) {
            queryWrapper.ne(BizShareTable::getId, (Object)id);
        }
        return (count = ((BizShareTableDao)this.baseMapper).selectCount((Wrapper)queryWrapper)) <= 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateCatalog(String[] ids, String catalogId) {
        int count = ((BizShareTableDao)this.baseMapper).updateCatalog(ids, catalogId);
        return count > 0;
    }
}

