/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.integrate.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.integrate.consts.DingTalkConsts;
import com.artfess.integrate.consts.WeChatOffAccConsts;
import com.artfess.integrate.consts.WeChatWorkConsts;
import com.artfess.integrate.enums.ExterUniEnum;
import com.artfess.integrate.model.SysExternalUnite;
import com.artfess.integrate.persistence.manager.SysExternalUniteManager;
import com.artfess.integrate.util.DingTalkTokenUtil;
import com.artfess.integrate.util.ThreadMessageUtil;
import com.artfess.integrate.util.WechatWorkTokenUtil;
import com.artfess.poi.util.ExcelUtil;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/integrate/sysExternalUnite/v1"})
@Api(tags={"\u7b2c\u4e09\u65b9\u96c6\u6210"})
@ApiGroup(group={"group_system"})
public class SysExternalUniteController
extends BaseController<SysExternalUniteManager, SysExternalUnite> {
    @Resource
    SysExternalUniteManager sysExternalUniteManager;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7b2c\u4e09\u65b9\u7cfb\u7edf\u96c6\u6210\u5217\u8868", httpMethod="POST", notes="\u7b2c\u4e09\u65b9\u7cfb\u7edf\u96c6\u6210\u5217\u8868")
    public PageList<SysExternalUnite> list(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysExternalUnite> queryFilter) {
        return this.sysExternalUniteManager.query(queryFilter);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u5f97\u96c6\u6210\u5bf9\u8c61", httpMethod="GET", notes="\u83b7\u5f97\u96c6\u6210\u5bf9\u8c61")
    public SysExternalUnite getJson(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id) throws Exception {
        if (StringUtil.isEmpty((String)id)) {
            return new SysExternalUnite();
        }
        SysExternalUnite sysExternalUnite = (SysExternalUnite)this.sysExternalUniteManager.get((Serializable)((Object)id));
        return sysExternalUnite;
    }

    @RequestMapping(value={"generateMenuUrl"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u751f\u6210\u5e94\u7528\u83dc\u5355url", httpMethod="GET", notes="\u751f\u6210\u5e94\u7528\u83dc\u5355url")
    public CommonResult<String> generateMenuUrl(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id) throws Exception {
        SysExternalUnite sysExternalUnite = (SysExternalUnite)this.sysExternalUniteManager.get((Serializable)((Object)id));
        String menuUrl = "-1";
        String type = sysExternalUnite.getType();
        if (ExterUniEnum.WeChatWork.getKey().equals(type)) {
            menuUrl = WeChatWorkConsts.generateMenuUrl(sysExternalUnite.getBaseUrl(), sysExternalUnite.getCorpId());
        } else if (ExterUniEnum.Dingtalk.getKey().equals(type)) {
            menuUrl = DingTalkConsts.generateMenuUrl(sysExternalUnite.getBaseUrl(), sysExternalUnite.getCorpId());
        } else if (ExterUniEnum.WeChatOfficialAccounts.getKey().equals(type)) {
            menuUrl = WeChatOffAccConsts.generateMenuUrl(sysExternalUnite.getBaseUrl(), sysExternalUnite.getCorpId());
        }
        return new CommonResult(true, "", (Object)menuUrl);
    }

    @PostMapping(value={"save"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u7cfb\u7edf\u7b2c\u4e09\u65b9\u96c6\u6210\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u7cfb\u7edf\u7b2c\u4e09\u65b9\u96c6\u6210\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="sysExternalUnite", value="\u7b2c\u4e09\u65b9\u96c6\u6210\u4fe1\u606f") @RequestBody SysExternalUnite sysExternalUnite) throws Exception {
        CommonResult resultMsg = null;
        String id = sysExternalUnite.getId();
        try {
            Boolean isTypeExists = this.sysExternalUniteManager.isTypeExists(sysExternalUnite.getType(), sysExternalUnite.getId());
            if (isTypeExists.booleanValue()) {
                for (ExterUniEnum en : ExterUniEnum.values()) {
                    if (!en.getKey().equals(sysExternalUnite.getType())) continue;
                    return new CommonResult(false, "\u3010" + en.getLabel() + "\u3011\u5df2\u96c6\u6210,\u65e0\u9700\u91cd\u590d\u6dfb\u52a0\uff01");
                }
            }
            if (StringUtil.isEmpty((String)id)) {
                sysExternalUnite.setId(UniqueIdUtil.getSuid());
                sysExternalUnite.setCorpName(ExterUniEnum.getLabelByKey(sysExternalUnite.getType()));
                this.sysExternalUniteManager.create((Model)sysExternalUnite);
                resultMsg = new CommonResult(true, "\u6dfb\u52a0\u6210\u529f");
            } else {
                this.sysExternalUniteManager.update((Model)sysExternalUnite);
                resultMsg = new CommonResult(true, "\u66f4\u65b0\u6210\u529f");
            }
        }
        catch (Exception e) {
            resultMsg = new CommonResult(false, "\u5bf9\u7b2c\u4e09\u65b9\u96c6\u6210\u64cd\u4f5c\u5931\u8d25");
        }
        return resultMsg;
    }

    @RequestMapping(value={"removes"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7cfb\u7edf\u7b2c\u4e09\u65b9\u96c6\u6210\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u7cfb\u7edf\u7b2c\u4e09\u65b9\u96c6\u6210\u8bb0\u5f55")
    public CommonResult<String> batchRemove(String ... ids) throws Exception {
        try {
            this.sysExternalUniteManager.removeByIds(Arrays.asList(ids));
            return new CommonResult("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u5931\u8d25");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"syncUser"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5c06\u672c\u7cfb\u7edf\u7684\u7528\u6237\u540c\u6b65\u5230\u7b2c\u4e09\u65b9\u5e73\u53f0", httpMethod="GET", notes="\u5c06\u672c\u7cfb\u7edf\u7684\u7528\u6237\u540c\u6b65\u5230\u7b2c\u4e09\u65b9\u5e73\u53f0")
    public void syncUser(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id, HttpServletResponse response) throws Exception {
        boolean state = true;
        String errMsg = "\u4e0a\u4f20\u901a\u8baf\u5f55\u6210\u529f";
        try {
            this.sysExternalUniteManager.syncUser(id);
        }
        catch (Exception e) {
            state = false;
            errMsg = e.getMessage();
            e.printStackTrace();
        }
        finally {
            Map<String, String> mapMsg = ThreadMessageUtil.getMapMsg(true);
            if (BeanUtils.isNotEmpty(mapMsg)) {
                Iterator<Map.Entry<String, String>> iterator = mapMsg.entrySet().iterator();
                LinkedHashMap<String, String> exportMap = new LinkedHashMap<String, String>();
                exportMap.put("fullname", "\u8d26\u53f7");
                exportMap.put("errmsg", "\u5f02\u5e38\u4fe1\u606f");
                ArrayList data = new ArrayList();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> next = iterator.next();
                    HashMap<String, String> item = new HashMap<String, String>();
                    item.put("fullname", next.getKey());
                    item.put("errmsg", next.getValue());
                    data.add(item);
                }
                HSSFWorkbook book = ExcelUtil.exportExcel((String)"\u5f02\u5e38\u8d26\u53f7", (int)24, exportMap, data);
                ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)"\u4e0a\u4f20\u901a\u8baf\u5f55\u5f02\u5e38\u7684\u8d26\u53f7\u4fe1\u606f", (HttpServletResponse)response);
            } else {
                response.setHeader("content-type", "text/html;charset=UTF-8");
                response.setCharacterEncoding("UTF-8");
                CommonResult commonResult = new CommonResult(state, errMsg);
                PrintWriter out = response.getWriter();
                out.write(JsonUtil.toJsonString((Object)commonResult));
                out.flush();
                out.close();
            }
            ThreadMessageUtil.cleanMapMsg();
        }
    }

    @RequestMapping(value={"pullUser"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4ece\u7b2c\u4e09\u65b9\u7cfb\u7edf\u62c9\u53d6\u901a\u8baf\u5f55\u81f3\u672c\u7cfb\u7edf", httpMethod="GET", notes="\u4ece\u7b2c\u4e09\u65b9\u7cfb\u7edf\u62c9\u53d6\u901a\u8baf\u5f55\u81f3\u672c\u7cfb\u7edf")
    public CommonResult<String> pullUser(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id) throws Exception {
        try {
            this.sysExternalUniteManager.pullUser(id);
            return new CommonResult("\u62c9\u53d6\u901a\u8baf\u5f55\u6210\u529f");
        }
        catch (IOException e) {
            return new CommonResult(false, "\u62c9\u53d6\u901a\u8baf\u5f55\u5931\u8d25" + e.getMessage());
        }
    }

    @RequestMapping(value={"saveAgent"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u7cfb\u7edf\u7b2c\u4e09\u65b9\u96c6\u6210\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u7cfb\u7edf\u7b2c\u4e09\u65b9\u96c6\u6210\u4fe1\u606f")
    public CommonResult<String> saveAgent(@ApiParam(name="sysExternalUnite", value="\u7b2c\u4e09\u65b9\u96c6\u6210\u4fe1\u606f") @RequestBody SysExternalUnite sysExternalUnite) throws Exception {
        CommonResult resultMsg = null;
        try {
            this.sysExternalUniteManager.saveAgent(sysExternalUnite);
            resultMsg = new CommonResult("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            resultMsg = new CommonResult(false, "\u5bf9\u7b2c\u4e09\u65b9\u96c6\u6210\u64cd\u4f5c\u5931\u8d25:" + e.getMessage());
        }
        return resultMsg;
    }

    @RequestMapping(value={"getToken"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6getToken", httpMethod="GET", notes="\u83b7\u53d6getToken")
    public String getToken(String type) throws IOException {
        String token = "";
        if (ExterUniEnum.WeChatWork.getKey().equals(type)) {
            token = WechatWorkTokenUtil.getToken();
        } else if (ExterUniEnum.Dingtalk.getKey().equals(type)) {
            token = DingTalkTokenUtil.getToken();
        }
        return token;
    }

    @RequestMapping(value={"getUserInfoUrl"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6getUserInfoUrl", httpMethod="GET", notes="\u83b7\u53d6getUserInfoUrl")
    public String getUserInfoUrl(@ApiParam(name="type", value="\u7b2c\u4e09\u65b9\u96c6\u6210\u7c7b\u578b") @RequestParam String type, @ApiParam(name="code", value="\u5e94\u7528code") @RequestParam String code) throws Exception {
        String url = "";
        if (ExterUniEnum.WeChatWork.getKey().equals(type)) {
            url = WeChatWorkConsts.getQyWxUserInfo(code);
        } else if (ExterUniEnum.Dingtalk.getKey().equals(type)) {
            url = DingTalkConsts.getUserInfo(code);
        } else if (ExterUniEnum.WeChatOfficialAccounts.getKey().equals(type)) {
            url = WeChatOffAccConsts.getWxAccessToken(code);
        }
        return url;
    }
}

