/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.integrate.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.integrate.consts.WeChatWorkConsts;
import com.artfess.integrate.enums.ExterUniEnum;
import com.artfess.integrate.model.SysExternalUnite;
import com.artfess.integrate.persistence.dao.SysExternalUniteDao;
import com.artfess.integrate.persistence.manager.SysExternalUniteManager;
import com.artfess.integrate.persistence.manager.impl.DtUserService;
import com.artfess.integrate.persistence.manager.impl.WxUserService;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="sysExternalUniteManager")
public class SysExternalUniteManagerImpl
extends BaseManagerImpl<SysExternalUniteDao, SysExternalUnite>
implements SysExternalUniteManager {
    @Resource
    WxUserService wxUserService;
    @Resource
    DtUserService dtUserService;
    @Resource
    SysExternalUniteDao sysExternalUniteDao;

    @Override
    public boolean isTypeExists(String type, String id) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", type);
        map.put("id", id);
        return BeanUtils.isNotEmpty((Object)((Object)this.sysExternalUniteDao.isTypeExists(map)));
    }

    @Override
    public SysExternalUnite getWechatWork() {
        return this.sysExternalUniteDao.getOneByType(ExterUniEnum.WeChatWork.getKey());
    }

    @Override
    public SysExternalUnite getDingtalk() {
        return this.sysExternalUniteDao.getOneByType(ExterUniEnum.Dingtalk.getKey());
    }

    @Override
    public SysExternalUnite getWeChatOfficialAccounts() {
        return this.sysExternalUniteDao.getOneByType(ExterUniEnum.WeChatOfficialAccounts.getKey());
    }

    @Override
    public void syncUser(String uniteId) throws IOException {
        SysExternalUnite entity = (SysExternalUnite)this.get((Serializable)((Object)uniteId));
        if (BeanUtils.isEmpty((Object)((Object)entity))) {
            throw new RuntimeException("\u67e5\u65e0\u6b64\u96c6\u6210\u4fe1\u606f");
        }
        if (ExterUniEnum.WeChatWork.getKey().equals(entity.getType())) {
            this.wxUserService.syncUser(null);
        } else if (ExterUniEnum.Dingtalk.getKey().equals(entity.getType())) {
            this.dtUserService.syncUser(null);
        }
    }

    @Override
    public void saveAgent(SysExternalUnite unite) throws IOException {
        this.update((Model)unite);
        if ("1".equals(unite.getIsPublish()) && ExterUniEnum.WeChatWork.getKey().equals(unite.getType())) {
            String url = WeChatWorkConsts.getCreateAgentMenuUrl(unite.getAgentId());
            String button = "{\"button\":[{\"type\":\"view\",\"name\":\"$name\",\"url\":\"$url\"}]}";
            button = button.replace("$name", unite.getMenuName()).replace("$url", unite.getMenuUrl());
            String rtn = HttpUtil.sendHttpsRequest((String)url, (String)button, (String)"POST");
            JsonNode jsonObj = JsonUtil.toJsonNode((String)rtn);
            System.out.println(jsonObj);
            if (!"0".equals(jsonObj.get("errcode").asText())) {
                throw new RuntimeException("\u53d1\u5e03\u83dc\u5355\u5931\u8d25\uff1a" + jsonObj.get("errmsg").asText());
            }
        }
    }

    @Override
    public void pullUser(String uniteId) throws Exception {
        SysExternalUnite entity = (SysExternalUnite)this.get((Serializable)((Object)uniteId));
        if (BeanUtils.isEmpty((Object)((Object)entity))) {
            throw new RuntimeException("\u67e5\u65e0\u6b64\u96c6\u6210\u4fe1\u606f");
        }
        if (ExterUniEnum.WeChatWork.getKey().equals(entity.getType())) {
            this.wxUserService.pullUser("1");
        } else if (ExterUniEnum.Dingtalk.getKey().equals(entity.getType())) {
            if (StringUtil.isEmpty((String)entity.getAgentKey()) || StringUtil.isEmpty((String)entity.getAgentSecret())) {
                throw new RuntimeException("\u8bf7\u5148\u914d\u7f6e\u5e94\u7528\uff0c\u5e76\u4e14\u4fdd\u8bc1\u5e94\u7528\u6709\u6743\u9650\u8bbf\u95ee\u901a\u8baf\u5f55\u76f8\u5173\u6743\u9650\uff01");
            }
            this.dtUserService.pullOrgAndUser("1");
        }
    }
}

