/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.uc.dao.ShiftRuleDao;
import com.artfess.uc.manager.HolidayTimeManager;
import com.artfess.uc.manager.ShiftRuleManager;
import com.artfess.uc.model.HolidayTime;
import com.artfess.uc.model.ShiftRule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="shiftRuleManager")
public class ShiftRuleManagerImpl
extends BaseManagerImpl<ShiftRuleDao, ShiftRule>
implements ShiftRuleManager {
    @Resource
    HolidayTimeManager holidayTimeManager;
    public static final String STYLE = "yyyy-MM-dd HH:mm:ss";

    @Override
    public long computeSendDate(String userId, long minute) throws ParseException, IOException {
        long checkDuration = minute * 60L * 1000L;
        ShiftRule rule = this.getRuleByUserId(userId);
        if (BeanUtils.isEmpty((Object)rule)) {
            return DateUtil.getCurrentTimeInMillis() + checkDuration;
        }
        List<HolidayTime> holidayTimes = this.getHolidayTimes(rule.getHolidayId());
        Map<Integer, ObjectNode> shiftMap = this.getMap(rule.getRule());
        LocalDateTime today = DateUtil.getCurrentDate();
        int count = 0;
        long result = TimeUtil.getTimeMillis((LocalDateTime)today);
        while (checkDuration > 0L) {
            if (count != 0) {
                today = today.plusDays(1L);
            }
            int day = today.getDayOfWeek().getValue() % 7;
            long duration = 0L;
            HolidayTime makeUpDay = this.getMakeUpDay(holidayTimes, TimeUtil.getTimeMillis((LocalDateTime)today));
            if (!this.isHoliday(holidayTimes, TimeUtil.getTimeMillis((LocalDateTime)today)) && this.isWorkDay(shiftMap.get(day))) {
                ObjectNode shift = shiftMap.get(day);
                LocalDateTime startDateTime = DateFormatUtil.parse((String)(DateFormatUtil.format((LocalDateTime)today, (String)"yyyy-MM-dd ") + shift.get("startTime").asText()), (String)STYLE);
                LocalDateTime endDateTime = DateFormatUtil.parse((String)(DateFormatUtil.format((LocalDateTime)today, (String)"yyyy-MM-dd ") + shift.get("endTime").asText()), (String)STYLE);
                long startTime = TimeUtil.getTimeMillis((LocalDateTime)startDateTime);
                long endTime = TimeUtil.getTimeMillis((LocalDateTime)endDateTime);
                if (endTime - startTime > checkDuration && count != 0) {
                    duration = checkDuration;
                    result = startTime + duration;
                }
                if (endTime - TimeUtil.getTimeMillis((LocalDateTime)today) > checkDuration && count == 0) {
                    duration = checkDuration;
                    result = TimeUtil.getTimeMillis((LocalDateTime)today) + duration;
                }
                if (today.isBefore(startDateTime)) {
                    duration = endTime - startTime;
                } else if (today.isBefore(endDateTime)) {
                    duration = endTime - TimeUtil.getTimeMillis((LocalDateTime)today);
                    today = LocalDateTime.of(today.toLocalDate(), LocalTime.MIN);
                }
            } else if (BeanUtils.isNotEmpty((Object)((Object)makeUpDay))) {
                long startTime = TimeUtil.getTimeMillis((LocalDateTime)makeUpDay.getStartTime());
                long endTime = TimeUtil.getTimeMillis((LocalDateTime)makeUpDay.getEndTime());
                if (endTime - startTime > checkDuration && count != 0) {
                    duration = checkDuration;
                    result = startTime + duration;
                }
                if (endTime - TimeUtil.getTimeMillis((LocalDateTime)today) > checkDuration && count == 0) {
                    duration = checkDuration;
                    result = TimeUtil.getTimeMillis((LocalDateTime)today) + duration;
                }
                if (today.isBefore(makeUpDay.getStartTime())) {
                    duration = endTime - startTime;
                } else if (today.isBefore(makeUpDay.getEndTime())) {
                    duration = endTime - TimeUtil.getTimeMillis((LocalDateTime)today);
                    today = LocalDateTime.of(today.toLocalDate(), LocalTime.MIN);
                }
            }
            checkDuration -= duration;
            ++count;
        }
        return result;
    }

    @Override
    public long computeDuration(String userId, LocalDateTime startDate, LocalDateTime endDate) throws ParseException, IOException {
        long duration = 0L;
        ShiftRule rule = this.getRuleByUserId(userId);
        if (BeanUtils.isEmpty((Object)rule)) {
            return TimeUtil.getTimeMillis((LocalDateTime)endDate) - TimeUtil.getTimeMillis((LocalDateTime)startDate);
        }
        List<HolidayTime> holidayTimes = this.getHolidayTimes(rule.getHolidayId());
        Map<Integer, ObjectNode> shiftMap = this.getMap(rule.getRule());
        LocalDateTime currentDate = DateFormatUtil.parse((String)DateFormatUtil.format((LocalDateTime)startDate, (String)STYLE));
        while (TimeUtil.getTimeMillis((LocalDateTime)currentDate) < TimeUtil.getTimeMillis((LocalDateTime)endDate)) {
            int day = currentDate.getDayOfWeek().getValue() % 7;
            HolidayTime makeUpDay = this.getMakeUpDay(holidayTimes, TimeUtil.getTimeMillis((LocalDateTime)currentDate));
            if (!this.isHoliday(holidayTimes, TimeUtil.getTimeMillis((LocalDateTime)currentDate)) && this.isWorkDay(shiftMap.get(day))) {
                ObjectNode shift = shiftMap.get(day);
                LocalDateTime startDateTime = DateFormatUtil.parse((String)(DateFormatUtil.format((LocalDateTime)currentDate, (String)"yyyy-MM-dd ") + shift.get("startTime").asText()), (String)STYLE);
                LocalDateTime endDateTime = DateFormatUtil.parse((String)(DateFormatUtil.format((LocalDateTime)currentDate, (String)"yyyy-MM-dd ") + shift.get("endTime").asText()), (String)STYLE);
                if (currentDate.isBefore(startDateTime)) {
                    duration = endDate.isBefore(endDateTime) ? (duration += TimeUtil.getTimeMillis((LocalDateTime)endDate) - TimeUtil.getTimeMillis((LocalDateTime)startDateTime)) : (duration += TimeUtil.getTimeMillis((LocalDateTime)endDateTime) - TimeUtil.getTimeMillis((LocalDateTime)startDateTime));
                } else if (currentDate.isBefore(endDateTime)) {
                    duration = endDate.isBefore(makeUpDay.getEndTime()) ? TimeUtil.getTimeMillis((LocalDateTime)endDate) - TimeUtil.getTimeMillis((LocalDateTime)currentDate) : (duration += TimeUtil.getTimeMillis((LocalDateTime)endDateTime) - TimeUtil.getTimeMillis((LocalDateTime)currentDate));
                }
            } else if (BeanUtils.isNotEmpty((Object)((Object)makeUpDay))) {
                if (currentDate.isBefore(makeUpDay.getStartTime())) {
                    duration = endDate.isBefore(makeUpDay.getEndTime()) ? (duration += TimeUtil.getTimeMillis((LocalDateTime)endDate) - TimeUtil.getTimeMillis((LocalDateTime)makeUpDay.getStartTime())) : (duration += TimeUtil.getTimeMillis((LocalDateTime)makeUpDay.getEndTime()) - TimeUtil.getTimeMillis((LocalDateTime)makeUpDay.getStartTime()));
                    duration += TimeUtil.getTimeMillis((LocalDateTime)makeUpDay.getEndTime()) - TimeUtil.getTimeMillis((LocalDateTime)makeUpDay.getStartTime());
                } else if (currentDate.isBefore(makeUpDay.getEndTime())) {
                    duration = endDate.isBefore(makeUpDay.getEndTime()) ? TimeUtil.getTimeMillis((LocalDateTime)endDate) - TimeUtil.getTimeMillis((LocalDateTime)currentDate) : (duration += TimeUtil.getTimeMillis((LocalDateTime)makeUpDay.getEndTime()) - TimeUtil.getTimeMillis((LocalDateTime)currentDate));
                }
            }
            currentDate = LocalDateTime.of(currentDate.toLocalDate(), LocalTime.MIN);
            currentDate = currentDate.plusDays(1L);
        }
        return duration;
    }

    private Map<Integer, ObjectNode> getMap(String rule) throws IOException {
        ArrayNode shifts = (ArrayNode)JsonUtil.toJsonNode((String)rule);
        List shiftList = JsonUtil.arrayToList((ArrayNode)shifts);
        Map<Integer, ObjectNode> shiftMap = shiftList.parallelStream().collect(Collectors.toMap(item -> item.get("date").asInt(), item -> item));
        return shiftMap;
    }

    private List<HolidayTime> getHolidayTimes(String holidayId) {
        List<HolidayTime> holidayTimes = new ArrayList<HolidayTime>();
        if (StringUtil.isNotEmpty((String)holidayId)) {
            holidayTimes = this.holidayTimeManager.getByHolidayId((Serializable)((Object)holidayId));
        }
        return holidayTimes;
    }

    @Override
    public ShiftRule getRuleByUserId(String userId) {
        return ((ShiftRuleDao)this.baseMapper).getRuleByUserId(userId);
    }

    private boolean isWorkDay(ObjectNode shift) {
        return shift.get("type").asInt() == 1;
    }

    private HolidayTime getMakeUpDay(List<HolidayTime> makeUpDay, long time) {
        List times = makeUpDay.parallelStream().filter(item -> item.getType() == HolidayTime.MAKE_UP_DAY).filter(item -> {
            LocalDateTime startDateTime = LocalDateTime.of(item.getStartTime().toLocalDate(), LocalTime.MIN);
            LocalDateTime endDateTime = LocalDateTime.of(item.getEndTime().toLocalDate(), LocalTime.MAX);
            return this.isBetween(startDateTime, endDateTime, time);
        }).collect(Collectors.toList());
        if (BeanUtils.isNotEmpty(times)) {
            return (HolidayTime)((Object)times.get(0));
        }
        return null;
    }

    private boolean isHoliday(List<HolidayTime> holidays, long time) {
        return holidays.parallelStream().filter(item -> item.getType() == HolidayTime.HOLIDAY).filter(item -> this.isBetween(item.getStartTime(), item.getEndTime(), time)).collect(Collectors.counting()).intValue() > 0;
    }

    private boolean isBetween(LocalDateTime startTime, LocalDateTime endTime, long time) {
        return TimeUtil.getTimeMillis((LocalDateTime)startTime) <= time && endTime.toInstant(ZoneOffset.of("+8")).toEpochMilli() > time;
    }
}

