/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.persistence.manager.impl;

import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.datasource.DatabaseSwitchResult;
import com.artfess.base.exception.BaseException;
import com.artfess.base.handler.MultiTenantHandler;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JAXBUtil;
import com.artfess.base.util.SQLUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.form.model.ViewManage;
import com.artfess.form.model.ViewManageList;
import com.artfess.form.persistence.dao.ViewManageDao;
import com.artfess.form.persistence.manager.ViewManageManager;
import com.artfess.table.operator.IViewOperator;
import com.artfess.table.util.MetaDataUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service(value="viewManageManager")
public class ViewManageManagerImpl
extends BaseManagerImpl<ViewManageDao, ViewManage>
implements ViewManageManager {
    @Resource
    DatabaseContext databaseContext;

    @Override
    @Transactional
    public void savePub(ViewManage viewManage, Integer saveType) {
        if (saveType == 1) {
            this.createPhysicalView(viewManage);
            viewManage.setStatus(ViewManage.Generated);
        }
        MultiTenantHandler.removeThreadLocalIgnore();
        if (StringUtil.isEmpty((String)viewManage.getId())) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"DS_ALIAS_", (Object)viewManage.getDsAlias());
            wrapper.eq((Object)"VIEW_NAME_", (Object)viewManage.getViewName());
            List viewManageList = ((ViewManageDao)this.baseMapper).selectList((Wrapper)wrapper);
            if (viewManageList != null && !viewManageList.isEmpty()) {
                throw new BaseException("\u89c6\u56fe\uff1a\"" + viewManage.getViewName() + "\"\u5df2\u5b58\u5728\uff0c\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0\uff01");
            }
            this.create((Model)viewManage);
        } else {
            this.update((Model)viewManage);
        }
    }

    @Override
    @Transactional
    public void createPhysicalView(String id) {
        ViewManage viewManage = (ViewManage)this.get((Serializable)((Object)id));
        this.createPhysicalView(viewManage);
        viewManage.setStatus(ViewManage.Generated);
        this.update((Model)viewManage);
    }

    public void createPhysicalView(ViewManage viewManage) {
        if (SQLUtil.containsSqlInjection((String)viewManage.getSql())) {
            throw new BaseException("sql\u8bed\u53e5\u542b\u6709\u975e\u6cd5\u6ce8\u5165\uff01");
        }
        try (DatabaseSwitchResult dResult = this.databaseContext.setDataSource(viewManage.getDsAlias());){
            IViewOperator iViewOperator = MetaDataUtil.getIViewOperatorAfterSetDT((String)dResult.getDbType());
            iViewOperator.createOrRep(viewManage.getViewName(), viewManage.getSql());
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg != null) {
                if (msg.contains("is not VIEW")) {
                    throw new BaseException("\u89c6\u56fe\u540d\u79f0\u5728\u6570\u636e\u5e93\u5df2\u5b58\u5728\uff0c\u8bf7\u8c03\u6574\uff01");
                }
                if (msg.contains("bad SQL grammar")) {
                    throw new BaseException("SQL\u8bed\u53e5\u5b58\u5728\u8bed\u6cd5\u9519\u8bef\uff0c\u8bf7\u8c03\u6574\uff01");
                }
            }
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Map<String, String> exportData(List<String> ids) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        ViewManageList viewManageList = new ViewManageList();
        for (String id : ids) {
            ViewManage viewManage = (ViewManage)this.get((Serializable)((Object)id));
            viewManageList.addViewManage(viewManage);
        }
        try {
            String xml = JAXBUtil.marshall((Object)viewManageList, ViewManageList.class);
            map.put("viewManages.form.xml", xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25\uff01" + e.getMessage(), e);
        }
        return map;
    }

    @Override
    @Transactional
    public void importData(MultipartFile file) {
        File formDir;
        String unZipFilePath = null;
        try {
            String rootRealPath = Paths.get(FileUtil.getIoTmpdir(), "attachFiles/unZip").toString();
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            unZipFilePath = Paths.get(rootRealPath, fileDir).toString();
            String xml = FileUtil.readFile((String)Paths.get(unZipFilePath, "viewManages.form.xml").toString());
            if (StringUtil.isEmpty((String)xml)) {
                throw new BaseException("\u5bfc\u5165\u7684xml\u6587\u4ef6\u6ca1\u6709\u5185\u5bb9\uff01");
            }
            ViewManageList list = (ViewManageList)JAXBUtil.unmarshall((String)xml, ViewManageList.class);
            List<ViewManage> viewManageList = list.getViewManageList();
            for (ViewManage viewManage : viewManageList) {
                this.importData(viewManage);
            }
        }
        catch (Exception e) {
            try {
                throw new BaseException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                File formDir2;
                if (StringUtil.isNotEmpty(unZipFilePath) && (formDir2 = new File(unZipFilePath)).exists()) {
                    FileUtil.deleteDir((File)formDir2);
                }
                throw throwable;
            }
        }
        if (StringUtil.isNotEmpty((String)unZipFilePath) && (formDir = new File(unZipFilePath)).exists()) {
            FileUtil.deleteDir((File)formDir);
        }
    }

    private void importData(ViewManage viewManage) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"DS_ALIAS_", (Object)viewManage.getDsAlias());
        wrapper.eq((Object)"VIEW_NAME_", (Object)viewManage.getViewName());
        List viewManageList = ((ViewManageDao)this.baseMapper).selectList((Wrapper)wrapper);
        if (viewManageList != null && !viewManageList.isEmpty()) {
            ThreadMsgUtil.addMapMsg2((String)"viewsSkipped", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s [%s]</div>", viewManage.getViewName() + "", viewManage.getDsAlias() + ""));
            return;
        }
        String id = UniqueIdUtil.getSuid();
        viewManage.setId(id);
        if (SQLUtil.containsSqlInjection((String)viewManage.getSql())) {
            throw new BaseException("SQL\u8bed\u53e5\u542b\u6709\u975e\u6cd5\u6ce8\u5165\uff01");
        }
        try (DatabaseSwitchResult dResult = this.databaseContext.setDataSource(viewManage.getDsAlias());){
            IViewOperator iViewOperator = MetaDataUtil.getIViewOperatorAfterSetDT((String)dResult.getDbType());
            iViewOperator.createOrRep(viewManage.getViewName(), viewManage.getSql());
        }
        catch (Exception e) {
            throw new BaseException("SQL\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u4e0d\u652f\u6301\u5bfc\u5165\uff01");
        }
        viewManage.setStatus(ViewManage.Generated);
        this.create((Model)viewManage);
        ThreadMsgUtil.addMapMsg2((String)"viewsSaved", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s [%s]</div>", viewManage.getViewName() + "", viewManage.getDsAlias() + ""));
    }
}

