/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bo.instance.impl;

import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.datasource.DatabaseSwitchResult;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.WorkflowFeignService;
import com.artfess.base.feign.dto.PortalDataSensitive;
import com.artfess.base.manager.CommonManager;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.bo.context.FormContextThreadUtil;
import com.artfess.bo.exception.BoBaseException;
import com.artfess.bo.instance.impl.AbstractBoDataHandler;
import com.artfess.bo.model.BoAttribute;
import com.artfess.bo.model.BoData;
import com.artfess.bo.model.BoDataRel;
import com.artfess.bo.model.BoDef;
import com.artfess.bo.model.BoEnt;
import com.artfess.bo.model.BoResult;
import com.artfess.bo.model.SqlModel;
import com.artfess.bo.persistence.dao.BoDataRelDao;
import com.artfess.bo.persistence.manager.BoEntManager;
import com.artfess.table.meta.impl.BaseTableMeta;
import com.artfess.table.util.MetaDataUtil;
import com.artfess.uc.api.util.IPermissionCalc;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.jsonwebtoken.lang.Assert;
import java.io.IOException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.UnaryOperator;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;

@Service(value="boDataHandler")
public class BoDbHandlerImpl
extends AbstractBoDataHandler {
    @Resource
    DatabaseContext databaseContext;
    @Resource
    BoDataRelDao boDataRelDao;
    @Resource
    CommonManager commonManager;
    @Resource
    BoEntManager boEntManager;
    @Resource
    SystemConfigFeignService systemConfigFeignService;
    @Resource
    IPermissionCalc permissionCalc;

    @Override
    public List<BoResult> save(String id, String defId, BoData curData) {
        BoEnt boEnt = curData.getBoEnt();
        Map<String, Object> row = curData.getData();
        String pk = "";
        if (boEnt != null) {
            pk = boEnt.getPkKey().toLowerCase();
            if (StringUtil.isNotEmpty((String)id)) {
                row.put(pk, id);
            }
        }
        ArrayList<BoResult> resultList = new ArrayList<BoResult>();
        try {
            if (row.containsKey(pk)) {
                this.update(curData, resultList);
            } else {
                this.add(curData, resultList, "0");
            }
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
            String[] str = ex.getMessage().split(":");
            throw new NumberFormatException(str[1] + "\u975e\u6570\u5b57\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u6570\u503c\uff01");
        }
        catch (BaseException e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
        catch (Exception ex) {
            throw new BaseException(ex.getMessage(), (Throwable)ex);
        }
        if (curData.getBoDef() != null) {
            this.setBoDefAlias(resultList, curData.getBoDef().getAlias());
        }
        return resultList;
    }

    private BoDef getBoDefByAlias(String alias) {
        BoDef boDef = this.boDefManager.getByAlias(alias);
        return boDef;
    }

    @Override
    public BoData getById(Object pk, String bodefCode) {
        BoDef boDef = this.getBoDefByAlias(bodefCode);
        BoData boData = new BoData();
        boData.setBoDef(boDef);
        BoEnt boEnt = boDef.getBoEnt();
        boData.setBoEnt(boEnt);
        Map<String, Object> row = this.getById(boEnt, pk);
        boData.setData(row);
        List<BoEnt> childEntList = boEnt.getChildEntList();
        for (BoEnt childEnt : childEntList) {
            List<Map<String, Object>> list = this.getByFk(childEnt, pk);
            String key = childEnt.getName();
            ArrayList<BoData> listData = new ArrayList<BoData>();
            List<BoEnt> sunEntList = childEnt.getChildEntList();
            Map<String, Object> initData = childEnt.getInitData();
            if (BeanUtils.isNotEmpty(sunEntList)) {
                HashMap<String, Map<String, Object>> sunInitData = new HashMap<String, Map<String, Object>>();
                for (BoEnt sunEnt : sunEntList) {
                    initData.put("sub_" + sunEnt.getName(), new ArrayList());
                    sunInitData.put(sunEnt.getName(), sunEnt.getInitData());
                }
                initData.put("initData", sunInitData);
            }
            for (Map<String, Object> rowMap : list) {
                BoData childData = new BoData();
                Map<String, Object> rtnMap = this.convertDbToData(childEnt, rowMap);
                childData.setData(rtnMap);
                if (BeanUtils.isNotEmpty(sunEntList)) {
                    String subPkStr = StringUtil.isNotEmpty((String)childEnt.getPk()) ? childEnt.getPk() : BoEnt.PK_NAME;
                    String subPk = String.valueOf(rowMap.get(subPkStr));
                    if (StringUtil.isEmpty((String)subPk) && StringUtil.isNotEmpty((String)subPkStr)) {
                        subPk = (String)rowMap.get(subPkStr.toLowerCase());
                    }
                    for (BoEnt sunEnt : sunEntList) {
                        List<Map<String, Object>> sunList = this.getByFk(sunEnt, subPk);
                        String sunKey = sunEnt.getName();
                        ArrayList<BoData> sunListData = new ArrayList<BoData>();
                        for (Map<String, Object> sunRowMap : sunList) {
                            BoData sunData = new BoData();
                            Map<String, Object> sunRtnMap = this.convertDbToData(sunEnt, sunRowMap);
                            sunData.setData(sunRtnMap);
                            sunListData.add(sunData);
                        }
                        childData.addInitDataMap(sunKey, sunEnt.getInitData());
                        childData.setSubList(sunKey, sunListData);
                    }
                }
                listData.add(childData);
            }
            boData.addInitDataMap(key, initData);
            boData.setSubList(key, listData);
        }
        return boData;
    }

    private Map<String, Object> convertDbToData(BoEnt boEnt, Map<String, Object> map) {
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> ent : map.entrySet()) {
            String field = ent.getKey().toLowerCase();
            BoAttribute attribute = boEnt.getAttrByField(field);
            if (!BeanUtils.isNotEmpty((Object)((Object)attribute))) continue;
            Object val = this.handValue(attribute, ent.getValue());
            rtnMap.put(attribute.getName(), val);
        }
        Object f_form_data_rev_ = 0;
        if (map.containsKey("F_form_data_rev_")) {
            f_form_data_rev_ = map.get("F_form_data_rev_");
        } else if (map.containsKey("f_form_data_rev_")) {
            f_form_data_rev_ = map.get("f_form_data_rev_");
        } else if (map.containsKey("F_FORM_DATA_REV_")) {
            f_form_data_rev_ = map.get("F_FORM_DATA_REV_");
        }
        if (map.containsKey(BoEnt.SUB_ROW_READONLY)) {
            rtnMap.put(BoEnt.SUB_ROW_READONLY, map.get(BoEnt.SUB_ROW_READONLY));
        }
        rtnMap.put("form_data_rev_", f_form_data_rev_);
        if (!"main".equals(boEnt.getType())) {
            rtnMap.put(BoEnt.SUB_KEY, UUID.randomUUID());
        }
        String pkKey = boEnt.getPkKey();
        if (boEnt.isPkNumber() && BeanUtils.isNotEmpty(rtnMap.get(pkKey))) {
            rtnMap.put(pkKey, rtnMap.get(pkKey).toString());
        }
        return rtnMap;
    }

    private Object handValue(BoAttribute attr, Object val) {
        if (BeanUtils.isEmpty((Object)val)) {
            return val;
        }
        if ("date".equals(attr.getDataType())) {
            String format = attr.getFormat();
            if (val instanceof Timestamp) {
                Timestamp times = (Timestamp)val;
                return TimeUtil.getDateTimeString((LocalDateTime)times.toLocalDateTime(), (String)format);
            }
            if (val instanceof Date) {
                return TimeUtil.getDateTimeString((LocalDateTime)DateFormatUtil.parse((Date)((Date)val)), (String)format);
            }
            if (val instanceof LocalDateTime) {
                return TimeUtil.getDateTimeString((LocalDateTime)((LocalDateTime)val), (String)format);
            }
        }
        return val;
    }

    private Map<String, Object> getById(BoEnt boEnt, Object pk) {
        Map<String, Object> map;
        block16: {
            String sql = String.format("select * from %s where %s=#{pk}", boEnt.getTableName(), boEnt.getPkKey());
            if (boEnt.isPkNumber()) {
                pk = Long.valueOf(pk.toString());
            }
            map = null;
            if (boEnt.isExternal()) {
                try (DatabaseSwitchResult setDataSource = this.databaseContext.setDataSource(boEnt.getDsName());){
                    map = this.getOneById(sql, pk);
                    break block16;
                }
                catch (Exception e) {
                    throw new BoBaseException("\u64cd\u4f5c\u5916\u90e8\u8868\uff1a" + boEnt.getDsName() + " \u4e2d\u7684 " + boEnt.getDesc() + " \u51fa\u9519\uff1a" + ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
            }
            map = this.getOneById(sql, pk);
        }
        Map<String, Object> rtnMap = this.convertDbToData(boEnt, map);
        return rtnMap;
    }

    private Map<String, Object> getOneById(String sql, Object pk) {
        List result;
        HashMap<String, Object> buildMap = new HashMap<String, Object>();
        if (BeanUtils.isNotEmpty((Object)pk)) {
            buildMap.put("pk", pk);
        }
        Assert.isTrue((BeanUtils.isNotEmpty((Object)(result = this.commonManager.query(sql, buildMap))) && result.size() == 1 ? 1 : 0) != 0, (String)"\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u6570\u636e\u65f6\u7ed3\u679c\u4e3a\u7a7a\u6216\u67e5\u8be2\u5230\u8d85\u8fc7\u4e00\u6761\u8bb0\u5f55");
        return (Map)result.get(0);
    }

    private List<Map<String, Object>> getByFk(BoEnt boEnt, Object pk) {
        ArrayList<Map<String, Object>> list = new ArrayList();
        ObjectNode subRowAuthJosn = null;
        if (BeanUtils.isNotEmpty((Object)FormContextThreadUtil.getCommuVar("subRowAuthJosn", ""))) {
            try {
                ObjectNode curTab = (ObjectNode)JsonUtil.toJsonNode((String)((String)FormContextThreadUtil.getCommuVar("subRowAuthJosn", "")));
                subRowAuthJosn = (ObjectNode)curTab.get(boEnt.getName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String sql = "";
        String readSql = "";
        HashSet<String> totalAuth = new HashSet<String>();
        HashMap<String, String> varMap = new HashMap<String, String>();
        if (BeanUtils.isNotEmpty((Object)subRowAuthJosn)) {
            if (boEnt.getType().equals("manytomany")) {
                sql = "select A.* from " + boEnt.getTableName() + " A , form_bo_data_relation B where " + " B.SUB_BO_NAME = '" + boEnt.getName() + "' AND A." + boEnt.getPk() + "=B.FK_  AND B.PK_=?";
            } else {
                String fk = boEnt.getFk();
                if (StringUtil.isEmpty((String)fk)) {
                    throw new RuntimeException("\u901a\u8fc7\u6dfb\u52a0\u5916\u90e8\u8868\u6784\u5efa\u4e1a\u52a1\u5bf9\u8c61\u65f6\u5fc5\u987b\u6307\u5b9a\u5916\u952e");
                }
                sql = "select * from " + boEnt.getTableName() + " A  where A." + fk + "=?";
            }
            varMap.put("curDate", DateUtil.getCurrentTime());
            varMap.put("curUserId", AuthenticationUtil.getCurrentUserId());
            varMap.put("curUserAccount", AuthenticationUtil.getCurrentUsername());
            varMap.put("curUserName", AuthenticationUtil.getCurrentUserFullname());
            varMap.put("curUserOrgIds", this.transToInsql(AuthenticationUtil.getCurrentUserOrgIds()));
            varMap.put("curUserOrgAndUnderIds", this.transToInsql(AuthenticationUtil.getCurrentUserSubOrgIds()));
            varMap.put("curUserRolesAlias", this.transToInsql(StringUtil.join((Collection)AuthenticationUtil.getCurrentUserRolesAlias(), (String)",")));
            readSql = sql;
            ArrayNode total = (ArrayNode)subRowAuthJosn.get("total");
            for (JsonNode jsonNode : total) {
                totalAuth.add(jsonNode.asText());
            }
            if (!totalAuth.contains("r") && StringUtil.isNotEmpty((String)JsonUtil.getStrByPath((JsonNode)subRowAuthJosn, (String)"r.conditionString"))) {
                readSql = sql + " and (" + JsonUtil.getStrByPath((JsonNode)subRowAuthJosn, (String)"r.conditionString") + ")";
                readSql = StringUtil.getStrByRule((String)readSql, varMap);
            }
        } else {
            WorkflowFeignService workflowFeignService = (WorkflowFeignService)AppUtil.getBean(WorkflowFeignService.class);
            ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
            try {
                objectNode = (ObjectNode)JsonUtil.toJsonNode((Object)((Object)boEnt));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            String defId = (String)FormContextThreadUtil.getCommuVar("defId", "");
            String nodeId = (String)FormContextThreadUtil.getCommuVar("nodeId", "");
            String parentDefKey = (String)FormContextThreadUtil.getCommuVar("parentDefKey", "local_");
            CommonResult result = workflowFeignService.getSubDataSqlByFk(objectNode, pk, defId, nodeId, parentDefKey);
            readSql = (String)result.getValue();
        }
        list = this.executeQuery(boEnt, readSql, pk);
        if (BeanUtils.isEmpty(list) || BeanUtils.isEmpty((Object)subRowAuthJosn) || totalAuth.contains("w") || StringUtil.isEmpty((String)JsonUtil.getStrByPath((JsonNode)subRowAuthJosn, (String)"w.conditionString"))) {
            return list;
        }
        HashSet<Object> editKeys = new HashSet<Object>();
        String editSql = sql + " and (" + JsonUtil.getStrByPath((JsonNode)subRowAuthJosn, (String)"w.conditionString") + ")";
        List<Map<String, Object>> editList = this.executeQuery(boEnt, editSql = StringUtil.getStrByRule((String)editSql, varMap), pk);
        if (BeanUtils.isNotEmpty(editList)) {
            for (Map<String, Object> data : editList) {
                editKeys.add(data.get(BoEnt.PK_NAME));
            }
        }
        for (Map<String, Object> data : list) {
            if (editKeys.contains(data.get(BoEnt.PK_NAME))) {
                data.put(BoEnt.SUB_ROW_READONLY, false);
                continue;
            }
            data.put(BoEnt.SUB_ROW_READONLY, true);
        }
        return list;
    }

    private String transToInsql(String str) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("('");
        if (StringUtil.isNotEmpty((String)str)) {
            sBuilder.append(StringUtil.join((String[])str.split(","), (String)"','"));
        }
        sBuilder.append("')");
        return sBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Map<String, Object>> executeQuery(BoEnt boEnt, String sql, Object pk) {
        if (!boEnt.isExternal()) {
            return this.commonManager.query(sql, new Object[]{pk});
        }
        try (DatabaseSwitchResult setDataSource = this.databaseContext.setDataSource(boEnt.getDsName());){
            List list = this.commonManager.query(sql, new Object[]{pk});
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException("\u64cd\u4f5c\u5916\u90e8\u8868\uff1a" + boEnt.getDsName() + " \u4e2d\u7684 " + boEnt.getDesc() + " \u51fa\u9519\uff1a" + e.getMessage(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void add(BoData curData, List<BoResult> resultList, String parentId) throws ParseException {
        BoEnt boEnt = curData.getBoEnt();
        Map<String, Object> map = this.convertDbMap(curData);
        BoResult boResult = this.insert(boEnt, map, parentId);
        boResult.setBoAlias(curData.getBoDefAlias());
        resultList.add(boResult);
        if (BeanUtils.isEmpty((Object)((Object)boEnt))) {
            return;
        }
        Map<String, BoEnt> entMap = boEnt.getChildMap();
        if (BeanUtils.isEmpty(entMap) && StringUtil.isNotEmpty((String)parentId) && BeanUtils.isNotEmpty(curData.getData()) && !curData.getData().isEmpty()) {
            boolean hasSun = false;
            for (String key : curData.getData().keySet()) {
                if (!key.startsWith("sub_") || !BeanUtils.isNotEmpty((Object)curData.getData().get(key))) continue;
                hasSun = true;
                break;
            }
            if (!hasSun) return;
            List<BoEnt> sunEnts = this.boEntManager.getBySubEntId(boEnt.getId());
            if (!BeanUtils.isNotEmpty(sunEnts)) return;
            boEnt.setChildEntList(sunEnts);
            entMap = boEnt.getChildMap();
        }
        for (Map.Entry<String, List<BoData>> ent : curData.getSubMap().entrySet()) {
            String key;
            key = ent.getKey();
            String tableName = key.replaceFirst("sub_", "");
            BoEnt childEnt = entMap.get(tableName.toLowerCase());
            List<BoData> subDataList = ent.getValue();
            for (BoData chidData : subDataList) {
                chidData.setBoEnt(childEnt);
                this.add(chidData, resultList, boResult.getPk());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void update(BoData curData, List<BoResult> resultList) throws Exception {
        BoEnt boEnt = curData.getBoEnt();
        Map<String, Object> map = this.convertDbMap(curData);
        String modifyResult = "";
        BoResult boResult = this.update(boEnt, map);
        if (StringUtil.isNotEmpty((String)boResult.getModifyDetail())) {
            modifyResult = String.format("\u4e3b\u8868\u3010%s\u3011\u4fee\u6539\u660e\u7ec6\uff1a\n%s", boEnt.getDesc(), boResult.getModifyDetail());
        }
        boResult.setBoAlias(curData.getBoDefAlias());
        resultList.add(boResult);
        String pk = (String)map.get(boEnt.getPkKey());
        Map<String, BoEnt> entMap = boEnt.getChildMap();
        if (BeanUtils.isEmpty(entMap) && BeanUtils.isNotEmpty(curData.getData()) && !curData.getData().isEmpty()) {
            boolean hasSun = false;
            for (String key : curData.getData().keySet()) {
                if (!key.startsWith("sub_") || !BeanUtils.isNotEmpty((Object)curData.getData().get(key))) continue;
                hasSun = true;
                break;
            }
            if (!hasSun) return;
            List<BoEnt> sunEnts = this.boEntManager.getBySubEntId(boEnt.getId());
            if (!BeanUtils.isNotEmpty(sunEnts)) return;
            boEnt.setChildEntList(sunEnts);
            entMap = boEnt.getChildMap();
        }
        if (BeanUtils.isEmpty(curData.getSubMap())) {
            for (Map.Entry<String, BoEnt> entry : entMap.entrySet()) {
                BoEnt childEnt = entMap.get(entry.getKey());
                if (!BeanUtils.isNotEmpty((Object)((Object)childEnt))) continue;
                Map<String, Map<String, Object>> oldDatas = this.getOldSubDatas(childEnt, pk);
                this.deleteSunBoData(childEnt, oldDatas, resultList);
                for (String subPk : oldDatas.keySet()) {
                    BoResult result = this.delete(childEnt, subPk);
                    resultList.add(result);
                }
                modifyResult = modifyResult + String.format("\n\u5b50\u8868\u3010%s\u3011\u5220\u9664\u660e\u7ec6\uff1a%s", childEnt.getDesc(), BeanUtils.ObjectToString(oldDatas));
            }
        } else {
            for (Map.Entry<String, List<BoData>> ent : curData.getSubMap().entrySet()) {
                String key;
                key = ent.getKey();
                String tableName = key.replaceFirst("sub_", "");
                BoEnt childEnt = entMap.get(tableName.toLowerCase());
                if (BeanUtils.isEmpty((Object)((Object)childEnt))) continue;
                Map<String, Map<String, Object>> oldDatas = this.getOldSubDatas(childEnt, pk);
                HashSet<String> updSet = new HashSet<String>();
                List<BoData> subDataList = ent.getValue();
                String curSubModifyRes = "";
                List<BoEnt> sunEnts = this.boEntManager.getBySubEntId(childEnt.getId());
                for (int i = 0; i < subDataList.size(); ++i) {
                    BoData chidData = subDataList.get(i);
                    chidData.setBoEnt(childEnt);
                    String childPkField = childEnt.getPkKey();
                    Map<String, Object> childRow = this.convertDbMap(chidData);
                    if (chidData.containKey(childPkField)) {
                        String childPk = chidData.getString(childPkField);
                        updSet.add(childPk);
                        if (!oldDatas.keySet().contains(childPk)) continue;
                        BoResult result = this.update(childEnt, childRow);
                        if (BeanUtils.isNotEmpty(sunEnts)) {
                            this.updateSunBoData(sunEnts, chidData, childPk, resultList);
                        }
                        if (StringUtil.isNotEmpty((String)result.getModifyDetail())) {
                            curSubModifyRes = curSubModifyRes + String.format("\n\u7b2c\u3010%s\u3011\u884c\u4fee\u6539\u660e\u7ec6\uff1a%s", i + 1, result.getModifyDetail());
                        }
                        if (result == null) continue;
                        if ("0".equals(result.getParentId())) {
                            result.setParentId(pk);
                        }
                        resultList.add(result);
                        continue;
                    }
                    BoResult result = this.insert(childEnt, childRow, pk);
                    this.addSunBoData(resultList, sunEnts, chidData, result.getPk());
                    curSubModifyRes = curSubModifyRes + String.format("\n\u7b2c\u3010%s\u3011\u884c\u65b0\u589e\u660e\u7ec6\uff1a%s", i + 1, BeanUtils.ObjectToString(childRow));
                    resultList.add(result);
                }
                ArrayList<String> delDatas = new ArrayList<String>();
                for (String subPk : oldDatas.keySet()) {
                    if (updSet.contains(subPk)) continue;
                    delDatas.add(BeanUtils.ObjectToString(oldDatas.get(subPk)));
                    this.deleteSunBoData(resultList, sunEnts, subPk);
                    BoResult result = this.delete(childEnt, subPk);
                    resultList.add(result);
                }
                if (delDatas.size() > 0) {
                    curSubModifyRes = curSubModifyRes + String.format("\n\u5220\u9664\u660e\u7ec6\u3010%s\u3011", StringUtil.join(delDatas, (String)","));
                }
                if (!StringUtil.isNotEmpty((String)curSubModifyRes)) continue;
                modifyResult = modifyResult + String.format("\n\u5b50\u8868\u3010%s\u3011\u53d8\u66f4\u660e\u7ec6\uff1a%s", childEnt.getDesc(), curSubModifyRes);
            }
        }
        this.setBoDefAlias(resultList, curData.getBoDefAlias());
        if (resultList.size() <= 0) return;
        resultList.get(0).setModifyDetail(modifyResult);
    }

    private void updateSunBoData(List<BoEnt> sunEnts, BoData chidData, String childPk, List<BoResult> resultList) throws IOException, ParseException {
        Map<String, Object> subData = chidData.getData();
        if (BeanUtils.isNotEmpty(subData)) {
            for (BoEnt sunEnt : sunEnts) {
                Map<String, Map<String, Object>> oldSunDatas = this.getOldSubDatas(sunEnt, childPk);
                if (BeanUtils.isNotEmpty((Object)subData.get("sub_" + sunEnt.getName()))) {
                    JsonNode sunDatas = JsonUtil.toJsonNode((Object)subData.get("sub_" + sunEnt.getName()));
                    String sunPkField = sunEnt.getPkKey();
                    for (JsonNode sunNode : sunDatas) {
                        BoData sunData = new BoData();
                        sunData.setBoEnt(sunEnt);
                        sunData.setData(JsonUtil.toMap((String)JsonUtil.toJson((Object)sunNode)));
                        Map<String, Object> sunRow = this.convertDbMap(sunData);
                        if (sunData.containKey(sunPkField)) {
                            String sunPk = sunData.getString(sunPkField);
                            if (!oldSunDatas.keySet().contains(sunPk)) continue;
                            BoResult result = this.update(sunEnt, sunRow);
                            if (result != null) {
                                if ("0".equals(result.getParentId())) {
                                    result.setParentId(childPk);
                                }
                                resultList.add(result);
                            }
                            oldSunDatas.remove(sunPk);
                            continue;
                        }
                        BoResult result = this.insert(sunEnt, sunRow, childPk);
                        if (result == null) continue;
                        if ("0".equals(result.getParentId())) {
                            result.setParentId(childPk);
                        }
                        resultList.add(result);
                    }
                    if (!BeanUtils.isNotEmpty(oldSunDatas)) continue;
                    for (String sunPk : oldSunDatas.keySet()) {
                        BoResult result = this.delete(sunEnt, sunPk);
                        resultList.add(result);
                    }
                    continue;
                }
                if (!BeanUtils.isNotEmpty(oldSunDatas)) continue;
                for (String sunPk : oldSunDatas.keySet()) {
                    BoResult result = this.delete(sunEnt, sunPk);
                    resultList.add(result);
                }
            }
        }
    }

    private void deleteSunBoData(BoEnt childEnt, Map<String, Map<String, Object>> oldDatas, List<BoResult> resultList) {
        if (BeanUtils.isNotEmpty((Object)((Object)childEnt)) && BeanUtils.isNotEmpty(childEnt.getChildEntList()) && BeanUtils.isNotEmpty(oldDatas)) {
            List<BoEnt> sunEnts = childEnt.getChildEntList();
            for (BoEnt sunEnt : sunEnts) {
                for (String subPk : oldDatas.keySet()) {
                    Map<String, Map<String, Object>> oldSunDatas = this.getOldSubDatas(sunEnt, subPk);
                    if (!BeanUtils.isNotEmpty(oldSunDatas)) continue;
                    for (String sunPk : oldSunDatas.keySet()) {
                        BoResult result = this.delete(sunEnt, sunPk);
                        resultList.add(result);
                    }
                }
            }
        }
    }

    private void addSunBoData(List<BoResult> resultList, List<BoEnt> sunEnts, BoData chidData, String parentId) {
        try {
            if (BeanUtils.isNotEmpty(sunEnts)) {
                boolean hasSun = false;
                HashMap<String, Object> sunDataMap = new HashMap<String, Object>();
                for (String subKey : chidData.getData().keySet()) {
                    if (!subKey.startsWith("sub_") || !BeanUtils.isNotEmpty((Object)chidData.getData().get(subKey))) continue;
                    sunDataMap.put(subKey, chidData.getData().get(subKey));
                    hasSun = true;
                }
                if (hasSun) {
                    for (BoEnt sunBoEnt : sunEnts) {
                        if (!sunDataMap.containsKey("sub_" + sunBoEnt.getName())) continue;
                        ArrayNode sunArray = (ArrayNode)JsonUtil.toJsonNode(sunDataMap.get("sub_" + sunBoEnt.getName()));
                        for (JsonNode jsonNode : sunArray) {
                            Map sunRow = JsonUtil.toMap((String)JsonUtil.toJson((Object)jsonNode));
                            BoData sunData = new BoData();
                            sunData.setBoDef(chidData.getBoDef());
                            sunData.setBoEnt(sunBoEnt);
                            sunData.setBoDefAlias(chidData.getBoDefAlias());
                            sunData.setData(sunRow);
                            Map<String, Object> row = this.convertDbMap(sunData);
                            BoResult sunresult = this.insert(sunBoEnt, row, parentId);
                            resultList.add(sunresult);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u5904\u7406\u5b59\u8868\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private void deleteSunBoData(List<BoResult> resultList, List<BoEnt> sunEnts, String subPk) {
        if (BeanUtils.isNotEmpty(sunEnts)) {
            for (BoEnt sunEnt : sunEnts) {
                Map<String, Map<String, Object>> oldSunDatas = this.getOldSubDatas(sunEnt, subPk);
                if (!BeanUtils.isNotEmpty(oldSunDatas)) continue;
                for (String sunPk : oldSunDatas.keySet()) {
                    BoResult sunResult = this.delete(sunEnt, sunPk);
                    resultList.add(sunResult);
                }
            }
        }
    }

    private Map<String, Object> convertDbMap(BoData curData) throws ParseException {
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        BoEnt boEnt = curData.getBoEnt();
        if (boEnt == null) {
            return rtnMap;
        }
        List<BoAttribute> list = boEnt.getBoAttrList();
        Iterator<BoAttribute> iterator = list.iterator();
        while (iterator.hasNext()) {
            BoAttribute attr;
            BoAttribute boAttr = attr = iterator.next();
            String fieldName = boAttr.getFieldName();
            String name = boAttr.getName();
            if (!curData.containKey(name)) continue;
            Object obj = curData.getValByKey(name);
            if (BeanUtils.isNotEmpty((Object)obj) && !name.equals("form_data_rev_") && !name.equals("F_form_data_rev_")) {
                String dataType = "varchar";
                if (obj.toString().length() > attr.getIntLen() && dataType.equals(attr.getDataType())) {
                    throw new BaseException(attr.getDesc() + "\u5b57\u6bb5\u8d85\u8fc7\u8bbe\u7f6e\u7684\u5b57\u7b26\u957f\u5ea6\uff01");
                }
            }
            rtnMap.put(fieldName, obj);
        }
        String pk = boEnt.getPkKey();
        if (curData.containKey(pk)) {
            rtnMap.put(pk, curData.getString(pk));
        }
        if (!boEnt.isExternal()) {
            rtnMap.put("F_form_data_rev_", BeanUtils.isNotEmpty((Object)curData.getByKey("form_data_rev_")) ? curData.getByKey("form_data_rev_") : Integer.valueOf(0));
        }
        return rtnMap;
    }

    private BoResult insert(BoEnt boEnt, Map<String, Object> row, String parentId) {
        String tableName = "";
        String pkField = "";
        if (boEnt != null) {
            tableName = boEnt.getTableName();
            pkField = boEnt.getPkKey();
        }
        Object id = UniqueIdUtil.getSuid();
        if (boEnt.isPkNumber()) {
            id = Long.valueOf(id.toString());
        }
        StringBuffer fieldNames = new StringBuffer(",");
        StringBuffer params = new StringBuffer();
        ArrayList<Object> values = new ArrayList<Object>();
        fieldNames.append(pkField).append(",");
        params.append("?,");
        values.add(id);
        if (boEnt != null && !boEnt.getType().equals("manytomany") && StringUtil.isNotEmpty((String)boEnt.getFk())) {
            if (fieldNames.toString().toUpperCase().indexOf("," + boEnt.getFk().toUpperCase() + ",") > -1) {
                throw new RuntimeException(String.format("\u5916\u90e8\u8868\u3010%s(%s)\u3011\u7684\u5916\u952e\u4e0d\u80fd\u548c\u4e3b\u952e\u76f8\u540c", boEnt.getDesc(), boEnt.getName()));
            }
            fieldNames.append(boEnt.getFk()).append(",");
            params.append("?,");
            values.add(parentId);
        }
        for (Map.Entry<String, Object> entry : row.entrySet()) {
            if (fieldNames.toString().toUpperCase().indexOf("," + entry.getKey().toUpperCase() + ",") >= 0) continue;
            fieldNames.append(entry.getKey()).append(",");
            params.append("?,");
            values.add(entry.getValue());
        }
        fieldNames = new StringBuffer(fieldNames.substring(1));
        StringBuffer sql = new StringBuffer();
        if (!"".equals(tableName) && tableName != null) {
            sql.append(" INSERT INTO ");
            sql.append(tableName);
            sql.append("(");
            sql.append(fieldNames.substring(0, fieldNames.length() - 1));
            sql.append(")");
            sql.append(" VALUES (");
            sql.append(params.substring(0, params.length() - 1));
            sql.append(")");
            SqlModel sqlModel = new SqlModel(sql.toString(), values.toArray());
            this.executeSql(sqlModel, boEnt);
            if (boEnt.getType().equals("manytomany")) {
                String relPk = UniqueIdUtil.getSuid();
                BoDataRel entRel = new BoDataRel(relPk, parentId, id.toString(), boEnt.getName());
                this.boDataRelDao.insert((Object)entRel);
            }
        }
        BoResult result = new BoResult();
        result.setParentId(parentId);
        result.setAction("add");
        result.setBoEnt(boEnt);
        result.setPk(id.toString());
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int executeSql(SqlModel model, BoEnt boEnt) {
        String sql = model.getSql();
        int update = -1;
        if (StringUtil.isEmpty((String)sql)) {
            return update;
        }
        Object[] obs = model.getValues();
        if (boEnt == null || !boEnt.isExternal()) {
            try {
                return this.commonManager.execute(sql, obs);
            }
            catch (DuplicateKeyException ex) {
                Throwable cause = ex.getCause();
                String dsName = boEnt.getDsName();
                if (StringUtil.isEmpty((String)dsName)) {
                    dsName = "LOCAL";
                }
                if (!(cause instanceof SQLIntegrityConstraintViolationException)) throw new RuntimeException("\u64cd\u4f5c\u5916\u90e8\u8868\uff1a" + boEnt.getDsName() + " \u4e2d\u7684 " + boEnt.getDesc() + " \u51fa\u9519\uff1a" + ex.getMessage(), ex);
                List tables = null;
                try (DatabaseSwitchResult dResult = this.databaseContext.setDataSource(dsName);){
                    BaseTableMeta baseTableMeta = MetaDataUtil.getBaseTableMetaAfterSetDT((String)dResult.getDbType());
                    tables = baseTableMeta.getTablesByNameIndex(boEnt.getTableName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String errMsg = ((SQLIntegrityConstraintViolationException)cause).getMessage();
                if (!StringUtils.isNotBlank((String)errMsg)) throw new RuntimeException("\u64cd\u4f5c\u5916\u90e8\u8868\uff1a" + boEnt.getDsName() + " \u4e2d\u7684 " + boEnt.getDesc() + " \u51fa\u9519\uff1a" + ex.getMessage(), ex);
                String customMsg = "";
                if (BeanUtils.isNotEmpty(tables)) {
                    HashSet result = new HashSet(tables);
                    for (Map table : result) {
                        if (errMsg.contains(table.get("keyName").toString()) && StringUtil.isEmpty((String)customMsg)) {
                            customMsg = customMsg + table.get("indexComment").toString();
                            continue;
                        }
                        if (!errMsg.contains(table.get("keyName").toString()) || !StringUtil.isNotEmpty((String)customMsg)) continue;
                        customMsg = customMsg + "," + table.get("indexComment").toString();
                    }
                }
                if (!StringUtil.isEmpty((String)customMsg)) throw new BaseException(customMsg, (Throwable)ex);
                customMsg = "\u60a8\u586b\u5199\u7684\u5185\u5bb9\u6709\u91cd\u590d\uff0c\u8bf7\u6838\u67e5\uff01";
                throw new BaseException(customMsg, (Throwable)ex);
            }
            catch (Exception e) {
                throw new BaseException(e.getMessage(), (Throwable)e);
            }
        }
        try (DatabaseSwitchResult setDataSource = this.databaseContext.setDataSource(boEnt.getDsName());){
            int dsName = this.commonManager.execute(sql, obs);
            return dsName;
        }
        catch (DuplicateKeyException ex) {
            Object customMsg;
            Throwable cause = ex.getCause();
            String dsName = boEnt.getDsName();
            if (StringUtil.isEmpty((String)dsName)) {
                dsName = "LOCAL";
            }
            if (!(cause instanceof SQLIntegrityConstraintViolationException)) throw new RuntimeException("\u64cd\u4f5c\u5916\u90e8\u8868\uff1a" + boEnt.getDsName() + " \u4e2d\u7684 " + boEnt.getDesc() + " \u51fa\u9519\uff1a" + ex.getMessage(), ex);
            List tables = null;
            try {
                DatabaseSwitchResult dResult = this.databaseContext.setDataSource(dsName);
                customMsg = null;
                try {
                    BaseTableMeta baseTableMeta = MetaDataUtil.getBaseTableMetaAfterSetDT((String)dResult.getDbType());
                    tables = baseTableMeta.getTablesByNameIndex(boEnt.getTableName());
                }
                catch (Throwable baseTableMeta) {
                    customMsg = baseTableMeta;
                    throw baseTableMeta;
                }
                finally {
                    if (dResult != null) {
                        if (customMsg != null) {
                            try {
                                dResult.close();
                            }
                            catch (Throwable baseTableMeta) {
                                ((Throwable)customMsg).addSuppressed(baseTableMeta);
                            }
                        } else {
                            dResult.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String errMsg = ((SQLIntegrityConstraintViolationException)cause).getMessage();
            if (!StringUtils.isNotBlank((String)errMsg)) throw new RuntimeException("\u64cd\u4f5c\u5916\u90e8\u8868\uff1a" + boEnt.getDsName() + " \u4e2d\u7684 " + boEnt.getDesc() + " \u51fa\u9519\uff1a" + ex.getMessage(), ex);
            customMsg = "";
            if (BeanUtils.isNotEmpty(tables)) {
                HashSet result = new HashSet(tables);
                for (Map table : result) {
                    if (errMsg.contains(table.get("keyName").toString()) && StringUtil.isEmpty((String)customMsg)) {
                        customMsg = (String)customMsg + table.get("indexComment").toString();
                        continue;
                    }
                    if (!errMsg.contains(table.get("keyName").toString()) || !StringUtil.isNotEmpty((String)customMsg)) continue;
                    customMsg = (String)customMsg + "," + table.get("indexComment").toString();
                }
            }
            if (!StringUtil.isEmpty((String)customMsg)) throw new BaseException((String)customMsg, (Throwable)ex);
            customMsg = "\u60a8\u586b\u5199\u7684\u5185\u5bb9\u6709\u91cd\u590d\uff0c\u8bf7\u6838\u67e5\uff01";
            throw new BaseException((String)customMsg, (Throwable)ex);
        }
        catch (Exception e) {
            throw new RuntimeException("\u64cd\u4f5c\u5916\u90e8\u8868\uff1a" + boEnt.getDsName() + " \u4e2d\u7684 " + boEnt.getDesc() + " \u51fa\u9519\uff1a" + e.getMessage(), e);
        }
    }

    private BoResult update(BoEnt boEnt, Map<String, Object> row) {
        String fkValue;
        SqlModel sqlModel;
        int numger;
        Object pkValue;
        BoResult result = new BoResult();
        String tableName = boEnt.getTableName();
        String pkField = boEnt.getPkKey();
        Object object = pkValue = BeanUtils.isNotEmpty((Object)row.get(pkField)) ? row.get(pkField).toString() : row.get(pkField.toUpperCase()).toString();
        if (boEnt.isPkNumber() && BeanUtils.isNotEmpty((Object)pkValue)) {
            pkValue = Long.valueOf(pkValue.toString());
        }
        String pkType = boEnt.getPkType();
        boolean isDataChange = false;
        if (!boEnt.isExternal()) {
            String modifyDetail;
            Map<String, Object> oldEntData = null;
            oldEntData = !"number".equals(pkType) && !"int".equals(pkType) ? this.getOneById("select * from " + tableName + " where " + pkField + " ='" + pkValue + "'", null) : this.getOneById("select * from " + tableName + " where " + pkField + " =" + pkValue, null);
            if (BeanUtils.isNotEmpty(oldEntData) && StringUtil.isNotEmpty((String)(modifyDetail = this.compareData(boEnt, row, oldEntData)))) {
                result.setModifyDetail(modifyDetail);
                isDataChange = true;
            }
        } else {
            ThreadMsgUtil.addMapMsg((String)"hasCheckFormDataRev", (String)"true");
        }
        CommonResult portalDataSensitiveResult = this.systemConfigFeignService.getPortalDataSensitive(boEnt.getDsName(), tableName);
        PortalDataSensitive portalDataSensitive = null;
        Map currentProfiles = null;
        if (portalDataSensitiveResult.getState().booleanValue() && BeanUtils.isNotEmpty((Object)portalDataSensitiveResult.getValue())) {
            portalDataSensitive = (PortalDataSensitive)portalDataSensitiveResult.getValue();
            currentProfiles = this.permissionCalc.getCurrentProfiles();
        }
        int version = 0;
        if (BeanUtils.isNotEmpty((Object)row.get("F_form_data_rev_"))) {
            version = Integer.parseInt(row.get("F_form_data_rev_").toString());
        }
        if (isDataChange) {
            row.put("F_form_data_rev_", version + 1);
        }
        ArrayList<Object> values = new ArrayList<Object>();
        StringBuffer set = new StringBuffer();
        for (Map.Entry<String, Object> entry : row.entrySet()) {
            boolean hasRight;
            if (pkField.equals(entry.getKey()) || BoEnt.SUB_ROW_READONLY.equals(entry.getKey()) || BeanUtils.isNotEmpty((Object)portalDataSensitive) && (hasRight = this.hasFieldNameRight(entry.getKey(), portalDataSensitive, currentProfiles))) continue;
            set.append(entry.getKey()).append("=?,");
            values.add(entry.getValue());
        }
        result.setAction("upd");
        result.setBoEnt(boEnt);
        result.setPk(pkValue.toString());
        if (values.size() == 0) {
            return result;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update ");
        sql.append(tableName);
        sql.append(" set ");
        sql.append(set.substring(0, set.length() - 1));
        sql.append(" where ");
        sql.append(pkField);
        sql.append("=?");
        values.add(pkValue);
        if (!"true".equals(ThreadMsgUtil.getMapMsg((String)"hasCheckFormDataRev")) && !"false".equals(FormContextThreadUtil.getCommuVars().get("hasCheckFormDataRev"))) {
            sql.append(" and F_form_data_rev_=?");
            values.add(version);
        }
        if ((numger = this.executeSql(sqlModel = new SqlModel(sql.toString(), values.toArray()), boEnt)) == 0) {
            throw new RuntimeException("\u8868\u5355\u6570\u636e\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u4fee\u6539\uff0c\u8bf7\u91cd\u65b0\u52a0\u8f7d\u6570\u636e\u3002");
        }
        ThreadMsgUtil.addMapMsg((String)"hasCheckFormDataRev", (String)"true");
        String fkField = boEnt.getFk();
        if (row.containsKey(fkField) && StringUtils.isNotEmpty((String)(fkValue = row.get(fkField).toString())) && !fkValue.equals("0")) {
            result.setParentId(fkValue);
        }
        return result;
    }

    private boolean hasFieldNameRight(String fieldName, PortalDataSensitive portalDataSensitive, Map<String, Set<String>> currentProfiles) {
        try {
            ArrayNode arrayNode = (ArrayNode)JsonUtil.toJsonNode((String)portalDataSensitive.getDesensitizationRules());
            for (JsonNode jsonNode : arrayNode) {
                boolean hasRight;
                if (!fieldName.equalsIgnoreCase(jsonNode.get("fieldName").asText()) || (hasRight = this.hasRight(jsonNode.get("rights").asText(), currentProfiles))) continue;
                return true;
            }
        }
        catch (IOException e) {
            throw new BaseException(ResponseErrorEnums.DESENSITIZATION);
        }
        return false;
    }

    private boolean hasRight(String rights, Map<String, Set<String>> currentProfiles) throws IOException {
        ArrayNode arrayNode = (ArrayNode)JsonUtil.toJsonNode((String)rights);
        Iterator iterator = arrayNode.iterator();
        if (iterator.hasNext()) {
            JsonNode jsonNode = (JsonNode)iterator.next();
            return this.permissionCalc.hasRight(JsonUtil.toJsonString((Object)jsonNode), currentProfiles);
        }
        return false;
    }

    private BoResult delete(BoEnt boEnt, Object pk) {
        if (boEnt.isPkNumber() && BeanUtils.isNotEmpty((Object)pk)) {
            pk = Long.valueOf(pk.toString());
        }
        String sql = "delete  from " + boEnt.getTableName() + "  where " + boEnt.getPkKey() + " =? ";
        SqlModel sqlModel = new SqlModel(sql, new Object[]{pk});
        this.executeSql(sqlModel, boEnt);
        if (boEnt.getType().equals("manytomany")) {
            sql = "delete from form_bo_data_relation where SUB_BO_NAME='" + boEnt.getName() + "' and FK_=?";
            sqlModel = new SqlModel(sql, new Object[]{pk});
            this.executeSql(sqlModel, null);
        }
        BoResult result = new BoResult();
        result.setAction("del");
        result.setBoEnt(boEnt);
        result.setPk(pk.toString());
        return result;
    }

    @Override
    public BoData getResById(Object id, String bodefCode) {
        BoDef boDef = this.getBoDefByAlias(bodefCode);
        BoData boData = new BoData();
        BoEnt boEnt = boDef.getBoEnt();
        Map<String, Object> row = this.getById(boEnt, id);
        boData.setData(row);
        this.getCascadeById(id, boEnt, boData);
        return boData;
    }

    private void getCascadeById(Object id, BoEnt boEnt, BoData boData) {
        List<BoEnt> childEntList = boEnt.getChildEntList();
        if (BeanUtils.isEmpty(childEntList)) {
            return;
        }
        for (BoEnt childEnt : childEntList) {
            List<Map<String, Object>> list = this.getByFk(childEnt, id);
            String key = childEnt.getName();
            ArrayList<BoData> listData = new ArrayList<BoData>();
            for (Map<String, Object> rowMap : list) {
                BoData childData = new BoData();
                Map<String, Object> rtnMap = this.convertDbToData(childEnt, rowMap);
                childData.setData(rtnMap);
                listData.add(childData);
                String pkKey = childEnt.getPkKey();
                String childId = (String)rowMap.get(pkKey);
                if (StringUtil.isEmpty((String)childId)) {
                    childId = (String)rowMap.get(pkKey.toUpperCase());
                }
                this.getCascadeById(childId, childEnt, childData);
            }
            String subName = key.startsWith("sub_") ? key : "sub_" + key;
            ArrayList<Map<String, Object>> subArr = new ArrayList<Map<String, Object>>();
            for (BoData listDatum : listData) {
                subArr.add(listDatum.getData());
            }
            boData.getData().put(subName, subArr);
            boData.setSubList(key, listData);
        }
    }

    @Override
    public String saveType() {
        return "database";
    }

    @Override
    public void removeBoData(String boCode, String[] aryIds) {
        BoDef boDef = this.getBoDefByAlias(boCode);
        BoEnt boEnt = boDef.getBoEnt();
        List<BoEnt> childEntList = boEnt.getChildEntList();
        for (String id : aryIds) {
            this.delete(boEnt, id);
            for (BoEnt child : childEntList) {
                String sql = "delete  from " + child.getTableName() + "  where " + child.getFk() + " =? ";
                SqlModel sqlModel = new SqlModel(sql, new Object[]{id});
                this.executeSql(sqlModel, boEnt);
            }
        }
    }

    @Override
    public List<Map<String, Object>> getList(String boCode, Map<String, Object> param) {
        List list;
        BoEnt boEnt;
        block18: {
            BoDef boDef = this.getBoDefByAlias(boCode);
            boEnt = boDef.getBoEnt();
            StringBuffer sql = new StringBuffer("select * from " + boEnt.getTableName());
            ArrayList<Object> p = new ArrayList<Object>();
            if (BeanUtils.isNotEmpty(param)) {
                sql.append(" where 1=1 ");
                for (String fieldName : param.keySet()) {
                    String filedName = fieldName.toLowerCase();
                    if (!boEnt.getAttrFieldMap().containsKey(filedName)) continue;
                    sql.append(" and " + filedName + "=? ");
                    p.add(param.get(fieldName));
                }
            }
            list = null;
            if (boEnt.isExternal()) {
                try {
                    DatabaseSwitchResult setDataSource = this.databaseContext.setDataSource(boEnt.getDsName());
                    Object object = null;
                    try {
                        list = this.commonManager.query(sql.toString(), p.toArray());
                        break block18;
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (setDataSource != null) {
                            if (object != null) {
                                try {
                                    setDataSource.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                setDataSource.close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("\u64cd\u4f5c\u5916\u90e8\u8868\uff1a" + boEnt.getDsName() + " \u4e2d\u7684 " + boEnt.getDesc() + " \u51fa\u9519\uff1a" + ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
            }
            list = this.commonManager.query(sql.toString(), p.toArray());
        }
        ArrayList<Map<String, Object>> returnData = new ArrayList<Map<String, Object>>();
        for (Map rowMap : list) {
            Map<String, Object> rtnMap = this.convertDbToData(boEnt, rowMap);
            returnData.add(rtnMap);
        }
        return returnData;
    }

    @Override
    public PageList<Map<String, Object>> getList(String boCode, QueryFilter queryFilter) {
        BoDef boDef = this.getBoDefByAlias(boCode);
        final BoEnt boEnt = boDef.getBoEnt();
        StringBuffer sb = new StringBuffer(" select * from " + boEnt.getTableName());
        PageList queryForPageList = this.commonManager.query(sb.toString(), queryFilter);
        List rows = queryForPageList.getRows();
        rows.replaceAll(new UnaryOperator<Map<String, Object>>(){

            @Override
            public Map<String, Object> apply(Map<String, Object> rowMap) {
                return BoDbHandlerImpl.this.convertDbToData(boEnt, rowMap);
            }
        });
        return queryForPageList;
    }

    private String compareData(BoEnt boEnt, Map<String, Object> newMap, Map<String, Object> oldMap) {
        HashMap<String, Object> newData = new HashMap<String, Object>();
        for (Map.Entry<String, Object> next : newMap.entrySet()) {
            newData.put(next.getKey().toLowerCase(), next.getValue());
        }
        HashMap<String, Object> oldData = new HashMap<String, Object>();
        for (Map.Entry<String, Object> next : oldMap.entrySet()) {
            oldData.put(next.getKey().toLowerCase(), next.getValue());
        }
        Map<String, BoAttribute> attrFieldMap = boEnt.getAttrFieldMap();
        ArrayList<String> changeList = new ArrayList<String>();
        for (Map.Entry next : newData.entrySet()) {
            Object oldVal;
            Object newVal;
            String filed = (String)next.getKey();
            if (filed.equals("f_form_data_rev_") || BeanUtils.isEquals(newVal = next.getValue(), oldVal = oldData.get(filed)) || !attrFieldMap.containsKey(filed)) continue;
            changeList.add(String.format("\u3010%s\u3011\u7531\u3010%s\u3011\u4fee\u6539\u4e3a\u3010%s\u3011", attrFieldMap.get(filed).getDesc(), BeanUtils.ObjectToString(oldVal), BeanUtils.ObjectToString(newVal)));
        }
        for (Map.Entry next : oldData.entrySet()) {
            BoAttribute boAttribute;
            if (!BeanUtils.isEmpty(newData.get(next.getKey())) || !BeanUtils.isNotEmpty(oldData.get(next.getKey())) || BoEnt.FK_NAME.equalsIgnoreCase((String)next.getKey()) || BeanUtils.isEmpty((Object)((Object)(boAttribute = attrFieldMap.get(next.getKey()))))) continue;
            String desc = boAttribute.getDesc();
            String objectToString = BeanUtils.ObjectToString(oldData.get(next.getKey()));
            changeList.add(String.format("\u3010%s\u3011\u7531\u3010%s\u3011\u4fee\u6539\u4e3a\u3010\u3011", desc, objectToString));
        }
        return StringUtil.join(changeList, (String)",");
    }

    private Map<String, Map<String, Object>> getOldSubDatas(BoEnt childEnt, String pk) {
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        String pkField = childEnt.getPkKey().toLowerCase();
        List<Object> oldList = new ArrayList();
        oldList = this.getByFk(childEnt, pk);
        block0: for (Map map2 : oldList) {
            for (Map.Entry entry : map2.entrySet()) {
                if (!((String)entry.getKey()).equalsIgnoreCase(pkField)) continue;
                map.put(entry.getValue().toString(), map2);
                continue block0;
            }
        }
        return map;
    }
}

