/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.portal.model.MessageNews;
import com.artfess.portal.persistence.dao.MessageNewsDao;
import com.artfess.portal.persistence.manager.MessageNewsManager;
import com.artfess.sysConfig.service.AuthorityManager;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.impl.util.PermissionCalc;
import com.artfess.uc.api.model.IUser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="messageNewsManager")
public class MessageNewsManagerImpl
extends BaseManagerImpl<MessageNewsDao, MessageNews>
implements MessageNewsManager {
    @Resource
    AuthorityManager authorityManager;
    @Resource
    PermissionCalc permssionCalc;

    public PageList<MessageNews> query(QueryFilter queryFilter) {
        QueryFilter filter;
        PageList pageList;
        List querys = queryFilter.getQuerys();
        boolean isp = false;
        for (QueryField queryField : querys) {
            if (!"2".equals(queryField.getValue()) || !"FStatus".equals(queryField.getProperty()) && !"F_status".equals(queryField.getProperty())) continue;
            isp = true;
            break;
        }
        IUser user = ContextUtil.getCurrentUser();
        if (isp && !user.isAdmin() && (pageList = super.query(filter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE)))).getTotal() > 0L) {
            List all = pageList.getRows();
            Map authMap = this.authorityManager.getUserRightMap();
            ArrayList<String> authIds = new ArrayList<String>();
            for (MessageNews messageNews : all) {
                try {
                    if (!StringUtil.isNotEmpty((String)messageNews.getFCkqxsz())) continue;
                    ArrayNode authArray = (ArrayNode)JsonUtil.toJsonNode((String)messageNews.getFCkqxsz());
                    for (JsonNode jsonNode : authArray) {
                        if (!this.permssionCalc.hasRight(jsonNode.toString(), authMap)) continue;
                        authIds.add(messageNews.getId());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (authIds.size() > 1000) {
                int sourceSize = authIds.size();
                int size = authIds.size() / 1000 + 1;
                for (int i = 0; i < size; ++i) {
                    ArrayList subset = new ArrayList();
                    for (int j = i * 1000; j < (i + 1) * 1000; ++j) {
                        if (j >= sourceSize) continue;
                        subset.add(authIds.get(j));
                    }
                    if (subset.size() <= 0) continue;
                    queryFilter.addFilter("id", subset, QueryOP.IN, FieldRelation.OR, "group01");
                }
            } else if (authIds.size() > 0) {
                queryFilter.addFilter("id", authIds, QueryOP.IN, FieldRelation.AND, "group01");
            }
        }
        return super.query(queryFilter);
    }
}

