/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.exception.BaseException;
import com.artfess.base.exception.NotFoundException;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.feign.WorkflowFeignService;
import com.artfess.base.groovy.GroovyScriptEngine;
import com.artfess.base.handler.MultiTenantHandler;
import com.artfess.base.handler.MultiTenantIgnoreResult;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.Base64;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.file.config.UploadResult;
import com.artfess.file.extend.DetailTablePolicy;
import com.artfess.file.extend.InstanceFlowOpinions;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.CatalogManager;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.file.persistence.manager.FileZoneManager;
import com.artfess.file.util.AppFileUtil;
import com.artfess.file.util.HtmlUtil;
import com.artfess.file.util.SignaturePictureRenderPolicy;
import com.artfess.file.util.UploadM3u8;
import com.artfess.file.vo.FileReqVo;
import com.artfess.file.vo.MultipartCompleteParam;
import com.artfess.file.vo.MultipartInitParam;
import com.artfess.file.vo.MultipartInitRespVo;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.data.DocxRenderData;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.template.MetaTemplate;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.activation.MimetypesFileTypeMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/file/v1"})
@Api(tags={"\u9644\u4ef6\u7ba1\u7406"})
@ApiGroup(group={"group_system"})
public class FileController
extends BaseController<FileManager, DefaultFile> {
    private Logger logger = LoggerFactory.getLogger(FileController.class);
    @Resource
    FileManager fileManager;
    @Resource
    IUserService userService;
    @Resource
    CatalogManager catalogManager;
    @Resource
    FileZoneManager fileZonedManager;
    @Resource
    BaseContext baseContext;
    @Resource
    WorkflowFeignService workflowFeignService;
    @Resource
    GroovyScriptEngine groovyScriptEngine;
    @Resource
    UCFeignService ucFeignService;

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9644\u4ef6\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u9644\u4ef6\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<DefaultFile> list(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) {
        List listQueryField = queryFilter.getQuerys();
        ArrayList<String> listId = new ArrayList<String>();
        QueryField query = new QueryField();
        String xbTypeId = "";
        for (QueryField queryField : listQueryField) {
            if (!"xbTypeId".equals(queryField.getProperty())) continue;
            xbTypeId = queryField.getValue() + "";
            query.setProperty(queryField.getProperty());
            query.setRelation(queryField.getRelation());
            listQueryField.remove(queryField);
            break;
        }
        if (StringUtil.isNotEmpty((String)xbTypeId)) {
            List<String> ids = this.catalogManager.getDepartmentList(xbTypeId, listId);
            ids.add(xbTypeId);
            query.setValue(ids);
            query.setOperation(QueryOP.IN);
            listQueryField.add(query);
            queryFilter.setQuerys(listQueryField);
        }
        return this.fileManager.query(queryFilter);
    }

    @PostMapping(value={"getFileInfo"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u9644\u4ef6\u7c7b\u578b\u548c\u4e1a\u52a1id\u83b7\u5f97\u9644\u4ef6\u5bf9\u8c61", notes="\u83b7\u5f97\u9644\u4ef6\u5bf9\u8c61")
    public DefaultFile getFileInfo(@RequestBody FileReqVo fileReqVo) {
        DefaultFile file = this.fileManager.getFileInfo(fileReqVo);
        return file;
    }

    @RequestMapping(value={"fileGet"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u5f97\u9644\u4ef6\u5bf9\u8c61", httpMethod="GET", notes="\u83b7\u5f97\u9644\u4ef6\u5bf9\u8c61")
    public DefaultFile edit(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id) {
        DefaultFile file = null;
        if (StringUtil.isNotEmpty((String)id)) {
            file = (DefaultFile)this.fileManager.get((Serializable)((Object)id));
        }
        return file;
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u9644\u4ef6", httpMethod="POST", notes="\u6279\u91cf\u5220\u9664\u9644\u4ef6")
    public CommonResult remove(@ApiParam(name="ids", value="\u9644\u4ef6ID!\u591a\u4e2aID\u7528,\u5206\u5272") @RequestBody String ids) throws Exception {
        String[] aryIds = null;
        if (StringUtil.isNotEmpty((String)ids)) {
            aryIds = ids.split(",");
        }
        this.fileManager.delSysFileByIds(aryIds);
        return new CommonResult(true, "\u5220\u9664\u9644\u4ef6\u6210\u529f", null);
    }

    @RequestMapping(value={"uploadFileForConfig"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c", httpMethod="POST", notes="\u6279\u91cf\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c")
    public UploadResult uploadForConfig(@ApiParam(name="bizCode", value="\u9644\u4ef6\u4e0a\u4f20\u7f16\u7801", required=true) @RequestParam String bizCode, @ApiParam(name="bizId", value="\u4e1a\u52a1ID", required=false) @RequestParam String bizId, @ApiParam(name="bizType", value="\u4e1a\u52a1\u5206\u7c7b\uff0c\u4e1a\u52a1\u5185\u90e8\u7684\u7c7b\u522b", required=false) @RequestParam String bizType, @ApiParam(name="files", value="\u4e0a\u4f20\u7684\u6587\u4ef6\u6d41") @RequestBody List<MultipartFile> files) throws Exception {
        DefaultFile file = new DefaultFile();
        String account = this.baseContext.getCurrentUserAccout();
        return this.fileManager.UploadFileForConfig(file, files, bizCode, bizId, bizType, this.userService.getUserByAccount(account));
    }

    @RequestMapping(value={"fileUpload"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c", httpMethod="POST", notes="\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c\uff0cminio\u53c2\u6570\uff1afile: {\"storeType\":\"minio\"}")
    public UploadResult fileUpload(@ApiParam(name="params", value="\u683c\u5f0f\u9650\u5b9a") @RequestParam Map<String, Object> params, @ApiParam(name="files", value="\u4e0a\u4f20\u7684\u6587\u4ef6\u6d41") @RequestBody List<MultipartFile> files, @ApiParam(name="flowKey", value="\u6d41\u7a0bkey") @RequestParam Optional<String> flowKey) throws Exception {
        DefaultFile file = new DefaultFile();
        if (params.containsKey("file")) {
            file = (DefaultFile)((Object)JsonUtil.toBean((String)params.getOrDefault("file", "{}").toString(), DefaultFile.class));
        }
        String account = this.baseContext.getCurrentUserAccout();
        return this.fileManager.uploadFile(file, files, params.getOrDefault("fileFormates", "").toString(), this.userService.getUserByAccount(account), flowKey.orElse(""));
    }

    @RequestMapping(value={"upload"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c", httpMethod="POST", notes="\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c")
    public UploadResult upload(MultipartHttpServletRequest request, @ApiParam(name="fileFormates", value="\u683c\u5f0f\u8981\u6c42,\u591a\u4e2a\u7528\u9017\u53f7\u9694\u5f00") @RequestParam Optional<String> fileFormates, @ApiParam(name="flowKey", value="\u6d41\u7a0bkey") @RequestParam Optional<String> flowKey, @ApiParam(name="fileId", value="\u6587\u4ef6id") @RequestParam(required=false) String fileId) throws Exception {
        IUser user = null;
        String account = this.baseContext.getCurrentUserAccout();
        if (StringUtil.isNotEmpty((String)account)) {
            user = this.userService.getUserByAccount(account);
        }
        Map fileMaps = request.getFileMap();
        Iterator it = fileMaps.values().iterator();
        ArrayList<MultipartFile> files = new ArrayList<MultipartFile>();
        while (it.hasNext()) {
            files.add((MultipartFile)it.next());
        }
        DefaultFile file = new DefaultFile();
        if (StringUtil.isNotEmpty((String)fileId)) {
            file = (DefaultFile)this.fileManager.get((Serializable)((Object)fileId));
            file.setFileName(null);
        }
        return this.fileManager.uploadFile(file, files, fileFormates.orElse(""), user, flowKey.orElse(""));
    }

    @RequestMapping(value={"downloadFile"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9644\u4ef6\u4e0b\u8f7d", httpMethod="GET", notes="\u9644\u4ef6\u4e0b\u8f7d")
    public void downloadFile(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="fileId", value="\u9644\u4ef6ID") @RequestParam String fileId) throws Exception {
        response.setContentType("APPLICATION/OCTET-STREAM");
        DefaultFile file = null;
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            file = (DefaultFile)this.fileManager.get((Serializable)((Object)fileId));
        }
        if (BeanUtils.isEmpty((Object)((Object)file))) {
            throw new NotFoundException(String.format("\u672a\u627e\u5230fileId\u4e3a: %s \u7684\u6587\u4ef6", fileId));
        }
        String fileName = file.getFileName() + "." + file.getExtensionName();
        String filedisplay = URLEncoder.encode(fileName, "utf-8");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Disposition", "attachment;filename=" + filedisplay);
        response.addHeader("filename", filedisplay);
        response.setHeader("Access-Control-Allow-Origin", "*");
        String type = new MimetypesFileTypeMap().getContentType(new File(file.getFilePath()));
        response.setContentType(type);
        this.fileManager.downloadFile(fileId, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"getLogoFile"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u79df\u6237logo\u6587\u4ef6", httpMethod="GET", notes="\u6839\u636e\u79df\u6237id\u83b7\u53d6\u79df\u6237logo\u6587\u4ef6")
    public void getLogoFile(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="tenantId", value="\u79df\u6237id") @RequestParam String tenantId, @ApiParam(name="logoType", value="logo\u7c7b\u578b\uff1amanage(\u7ba1\u7406\u7aef)\u3001front(\u5e94\u7528\u7aef)") @RequestParam String logoType) throws Exception {
        ArrayNode logoNode;
        String fileId;
        response.setContentType("APPLICATION/OCTET-STREAM");
        DefaultFile file = null;
        JsonNode tenantNode = this.ucFeignService.getTenantById(tenantId);
        String logoTypeField = "manageLogo";
        if ("front".equals(logoType)) {
            logoTypeField = "frontLogo";
        }
        if (BeanUtils.isEmpty((Object)((Object)(file = (DefaultFile)this.fileManager.get((Serializable)((Object)(fileId = (logoNode = (ArrayNode)JsonUtil.toJsonNode((String)tenantNode.get(logoTypeField).asText())).get(0).get("id").asText()))))))) {
            throw new NotFoundException(String.format("\u672a\u627e\u5230fileId\u4e3a: %s \u7684\u6587\u4ef6", fileId));
        }
        String fileName = file.getFileName() + "." + file.getExtensionName();
        String filedisplay = URLEncoder.encode(fileName, "utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + filedisplay);
        response.addHeader("filename", filedisplay);
        response.setHeader("Access-Control-Allow-Origin", "*");
        String type = new MimetypesFileTypeMap().getContentType(new File(file.getFilePath()));
        response.setContentType(type);
        this.fileManager.downloadFile(fileId, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"getFileType"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u9644\u4ef6id\u53d6\u5f97\u9644\u4ef6\u7c7b\u578b\u3002", httpMethod="POST", notes="\u6839\u636e\u9644\u4ef6id\u53d6\u5f97\u9644\u4ef6\u7c7b\u578b\u3002")
    public String getFileType(@ApiParam(name="fileId", value="\u9644\u4ef6id") @RequestBody String fileId) throws IOException {
        DefaultFile DefaultFile2 = null;
        String type = "doc";
        if (StringUtil.isNotEmpty((String)fileId)) {
            DefaultFile2 = (DefaultFile)this.fileManager.get((Serializable)((Object)fileId));
            type = DefaultFile2.getExtensionName().toLowerCase();
        }
        return type;
    }

    @RequestMapping(value={"setXbTypeId"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539\u9644\u4ef6\u5206\u7c7b\u3002", httpMethod="POST", notes="\u4fee\u6539\u9644\u4ef6\u5206\u7c7b\u3002")
    public CommonResult setXbTypeId(@ApiParam(name="fileId", value="\u9644\u4ef6id") @RequestBody List<String> fileId, @ApiParam(name="xbTypeId", value="\u5206\u7c7bID") @RequestParam String xbTypeId, @ApiParam(name="type", value="\u5206\u7c7b\u540d\u79f0") @RequestParam String type) throws Exception {
        this.fileManager.setXbTypeId(fileId, xbTypeId, type);
        return new CommonResult(true, "\u8bbe\u7f6e\u9644\u4ef6\u5206\u7c7b\u6210\u529f", null);
    }

    @RequestMapping(value={"updateFileExtraProp"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u65b0\u9644\u4ef6\u7684\u5c5e\u6027\u6210\u529f", httpMethod="POST", notes="\u66f4\u65b0\u9644\u4ef6\u7684\u5c5e\u6027\u6210\u529f\uff08\u5305\u542b\u6269\u5c55\u5c5e\u6027\u3001\u6d41\u7a0b\u5b9e\u4f8bID\u3001\u8282\u70b9\u540d\u79f0\u3001\u6d41\u7a0b\u6807\u9898\u3001\u9644\u4ef6\u6765\u6e90\u3001\u6240\u5c5e\u5206\u7c7b\uff09")
    public CommonResult updateFileExtraProp(@ApiParam(name="files", value="\u9644\u4ef6\u5217\u8868") @RequestBody List<DefaultFile> files) throws Exception {
        this.fileManager.updateFileExtraProp(files);
        return new CommonResult(true, "\u66f4\u65b0\u9644\u4ef6\u7684\u5c5e\u6027\u6210\u529f", null);
    }

    @RequestMapping(value={"preview"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9644\u4ef6\u9884\u89c8", httpMethod="GET", notes="\u9644\u4ef6\u9884\u89c8")
    public void preview(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="fileId", value="\u9644\u4ef6ID") @RequestParam String fileId) throws Exception {
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            String fileName;
            response.setContentType("text/html; charset=UTF-8");
            response.setContentType("image/jpeg");
            DefaultFile file = null;
            file = (DefaultFile)this.fileManager.get((Serializable)((Object)fileId));
            if (BeanUtils.isEmpty((Object)((Object)file))) {
                return;
            }
            String filedisplay = fileName = file.getFileName() + "." + file.getExtensionName();
            String agent = request.getHeader("USER-AGENT");
            filedisplay = agent != null && agent.indexOf("MSIE") == -1 && agent.indexOf("Trident") == -1 ? "=?UTF-8?B?" + new String(Base64.getBase64((String)filedisplay)) + "?=" : URLEncoder.encode(filedisplay, "utf-8");
            response.addHeader("filename", filedisplay);
            response.setHeader("Access-Control-Allow-Origin", "*");
            this.fileManager.downloadFile(fileId, (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            this.logger.error("\u9884\u89c8\u9644\u4ef6\u5931\u8d25");
        }
    }

    @RequestMapping(value={"wordPrint"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="word\u6a21\u677f\u6253\u5370", httpMethod="POST", notes="word\u6a21\u677f\u6253\u5370")
    public String wordPrint(@ApiParam(name="objectNode", value="Json\u5bf9\u8c61") @RequestBody ObjectNode objectNode) throws Exception {
        String boData = objectNode.get("boData").toString();
        String fileId = objectNode.get("fileId").asText();
        String subject = objectNode.get("subject").asText();
        ArrayNode flowOpinions = (ArrayNode)objectNode.get("flowOpinions");
        String scriptStr = objectNode.get("scriptStr").asText();
        DefaultFile defaultFile = (DefaultFile)this.fileManager.get((Serializable)((Object)fileId));
        DefaultFile model = new DefaultFile();
        model.setId(UniqueIdUtil.getSuid());
        String outputFilePath = AppFileUtil.createFilePath("print" + File.separator + this.baseContext.getCurrentUserAccout(), model.getId() + "." + defaultFile.getExtensionName());
        String saveOutputFilePath = this.printFile(boData, defaultFile, outputFilePath, flowOpinions, scriptStr, model.getId());
        try {
            if (flowOpinions.size() > 0) {
                String defId = objectNode.get("defId").asText();
                String nodeId = objectNode.get("nodeId").asText();
                ObjectNode opinion = (ObjectNode)flowOpinions.get(0);
                ObjectNode record = JsonUtil.getMapper().createObjectNode();
                record.put("procInstId", opinion.get("procInstId").asText());
                record.put("nodeId", nodeId);
                record.put("procDefId", defId);
                record.put("formKey", objectNode.get("formKey").asText());
                record.put("templateId", fileId);
                record.put("templateName", defaultFile.getFileName());
                record.put("fileId", model.getId());
                this.workflowFeignService.addPrintLog(record);
            }
        }
        catch (Exception e) {
            System.out.println("\u65b0\u589e\u6253\u5370\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
        }
        model.setFileName(subject);
        model.setStoreType(AppFileUtil.getSaveType(""));
        model.setFilePath(outputFilePath.replace(AppFileUtil.getAttachPath() + File.separator, ""));
        model.setExtensionName(defaultFile.getExtensionName());
        model.setIsDel((short)0);
        model.setCreateTime(DateUtil.getCurrentDate());
        if (!model.getStoreType().equals(DefaultFile.SAVE_TYPE_FOLDER)) {
            this.fileManager.uploadFile(model, new FileInputStream(saveOutputFilePath));
        } else {
            this.fileManager.create((Model)model);
        }
        return model.getId();
    }

    private String printFile(String boData, DefaultFile defaultFile, String outputFilePath, ArrayNode flowOpinions, String scriptStr, String fileId) throws Exception {
        FileOutputStream out2;
        XWPFTemplate template2;
        HashMap<String, ArrayNode> boMap = new HashMap<String, ArrayNode>();
        HashMap twiceMap = new HashMap();
        AtomicBoolean isSubHtml = new AtomicBoolean(false);
        Configure config = Configure.newBuilder().setElMode(Configure.ELMode.SPEL_MODE).setValidErrorHandler((Configure.ValidErrorHandler)new Configure.ClearHandler()).build();
        JsonUtil.toMap((String)boData).values().forEach(item -> ((Map)item).forEach((key, val) -> {
            Object printObj = val;
            if (key.toString().startsWith("sub_")) {
                if (HtmlUtil.isHtml(printObj.toString())) {
                    isSubHtml.set(true);
                }
                if (val instanceof List && ((List)val).size() == 1) {
                    Map subMapKey = (Map)((List)val).get(0);
                    printObj = subMapKey;
                }
                config.customPolicy(key.toString(), (RenderPolicy)new DetailTablePolicy());
            }
            boMap.put((String)key, (ArrayNode)printObj);
            if (HtmlUtil.isHtml(printObj.toString())) {
                this.handRichtext(key.toString(), val.toString(), boMap);
            } else if (BeanUtils.isNotEmpty((Object)val)) {
                HtmlUtil.printPicture(key.toString(), printObj.toString(), boMap, twiceMap);
            }
        }));
        config.customPolicy("flowOpinions", (RenderPolicy)new InstanceFlowOpinions());
        boMap.put("flowOpinions", flowOpinions);
        String filePath = defaultFile.getFilePath();
        String fullPath = StringUtil.trimSufffix((String)AppFileUtil.getAttachPath(), (String)File.separator) + File.separator + filePath.replace("/", File.separator);
        outputFilePath = StringUtil.trimSufffix((String)AppFileUtil.getAttachPath(), (String)File.separator) + outputFilePath.replace("/", File.separator);
        String[] paths = outputFilePath.split(fileId);
        if (paths.length > 1 && !FileUtil.isExistFile((String)paths[0])) {
            FileUtil.createFolder((String)paths[0], (boolean)false);
        }
        if (StringUtil.isNotEmpty((String)scriptStr)) {
            HashMap<String, HashMap<String, Object>> params = new HashMap<String, HashMap<String, Object>>();
            params.put("boMap", boMap);
            params.putAll(boMap);
            this.groovyScriptEngine.executeString(scriptStr, params);
        }
        if (!new File(fullPath).exists()) {
            this.fileManager.downloadFileToPath(defaultFile, fullPath);
        }
        XWPFTemplate template = XWPFTemplate.compile((String)fullPath, (Configure)config);
        List templates = template.getElementTemplates();
        for (MetaTemplate metaTemplate : templates) {
            String code = metaTemplate.variable();
            if (!code.startsWith("{{+")) continue;
            code = code.replaceAll("\\{", "");
            code = code.replaceAll("\\+", "");
            if (!BeanUtils.isEmpty(boMap.get(code = code.replaceAll("\\}", "")))) continue;
            this.handRichtext(code, "", boMap);
        }
        template.render(boMap);
        FileOutputStream out = new FileOutputStream(outputFilePath);
        template.write((OutputStream)out);
        out.flush();
        out.close();
        template.close();
        if (isSubHtml.get()) {
            Configure subConfig = Configure.newBuilder().setElMode(Configure.ELMode.SPEL_MODE).build();
            template2 = XWPFTemplate.compile((String)outputFilePath, (Configure)subConfig).render(boMap);
            out2 = new FileOutputStream(outputFilePath);
            template2.write((OutputStream)out2);
            out2.flush();
            out2.close();
            template2.close();
        }
        if (!twiceMap.isEmpty()) {
            Configure twiceConfig = Configure.newBuilder().setElMode(Configure.ELMode.SPEL_MODE).addPlugin('#', (RenderPolicy)new SignaturePictureRenderPolicy()).build();
            template2 = XWPFTemplate.compile((String)outputFilePath, (Configure)twiceConfig).render(twiceMap);
            out2 = new FileOutputStream(outputFilePath);
            template2.write((OutputStream)out2);
            out2.flush();
            out2.close();
            template2.close();
        }
        return outputFilePath;
    }

    private void handRichtext(String key, String text, Map boMap) {
        if (boMap.get(key) instanceof List) {
            List subList = (List)boMap.get(key);
            subList.forEach(subMap -> subMap.forEach((subKey, subValue) -> {
                if (HtmlUtil.isHtml(subValue.toString())) {
                    File docxFile = HtmlUtil.getRichtextToDocx(subValue.toString());
                    subMap.put(subKey, new DocxRenderData(docxFile));
                    if (docxFile != null && docxFile.exists()) {
                        docxFile.delete();
                    }
                }
            }));
        } else if (boMap.get(key) instanceof Map) {
            Map subMap2 = (Map)boMap.get(key);
            subMap2.forEach((subKey, subValue) -> {
                if (HtmlUtil.isHtml(subValue.toString())) {
                    File docxFile = HtmlUtil.getRichtextToDocx(subValue.toString());
                    subMap2.put(subKey, new DocxRenderData(docxFile));
                    if (docxFile != null && docxFile.exists()) {
                        docxFile.delete();
                    }
                }
            });
        } else {
            File docxFile = HtmlUtil.getRichtextToDocx(text);
            boMap.put(key, new DocxRenderData(docxFile));
            if (docxFile != null && docxFile.exists()) {
                docxFile.delete();
            }
        }
    }

    @RequestMapping(value={"getFileBytesById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9644\u4ef6\u4e0b\u8f7d", httpMethod="GET", notes="\u9644\u4ef6\u4e0b\u8f7d")
    public byte[] getFileBytesById(@ApiParam(name="fileId", value="\u9644\u4ef6ID") @RequestParam String fileId) throws Exception {
        return this.fileManager.getFileBytesById(fileId);
    }

    @RequestMapping(value={"/importSignature"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165\u7b7e\u7ae0", httpMethod="POST", notes="\u6279\u91cf\u5bfc\u5165\u7b7e\u7ae0")
    public CommonResult<String> importSignature(@ApiParam(name="file", value="\u5bfc\u5165\u7684\u538b\u7f29\u6587\u4ef6\uff08.zip\u6216.rar\uff09", required=true) @RequestBody MultipartFile file, @ApiParam(name="repeatConver", value="\u5f53\u7528\u6237\u5df2\u5b58\u5728\u7b7e\u7ae0\u65f6\u662f\u5426\u8986\u76d6", required=false) @RequestParam Optional<Boolean> repeatConver) throws Exception {
        return this.fileManager.importSignature(file, repeatConver.orElse(true));
    }

    @ApiOperation(value="\u5206\u7247\u521d\u59cb\u5316", httpMethod="POST", notes="\u5206\u7247\u4e0a\u4f20\uff0c\u5206\u7247\u5927\u5c0f\u4e3a10\u5146")
    @PostMapping(value={"init"})
    public CommonResult<String> initMultiPartUpload(@RequestBody MultipartInitParam requestParam) {
        MultipartInitRespVo multipartInitBO = this.fileManager.initMultiPartUpload(requestParam);
        if (Objects.nonNull(multipartInitBO)) {
            return CommonResult.success((Object)multipartInitBO, null);
        }
        throw new BaseException("\u5206\u7247\u521d\u59cb\u5316\u5931\u8d25\uff01");
    }

    @ApiOperation(value="\u5206\u7247\u4e0a\u4f20", httpMethod="POST", notes="\u7531uploadId\u548cchunk\u67e5\u5230minio\u751f\u6210\u7684\u5206\u7247url, \u4e0a\u4f20\u6587\u4ef6part\u5230minio")
    @PostMapping(value={"/chunkUpload"})
    public CommonResult<String> chunkUpload(@RequestPart(value="file") MultipartFile file, @RequestParam(value="uploadId") String uploadId, @RequestParam(value="chunk") String chunk) {
        boolean status = this.fileManager.chunkUpload(file, uploadId, chunk);
        return CommonResult.success((Object)status, null);
    }

    @ApiOperation(value="\u5b8c\u6210\u4e0a\u4f20", httpMethod="POST", notes="\u5f53\u6240\u6709\u5206\u7247\u4e0a\u4f20\u63a5\u53e3\u8fd4\u56de200\u540e\uff0c\u8c03\u7528\u6b64\u65b9\u6cd5\uff0c\u5408\u5e76\u5206\u7247\uff08minio\u6587\u4ef6\u670d\u52a1\u5668\u5408\u5e76\uff09\uff0c\u5b8c\u6210\u4e0a\u4f20\u3002")
    @PostMapping(value={"completeUpload"})
    public CommonResult<String> completeMultiPartUpload(@RequestBody MultipartCompleteParam param) {
        UploadResult uploadResult = this.fileManager.mergeMultipartUpload(param);
        return CommonResult.success((Object)uploadResult, null);
    }

    @ApiOperation(value="\u6d4b\u8bd5\u89c6\u5c4f\u8f6cM3U8")
    @GetMapping(value={"uploadVideoToM3U8"})
    public CommonResult<String> uploadVideoToM3U8(String fileId) {
        UploadM3u8 uploadM3u8 = new UploadM3u8();
        DefaultFile defaultFile = (DefaultFile)this.fileManager.get((Serializable)((Object)fileId));
        String s = uploadM3u8.uploadVideoToM3U8(defaultFile);
        return CommonResult.success((Object)s, null);
    }
}

