/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.activiti.ext.listener;

import com.artfess.activiti.ext.factory.BpmDelegateFactory;
import com.artfess.base.groovy.GroovyScriptEngine;
import com.artfess.base.model.HtJsonNodeFactory;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.constant.EventType;
import com.artfess.bpm.api.constant.ScriptType;
import com.artfess.bpm.api.context.BpmContextUtil;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.model.delegate.BpmDelegateExecution;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.plugin.core.cmd.ExecutionCommand;
import com.artfess.bpm.api.service.BoDataService;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.api.service.BpmDefinitionService;
import com.artfess.bpm.api.service.BpmInstService;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;

public abstract class AbstractExecutionListener
implements ExecutionListener {
    private static final long serialVersionUID = 5610767582073352010L;
    @Resource
    private BpmDefinitionService bpmDefinitionService;
    @Resource
    BoDataService boDataService;
    @Resource
    BpmInstService bpmInstService;
    @Resource
    private BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    private GroovyScriptEngine groovyScriptEngine;
    private List<ExecutionCommand> executionCommands;

    public abstract EventType getBeforeTriggerEventType();

    public abstract EventType getAfterTriggerEventType();

    public abstract void beforePluginExecute(BpmDelegateExecution var1);

    public abstract void triggerExecute(BpmDelegateExecution var1);

    public abstract void afterPluginExecute(BpmDelegateExecution var1) throws Exception;

    public void notify(DelegateExecution delegateExecution) throws Exception {
        BpmDelegateExecution bpmDelegateExecution = BpmDelegateFactory.getBpmDelegateExecution(delegateExecution);
        this.beforePluginExecute(bpmDelegateExecution);
        if (this.executionCommands != null && this.getBeforeTriggerEventType() != null) {
            for (ExecutionCommand cmd : this.executionCommands) {
                cmd.execute(this.getBeforeTriggerEventType(), bpmDelegateExecution);
            }
        }
        this.triggerExecute(bpmDelegateExecution);
        if (this.executionCommands != null && this.getAfterTriggerEventType() != null) {
            for (ExecutionCommand cmd : this.executionCommands) {
                cmd.execute(this.getAfterTriggerEventType(), bpmDelegateExecution);
            }
        }
        this.afterPluginExecute(bpmDelegateExecution);
        this.exeEventScript(bpmDelegateExecution);
    }

    protected abstract ScriptType getScriptType();

    private void exeEventScript(BpmDelegateExecution bpmDelegateExecution) throws Exception {
        String bpmnDefId = bpmDelegateExecution.getBpmnDefId();
        String defId = this.bpmDefinitionService.getDefIdByBpmnDefId(bpmnDefId);
        String nodeId = bpmDelegateExecution.getNodeId();
        if (StringUtil.isEmpty((String)nodeId)) {
            return;
        }
        BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        ScriptType scriptType = this.getScriptType();
        String script = (String)nodeDef.getScripts().get(scriptType);
        if (StringUtil.isEmpty((String)script)) {
            return;
        }
        Map vars = bpmDelegateExecution.getVariables();
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        Map boMap = BpmContextUtil.getBoFromContext();
        if (BeanUtils.isEmpty((Object)boMap)) {
            BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(cmd.getInstId());
            List boDatas = this.boDataService.getDataByInst(bpmProcessInstance);
            BpmContextUtil.setBoToContext((List)boDatas);
            boMap = BpmContextUtil.getBoFromContext();
        }
        if (BeanUtils.isNotEmpty((Object)boMap) && BeanUtils.isNotEmpty((Object)boMap)) {
            HashMap newMap = new HashMap();
            for (Map.Entry next : boMap.entrySet()) {
                newMap.put(next.getKey(), HtJsonNodeFactory.build().htObjectNode((ObjectNode)next.getValue()));
            }
            vars.putAll(newMap);
        }
        vars.put("nodeDef", nodeDef);
        vars.put("execution", bpmDelegateExecution);
        vars.put("cmd", cmd);
        this.groovyScriptEngine.execute(script, vars);
    }

    public void setExecutionCommands(List<ExecutionCommand> executionCommands) {
        this.executionCommands = executionCommands;
    }
}

