/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.ueditor.upload;

import com.artfess.base.util.AppUtil;
import com.artfess.base.util.Base64;
import com.artfess.ueditor.PathFormat;
import com.artfess.ueditor.define.BaseState;
import com.artfess.ueditor.define.FileType;
import com.artfess.ueditor.define.State;
import com.artfess.ueditor.upload.StorageService;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

public class Base64Uploader {
    @Resource
    StorageService storageService;

    public State save(HttpServletRequest request, Map<String, Object> conf) {
        State storageState;
        long maxSize;
        String filedName = (String)conf.get("fieldName");
        String fileName = request.getParameter(filedName);
        byte[] data = this.decode(fileName);
        if (!this.validSize(data, maxSize = ((Long)conf.get("maxSize")).longValue())) {
            return new BaseState(false, 1);
        }
        String suffix = FileType.getSuffix("JPG");
        String savePath = PathFormat.parse((String)conf.get("savePath"), (String)conf.get("filename"));
        savePath = savePath + suffix;
        String rootPath = "";
        String physicalPath = rootPath + savePath;
        if (this.storageService == null) {
            this.storageService = (StorageService)AppUtil.getBean(StorageService.class);
        }
        if ((storageState = this.storageService.saveBinaryFile(data, physicalPath)).isSuccess()) {
            storageState.putInfo("url", PathFormat.format(savePath));
            storageState.putInfo("type", suffix);
            storageState.putInfo("original", "");
        }
        return storageState;
    }

    private byte[] decode(String content) {
        return Base64.decodeBase64((String)content);
    }

    private boolean validSize(byte[] data, long length) {
        return (long)data.length <= length;
    }
}

