/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.api.impl.service;

import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.uc.api.constant.GroupTypeConstant;
import com.artfess.uc.api.impl.model.Org;
import com.artfess.uc.api.impl.model.OrgJob;
import com.artfess.uc.api.impl.model.OrgRel;
import com.artfess.uc.api.impl.model.Role;
import com.artfess.uc.api.model.Group;
import com.artfess.uc.api.model.GroupType;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.service.IUserGroupService;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class DefaultUserGroupService
implements IUserGroupService {
    @Resource
    UCFeignService ucFeignService;

    public List<GroupType> getGroupTypes() {
        ArrayList<GroupType> list = new ArrayList<GroupType>();
        for (GroupTypeConstant e : GroupTypeConstant.values()) {
            GroupType type = new GroupType(e.key(), e.label());
            list.add(type);
        }
        return list;
    }

    public IGroup getGroupByIdOrCode(String groupType, String code) {
        ObjectNode result = JsonUtil.getMapper().createObjectNode();
        try {
            CommonResult commonResult;
            if (groupType.equals(GroupTypeConstant.ORG.key()) && BeanUtils.isNotEmpty((Object)(result = this.ucFeignService.getOrgByIdOrCode(code)))) {
                return (IGroup)JsonUtil.toBean((JsonNode)result, Org.class);
            }
            if (groupType.equals(GroupTypeConstant.ROLE.key()) && BeanUtils.isNotEmpty((Object)(commonResult = this.ucFeignService.getRoleByIdOrCode(code)).getValue())) {
                return (IGroup)JsonUtil.toBean((JsonNode)((JsonNode)commonResult.getValue()), Role.class);
            }
            if (groupType.equals(GroupTypeConstant.POSITION.key()) && BeanUtils.isNotEmpty((Object)(commonResult = this.ucFeignService.getPostByIdOrCode(code)).getValue())) {
                return (IGroup)JsonUtil.toBean((JsonNode)((JsonNode)commonResult.getValue()), OrgRel.class);
            }
            if (groupType.equals(GroupTypeConstant.JOB.key()) && BeanUtils.isNotEmpty((Object)(commonResult = this.ucFeignService.getJobByOrgCode(code)).getValue())) {
                return (IGroup)JsonUtil.toBean((JsonNode)((JsonNode)commonResult.getValue()), OrgJob.class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public List<IGroup> getGroupsByUserIdOrAccount(String groupType, String userId) {
        ArrayList<IGroup> listMap = new ArrayList<IGroup>();
        List groupIdsByUserId = this.ucFeignService.getGroupsByUidAndType(userId, groupType);
        for (Group group : groupIdsByUserId) {
            listMap.add((IGroup)group);
        }
        return listMap;
    }

    public List<IGroup> getGroupsByUserIdOrAccount(String account) {
        ArrayList<IGroup> listMap = new ArrayList<IGroup>();
        List groupIdsByUserId = this.ucFeignService.getGroupsByUidAndType(account, "all");
        for (Group group : groupIdsByUserId) {
            listMap.add((IGroup)group);
        }
        return listMap;
    }

    public Map<String, List<IGroup>> getGroupsMapUserIdOrAccount(String id) {
        List<IGroup> groups = this.getGroupsByUserIdOrAccount(id);
        HashMap<String, List<IGroup>> map = new HashMap<String, List<IGroup>>();
        if (BeanUtils.isEmpty(groups)) {
            return map;
        }
        for (IGroup group : groups) {
            String type = group.getGroupType();
            List list = null;
            list = map.containsKey(type) ? (List)map.get(type) : new ArrayList();
            list.add(group);
            map.put(type, list);
        }
        return map;
    }
}

