/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.sysConfig.persistence.manager.impl;

import com.alibaba.druid.util.StringUtils;
import com.artfess.base.cache.CacheManager;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.sysConfig.persistence.dao.SysIdentityDao;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.artfess.sysConfig.persistence.model.SysIdentity;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="identityManager")
public class SysIdentityManagerImpl
extends BaseManagerImpl<SysIdentityDao, SysIdentity>
implements SysIdentityManager {
    @Resource
    CacheManager cacheManager;

    @Override
    public boolean isAliasExisted(Map<String, Object> params) {
        Integer i = ((SysIdentityDao)this.baseMapper).isAliasExisted(params);
        return i > 0;
    }

    @Override
    public String getCurIdByAlias(String alias) {
        SysIdentity identity = ((SysIdentityDao)this.baseMapper).getByAlias(alias);
        Integer curValue = identity.getCurValue();
        if (curValue == null) {
            curValue = identity.getInitValue();
        }
        String rtn = this.getByRule(identity.getRegulation(), identity.getNoLength(), curValue);
        return rtn;
    }

    private String getByRule(String rule, int length, int curValue) {
        Calendar c = Calendar.getInstance();
        int year = c.get(1);
        int month = c.get(2) + 1;
        int day = c.get(5);
        String yearStr = "" + year;
        String shortMonth = "" + month;
        String longMonth = month < 10 ? "0" + month : "" + month;
        String shortDay = "" + day;
        String longDay = day < 10 ? "0" + day : "" + day;
        String pre = rule.replace("{yyyy}", yearStr).replace("{MM}", longMonth).replace("{mm}", shortMonth).replace("{DD}", longDay).replace("{dd}", shortDay).replace("{NO}", "").replace("{no}", "");
        int fillLen = StringUtils.isEmpty((CharSequence)pre) ? 0 : pre.length();
        String seqNo = SysIdentityManagerImpl.getSeqNo(rule, curValue, length);
        String rtn = rule.replace("{yyyy}", yearStr).replace("{MM}", longMonth).replace("{mm}", shortMonth).replace("{DD}", longDay).replace("{dd}", shortDay).replace("{NO}", seqNo).replace("{no}", seqNo);
        return rtn;
    }

    private static String getSeqNo(String rule, int curValue, int length) {
        String tmp = curValue + "";
        int len = 0;
        len = rule.indexOf("no") > -1 ? length : length - tmp.length();
        String rtn = "";
        for (int i = 0; i < len; ++i) {
            rtn = rtn + "0";
        }
        if (rule.indexOf("no") > -1) {
            return tmp + rtn;
        }
        return rtn + tmp;
    }

    @Override
    public synchronized String nextId(String alias) {
        SysIdentity identity = ((SysIdentityDao)this.baseMapper).getByAlias(alias);
        Result result = this.genResult(identity);
        int tryTimes = 0;
        while (result.getRtn() == 0) {
            if (++tryTimes > 100) {
                throw new RuntimeException("\u83b7\u53d6\u5355\u636e\u53f7\u89c4\u5219\u5931\u8d25\uff01 " + identity.getAlias());
            }
            try {
                TimeUnit.MILLISECONDS.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            identity.setCurValue(result.getCurValue());
            result = this.genResult(identity);
        }
        return result.getIdNo();
    }

    public Result genResult(SysIdentity identity) {
        String rule = identity.getRegulation();
        short step = identity.getStep();
        short genEveryDay = identity.getGenType();
        Integer curValue = identity.getCurValue();
        if (curValue == 0) {
            curValue = identity.getInitValue();
        }
        if (genEveryDay == 0) {
            curValue = curValue + step;
        } else {
            String formatString = this.getFormatString(Integer.valueOf(genEveryDay));
            String curDate = this.getCurDate(formatString);
            String oldDate = identity.getCurDate();
            identity.setOldDate(oldDate);
            if (!curDate.equals(oldDate)) {
                identity.setCurDate(curDate);
                curValue = identity.getInitValue();
            } else {
                curValue = curValue + step;
            }
        }
        identity.setNewCurValue(curValue);
        int i = 0;
        i = genEveryDay == 0 ? ((SysIdentityDao)this.baseMapper).updByAlias(identity) : ((SysIdentityDao)this.baseMapper).updByAliasWithDay(identity);
        Result result = new Result(0, "", curValue);
        if (i > 0) {
            String rtn = this.getByRule(rule, identity.getNoLength(), curValue);
            result.setIdNo(rtn);
            result.setRtn(1);
        }
        return result;
    }

    public String getFormatString(Integer type) {
        String formatString = "yyyyMMdd";
        if (type == 2) {
            formatString = "yyyyMM";
        } else if (type == 3) {
            formatString = "yyyy";
        }
        return formatString;
    }

    public String getCurDate(String formatString) {
        return DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)formatString);
    }

    @Override
    public List<SysIdentity> getPreviewIden(String alias) {
        int genNum = 10;
        SysIdentity identity = ((SysIdentityDao)this.baseMapper).getByAlias(alias);
        String rule = identity.getRegulation();
        short step = identity.getStep();
        Integer curValue = identity.getCurValue();
        if (curValue == null) {
            curValue = identity.getInitValue();
        }
        ArrayList<SysIdentity> tempList = new ArrayList<SysIdentity>();
        for (int i = 0; i < genNum; ++i) {
            SysIdentity identitytemp = new SysIdentity();
            if (i > 0) {
                curValue = curValue + step;
            }
            String rtn = this.getByRule(rule, identity.getNoLength(), curValue);
            identitytemp.setId(curValue.toString());
            identitytemp.setCurIdenValue(rtn);
            tempList.add(identitytemp);
        }
        return tempList;
    }

    @Override
    public String export(String[] idList) throws IOException {
        if (BeanUtils.isEmpty((Object)idList)) {
            return "";
        }
        ArrayList<SysIdentity> list = new ArrayList<SysIdentity>();
        for (String s : idList) {
            SysIdentity sysIdentity = (SysIdentity)this.get((Serializable)((Object)s));
            list.add(sysIdentity);
        }
        if (BeanUtils.isEmpty(list)) {
            return "";
        }
        return JsonUtil.toJson(list);
    }

    @Override
    @Transactional
    public void importFile(String unZipFilePath) throws Exception {
        try {
            String json = FileUtil.readFile((String)(unZipFilePath + File.separator + "identity.json"));
            List list = (List)JsonUtil.toBean((String)json, List.class);
            for (Object o : list) {
                String identityStr = JsonUtil.toJson(o);
                SysIdentity sysIdentity = (SysIdentity)((Object)JsonUtil.toBean((String)identityStr, SysIdentity.class));
                SysIdentity byAlias = ((SysIdentityDao)this.baseMapper).getByAlias(sysIdentity.getAlias());
                if (BeanUtils.isNotEmpty((Object)((Object)byAlias))) {
                    if (byAlias.getId().equals(sysIdentity.getId())) {
                        sysIdentity.setUpdateTime(LocalDateTime.now());
                        ((SysIdentityDao)this.baseMapper).updateById((Object)sysIdentity);
                        continue;
                    }
                    throw new BaseException("\u5355\u636e\u53f7\u89c4\u5219\u522b\u540d\u3010" + byAlias.getAlias() + "\u3011\u5df2\u5b58\u5728,\u5bfc\u5165\u5931\u8d25");
                }
                sysIdentity.setId(UniqueIdUtil.getSuid());
                ((SysIdentityDao)this.baseMapper).insert((Object)sysIdentity);
            }
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
    }

    public class Result {
        private int rtn = 0;
        private String idNo = "";
        private int curValue = 0;

        public Result(int rtn, String idNo, int curValue) {
            this.rtn = rtn;
            this.idNo = idNo;
            this.setCurValue(curValue);
        }

        public int getRtn() {
            return this.rtn;
        }

        public void setRtn(int rtn) {
            this.rtn = rtn;
        }

        public String getIdNo() {
            return this.idNo;
        }

        public void setIdNo(String idNo) {
            this.idNo = idNo;
        }

        public int getCurValue() {
            return this.curValue;
        }

        public void setCurValue(int curValue) {
            this.curValue = curValue;
        }
    }
}

