/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.mongodb.repository.impl;

import com.artfess.mongodb.page.BasePage;
import com.artfess.mongodb.page.Page;
import com.artfess.mongodb.query.FieldSortMongo;
import com.artfess.mongodb.repository.MongoDbRepository;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.support.SimpleMongoRepository;

public class MongoDbRepositoryImpl<T, ID extends Serializable>
extends SimpleMongoRepository<T, ID>
implements MongoDbRepository<T, ID> {
    protected final MongoTemplate mongoTemplate;
    protected final MongoEntityInformation<T, ID> entityInformation;
    private Class<T> clazz;

    public MongoDbRepositoryImpl(MongoEntityInformation<T, ID> metadata, MongoTemplate mongoOperations) {
        super(metadata, (MongoOperations)mongoOperations);
        this.mongoTemplate = mongoOperations;
        this.entityInformation = metadata;
        this.clazz = this.entityInformation.getJavaType();
    }

    @Override
    public void update(ID id, Map<String, Object> updateFieldMap) {
        if (updateFieldMap != null && !updateFieldMap.isEmpty()) {
            Criteria criteria = new Criteria("_id").is(id);
            Update update = new Update();
            updateFieldMap.forEach((arg_0, arg_1) -> ((Update)update).set(arg_0, arg_1));
            this.mongoTemplate.updateFirst(new Query((CriteriaDefinition)criteria), update, this.clazz);
        }
    }

    @Override
    public void update(Map<String, Object> queryFieldMap, Map<String, Object> updateFieldMap) {
        Criteria criteria = new Criteria();
        if (null != queryFieldMap && !queryFieldMap.isEmpty()) {
            queryFieldMap.forEach((key, value) -> criteria.and(key).is(value));
        }
        if (updateFieldMap != null && !updateFieldMap.isEmpty()) {
            Update update = new Update();
            updateFieldMap.forEach((arg_0, arg_1) -> ((Update)update).set(arg_0, arg_1));
            this.mongoTemplate.updateFirst(new Query((CriteriaDefinition)criteria), update, this.clazz);
        }
    }

    @Override
    public List<T> find(HashMap<String, Object> map) {
        Criteria criteria = new Criteria();
        if (null != map && !map.isEmpty()) {
            map.forEach((key, value) -> criteria.and(key).is(value));
        }
        return this.mongoTemplate.find(new Query((CriteriaDefinition)criteria), this.clazz);
    }

    @Override
    public Page<T> findPage(Page<T> page, HashMap<String, Object> map) {
        Criteria criteria = new Criteria();
        if (null != map && !map.isEmpty()) {
            map.forEach((key, value) -> criteria.and(key).is(value));
        }
        Query query = new Query((CriteriaDefinition)criteria);
        long count = this.count(map);
        page.setTotal(count);
        long currentPage = page.getCurrent();
        long pageSize = page.getSize();
        query.skip((currentPage - 1L) * pageSize).limit((int)pageSize);
        List rows = this.mongoTemplate.find(query, this.clazz);
        page.build(rows);
        return page;
    }

    @Override
    public BasePage<T> findBasePage(BasePage<T> page) {
        T param = page.getParam();
        Criteria criteria = new Criteria();
        if (null != param) {
            Field[] field;
            for (Field f : field = this.clazz.getDeclaredFields()) {
                f.setAccessible(true);
                try {
                    String name = f.getName();
                    Object o = MongoDbRepositoryImpl.getFieldValueByName(name, param);
                    if (o == null) continue;
                    criteria.and(name).is(o);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        Query query = new Query((CriteriaDefinition)criteria);
        long count = this.mongoTemplate.count(query, this.clazz);
        page.setTotal(count);
        long currentPage = page.getCurrent();
        long pageSize = page.getSize();
        query.skip((currentPage - 1L) * pageSize).limit((int)pageSize);
        List<FieldSortMongo> sorter = page.getSorter();
        if (sorter.size() > 0) {
            for (FieldSortMongo fieldSort : sorter) {
                if (fieldSort.getOrder().booleanValue()) {
                    query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{fieldSort.getProperty()}));
                    continue;
                }
                query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{fieldSort.getProperty()}));
            }
        }
        List rows = this.mongoTemplate.find(query, this.clazz);
        page.setCurrent(count);
        page.setPages(page.getPages());
        page.setRows(rows);
        page.setSize(pageSize);
        return page;
    }

    private static Object getFieldValueByName(String fieldName, Object o) {
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = o.getClass().getMethod(getter, new Class[0]);
            Object value = method.invoke(o, new Object[0]);
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public long count(HashMap<String, Object> map) {
        Criteria criteria = new Criteria();
        if (null != map && !map.isEmpty()) {
            map.forEach((key, value) -> criteria.and(key).is(value));
        }
        return this.mongoTemplate.count(new Query((CriteriaDefinition)criteria), this.clazz);
    }

    @Override
    public T findByIdCollectionName(String id, String collectionName) {
        return (T)this.mongoTemplate.findById((Object)id, this.clazz, collectionName);
    }

    @Override
    public void updateById(String id, T t) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
        Update update = this.buildBaseUpdate(t);
        this.mongoTemplate.updateMulti(query, update, this.clazz);
    }

    private Update buildBaseUpdate(T t) {
        Field[] fields;
        Update update = new Update();
        for (Field field : fields = t.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                Object value = field.get(t);
                if (value == null) continue;
                update.set(field.getName(), value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return update;
    }
}

