/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.mail.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.Base64;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.EncryptUtil;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.file.util.AppFileUtil;
import com.artfess.mail.api.AttacheHandler;
import com.artfess.mail.model.Mail;
import com.artfess.mail.model.MailAttachment;
import com.artfess.mail.model.MailSetting;
import com.artfess.mail.persistence.dao.MailDao;
import com.artfess.mail.persistence.manager.MailAttachmentManager;
import com.artfess.mail.persistence.manager.MailManager;
import com.artfess.mail.persistence.manager.MailSettingManager;
import com.artfess.mail.persistence.manager.impl.MailSettingManagerImpl;
import com.artfess.mail.util.ExchangeMailUtil;
import com.artfess.mail.util.MailUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.security.NoSuchProviderException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.mail.MessagingException;
import javax.mail.Part;
import microsoft.exchange.webservices.data.property.complex.Attachment;
import microsoft.exchange.webservices.data.property.complex.AttachmentCollection;
import microsoft.exchange.webservices.data.property.complex.FileAttachment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="mailManager")
public class MailManagerImpl
extends BaseManagerImpl<MailDao, Mail>
implements MailManager {
    protected static Logger logger = LoggerFactory.getLogger(MailUtil.class);
    static short MAIL_NO_READ = 0;
    static short MAIL_IS_READ = 1;
    static Integer MAIL_IS_RECEIVE = 1;
    static Integer MAIL_IS_SEND = 2;
    static Integer MAIL_IS_DRAFT = 3;
    static Integer MAIL_IS_DELETE = 4;
    @Resource
    MailSettingManager mailSettingManager;
    @Resource
    MailSettingManagerImpl mailSettingService;
    @Resource
    MailAttachmentManager mailAttachmentManager;
    @Resource
    FileManager fileManager;
    @Resource
    IUserService ius;

    @Override
    public void addDump(String[] lAryId) {
        for (String l : lAryId) {
            Mail mail = (Mail)this.get((Serializable)((Object)l));
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("type", MAIL_IS_DELETE);
            params.put("id", mail.getId());
            ((MailDao)this.baseMapper).updateTypes(params);
        }
    }

    @Override
    public void emailRead(Mail mail) throws NoSuchProviderException, MessagingException {
        if (Mail.Mail_IsNotRead.shortValue() == mail.getIsRead().shortValue() && Mail.Mail_InBox.shortValue() != mail.getType().shortValue()) {
            return;
        }
        mail.setIsRead(Mail.Mail_IsRead);
        ((MailDao)this.baseMapper).updateById((Object)mail);
    }

    @Override
    public List<Mail> getMailListBySetting(final MailSetting mailSetting) throws Exception {
        Object mailUtil;
        String password;
        String mailType = mailSetting.getMailType();
        String lastMessageId = mailSetting.getLastMessageId();
        LocalDateTime lastReceiveTime = mailSetting.getLastReceiveTime();
        List<Mail> list = null;
        final String userId = mailSetting.getUserId();
        final String userFullname = this.ius.getUserById(userId).getFullname();
        AttacheHandler handler = new AttacheHandler(){

            @Override
            public Boolean isDownlad(String UID) {
                return true;
            }

            @Override
            public void handle(Part part, Mail mail) {
                try {
                    String content = mail.getContent();
                    if (StringUtil.isNotEmpty((String)content)) {
                        mail.setContent(Base64.getBase64((String)content));
                    }
                    MailManagerImpl.this.saveAttach(part, mail, mailSetting, userId, userFullname);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void handle(AttachmentCollection attachments, Mail mail) {
                try {
                    MailManagerImpl.this.saveExchangeAttach(attachments, mail, mailSetting, userId, userFullname);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        if ("exchange".equals(mailType)) {
            password = mailSetting.getPassword();
            mailUtil = new ExchangeMailUtil(mailSetting.getSmtpPort(), mailSetting.getMailAddress(), EncryptUtil.decrypt((String)password));
            list = ((ExchangeMailUtil)mailUtil).receive(handler, lastReceiveTime);
        } else {
            password = mailSetting.getPassword();
            mailSetting.setPassword(EncryptUtil.decrypt((String)password));
            mailUtil = new MailUtil(mailSetting);
            list = ((MailUtil)mailUtil).receive(handler, lastMessageId);
        }
        if (list.size() > 0) {
            Mail mail = list.get(0);
            String messageId = mail.getMessageId();
            LocalDateTime sendDate = mail.getSendDate();
            this.mailSettingManager.updateLastEnvelop(mailSetting.getId(), messageId, sendDate);
        }
        return list;
    }

    private DefaultFile getDefaultFile(Long byteCount, String fileName, String mailAccount, String userId, String userFullname) {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        String fileExt = FileUtil.getFileExt((String)fileName);
        String filePath = "emailAttachs" + File.separator + mailAccount + File.separator + year + File.separator + month + File.separator + UniqueIdUtil.getUId() + "." + fileExt;
        DefaultFile file = new DefaultFile();
        file.setByteCount(byteCount);
        file.setFileType("mail");
        file.setFileName(fileName.replace("." + fileExt, ""));
        file.setExtensionName(fileExt);
        file.setFilePath(filePath);
        file.setCreateTime(LocalDateTime.now());
        if (StringUtil.isNotEmpty((String)userId)) {
            file.setCreateBy(userId);
        }
        if (StringUtil.isNotEmpty((String)userFullname)) {
            file.setCreatorName(userFullname);
        }
        return file;
    }

    private void saveExchangeAttach(AttachmentCollection attachments, Mail mail, MailSetting mailSetting, String userId, String userFullname) throws Exception {
        List items = attachments.getItems();
        String mailAccount = mailSetting.getMailAddress();
        Boolean isHandleAttach = mailSetting.getIsHandleAttach();
        for (Attachment attach : items) {
            if (!(attach instanceof FileAttachment)) continue;
            FileAttachment fileAttach = (FileAttachment)attach;
            String filename = fileAttach.getName();
            String fileId = "";
            if (isHandleAttach.booleanValue()) {
                fileAttach.load();
                int size = fileAttach.getSize();
                byte[] content = fileAttach.getContent();
                ByteArrayInputStream sbs = new ByteArrayInputStream(content);
                DefaultFile file = this.getDefaultFile(Long.valueOf(size), filename, mailAccount, userId, userFullname);
                this.fileManager.uploadFile(file, (InputStream)sbs);
                fileId = file.getId();
            }
            mail.getMailAttachments().add(new MailAttachment(filename, fileId));
        }
    }

    private void saveAttach(Part message, Mail mail, MailSetting mailSetting, String userId, String userFullname) throws Exception {
        String mailAccount = mailSetting.getMailAddress();
        String filename = message.getFileName();
        String fileId = "";
        int size = message.getSize();
        DefaultFile file = this.getDefaultFile(Long.valueOf(size), filename, mailAccount, userId, userFullname);
        this.fileManager.uploadFile(file, message.getInputStream());
        fileId = file.getId();
        mail.getMailAttachments().add(new MailAttachment(filename, fileId));
    }

    @Override
    public void saveMail(List<Mail> list, String setId, String currentUserId) throws Exception {
        List<Mail> existMails = ((MailDao)this.baseMapper).getAll((Wrapper<Mail>)((Wrapper)Wrappers.lambdaQuery().in(Mail::getSetId, Arrays.asList(setId.split(",")))));
        HashMap<String, Boolean> mailIDMap = new HashMap<String, Boolean>();
        for (Mail mail : existMails) {
            mailIDMap.put(mail.getMessageId(), true);
        }
        for (Mail mail : list) {
            if (!BeanUtils.isEmpty(mailIDMap.get(mail.getMessageId()))) continue;
            Mail bean = this.getOutMail(mail, setId, currentUserId);
            String mailId = UniqueIdUtil.getSuid();
            bean.setId(mailId);
            bean.setMessageId(mail.getUID());
            ((MailDao)this.baseMapper).insert((Object)bean);
            logger.info("\u5df2\u4e0b\u8f7d\u90ae\u4ef6" + bean.getSubject());
            List<MailAttachment> attachments = mail.getMailAttachments();
            if (BeanUtils.isEmpty(attachments)) continue;
            for (MailAttachment attachment : attachments) {
                String fileName = attachment.getFileName();
                String filePath = attachment.getFilePath();
                String ext = FileUtil.getFileExt((String)fileName);
                String fileId = StringUtil.isNotEmpty((String)filePath) ? new String(new File(filePath).getName().replace("." + ext, "")) : UniqueIdUtil.getSuid();
                MailAttachment mailAttachment = new MailAttachment();
                mailAttachment.setId(fileId);
                mailAttachment.setFileName(attachment.getFileName());
                mailAttachment.setFilePath(filePath);
                mailAttachment.setMailId(mailId);
                this.mailAttachmentManager.create((Model)mailAttachment);
            }
        }
    }

    private Mail getOutMail(Mail mail, String setId, String userId) {
        Mail bean = new Mail();
        LocalDateTime sentDate = null;
        sentDate = mail.getSendDate() != null ? mail.getSendDate() : LocalDateTime.now();
        bean.setSendDate(sentDate);
        bean.setSetId(setId);
        bean.setSubject(mail.getSubject());
        bean.setContent(mail.getContent());
        bean.setSenderAddress(mail.getSenderAddress());
        bean.setSenderName(mail.getSenderName());
        bean.setReceiverAddresses(mail.getReceiverAddresses());
        bean.setReceiverName(mail.getReceiverName());
        bean.setBcCAddresses(mail.getBcCAddresses());
        bean.setBccName(mail.getBccName());
        bean.setCopyToAddresses(mail.getCopyToAddresses());
        bean.setCopyToName(mail.getCopyToName());
        bean.setType(Mail.Mail_InBox);
        bean.setIsRead(Mail.Mail_IsNotRead);
        bean.setUserId(userId);
        return bean;
    }

    @Override
    public List<MailSetting> getMailTreeData(String userId) throws Exception {
        List<MailSetting> list = this.mailSettingManager.getMailByUserId(userId);
        ArrayList<MailSetting> temp = new ArrayList<MailSetting>();
        MailSetting omus = null;
        for (MailSetting beanTemp : list) {
            beanTemp.setParentId("0");
            String id = beanTemp.getId();
            temp.add(beanTemp);
            for (int i = 0; i < 4; ++i) {
                omus = new MailSetting();
                if (i == 0) {
                    omus.setNickName("\u6536\u4ef6\u7bb1(" + this.getCount(id, MAIL_IS_RECEIVE) + ")");
                    omus.setTypes(MAIL_IS_RECEIVE);
                } else if (i == 1) {
                    omus.setNickName("\u53d1\u4ef6\u7bb1(" + this.getCount(id, MAIL_IS_SEND) + ")");
                    omus.setTypes(MAIL_IS_SEND);
                } else if (i == 2) {
                    omus.setNickName("\u8349\u7a3f\u7bb1(" + this.getCount(id, MAIL_IS_DRAFT) + ")");
                    omus.setTypes(MAIL_IS_DRAFT);
                } else {
                    omus.setNickName("\u5783\u573e\u7bb1(" + this.getCount(id, MAIL_IS_DELETE) + ")");
                    omus.setTypes(MAIL_IS_DELETE);
                }
                omus.setId(UniqueIdUtil.getSuid());
                omus.setParentId(beanTemp.getId());
                temp.add(omus);
            }
        }
        return temp;
    }

    private int getCount(String id, int type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", type);
        params.put("setId", id);
        return ((MailDao)this.baseMapper).getFolderCount(params);
    }

    @Override
    public List<Mail> getFolderList(QueryFilter queryFilter) {
        return ((MailDao)this.baseMapper).getFolderList(queryFilter.getParams());
    }

    @Override
    public List<Mail> getDefaultMailList(QueryFilter queryFilter) {
        return ((MailDao)this.baseMapper).getFolderList(queryFilter.getParams());
    }

    @Override
    public String sendMail(Mail outMail, String userId, String mailId, int isReply, String context, String basePath) throws Exception {
        String content = outMail.getContent();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", 2);
        params.put("id", mailId);
        if ("0".equals(mailId) || isReply == 1) {
            outMail.setId(UniqueIdUtil.getSuid());
            this.create((Model)outMail);
        } else {
            ((MailDao)this.baseMapper).updateTypes(params);
        }
        outMail.setContent(content);
        this.getMailAttachments(outMail, basePath);
        String mailsetId = outMail.getSetId();
        MailSetting mailSetting = (MailSetting)this.mailSettingManager.get((Serializable)((Object)mailsetId));
        MailUtil m = new MailUtil(mailSetting);
        m.send(outMail);
        return outMail.getId();
    }

    private Mail getMailAttachments(Mail outMail, String basePath) throws Exception {
        String fileIds;
        JsonNode jsonArray;
        if (BeanUtils.isNotEmpty((Object)((Object)outMail)) && StringUtil.isNotEmpty((String)outMail.getFileIds()) && (jsonArray = JsonUtil.toJsonNode((String)(fileIds = outMail.getFileIds().replaceAll("quot;", "\"")))).size() > 0) {
            DefaultFile sysFile = null;
            List<MailAttachment> attachments = outMail.getMailAttachments();
            for (Object obj : jsonArray) {
                MailAttachment mailAttachment;
                ObjectNode json = (ObjectNode)obj;
                sysFile = (DefaultFile)this.fileManager.get((Serializable)((Object)json.get("id").textValue()));
                String filePath = sysFile.getFilePath();
                String fileName = sysFile.getFileName() + "." + sysFile.getExtensionName();
                if (StringUtil.isEmpty((String)filePath)) {
                    mailAttachment = new MailAttachment(fileName, sysFile.getBytes());
                    mailAttachment.setId(json.get("id").textValue());
                    attachments.add(mailAttachment);
                    continue;
                }
                if (StringUtil.isEmpty((String)basePath)) {
                    basePath = AppFileUtil.getBasePath();
                }
                filePath = basePath + File.separator + filePath;
                mailAttachment = new MailAttachment(fileName, filePath);
                mailAttachment.setId(json.get("id").textValue());
                attachments.add(mailAttachment);
            }
        }
        return outMail;
    }

    @Override
    public Mail getMailReply(String mailId) {
        Mail outMail = (Mail)this.get((Serializable)((Object)mailId));
        outMail.setIsReply(Mail.Mail_IsReplay);
        outMail.setSubject("\u56de\u590d:" + outMail.getSubject());
        return outMail;
    }

    @Override
    public void delBySetId(String setId) {
        ((MailDao)this.baseMapper).delBySetId(setId);
    }

    @Override
    public String mailAttachementFilePath(MailAttachment entity) throws Exception {
        Mail outMail = (Mail)this.get((Serializable)((Object)entity.getId()));
        String setId = outMail.getSetId();
        final String emailId = outMail.getMessageId();
        final MailSetting outMailSetting = (MailSetting)this.mailSettingManager.get((Serializable)((Object)setId));
        outMailSetting.setIsHandleAttach(true);
        MailUtil mailUtil = new MailUtil(outMailSetting);
        final String userId = outMailSetting.getUserId();
        final String userFullname = this.ius.getUserById(userId).getFullname();
        List<Mail> list = mailUtil.receive(new AttacheHandler(){

            @Override
            public Boolean isDownlad(String UID) {
                if (StringUtil.isEmpty((String)UID)) {
                    return false;
                }
                return UID.equals(emailId);
            }

            @Override
            public void handle(Part part, Mail mail) {
                try {
                    MailManagerImpl.this.saveAttach(part, mail, outMailSetting, userId, userFullname);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void handle(AttachmentCollection attachments, Mail mail) {
            }
        }, emailId);
        if (BeanUtils.isEmpty(list)) {
            throw new Exception("\u627e\u4e0d\u5230\u8be5\u90ae\u4ef6\uff0c\u53ef\u80fd\u90ae\u4ef6\u5df2\u88ab\u5220\u9664\uff01");
        }
        String mailId = outMail.getId();
        String attachFileName = entity.getFileName();
        String resultPath = "";
        Mail mail = list.get(0);
        List<MailAttachment> attachments = mail.getMailAttachments();
        for (MailAttachment attachment : attachments) {
            String fileName = attachment.getFileName();
            String filePath = attachment.getFilePath();
            if (fileName.equals(attachFileName)) {
                resultPath = filePath;
            }
            this.mailAttachmentManager.updateFilePath(fileName, mailId, filePath);
        }
        return resultPath;
    }

    @Override
    public String getNameByEmail(String email) {
        String linkName = "\u964c\u751f\u4eba";
        try {
            List users = this.ius.getByEmail(email);
            if (BeanUtils.isNotEmpty((Object)users)) {
                linkName = ((IUser)users.get(0)).getFullname();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return linkName;
    }

    @Override
    public void sendExchangeMail(MailSetting mailSetting, Mail mail) throws Exception {
        ExchangeMailUtil eu = new ExchangeMailUtil(mailSetting.getSmtpPort(), mailSetting.getMailAddress(), EncryptUtil.decrypt((String)mailSetting.getPassword()));
        if ("0".equals(mail.getId()) || mail.getIsReply() == 1) {
            mail.setId(UniqueIdUtil.getSuid());
            this.create((Model)mail);
        } else {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("mailId", mail.getId());
            params.put("types", 2);
            ((MailDao)this.baseMapper).updateTypes(params);
        }
        if (mail.getFileIds() != null) {
            String[] stringArray;
            String[] stringArray2;
            String basePath = AppFileUtil.getBasePath();
            this.getMailAttachments(mail, basePath);
            String string = mail.getSubject();
            String[] stringArray3 = new String[]{mail.getReceiverAddresses()};
            if (mail.getCopyToAddresses() == null) {
                stringArray2 = null;
            } else {
                String[] stringArray4 = new String[1];
                stringArray2 = stringArray4;
                stringArray4[0] = mail.getCopyToAddresses();
            }
            if (mail.getBcCAddresses() == null) {
                stringArray = null;
            } else {
                String[] stringArray5 = new String[1];
                stringArray = stringArray5;
                stringArray5[0] = mail.getBcCAddresses();
            }
            eu.send(string, stringArray3, stringArray2, stringArray, mail.getContent(), new String[]{mail.getFileIds()});
        } else {
            String[] stringArray;
            String[] stringArray6;
            String string = mail.getSubject();
            String[] stringArray7 = new String[]{mail.getReceiverAddresses()};
            if (mail.getCopyToAddresses() == null) {
                stringArray6 = null;
            } else {
                String[] stringArray8 = new String[1];
                stringArray6 = stringArray8;
                stringArray8[0] = mail.getCopyToAddresses();
            }
            if (mail.getBcCAddresses() == null) {
                stringArray = null;
            } else {
                String[] stringArray9 = new String[1];
                stringArray = stringArray9;
                stringArray9[0] = mail.getBcCAddresses();
            }
            eu.send(string, stringArray7, stringArray6, stringArray, mail.getContent());
        }
    }

    @Override
    public void isRead(String id) {
        ((MailDao)this.baseMapper).isRead(id);
    }
}

