/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.mail.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.file.util.AppFileUtil;
import com.artfess.mail.model.MailAttachment;
import com.artfess.mail.persistence.dao.MailAttachmentDao;
import com.artfess.mail.persistence.manager.MailAttachmentManager;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="mailAttachmentManager")
public class MailAttachmentManagerImpl
extends BaseManagerImpl<MailAttachmentDao, MailAttachment>
implements MailAttachmentManager {
    @Resource
    FileManager fileManager;

    @Override
    public List<MailAttachment> getByMailId(String mailId) {
        return ((MailAttachmentDao)this.baseMapper).getByMailId(mailId);
    }

    @Override
    public void updateFilePath(String fileName, String mailId, String filePath) {
        ((MailAttachmentDao)this.baseMapper).updateFilePath(fileName, mailId, filePath);
    }

    @Override
    public List<MailAttachment> getByOutMailFileIds(String fileIds) throws Exception {
        ArrayList<MailAttachment> result = new ArrayList<MailAttachment>();
        if (StringUtil.isEmpty((String)fileIds)) {
            return result;
        }
        JsonNode jsonNode = JsonUtil.toJsonNode((String)fileIds);
        for (Object obj : jsonNode) {
            ObjectNode json = (ObjectNode)obj;
            String id = json.get("id").textValue();
            DefaultFile file = (DefaultFile)this.fileManager.get((Serializable)((Object)id));
            String filePath = AppFileUtil.getBasePath() + File.separator + file.getFilePath();
            MailAttachment attachment = new MailAttachment();
            attachment.setId(id);
            attachment.setFileName(json.get("name").textValue());
            attachment.setFilePath(filePath);
            result.add(attachment);
        }
        return result;
    }

    @Override
    public void delByMailId(String mailId) {
        ((MailAttachmentDao)this.baseMapper).delByMailId(mailId);
    }
}

