/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.workflow.runtime.script;

import com.artfess.base.feign.UCFeignService;
import com.artfess.base.groovy.IUserScript;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.model.identity.DefaultBpmIdentity;
import com.artfess.uc.api.constant.GroupTypeConstant;
import com.artfess.uc.api.impl.model.UserFacade;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IParamService;
import com.artfess.uc.api.service.IUserGroupService;
import com.artfess.uc.api.service.IUserService;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BpmUserScript
implements IUserScript {
    @Resource
    IUserService userService;
    @Resource
    IUserGroupService userGroupService;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    IParamService paramService;

    private Set<BpmIdentity> convertUserList(List<IUser> list) {
        LinkedHashSet<BpmIdentity> identitys = new LinkedHashSet<BpmIdentity>();
        for (IUser iUser : list) {
            if (!BeanUtils.isNotEmpty((Object)iUser) || !BeanUtils.isNotEmpty((Object)iUser.getStatus()) || iUser.getStatus() != 1) continue;
            DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
            bpmIdentity.setId(iUser.getUserId());
            bpmIdentity.setName(iUser.getFullname());
            bpmIdentity.setType("user");
            identitys.add((BpmIdentity)bpmIdentity);
        }
        return identitys;
    }

    public Set<BpmIdentity> getListUserByRoleId(String roleCode) {
        IGroup role = this.userGroupService.getGroupByIdOrCode(GroupTypeConstant.ROLE.key(), roleCode);
        List list = this.userService.getUserListByGroup(GroupTypeConstant.ROLE.key(), role.getGroupId());
        return this.convertUserList(list);
    }

    public Set<BpmIdentity> getListUserByRelCode(String relCode) {
        ArrayNode array = this.ucFeignService.getUserByPost(relCode);
        ArrayList<IUser> list = new ArrayList<IUser>();
        if (BeanUtils.isNotEmpty((Object)array)) {
            for (Object node : array) {
                try {
                    ObjectNode obj = (ObjectNode)JsonUtil.toJsonNode(node);
                    UserFacade user = new UserFacade();
                    user.setId(obj.get("id").asText());
                    user.setUserId(obj.get("id").asText());
                    user.setAccount(obj.get("account").asText());
                    user.setFullname(obj.get("fullname").asText());
                    user.setStatus(Integer.valueOf(BeanUtils.isNotEmpty((Object)obj.get("status")) ? obj.get("status").asInt() : 0));
                    list.add((IUser)user);
                }
                catch (IOException iOException) {}
            }
        }
        return this.convertUserList(list);
    }

    public Set<BpmIdentity> getListUserByParentOrgRoleCode(String roleCode) {
        IGroup role = this.userGroupService.getGroupByIdOrCode(GroupTypeConstant.ROLE.key(), roleCode);
        List list = this.userService.getUserListByGroup(GroupTypeConstant.ROLE.key(), role.getGroupId());
        return this.convertUserList(list);
    }

    public Set<BpmIdentity> getUserByOrgParamsAlias(String alias) {
        ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
        String userId = (String)taskCmd.getVariables().get("startUser");
        ObjectNode org = this.ucFeignService.getMainGroup(userId);
        if (org == null) {
            return new LinkedHashSet<BpmIdentity>();
        }
        String value = this.paramService.getParamByGroup(org.get("groupId").asText(), alias) + "";
        ArrayList<IUser> list = new ArrayList<IUser>();
        IUser iUser = this.userService.getUserById(value);
        list.add(iUser);
        Set<BpmIdentity> set = this.convertUserList(list);
        return set;
    }
}

