/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.workflow.runtime.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.cmd.BaseActionCmd;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.helper.identity.BpmIdentityExtractService;
import com.artfess.bpm.api.model.form.FormType;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.model.process.def.BpmVariableDef;
import com.artfess.bpm.api.model.process.def.NodeProperties;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.Button;
import com.artfess.bpm.api.model.process.task.BpmTask;
import com.artfess.bpm.api.service.BpmAgentService;
import com.artfess.bpm.api.service.BpmFormService;
import com.artfess.bpm.api.service.BpmIdentityService;
import com.artfess.bpm.api.service.BpmInstService;
import com.artfess.bpm.api.service.BpmTaskActionService;
import com.artfess.bpm.api.service.BpmTaskService;
import com.artfess.bpm.defxml.entity.ext.DecideType;
import com.artfess.bpm.engine.form.BpmFormFactory;
import com.artfess.bpm.model.form.FormModel;
import com.artfess.bpm.model.identity.DefaultBpmIdentity;
import com.artfess.bpm.natapi.task.NatTaskService;
import com.artfess.bpm.persistence.manager.BpmBusLinkManager;
import com.artfess.bpm.persistence.manager.BpmCheckOpinionManager;
import com.artfess.bpm.persistence.manager.BpmCommuReceiverManager;
import com.artfess.bpm.persistence.manager.BpmDefActManager;
import com.artfess.bpm.persistence.manager.BpmDefAuthorizeManager;
import com.artfess.bpm.persistence.manager.BpmDefUserManager;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.manager.BpmInstFormManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.manager.BpmSaveOpinionManager;
import com.artfess.bpm.persistence.manager.BpmTaskCandidateManager;
import com.artfess.bpm.persistence.manager.BpmTaskCommuManager;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.bpm.persistence.manager.BpmTaskNoticeDoneManager;
import com.artfess.bpm.persistence.manager.BpmTaskNoticeManager;
import com.artfess.bpm.persistence.model.BpmDefAct;
import com.artfess.bpm.persistence.model.BpmDefUser;
import com.artfess.bpm.persistence.model.BpmSaveOpinion;
import com.artfess.bpm.persistence.model.BpmTaskCommu;
import com.artfess.bpm.persistence.model.BpmTaskNotice;
import com.artfess.bpm.persistence.model.BpmTaskNoticeDone;
import com.artfess.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.bpm.persistence.model.DefaultBpmTaskCandidate;
import com.artfess.bpm.persistence.model.DefaultBpmTaskTurn;
import com.artfess.bpm.persistence.util.ServiceUtil;
import com.artfess.bpm.util.BpmUtil;
import com.artfess.bpm.util.MessageUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.artfess.workflow.runtime.manager.BpmTaskTransManager;
import com.artfess.workflow.runtime.manager.BpmTaskTransRecordManager;
import com.artfess.workflow.runtime.manager.IFlowManager;
import com.artfess.workflow.runtime.manager.IProcessManager;
import com.artfess.workflow.runtime.manager.TaskTransService;
import com.artfess.workflow.runtime.model.BpmTaskTransRecord;
import com.artfess.workflow.runtime.params.AssignParamObject;
import com.artfess.workflow.runtime.params.BpmNodeDefVo;
import com.artfess.workflow.runtime.params.BpmTaskResult;
import com.artfess.workflow.runtime.params.CommunicateParamObject;
import com.artfess.workflow.runtime.params.DoNextParamObject;
import com.artfess.workflow.runtime.params.IsAllowAddSignObject;
import com.artfess.workflow.runtime.params.ModifyExecutorsParamObject;
import com.artfess.workflow.runtime.params.TaskApproveLineParam;
import com.artfess.workflow.runtime.params.TaskCommuVo;
import com.artfess.workflow.runtime.params.TaskDetailVo;
import com.artfess.workflow.runtime.params.TaskDoNextVo;
import com.artfess.workflow.runtime.params.TaskGetVo;
import com.artfess.workflow.runtime.params.TaskToAgreeVo;
import com.artfess.workflow.runtime.params.TaskToRejectVo;
import com.artfess.workflow.runtime.params.TaskTransParamObject;
import com.artfess.workflow.runtime.params.TaskjImageVo;
import com.artfess.workflow.runtime.params.WithDrawParam;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/runtime/task/v1/"})
@Api(tags={"\u6d41\u7a0b\u4efb\u52a1"})
@ApiGroup(group={"group_bpm"})
public class TaskController
extends BaseController<BpmTaskManager, DefaultBpmTask> {
    @Resource
    IFlowManager iFlowService;
    @Resource
    NatTaskService natTaskService;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    IUserService userService;
    @Resource
    IProcessManager iProcessService;
    @Resource
    BpmTaskTransRecordManager taskTransRecordManager;
    @Resource
    BpmTaskCommuManager bpmTaskCommuManager;
    @Resource
    BpmInstService bpmInstService;
    @Resource
    BpmDefAuthorizeManager bpmDefAuthorizeManager;
    @Resource
    BpmCommuReceiverManager bpmCommuReceiverManager;
    @Resource
    BpmTaskActionService bpmTaskActionService;
    @Resource
    BpmAgentService bpmAgentService;
    @Resource
    TaskTransService taskTransService;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    IUserService ius;
    @Resource
    BpmTaskTransManager bpmTaskTransManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BaseContext baseContext;
    @Resource
    BpmSaveOpinionManager bpmSaveOpinionManager;
    @Resource
    BpmIdentityService bpmIdentityService;
    @Resource
    BpmIdentityExtractService bpmIdentityExtractService;
    @Resource
    BpmBusLinkManager bpmBusLinkManager;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    BpmDefUserManager bpmDefUserManager;
    @Resource
    BpmDefActManager bpmDefActManager;
    @Resource
    BpmInstFormManager bpmInstFormManager;

    @RequestMapping(value={"getBpmTaskNoticeById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4e3b\u952eID\u83b7\u53d6\u5f85\u529e\u77e5\u4f1a\u4efb\u52a1\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636e\u4e3b\u952eID\u83b7\u53d6\u5f85\u529e\u77e5\u4f1a\u4efb\u52a1\u4fe1\u606f")
    public BpmTaskNotice getBpmTaskNoticeById(@ApiParam(required=true, name="id", value="\u5f85\u529e\u77e5\u4f1a\u4efb\u52a1\u4e3b\u952eId") String id) {
        BpmTaskNoticeManager noticeManager = (BpmTaskNoticeManager)AppUtil.getBean(BpmTaskNoticeManager.class);
        BpmTaskNotice notice = (BpmTaskNotice)noticeManager.get((Serializable)((Object)id));
        return notice;
    }

    @RequestMapping(value={"getBpmTaskNoticeDoneById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4e3b\u952eID\u83b7\u53d6\u5df2\u529e\u77e5\u4f1a\u4efb\u52a1\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636e\u4e3b\u952eID\u83b7\u53d6\u5df2\u529e\u77e5\u4f1a\u4efb\u52a1\u4fe1\u606f")
    public BpmTaskNoticeDone getBpmTaskNoticeDoneById(@ApiParam(required=true, name="id", value="\u5df2\u529e\u77e5\u4f1a\u4efb\u52a1\u4e3b\u952eId") String id) {
        BpmTaskNoticeDoneManager noticeDoneManager = (BpmTaskNoticeDoneManager)AppUtil.getBean(BpmTaskNoticeDoneManager.class);
        BpmTaskNoticeDone noticeDone = (BpmTaskNoticeDone)noticeDoneManager.get((Serializable)((Object)id));
        return noticeDone;
    }

    @RequestMapping(value={"getTaskKeyByTaskId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1Id\u83b7\u53d6\u5ba1\u6279\u5386\u53f2\u6570\u636e\uff08\u53ea\u6709\u4e00\u6761\uff09", httpMethod="GET", notes="\u6839\u636e\u4efb\u52a1Id\u83b7\u53d6\u5ba1\u6279\u5386\u53f2\u6570\u636e\uff08\u53ea\u6709\u4e00\u6761\uff09")
    public DefaultBpmCheckOpinion getTaskKeyByTaskId(@ApiParam(required=true, name="taskId", value="\u4efb\u52a1Id") String taskId) {
        DefaultBpmCheckOpinion defaultBpmCheckOpinion = this.bpmCheckOpinionManager.getTaskKeyByTaskId(taskId);
        return defaultBpmCheckOpinion;
    }

    @RequestMapping(value={"getTaskKeyByNodeId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1\u8282\u70b9ID\u548c\u6d41\u7a0b\u5b9e\u4f8bID\u83b7\u53d6\u5ba1\u6279\u5386\u53f2\u6570\u636e\uff08\u53ea\u6709\u4e00\u6761\uff09", httpMethod="GET", notes="\u6839\u636e\u4efb\u52a1\u8282\u70b9ID\u548c\u6d41\u7a0b\u5b9e\u4f8bID\u83b7\u53d6\u5ba1\u6279\u5386\u53f2\u6570\u636e\uff08\u53ea\u6709\u4e00\u6761\uff09")
    public DefaultBpmCheckOpinion getTaskKeyByNodeId(@ApiParam(required=true, name="nodeId", value="\u4efb\u52a1\u8282\u70b9Id") String nodeId, @ApiParam(required=true, name="instId", value="\u6d41\u7a0b\u5b9e\u4f8bId") String instId) {
        DefaultBpmCheckOpinion defaultBpmCheckOpinion = this.bpmCheckOpinionManager.getTaskKeyByNodeId(nodeId, instId);
        return defaultBpmCheckOpinion;
    }

    @RequestMapping(value={"retrieveBpmTask"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u56de\u59d4\u6258/\u8f6c\u529e\u6d41\u7a0b", httpMethod="GET", notes="\u53d6\u56de\u59d4\u6258/\u8f6c\u529e\u6d41\u7a0b\u6d41\u7a0b")
    public CommonResult<String> retrieveBpmTask(@ApiParam(required=true, name="taskId", value="\u4efb\u52a1taskId") String taskId) {
        IUser user = ContextUtil.getCurrentUser();
        return this.bpmTaskManager.retrieveBpmTask(user, taskId);
    }

    @RequestMapping(value={"getLeaderTodoList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u9886\u5bfc\u7684\u5f85\u529e\u4e8b\u5b9c", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u9886\u5bfc\u7684\u5f85\u529e\u4e8b\u5b9c")
    public PageList<DefaultBpmTask> getLeaderTodoList(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        if (BeanUtils.isNotEmpty((Object)queryFilter.getQuerys()) && queryFilter.getQuerys().size() > 0) {
            ArrayList<QueryField> fields = new ArrayList<QueryField>();
            for (QueryField field : queryFilter.getQuerys()) {
                if ("urgentStateValue".equals(field.getProperty())) {
                    field.setGroup("groupUrgent");
                    field.setRelation(FieldRelation.AND);
                    QueryFilter defFilter = QueryFilter.build();
                    defFilter.addFilter("IS_MAIN_", (Object)"Y", QueryOP.EQUAL);
                    defFilter.addFilter("SHOW_URGENT_STATE_", (Object)"1", QueryOP.EQUAL);
                    PageList query = this.bpmDefinitionManager.query(defFilter);
                    ArrayList<String> defKeys = new ArrayList<String>();
                    defKeys.add("-1");
                    if (BeanUtils.isNotEmpty((Object)query.getRows())) {
                        for (DefaultBpmDefinition def : query.getRows()) {
                            defKeys.add(def.getDefKey());
                        }
                    }
                    fields.add(new QueryField("PROC_DEF_KEY_", defKeys, QueryOP.IN, FieldRelation.AND, "groupUrgent"));
                    continue;
                }
                fields.add(field);
            }
            queryFilter.setQuerys(fields);
        }
        queryFilter.setGroupRelation(FieldRelation.AND);
        PageList<DefaultBpmTask> pageList = this.iFlowService.getLeaderTodoList(this.baseContext.getCurrentUserAccout(), queryFilter);
        return pageList;
    }

    @RequestMapping(value={"getTodoList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7684\u5f85\u529e\u4e8b\u5b9c", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u7684\u5f85\u529e\u4e8b\u5b9c")
    public PageList<DefaultBpmTask> getTodoList(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter<DefaultBpmTask> queryFilter) throws Exception {
        if (BeanUtils.isNotEmpty((Object)queryFilter.getQuerys()) && queryFilter.getQuerys().size() > 0) {
            ArrayList<QueryField> fields = new ArrayList<QueryField>();
            for (QueryField field : queryFilter.getQuerys()) {
                if ("urgentStateValue".equals(field.getProperty())) {
                    field.setGroup("groupUrgent");
                    field.setRelation(FieldRelation.AND);
                    QueryFilter defFilter = QueryFilter.build();
                    defFilter.addFilter("IS_MAIN_", (Object)"Y", QueryOP.EQUAL);
                    defFilter.addFilter("SHOW_URGENT_STATE_", (Object)"1", QueryOP.EQUAL);
                    PageList query = this.bpmDefinitionManager.query(defFilter);
                    ArrayList<String> defKeys = new ArrayList<String>();
                    defKeys.add("-1");
                    if (BeanUtils.isNotEmpty((Object)query.getRows())) {
                        for (DefaultBpmDefinition def : query.getRows()) {
                            defKeys.add(def.getDefKey());
                        }
                    }
                    fields.add(new QueryField("PROC_DEF_KEY_", defKeys, QueryOP.IN, FieldRelation.AND, "groupUrgent"));
                    continue;
                }
                fields.add(field);
            }
            queryFilter.setQuerys(fields);
        }
        queryFilter.setGroupRelation(FieldRelation.AND);
        PageList<DefaultBpmTask> pageList = this.iFlowService.getTodoList(this.baseContext.getCurrentUserAccout(), queryFilter).get();
        return pageList;
    }

    @PostMapping(value={"getTodoCount"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f85\u529e\u6570\u76ee", httpMethod="POST", notes="\u83b7\u53d6\u5f85\u529e\u6570\u76ee")
    public List<Map<String, Object>> getTodoCount(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.bpmTaskManager.getCountByUserId(this.baseContext.getCurrentUserId());
    }

    @RequestMapping(value={"getMobileTodoList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u624b\u673a\u7684\u5f85\u529e\u4e8b\u5b9c", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u624b\u673a\u7684\u5f85\u529e\u4e8b\u5b9c")
    public PageList<DefaultBpmTask> getMobileTodoList(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        queryFilter.addFilter("bt.SUPPORT_MOBILE_", (Object)1, QueryOP.EQUAL, FieldRelation.AND, "m");
        CompletableFuture<PageList<DefaultBpmTask>> result = this.iFlowService.getTodoList(this.baseContext.getCurrentUserAccout(), (QueryFilter<DefaultBpmTask>)queryFilter);
        return result.get();
    }

    @RequestMapping(value={"getDelegate"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u8f6c\u529e\u4ee3\u7406\u4e8b\u5b9c", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u8f6c\u529e\u4ee3\u7406\u4e8b\u5b9c")
    public PageList<DefaultBpmTaskTurn> getMyDelegate(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.iFlowService.getDelegate(this.baseContext.getCurrentUserAccout(), queryFilter);
    }

    @PostMapping(value={"getDelegateCount"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u8f6c\u529e\u4ee3\u7406\u4e8b\u5b9c\u6570\u91cf", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u8f6c\u529e\u4ee3\u7406\u4e8b\u5b9c")
    public List<Map<String, Object>> getMyDelegateCount(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.iFlowService.getDelegateCount(this.baseContext.getCurrentUserAccout(), queryFilter);
    }

    @RequestMapping(value={"getMobileDelegate"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u624b\u673a\u7528\u6237\u8f6c\u529e\u4ee3\u7406\u4e8b\u5b9c", httpMethod="POST", notes="\u83b7\u53d6\u624b\u673a\u7528\u6237\u8f6c\u529e\u4ee3\u7406\u4e8b\u5b9c")
    public PageList<DefaultBpmTaskTurn> getMobileDelegate(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.iFlowService.getDelegate(this.baseContext.getCurrentUserAccout(), queryFilter);
    }

    @RequestMapping(value={"getMyTrans"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6211\u7684\u6d41\u8f6c\u4efb\u52a1", httpMethod="POST", notes="\u6211\u7684\u6d41\u8f6c\u4efb\u52a1")
    public PageList<BpmTaskTransRecord> getMyTrans(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter, HttpServletResponse response) throws Exception {
        return this.iFlowService.getMyTrans(this.baseContext.getCurrentUserAccout(), queryFilter);
    }

    @RequestMapping(value={"delegate"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4efb\u52a1\u8f6c\u529e", httpMethod="POST", notes="\u4efb\u52a1\u8f6c\u529e")
    public CommonResult<String> delegate(@ApiParam(required=true, name="assignParamObject", value="\u4efb\u52a1\u8f6c\u529e\u53c2\u6570") @RequestBody AssignParamObject assignParamObject, HttpServletResponse response, @ApiParam(name="leaderId", value="\u9886\u5bfcid", required=false) @RequestParam Optional<String> leaderId) throws Exception {
        BpmUtil.checkDefForbidStatus((String)"", (String)"", (String)assignParamObject.getTaskId());
        BaseActionCmd cmd = new BaseActionCmd();
        cmd.setFormKey(assignParamObject.getFormKey());
        ContextThreadUtil.setActionCmd((ActionCmd)cmd);
        if (StringUtil.isNotZeroEmpty((String)leaderId.orElse(""))) {
            ThreadMsgUtil.addMapMsg((String)"leaderId", (String)leaderId.get());
            if (leaderId.get().equals(assignParamObject.getUserId())) {
                throw new RuntimeException("\u4ee3\u9886\u5bfc\u8f6c\u529e\u65f6\u4e0d\u80fd\u518d\u8f6c\u529e\u7ed9\u9886\u5bfc\uff01");
            }
        }
        return this.iFlowService.delegate(assignParamObject);
    }

    @RequestMapping(value={"doCancelTurn"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u6d88\u4ee3\u7406\u6216\u8f6c\u529e", httpMethod="POST", notes="\u53d6\u6d88\u4ee3\u7406\u6216\u8f6c\u529e")
    public CommonResult<String> doCancelTurn(@ApiParam(required=true, name="assignParamObject", value="\u53d6\u6d88\u4ee3\u7406\u6216\u8f6c\u529e") @RequestBody AssignParamObject assignParamObject, HttpServletResponse response) throws Exception {
        try {
            this.bpmAgentService.retrieveTask(assignParamObject.getTaskId(), assignParamObject.getMessageType(), assignParamObject.getOpinion());
        }
        catch (Exception e) {
            return new CommonResult(false, "\u53d6\u6d88\u4efb\u52a1\u5931\u8d25\uff01" + e.getMessage());
        }
        return new CommonResult(true, "\u53d6\u6d88\u6d41\u8f6c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"doRevokeTrans"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5904\u7406\u64a4\u9500\u6d41\u8f6c\u4efb\u52a1", httpMethod="POST", notes="\u5904\u7406\u64a4\u9500\u6d41\u8f6c\u4efb\u52a1")
    public CommonResult<String> doRevokeTrans(@ApiParam(required=true, name="withDrawParam", value="\u64a4\u9500\u6d41\u8f6c\u4efb\u52a1\u53c2\u6570") @RequestBody WithDrawParam withDrawParam, HttpServletResponse response) throws Exception {
        try {
            return this.iFlowService.withDraw(withDrawParam);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u6d41\u8f6c\u4efb\u52a1\u53d6\u56de\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    @RequestMapping(value={"communicate"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4efb\u52a1\u6c9f\u901a", httpMethod="POST", notes="\u4efb\u52a1\u6c9f\u901a")
    public CommonResult<String> communicate(@ApiParam(required=true, name="communicateParamObject", value="\u4efb\u52a1\u6c9f\u901a\u53c2\u6570") @RequestBody CommunicateParamObject communicateParamObject) throws Exception {
        return this.iFlowService.communicate(communicateParamObject);
    }

    @RequestMapping(value={"taskSignUsers"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u52a0\u7b7e", httpMethod="POST", notes="\u52a0\u7b7e")
    public CommonResult<String> taskSignUsers(@ApiParam(required=true, name="signParamObject", value="\u4efb\u52a1\u52a0\u7b7e\u53c2\u6570") @RequestBody AssignParamObject signParamObject, HttpServletResponse response) throws Exception {
        return this.iFlowService.taskSignUsers(signParamObject);
    }

    @RequestMapping(value={"taskCustomSignUsers"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u7b7e\u7f72\u4eba\u5458", httpMethod="POST", notes="\u6dfb\u52a0\u7b7e\u7f72\u4eba\u5458")
    public CommonResult<String> taskCustomSignUsers(@ApiParam(required=true, name="signParamObject", value="\u4efb\u52a1\u52a0\u7b7e\u53c2\u6570") @RequestBody AssignParamObject signParamObject, HttpServletResponse response) throws Exception {
        return this.iFlowService.taskCustomSignUsers(signParamObject);
    }

    @GetMapping(value={"getTaskVar"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1taskId, \u83b7\u53d6\u6d41\u7a0b\u53d8\u91cf(\u5168\u5c40\u548c\u8282\u70b9)", httpMethod="GET", notes="\u6839\u636e\u4efb\u52a1id, \u83b7\u53d6\u6d41\u7a0b\u53d8\u91cf(\u5168\u5c40\u548c\u8282\u70b9)")
    public Map<String, Object> getTaskVar(@ApiParam(name="taskId", required=true) @RequestParam String taskId) {
        return this.natTaskService.getVariables(taskId);
    }

    @GetMapping(value={"getTaskVarLocal"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1taskId,\u83b7\u53d6\u6d41\u7a0b\u4efb\u52a1\u8282\u70b9\u7684\u53d8\u91cf", httpMethod="GET", notes="\u6839\u636e\u4efb\u52a1id,\u83b7\u53d6\u6d41\u7a0b\u4efb\u52a1\u8282\u70b9\u7684\u53d8\u91cf")
    public Map<String, Object> getTaskVarLocal(@ApiParam(name="taskId", required=true) @RequestParam String taskId) {
        return this.natTaskService.getVariablesLocal(taskId);
    }

    @GetMapping(value={"getWorkflowVar"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49ID\u6216\u6d41\u7a0b\u5b9a\u4e49KEY\u83b7\u53d6\u6d41\u7a0b\u53d8\u91cf", httpMethod="GET", notes="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49ID\u6216\u6d41\u7a0b\u5b9a\u4e49KEY\u83b7\u53d6\u6d41\u7a0b\u53d8\u91cf")
    public List<BpmVariableDef> getWorkflowVar(@ApiParam(name="json", required=true) @RequestParam String json) throws Exception {
        return this.iFlowService.getWorkflowVar(json);
    }

    @PostMapping(value={"setTaskVar"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1taskId,\u8bbe\u7f6e\u6d41\u7a0b\u53d8\u91cf", httpMethod="POST", notes="\u6839\u636e\u4efb\u52a1taskId,\u8bbe\u7f6e\u6d41\u7a0b\u53d8\u91cf")
    public CommonResult<String> setTaskVar(@ApiParam(name="taskId", required=true) @RequestParam String taskId, @ApiParam(name="variables", required=true) @RequestBody Map<String, Object> variables) throws Exception {
        return this.iProcessService.setTaskVar(taskId, variables);
    }

    @PostMapping(value={"setTaskVarLocal"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1taskId,\u8bbe\u7f6e\u4efb\u52a1\u8282\u70b9\u672c\u5730\u53d8\u91cf", httpMethod="POST", notes="\u6839\u636e\u4efb\u52a1taskId,\u8bbe\u7f6e\u6d41\u7a0b\u53d8\u91cf")
    public CommonResult<String> setTaskVarLocal(@ApiParam(name="taskId", required=true) @RequestParam String taskId, @ApiParam(name="variables", required=true) @RequestBody Map<String, Object> variables) throws Exception {
        return this.iProcessService.setTaskVarLocal(taskId, variables);
    }

    @PostMapping(value={"isAllowAddSign"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u5224\u65ad\u7528\u6237\u662f\u5426\u6709\u6dfb\u52a0\u4f1a\u7b7e\u6743\u9650", httpMethod="POST", notes="\u5224\u65ad\u7528\u6237\u662f\u5426\u6709\u6dfb\u52a0\u4f1a\u7b7e\u6743\u9650")
    public Boolean isAllowAddSign(@RequestBody @ApiParam(name="isAllowAddSignObject", required=true) IsAllowAddSignObject isAllowAddSignObject) throws Exception {
        return this.iFlowService.isAllowAddSign(isAllowAddSignObject);
    }

    @RequestMapping(value={"setTaskExecutors"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539\u4efb\u52a1\u6267\u884c\u4eba", httpMethod="POST", notes="\u4fee\u6539\u4efb\u52a1\u6267\u884c\u4eba")
    public CommonResult<String> setTaskExecutors(@ApiParam(required=true, name="modifyExecutorsParamObject", value="\u4fee\u6539\u6267\u884c\u4eba\u5bf9\u8c61") @RequestBody ModifyExecutorsParamObject modifyExecutorsParamObject) throws Exception {
        return this.iFlowService.setTaskExecutors(modifyExecutorsParamObject);
    }

    @RequestMapping(value={"taskToTrans"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6d41\u8f6c\u4fe1\u606f\uff08\u589e\u52a0\u6d41\u8f6c\uff09", httpMethod="POST", notes="\u4fdd\u5b58\u6d41\u8f6c\u4fe1\u606f\uff08\u589e\u52a0\u6d41\u8f6c\uff09")
    public CommonResult<String> taskToTrans(@ApiParam(name="taskTransParamObject", value="\u6d41\u8f6c\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody TaskTransParamObject taskTransParamObject, @ApiParam(name="leaderId", value="\u9886\u5bfcid", required=false) @RequestParam Optional<String> leaderId) throws Exception {
        BpmUtil.checkDefForbidStatus((String)"", (String)"", (String)taskTransParamObject.getTaskId());
        if (StringUtil.isNotZeroEmpty((String)leaderId.orElse(""))) {
            ThreadMsgUtil.addMapMsg((String)"leaderId", (String)leaderId.get());
        }
        return this.iFlowService.taskToTrans(taskTransParamObject);
    }

    @RequestMapping(value={"userTaskToSign"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u666e\u901a\u4efb\u52a1\u52a0\u7b7e\uff08\u6d41\u8f6c\u505a\u7684\uff09", httpMethod="POST", notes="\u666e\u901a\u4efb\u52a1\u52a0\u7b7e")
    public CommonResult<String> userTaskToSign(@ApiParam(name="taskTransParamObject", value="\u52a0\u7b7e\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody TaskTransParamObject taskTransParamObject, @ApiParam(name="leaderId", value="\u9886\u5bfcid", required=false) @RequestParam Optional<String> leaderId) throws Exception {
        BpmUtil.checkDefForbidStatus((String)"", (String)"", (String)taskTransParamObject.getTaskId());
        if (StringUtil.isNotZeroEmpty((String)leaderId.orElse(""))) {
            ThreadMsgUtil.addMapMsg((String)"leaderId", (String)leaderId.get());
        }
        return this.iFlowService.userTaskToSign(taskTransParamObject);
    }

    @RequestMapping(value={"taskToSignSequence"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u987a\u5e8f\u7b7e\u7f72\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u987a\u5e8f\u7b7e\u7f72\u4fe1\u606f")
    public CommonResult<String> taskToSignSequence(@ApiParam(name="taskTransParamObject", value="\u6d41\u8f6c\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody TaskTransParamObject taskTransParamObject, @ApiParam(name="leaderId", value="\u9886\u5bfcid", required=false) @RequestParam Optional<String> leaderId) throws Exception {
        BpmUtil.checkDefForbidStatus((String)"", (String)"", (String)taskTransParamObject.getTaskId());
        if (StringUtil.isNotZeroEmpty((String)leaderId.orElse(""))) {
            ThreadMsgUtil.addMapMsg((String)"leaderId", (String)leaderId.get());
        }
        return this.iFlowService.taskToSignSequence(taskTransParamObject);
    }

    @RequestMapping(value={"taskToSignLine"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u5e76\u884c\u7b7e\u7f72\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u5e76\u884c\u7b7e\u7f72\u4fe1\u606f")
    public CommonResult<String> taskToSignLine(@ApiParam(name="taskTransParamObject", value="\u6d41\u8f6c\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody TaskTransParamObject taskTransParamObject, @ApiParam(name="leaderId", value="\u9886\u5bfcid", required=false) @RequestParam Optional<String> leaderId) throws Exception {
        if (StringUtil.isNotZeroEmpty((String)leaderId.orElse(""))) {
            ThreadMsgUtil.addMapMsg((String)"leaderId", (String)leaderId.get());
        }
        return this.iFlowService.taskToSignLine(taskTransParamObject);
    }

    @RequestMapping(value={"taskToApproveLine"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u5e76\u884c\u5ba1\u6279\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u5e76\u884c\u5ba1\u6279\u4fe1\u606f")
    public CommonResult<String> taskToApproveLine(@ApiParam(name="taskTransParamObject", value="\u5e76\u884c\u5ba1\u6279\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody TaskApproveLineParam taskApproveLineParam, @ApiParam(name="leaderId", value="\u9886\u5bfcid", required=false) @RequestParam Optional<String> leaderId) throws Exception {
        if (StringUtil.isNotZeroEmpty((String)leaderId.orElse(""))) {
            ThreadMsgUtil.addMapMsg((String)"leaderId", (String)leaderId.get());
        }
        return this.iFlowService.taskToApproveLine(taskApproveLineParam);
    }

    @RequestMapping(value={"getTaskByTaskId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u4efb\u52a1id\u83b7\u53d6\u4efb\u52a1\u5bf9\u8c61", httpMethod="GET", notes="\u901a\u8fc7\u4efb\u52a1id\u83b7\u53d6\u4efb\u52a1\u5bf9\u8c61")
    public BpmTaskResult getTaskByTaskId(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        return this.iProcessService.getTaskByTaskId(taskId);
    }

    @RequestMapping(value={"getTaskNameByTaskId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u4efb\u52a1id\u83b7\u53d6\u4efb\u52a1\u540d\u79f0", httpMethod="GET", notes="\u901a\u8fc7\u4efb\u52a1id\u83b7\u53d6\u4efb\u52a1\u540d\u79f0")
    public String getTaskNameByTaskId(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        return this.iProcessService.getTaskNameByTaskId(taskId);
    }

    @RequestMapping(value={"getTasksByInstId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u5b9e\u4f8bid\u83b7\u53d6\u4efb\u52a1\u5217\u8868", httpMethod="GET", notes="\u901a\u8fc7\u5b9e\u4f8bid\u83b7\u53d6\u4efb\u52a1\u5217\u8868")
    public PageList<DefaultBpmTask> getTasksByInstId(@ApiParam(name="instId", value="\u5b9e\u4f8bid", required=true) @RequestParam String instId) throws Exception {
        return this.iProcessService.getTasksByInstId(instId);
    }

    @RequestMapping(value={"getNextTaskUsers"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1id\u83b7\u53d6\u4e0b\u4e00\u73af\u8282\u5904\u7406\u4eba", notes="\u6839\u636e\u4efb\u52a1id\u83b7\u53d6\u4e0b\u4e00\u73af\u8282\u5904\u7406\u4eba", httpMethod="GET")
    public Map<String, List<BpmIdentity>> getNextTaskUsers(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        return this.iFlowService.getNextTaskUsers(taskId);
    }

    @RequestMapping(value={"getApprovalItems"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1id\u83b7\u53d6\u9884\u5148\u8bbe\u7f6e\u7684\u5ba1\u6279\u7528\u8bed\u5217\u8868", notes="\u6839\u636e\u4efb\u52a1id\u83b7\u53d6\u9884\u5148\u8bbe\u7f6e\u7684\u5ba1\u6279\u7528\u8bed\u5217\u8868", httpMethod="GET")
    public List<String> getApprovalItems(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        return this.iProcessService.getApprovalItems(taskId);
    }

    @RequestMapping(value={"getTaskOutNodes"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u4efb\u52a1id\u83b7\u53d6\u4efb\u52a1\u7684\u540e\u7eed\u8282\u70b9", httpMethod="GET", notes="\u901a\u8fc7\u4efb\u52a1id\u83b7\u53d6\u4efb\u52a1\u7684\u540e\u7eed\u8282\u70b9")
    public List<BpmNodeDefVo> getTaskOutNodes(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        return this.iProcessService.getTaskOutNodes(taskId);
    }

    @GetMapping(value={"getUrlFormByTaskId"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u7684\u5728\u7ebf\u8868\u5355\u5730\u5740", httpMethod="GET", notes="\u83b7\u53d6\u4efb\u52a1\u7684\u5728\u7ebf\u8868\u5355\u5730\u5740")
    public String getUrlFormByTaskId(@ApiParam(name="taskId", required=true) @RequestParam String taskId, @ApiParam(name="formType", required=true, defaultValue="pc") @RequestParam String formType) throws Exception {
        return this.iFlowService.getUrlFormByTaskId(taskId, formType);
    }

    @GetMapping(value={"getInstUrlForm"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u83b7\u53d6\u5b9e\u4f8b\u5728\u7ebf\u8868\u5355", httpMethod="GET", notes="\u83b7\u53d6\u5b9e\u4f8b\u5728\u7ebf\u8868\u5355")
    public String getInstUrlForm(@ApiParam(name="proInstId", required=true) @RequestParam String proInstId, @ApiParam(name="nodeId", required=false) @RequestParam(required=false) String nodeId, @ApiParam(name="formType", required=true, defaultValue="pc") @RequestParam String formType) throws Exception {
        return this.iFlowService.getInstUrlForm(proInstId, nodeId, formType);
    }

    @RequestMapping(value={"taskDoNext"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7ba1\u7406\u5458\u5904\u7406\u4efb\u52a1\u9875\u9762", httpMethod="GET", notes="\u7ba1\u7406\u5458\u5904\u7406\u4efb\u52a1\u9875\u9762")
    public TaskDoNextVo taskDoNext(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        return this.iFlowService.taskDoNext(taskId).get();
    }

    @RequestMapping(value={"taskApprove"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5ba1\u6279\u754c\u9762\u53c2\u6570", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u5ba1\u6279\u754c\u9762\u53c2\u6570")
    public TaskDoNextVo taskApprove(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        return this.iFlowService.taskApprove(taskId);
    }

    @RequestMapping(value={"taskImage"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u67e5\u770b\u4efb\u52a1\u6d41\u7a0b\u56fe\u53c2\u6570", httpMethod="GET", notes="\u83b7\u53d6\u67e5\u770b\u4efb\u52a1\u6d41\u7a0b\u56fe\u754c\u9762\u53c2\u6570")
    public TaskjImageVo taskImage(@ApiParam(name="taskId", value="\u4efb\u52a1id") @RequestParam Optional<String> taskId, @ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id") @RequestParam Optional<String> defId) throws Exception {
        return this.iFlowService.taskImage(taskId.orElse(""), defId.orElse(""));
    }

    @RequestMapping(value={"nodeOpinion"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u4e2d\u6307\u5b9a\u8282\u70b9\u7684\u5ba1\u6279\u610f\u89c1", httpMethod="GET", notes="\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u4e2d\u6307\u5b9a\u8282\u70b9\u7684\u5ba1\u6279\u610f\u89c1")
    public Object nodeOpinion(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam Optional<String> defId, @ApiParam(name="instId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true) @RequestParam Optional<String> instId, @ApiParam(name="nodeId", value="\u4efb\u52a1\u8282\u70b9id\uff0c\u591a\u4e2a\u4ee5\u9017\u53f7\u62fc\u63a5", required=true) @RequestParam String nodeId) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (BeanUtils.isNotEmpty((Object)nodeId)) {
            String[] split;
            for (String id : split = nodeId.split(",")) {
                Object nodeOpinion = this.iFlowService.nodeOpinion(defId.orElse(""), instId.orElse(""), id);
                if (split.length == 1) {
                    return nodeOpinion;
                }
                map.put(id, nodeOpinion);
            }
        }
        return map;
    }

    @RequestMapping(value={"getButtonsBytaskId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1ID\u83b7\u53d6\u5ba1\u6279\u6309\u94ae", httpMethod="GET", notes="\u6839\u636e\u4efb\u52a1ID\u83b7\u53d6\u5ba1\u6279\u6309\u94ae")
    public TaskDetailVo getButtonsBytaskId(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId, @ApiParam(name="leaderId", value="\u4ee3\u4e3a\u5904\u7406\u7684\u9886\u5bfcid", required=true) @RequestParam Optional<String> leaderId) throws Exception {
        TaskDetailVo buttonsBytaskId = this.iFlowService.getButtonsBytaskId(taskId);
        if (BeanUtils.isNotEmpty(buttonsBytaskId.getButtons())) {
            Iterator<Button> iterator = buttonsBytaskId.getButtons().iterator();
            while (iterator.hasNext()) {
                Button button = iterator.next();
                String btnName = button.getAlias();
                if (!StringUtil.isNotZeroEmpty((String)leaderId.orElse("")) || btnName.equals("agree") || btnName.equals("reject") || btnName.equals("lockUnlock")) continue;
                iterator.remove();
            }
            return buttonsBytaskId;
        }
        return new TaskDetailVo();
    }

    @RequestMapping(value={"taskDetail"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u7684\u8be6\u60c5", httpMethod="GET", notes="\u83b7\u53d6\u4efb\u52a1\u7684\u8be6\u60c5")
    public TaskDetailVo taskDetail(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId, @ApiParam(name="reqParams", value="\u8bf7\u6c42\u53c2\u6570", required=true) @RequestParam String reqParams, @ApiParam(name="leaderId", value="\u4ee3\u4e3a\u5904\u7406\u7684\u9886\u5bfcid", required=false) @RequestParam Optional<String> leaderId) throws Exception {
        return this.iFlowService.taskDetail(taskId, reqParams, FormType.PC, leaderId.orElse("")).get();
    }

    @RequestMapping(value={"taskDetailBo"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u7684\u8be6\u60c5", httpMethod="GET", notes="\u83b7\u53d6\u4efb\u52a1\u7684\u8be6\u60c5")
    public TaskDetailVo taskDetailBo(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId, @ApiParam(name="reqParams", value="\u8bf7\u6c42\u53c2\u6570", required=true) @RequestParam String reqParams, @ApiParam(name="leaderId", value="\u4ee3\u4e3a\u5904\u7406\u7684\u9886\u5bfcid", required=false) @RequestParam Optional<String> leaderId) throws Exception {
        return this.iFlowService.taskDetail(taskId, reqParams, FormType.PC, leaderId.orElse("").equals("0") ? "" : leaderId.orElse("")).get();
    }

    @RequestMapping(value={"taskMobileDetail"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u624b\u673a\u4efb\u52a1\u7684\u8be6\u60c5", httpMethod="GET", notes="\u83b7\u53d6\u624b\u673a\u4efb\u52a1\u7684\u8be6\u60c5")
    public TaskDetailVo taskMobileDetail(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId, @ApiParam(name="reqParams", value="\u8bf7\u6c42\u53c2\u6570", required=true) @RequestParam String reqParams) throws Exception {
        if (!this.isAuth(taskId, null)) {
            throw new RuntimeException("\u60a8\u6ca1\u6709\u5904\u7406\u8be5\u4efb\u52a1\u7684\u6743\u9650\uff01");
        }
        return this.iFlowService.taskDetailMobile(taskId, reqParams, FormType.MOBILE).get();
    }

    @RequestMapping(value={"getMyTasks"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6211\u7684\u5f85\u529e\uff0c\u5e76\u4e14\u8fdb\u884c\u6761\u4ef6\u8fc7\u6ee4", httpMethod="GET", notes="\u83b7\u53d6\u6211\u7684\u5f85\u529e\uff0c\u5e76\u4e14\u8fdb\u884c\u6761\u4ef6\u8fc7\u6ee4")
    public PageList<DefaultBpmTask> getMyTasks(@ApiParam(name="account", value="\u7528\u6237\u8d26\u53f7", required=true) @RequestParam String account, @ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        IUser user = ServiceUtil.getUserByAccount((String)account);
        return this.bpmTaskManager.getByUserId(user.getUserId(), queryFilter);
    }

    @RequestMapping(value={"getTaskEnt"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1id\u83b7\u53d6\u5f85\u529e", httpMethod="GET", notes="\u6839\u636e\u4efb\u52a1id\u83b7\u53d6\u5f85\u529e")
    public BpmTask getTaskEnt(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        return (BpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
    }

    @RequestMapping(value={"getTaskVars"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u4e0a\u4e0b\u6587\u6d41\u7a0b\u53d8\u91cf", httpMethod="GET", notes="\u83b7\u53d6\u4efb\u52a1\u4e0a\u4e0b\u6587\u6d41\u7a0b\u53d8\u91cf")
    public Map<String, Object> getTaskVars(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        return this.iFlowService.getTaskVars(taskId, null);
    }

    @RequestMapping(value={"complete"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5904\u7406\u4efb\u52a1", httpMethod="POST", notes="\u5904\u7406\u4efb\u52a1")
    public CommonResult<String> complete(@ApiParam(name="doNextParamObject", value="\u6d41\u8f6c\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody DoNextParamObject doNextParamObject) throws Exception {
        if (!this.isAuth(doNextParamObject.getTaskId(), doNextParamObject.getAgentLeaderId())) {
            return new CommonResult(false, "\u60a8\u6ca1\u6709\u5904\u7406\u8be5\u4efb\u52a1\u7684\u6743\u9650\uff01");
        }
        try {
            return this.iFlowService.complete(doNextParamObject).get();
        }
        catch (SQLException e) {
            if (StringUtil.hasEmoji((String)doNextParamObject.getOpinion())) {
                return new CommonResult(false, "\u5ba1\u6279\u610f\u89c1\u4e0d\u80fd\u8f93\u5165\u8868\u60c5\uff01");
            }
            throw e;
        }
    }

    @RequestMapping(value={"saveDraft"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u8349\u7a3f", httpMethod="POST", notes="\u4fdd\u5b58\u8349\u7a3f")
    public CommonResult<String> saveDraft(@ApiParam(name="doNextParamObject", value="\u6d41\u8f6c\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody DoNextParamObject doNextParamObject) throws Exception {
        return this.iFlowService.saveDraft(doNextParamObject);
    }

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4efb\u52a1\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u83b7\u53d6\u4efb\u52a1\u5217\u8868")
    public PageList<DefaultBpmTask> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        PageList query;
        IUser user = ContextUtil.getCurrentUser();
        boolean isAdmin = user.isAdmin();
        queryFilter.addParams("isAdmin", (Object)(isAdmin ? 1 : 0));
        if (!isAdmin) {
            this.setNoAuthFilter(queryFilter);
        }
        if (BeanUtils.isEmpty((Object)(query = this.bpmTaskManager.query(queryFilter))) || BeanUtils.isEmpty((Object)query.getRows())) {
            return query;
        }
        HashMap cMap = new HashMap();
        for (DefaultBpmTask task : query.getRows()) {
            if (!StringUtil.isEmpty((String)task.getAssigneeName())) continue;
            cMap.put(task.getTaskId(), new ArrayList());
        }
        Set keySet = cMap.keySet();
        if (BeanUtils.isNotEmpty(keySet)) {
            QueryFilter cQueryFilter = QueryFilter.build();
            cQueryFilter.addFilter("task_id_", (Object)StringUtil.join(keySet, (String)","), QueryOP.IN);
            BpmTaskCandidateManager candidateManager = (BpmTaskCandidateManager)AppUtil.getBean(BpmTaskCandidateManager.class);
            PageList candidateQuery = candidateManager.query(cQueryFilter);
            if (BeanUtils.isEmpty((Object)candidateQuery) || BeanUtils.isEmpty((Object)candidateQuery.getRows())) {
                return query;
            }
            for (DefaultBpmTaskCandidate candidate : candidateQuery.getRows()) {
                ((List)cMap.get(candidate.getTaskId())).add(candidate);
            }
            for (DefaultBpmTask task : query.getRows()) {
                if (!cMap.containsKey(task.getTaskId()) || !BeanUtils.isNotEmpty(cMap.get(task.getTaskId()))) continue;
                List list = (List)cMap.get(task.getTaskId());
                ArrayList<DefaultBpmIdentity> identityList = new ArrayList<DefaultBpmIdentity>();
                for (DefaultBpmTaskCandidate candidate : list) {
                    identityList.add(new DefaultBpmIdentity(candidate.getExecutor(), "", candidate.getType()));
                }
                task.setIdentityList(identityList);
            }
        }
        return query;
    }

    @RequestMapping(value={"get"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u660e\u7ec6", httpMethod="GET", notes="\u83b7\u53d6\u4efb\u52a1\u660e\u7ec6")
    public TaskGetVo get(@ApiParam(name="id", value="\u4efb\u52a1id", required=true) @RequestParam String id) throws Exception {
        return this.iFlowService.getTaskById(id, true).get();
    }

    @RequestMapping(value={"getNotice"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u660e\u7ec6", httpMethod="GET", notes="\u83b7\u53d6\u4efb\u52a1\u660e\u7ec6")
    public TaskGetVo getNotice(@ApiParam(name="id", value="\u4efb\u52a1id", required=true) @RequestParam String id) throws Exception {
        return this.iFlowService.getTaskById(id, false).get();
    }

    @RequestMapping(value={"taskToAgree"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4efb\u52a1\u529e\u7406(\u540c\u610f\u3001\u53cd\u5bf9\u3001\u5f03\u6743)", httpMethod="GET", notes="\u4efb\u52a1\u529e\u7406(\u540c\u610f\u3001\u53cd\u5bf9\u3001\u5f03\u6743)")
    public TaskToAgreeVo taskToAgree(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId, @ApiParam(name="actionName", value="\u5ba1\u6279\u52a8\u4f5c", required=true) @RequestParam String actionName) throws Exception {
        return this.iFlowService.toAgree(taskId, actionName);
    }

    @RequestMapping(value={"taskToReject"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9a73\u56de\u4efb\u52a1\u9875\u9762\u53c2\u6570", httpMethod="GET", notes="\u9a73\u56de\u4efb\u52a1\u9875\u9762\u53c2\u6570")
    public TaskToRejectVo taskToReject(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId, @ApiParam(name="backModel", value="\u9a73\u56de\u6a21\u5f0f\uff1areject\u3001backToStart") @RequestParam String backModel) throws Exception {
        return this.iFlowService.toReject(taskId, backModel);
    }

    @RequestMapping(value={"handlerTypes"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u652f\u6301\u7684\u6d88\u606f\u5904\u7406\u7c7b\u578b", httpMethod="GET", notes="\u83b7\u53d6\u652f\u6301\u7684\u6d88\u606f\u5904\u7406\u7c7b\u578b")
    public Map<String, String> getHandlerTypes() throws Exception {
        return MessageUtil.getHandlerTypes();
    }

    @RequestMapping(value={"getTaskTransById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u8f6c\u4efb\u52a1id\u660e\u7ec6", httpMethod="GET", notes="\u6839\u636e\u6d41\u8f6c\u4efb\u52a1id\u660e\u7ec6")
    public BpmTaskTransRecord getTaskTransById(@ApiParam(name="id", value="\u6d41\u8f6c\u4efb\u52a1id", required=true) @RequestParam String id) throws Exception {
        return (BpmTaskTransRecord)this.taskTransRecordManager.get((Serializable)((Object)id));
    }

    @RequestMapping(value={"getTransRecordList"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u7684\u6d41\u8f6c\u8bb0\u5f55\u660e\u7ec6", httpMethod="GET", notes="\u83b7\u53d6\u4efb\u52a1\u7684\u6d41\u8f6c\u8bb0\u5f55\u660e\u7ec6")
    public List<BpmTaskTransRecord> getTransRecordList(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE)).withParam("taskId", (Object)taskId);
        return this.taskTransRecordManager.getTransRecordList(queryFilter);
    }

    @RequestMapping(value={"withDraw"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u64a4\u9500\u6211\u6d41\u8f6c\u51fa\u53bb\u7684\u4efb\u52a1", httpMethod="POST", notes="\u64a4\u9500\u6211\u6d41\u8f6c\u51fa\u53bb\u7684\u4efb\u52a1")
    public CommonResult<String> withDraw(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestBody WithDrawParam withDrawParam) throws Exception {
        return this.iFlowService.withDraw(withDrawParam);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u4efb\u52a1\u8bb0\u5f55", httpMethod="DELETE", notes="\u5220\u9664\u4efb\u52a1\u8bb0\u5f55")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u4efb\u52a1\u8bb0\u5f55ID\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u5206\u9694", required=true) @RequestParam String ids) throws Exception {
        String[] aryIds = null;
        if (!StringUtil.isEmpty((String)ids)) {
            aryIds = ids.split(",");
        }
        this.bpmTaskManager.removeByIds(aryIds);
        return new CommonResult(true, "\u5220\u9664\u4efb\u52a1\u6210\u529f", (Object)"");
    }

    @RequestMapping(value={"getTaskCommu"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6c9f\u901a\u53cd\u9988\u4efb\u52a1", httpMethod="GET", notes="\u901a\u8fc7\u6c9f\u901a\u4efb\u52a1id\u83b7\u53d6\u6c9f\u901a\u53cd\u9988\u4efb\u52a1")
    public TaskCommuVo getTaskCommu(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        BpmTask bpmTask = (BpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        BpmTaskCommu taskCommu = this.bpmTaskCommuManager.getByTaskId(bpmTask.getParentId());
        List commuReceivers = null;
        if (taskCommu != null) {
            commuReceivers = this.bpmCommuReceiverManager.getByCommuStatus(taskCommu.getId(), null);
        }
        return new TaskCommuVo(taskCommu, commuReceivers);
    }

    @RequestMapping(value={"canLock"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u662f\u5426\u80fd\u9501\u5b9a", httpMethod="GET", notes="\u83b7\u53d6\u4efb\u52a1\u662f\u5426\u80fd\u9501\u5b9a\uff0c\u8fd4\u56de\u5f53\u524d\u4efb\u52a1\u7684\u53ef\u64cd\u4f5c\u72b6\u6001\uff1a0:\u4efb\u52a1\u5df2\u7ecf\u5904\u7406,1:\u53ef\u4ee5\u9501\u5b9a,2:\u4e0d\u9700\u8981\u89e3\u9501 ,3:\u53ef\u4ee5\u89e3\u9501\uff0c4,\u88ab\u5176\u4ed6\u4eba\u9501\u5b9a,5:\u8fd9\u79cd\u60c5\u51b5\u4e00\u822c\u662f\u7ba1\u7406\u5458\u64cd\u4f5c\uff0c\u6240\u4ee5\u4e0d\u7528\u51fa\u9501\u5b9a\u6309\u94ae")
    public int canLock(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId, @ApiParam(name="leaderId", value="\u9886\u5bfcid", required=true) @RequestParam Optional<String> leaderId) throws Exception {
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (task == null) {
            return 0;
        }
        boolean isForbindden = this.bpmInstService.isSuspendByInstId(task.getProcInstId());
        if (isForbindden) {
            return 6;
        }
        int rtn = this.bpmTaskManager.canLockTask(taskId, leaderId.orElse(""));
        return rtn;
    }

    @RequestMapping(value={"isForbindden"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u4efb\u52a1\u662f\u5426\u5df2\u88ab\u7981\u7528", httpMethod="GET", notes="\u83b7\u53d6\u6d41\u7a0b\u4efb\u52a1\u662f\u5426\u5df2\u88ab\u7981\u7528\uff1a1\u3001\u6d41\u7a0b\u5df2\u7ecf\u88ab\u7981\u6b62\uff0c2\u3001\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c3\u3001\u6ca1\u6709\u5904\u7406\u6b64\u4efb\u52a1\u7684\u6743\u9650\u3002")
    public int isForbindden(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        ObjectNode jsonObj;
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (task == null) {
            return 2;
        }
        boolean isForbindden = this.bpmInstService.isSuspendByInstId(task.getProcInstId());
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin() && (jsonObj = this.bpmDefAuthorizeManager.getRight(task.getProcDefKey(), "task")) == null && !ContextUtil.getCurrentUserId().equals(task.getAssigneeId())) {
            return 3;
        }
        if (isForbindden) {
            return 1;
        }
        return 0;
    }

    @RequestMapping(value={"lockUnlock"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u9501\u5b9a\u72b6\u6001", httpMethod="GET", notes="\u83b7\u53d6\u4efb\u52a1\u9501\u5b9a\u72b6\u6001\uff1a0:\u4efb\u52a1\u5df2\u7ecf\u5904\u7406,1:\u53ef\u4ee5\u9501\u5b9a,2:\u4e0d\u9700\u8981\u89e3\u9501 ,3:\u53ef\u4ee5\u89e3\u9501\uff0c4,\u88ab\u5176\u4ed6\u4eba\u9501\u5b9a\u3002")
    public int lockUnlock(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId, @ApiParam(name="leaderId", value="\u9886\u5bfcid", required=false) @RequestParam Optional<String> leaderId) throws Exception {
        int rtn;
        String curUserId = ContextUtil.getCurrentUserId();
        if (StringUtil.isNotZeroEmpty((String)leaderId.orElse(""))) {
            ThreadMsgUtil.addMapMsg((String)"leaderId", (String)leaderId.get());
            curUserId = leaderId.get();
        }
        if ((rtn = this.bpmTaskManager.canLockTask(taskId)) == 0 || rtn == 4 || rtn == 2 || rtn == 5) {
            return rtn;
        }
        if (rtn == 1) {
            this.bpmTaskManager.lockTask(taskId, curUserId);
        } else {
            this.bpmTaskManager.unLockTask(taskId, curUserId);
        }
        return rtn;
    }

    @RequestMapping(value={"getCandidatesListByInstId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8b\u83b7\u53d6\u5176\u4e0b\u7684\u5019\u9009\u4eba\u5217\u8868", httpMethod="GET", notes="\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8b\u83b7\u53d6\u5176\u4e0b\u7684\u5019\u9009\u4eba\u5217\u8868")
    public List<BpmIdentity> getCandidatesListByInstId(@ApiParam(name="instId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true) @RequestParam String instId) throws Exception {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("PROC_INST_ID_", (Object)instId, QueryOP.EQUAL);
        queryFilter.addFilter("task.STATUS_", (Object)"TRANSFORMING", QueryOP.NOT_EQUAL);
        PageList query = this.bpmTaskManager.query(queryFilter);
        if (query.getRows().size() != 1) {
            return null;
        }
        DefaultBpmTask defaultBpmTask = (DefaultBpmTask)query.getRows().get(0);
        BpmTaskService bpmTaskService = (BpmTaskService)AppUtil.getBean(BpmTaskService.class);
        List bpmIdentities = bpmTaskService.getTaskCandidates(defaultBpmTask.getTaskId());
        return bpmIdentities;
    }

    @RequestMapping(value={"taskNode"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u53ef\u8ddf\u8e2a\u7684\u4efb\u52a1\u8282\u70b9", httpMethod="GET", notes="\u83b7\u53d6\u53ef\u8ddf\u8e2a\u7684\u4efb\u52a1\u8282\u70b9")
    public TaskjImageVo taskNode(@ApiParam(name="taskId", value="\u4efb\u52a1id") @RequestParam Optional<String> taskId, @ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id") @RequestParam Optional<String> defId) throws Exception {
        TaskjImageVo taskNode = this.iFlowService.taskImage(taskId.orElse(""), defId.orElse(""));
        return taskNode;
    }

    @RequestMapping(value={"addSign"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u52a0\u7b7e", httpMethod="POST", notes="\u52a0\u7b7e")
    public CommonResult<String> addSign(@ApiParam(name="taskTransParamObject", value="\u6d41\u8f6c\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody TaskTransParamObject taskTransParamObject) throws Exception {
        return this.taskTransService.addSign(taskTransParamObject);
    }

    @RequestMapping(value={"isEnd"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u662f\u5426\u7ed3\u675f", httpMethod="POST", notes="\u6d41\u7a0b\u662f\u5426\u7ed3\u675f")
    public CommonResult<String> isEnd(@ApiParam(name="procInstId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true) @RequestParam String procInstId) throws Exception {
        try {
            DefaultBpmProcessInstance defaultBpmProcessInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)procInstId));
            if (BeanUtils.isNotEmpty((Object)defaultBpmProcessInstance)) {
                if (!defaultBpmProcessInstance.getStatus().equals("end")) {
                    return new CommonResult(true, "");
                }
                return new CommonResult(false, "\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u7ed3\u675f!");
            }
            return new CommonResult(false, "\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728");
        }
        catch (Exception e) {
            return new CommonResult(false, e.getMessage());
        }
    }

    @RequestMapping(value={"taskToInqu"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5f81\u8be2\u8bbe\u7f6e", httpMethod="POST", notes="\u5f81\u8be2\u8bbe\u7f6e")
    public CommonResult<String> taskToInqu(@ApiParam(name="taskTransParamObject", value="\u5f81\u8be2\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody TaskTransParamObject taskTransParamObject, @ApiParam(name="leaderId", value="\u4ee3\u4e3a\u5904\u7406\u7684\u9886\u5bfcid", required=true) @RequestParam Optional<String> leaderId) throws Exception {
        BpmUtil.checkDefForbidStatus((String)"", (String)"", (String)taskTransParamObject.getTaskId());
        if (StringUtil.isNotZeroEmpty((String)leaderId.orElse(""))) {
            ThreadMsgUtil.addMapMsg((String)"leaderId", (String)leaderId.get());
        }
        return this.iFlowService.taskToInqu(taskTransParamObject);
    }

    @RequestMapping(value={"taskToInquReply"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5f81\u8be2\u56de\u590d", httpMethod="POST", notes="\u5f81\u8be2\u56de\u590d")
    public CommonResult<String> taskToInquReply(@ApiParam(name="dbo", value="\u56de\u590d\u4fe1\u606f", required=true) @RequestBody DefaultBpmCheckOpinion dbo, @ApiParam(name="leaderId", value="\u4ee3\u4e3a\u5904\u7406\u7684\u9886\u5bfcid", required=true) @RequestParam Optional<String> leaderId) throws Exception {
        if (!this.isAuth(dbo.getTaskId(), leaderId.orElse(null))) {
            throw new RuntimeException("\u60a8\u6ca1\u6709\u5904\u7406\u8be5\u4efb\u52a1\u7684\u6743\u9650\uff01");
        }
        try {
            BpmUtil.checkDefForbidStatus((String)"", (String)"", (String)dbo.getTaskId());
            if (StringUtil.isNotZeroEmpty((String)leaderId.orElse(""))) {
                ThreadMsgUtil.addMapMsg((String)"leaderId", (String)leaderId.get());
            }
            this.bpmTaskTransManager.taskToInquReply(dbo);
            return new CommonResult(true, "\u5f81\u8be2\u56de\u590d\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5f81\u8be2\u56de\u590d\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @RequestMapping(value={"userAddSignFeedback"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u666e\u901a\u7528\u6237\u8282\u70b9\u7528\u6237\u52a0\u7b7e\u53cd\u9988", httpMethod="POST", notes="\u666e\u901a\u7528\u6237\u8282\u70b9\u7528\u6237\u52a0\u7b7e\u53cd\u9988")
    public CommonResult<String> userAddSignFeedback(@ApiParam(name="dbo", value="\u56de\u590d\u4fe1\u606f", required=true) @RequestBody DefaultBpmCheckOpinion dbo, @ApiParam(name="leaderId", value="\u4ee3\u4e3a\u5904\u7406\u7684\u9886\u5bfcid", required=true) @RequestParam Optional<String> leaderId) throws Exception {
        try {
            BpmUtil.checkDefForbidStatus((String)"", (String)"", (String)dbo.getTaskId());
            if (StringUtil.isNotZeroEmpty((String)leaderId.orElse(""))) {
                ThreadMsgUtil.addMapMsg((String)"leaderId", (String)leaderId.get());
            }
            this.bpmTaskTransManager.userAddSignFeedback(dbo);
            return new CommonResult(true, "\u52a0\u7b7e\u53cd\u9988\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u52a0\u7b7e\u53cd\u9988\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @RequestMapping(value={"addReadRecord"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6240\u4f20\u4efb\u52a1id\u65b0\u589e\u8be5\u4efb\u52a1\u7684\u9605\u8bfb\u8bb0\u5f55", httpMethod="POST", notes="\u6839\u636e\u6240\u4f20\u4efb\u52a1id\u65b0\u589e\u8be5\u4efb\u52a1\u7684\u9605\u8bfb\u8bb0\u5f55")
    public void addReadRecord(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        DefaultBpmTask bpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (BeanUtils.isEmpty((Object)bpmTask)) {
            bpmTask = new DefaultBpmTask();
            BpmTaskNoticeManager noticeManager = (BpmTaskNoticeManager)AppUtil.getBean(BpmTaskNoticeManager.class);
            BpmTaskNotice bpmTaskNotice = (BpmTaskNotice)noticeManager.get((Serializable)((Object)taskId));
            if (BeanUtils.isEmpty((Object)bpmTaskNotice)) {
                throw new BaseException("\u6839\u636e\u6240\u4f20\u4efb\u52a1id:" + taskId + "\u672a\u627e\u5230\u4efb\u52a1\uff01");
            }
            bpmTask = bpmTaskNotice.convertToBpmTask();
        }
        this.iFlowService.addReadRecord(bpmTask);
        this.bpmCheckOpinionManager.checkOpinionIsRead(bpmTask.getId());
    }

    @RequestMapping(value={"noticeTurnDode"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u77e5\u4f1a\u4efb\u52a1\u5f85\u529e\u8f6c\u5df2\u529e", httpMethod="POST", notes="\u77e5\u4f1a\u4efb\u52a1\u5f85\u529e\u8f6c\u5df2\u529e")
    public void noticeTurnDode(@ApiParam(name="taskId", value="\u77e5\u4f1a\u4efb\u52a1\u4e3b\u952eid\u96c6\u5408", required=true) @RequestParam String taskId) throws Exception {
        String[] val;
        for (String id : val = taskId.split(",")) {
            this.iFlowService.noticeTurnDode(id);
        }
    }

    @RequestMapping(value={"getCurNodeProperties"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u8282\u70b9\u5c5e\u6027,\u542f\u52a8\u7684\u65f6\u5019\u53d6\u53d1\u8d77\u8282\u70b9", httpMethod="GET", notes="\u83b7\u53d6\u5f53\u524d\u8282\u70b9\u5c5e\u6027,\u542f\u52a8\u7684\u65f6\u5019\u53d6\u53d1\u8d77\u8282\u70b9")
    public BpmNodeDef getCurNodeProperties(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=false) @RequestParam Optional<String> taskId, @ApiParam(name="defId", value="\u5b9a\u4e49id", required=false) @RequestParam Optional<String> defId, @ApiParam(name="instId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=false) @RequestParam Optional<String> instId) throws Exception {
        return this.iFlowService.getCurNodeProperties(taskId.orElse(""), defId.orElse(""), instId.orElse(""));
    }

    @RequestMapping(value={"getAfterJumpNodes"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8282\u70b9\u914d\u7f6e\u83b7\u53d6\u540e\u7eed\u53ef\u8df3\u8f6c\u8282\u70b9", httpMethod="POST", notes="\u6839\u636e\u8282\u70b9\u914d\u7f6e\u83b7\u53d6\u540e\u7eed\u53ef\u8df3\u8f6c\u8282\u70b9")
    public ObjectNode getAfterJumpNodes(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestBody ObjectNode obj) throws Exception {
        return this.iFlowService.getAfterJumpNode(obj);
    }

    @RequestMapping(value={"getNoticeTodoReadList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09", httpMethod="POST", notes="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09")
    public PageList<BpmTaskNotice> getNoticeTodoReadList(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        PageList<BpmTaskNotice> pageList = this.iFlowService.getNoticeTodoReadList(this.baseContext.getCurrentUserAccout(), queryFilter);
        return pageList;
    }

    @PostMapping(value={"getNoticeTodoReadCount"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09\u6570\u91cf", httpMethod="POST", notes="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09\u6570\u91cf")
    public List<Map<String, Object>> getNoticeTodoReadCount(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.iFlowService.getNoticeTodoReadCount(this.baseContext.getCurrentUserAccout(), queryFilter);
    }

    @RequestMapping(value={"getNoticeDoneReadList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5df2\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09", httpMethod="POST", notes="\u83b7\u53d6\u5df2\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09")
    public PageList<BpmTaskNoticeDone> getNoticeDoneReadList(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        List boys = queryFilter.getQuerys();
        Optional<QueryField> queryFieldOptional = boys.stream().filter(s -> s.getProperty().equals("inst.PROC_DEF_KEY_")).findFirst();
        if (queryFieldOptional.isPresent()) {
            QueryField queryField = queryFieldOptional.get();
            DefaultBpmDefinition po = this.bpmDefinitionManager.getMainByDefKey(queryFieldOptional.get().getValue().toString());
            queryFilter.addFilter("bpm_task_notice_done.PROC_DEF_ID_", (Object)po.getDefId(), QueryOP.EQUAL);
            queryFilter.getQuerys().remove(queryFieldOptional.get());
        }
        PageList<BpmTaskNoticeDone> pageList = this.iFlowService.getNoticeDoneReadList(this.baseContext.getCurrentUserAccout(), queryFilter);
        return pageList;
    }

    @PostMapping(value={"getNoticeDoneReadCount"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09\u6570\u91cf", httpMethod="POST", notes="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09\u6570\u91cf")
    public List<Map<String, Object>> getNoticeDoneReadCount(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.iFlowService.getNoticeDoneReadCount(this.baseContext.getCurrentUserAccout(), queryFilter);
    }

    @RequestMapping(value={"getMyNoticeReadList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6211\u4f20\u9605\u7684\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09", httpMethod="POST", notes="\u83b7\u53d6\u6211\u4f20\u9605\u7684\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09")
    public PageList<BpmTaskNotice> getMyNoticeReadList(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        PageList<BpmTaskNotice> pageList = this.iFlowService.getMyNoticeReadList(this.baseContext.getCurrentUserAccout(), queryFilter);
        return pageList;
    }

    @PostMapping(value={"getMyNoticeReadCount"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09\u6570\u91cf", httpMethod="POST", notes="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09\u6570\u91cf")
    public List<Map<String, Object>> getMyNoticeReadCount(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.iFlowService.getMyNoticeReadCount(this.baseContext.getCurrentUserAccout(), queryFilter);
    }

    @RequestMapping(value={"delBpmTaskNoticeById"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eID\u4e3b\u952eID\u5220\u9664\u4f20\u9605\u4efb\u52a1", httpMethod="POST", notes="\u6839\u636eID\u4e3b\u952eID\u5220\u9664\u4f20\u9605\u4efb\u52a1")
    public CommonResult<String> delBpmTaskNoticeById(@ApiParam(name="id", value="\u4e3b\u952eID", required=true) @RequestParam String id) throws Exception {
        try {
            this.iFlowService.delBpmTaskNoticeById(id);
            return new CommonResult(true, "\u64a4\u56de\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u64a4\u56de\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @RequestMapping(value={"nextExecutor"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u987a\u5e8f\u7b7e\u7f72\u4e0b\u4e00\u6b65\u6267\u884c\u4eba", httpMethod="GET", notes="\u83b7\u53d6\u987a\u5e8f\u7b7e\u7f72\u4e0b\u4e00\u6b65\u6267\u884c\u4eba")
    public CommonResult<BpmIdentity> nextExecutor(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        return this.iFlowService.nextExecutor(taskId);
    }

    @RequestMapping(value={"testRevoke"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u987a\u7b7e\u64a4\u56de", httpMethod="GET", notes="\u987a\u7b7e\u64a4\u56de")
    public CommonResult<BpmIdentity> testRevoke(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId, @ApiParam(name="customSignTaskId", value="\u4efb\u52a1id", required=true) @RequestParam String customSignTaskId, @ApiParam(name="instId", value="instId", required=true) @RequestParam String instId) throws Exception {
        return new CommonResult(true, "\u6210\u529f");
    }

    @RequestMapping(value={"getBpmTaskByInstId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bId\u83b7\u53d6\u4ee3\u529e\u4efb\u52a1", httpMethod="GET", notes="\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bId\u83b7\u53d6\u4ee3\u529e\u4efb\u52a1")
    public List<DefaultBpmTask> getBpmTaskByInstId(@ApiParam(name="instId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true) @RequestParam String instId) throws Exception {
        IUser iUser = this.userService.getUserByAccount(this.baseContext.getCurrentUserAccout());
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        queryFilter.addFilter("bt.proc_inst_id_", (Object)instId, QueryOP.EQUAL);
        return this.bpmTaskManager.getByUserId(iUser.getUserId(), queryFilter).getRows();
    }

    @RequestMapping(value={"getCandidatesListByTaskId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1id\u83b7\u53d6\u5176\u4e0b\u7684\u5019\u9009\u4eba\u5217\u8868\u5e76\u62bd\u53d6\u6267\u884c\u4eba", httpMethod="GET", notes="\u6839\u636e\u4efb\u52a1id\u83b7\u53d6\u5176\u4e0b\u7684\u5019\u9009\u4eba\u5217\u8868\u5e76\u62bd\u53d6\u6267\u884c\u4eba")
    public ArrayNode getCandidatesListByTaskId(@ApiParam(name="taskId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true) @RequestParam String taskId) throws Exception {
        BpmTaskService bpmTaskService = (BpmTaskService)AppUtil.getBean(BpmTaskService.class);
        List bpmIdentities = bpmTaskService.getTaskCandidates(taskId);
        ArrayNode bpmIdentitiesArray = JsonUtil.getMapper().createArrayNode();
        if (BeanUtils.isEmpty((Object)bpmIdentities)) {
            return bpmIdentitiesArray;
        }
        BpmIdentityExtractService bpmIdentityExtractService = (BpmIdentityExtractService)AppUtil.getBean(BpmIdentityExtractService.class);
        for (BpmIdentity identity : bpmIdentities) {
            ObjectNode identityObj = (ObjectNode)JsonUtil.toJsonNode((Object)((DefaultBpmIdentity)identity));
            bpmIdentitiesArray.add((JsonNode)identityObj);
            if ("user".equals(identity.getType())) continue;
            ArrayList<BpmIdentity> tempList = new ArrayList<BpmIdentity>();
            tempList.add(identity);
            List extractUser = bpmIdentityExtractService.extractUser(tempList);
            if (!BeanUtils.isNotEmpty((Object)extractUser)) continue;
            ArrayList<String> userNames = new ArrayList<String>();
            ArrayList<String> userIds = new ArrayList<String>();
            for (IUser iUser : extractUser) {
                userNames.add(iUser.getFullname());
                userIds.add(iUser.getUserId());
            }
            identityObj.put("userNames", StringUtil.join(userNames, (String)","));
            identityObj.put("userIds", StringUtil.join(userIds, (String)","));
        }
        return bpmIdentitiesArray;
    }

    @RequestMapping(value={"getTaskListByTenantId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u79df\u6237id\u83b7\u53d6\u4efb\u52a1\u5217\u8868", httpMethod="GET", notes="\u6839\u636e\u79df\u6237id\u83b7\u53d6\u4efb\u52a1\u5217\u8868")
    public List<ObjectNode> getTaskListByTenantId(@ApiParam(name="tenantId", value="\u79df\u6237id", required=true) @RequestParam String tenantId) throws Exception {
        return this.bpmTaskManager.getTaskListByTenantId(tenantId);
    }

    @RequestMapping(value={"getLeaderTodoCount"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u9886\u5bfc\u5f85\u529e\u6570\u76ee", httpMethod="GET", notes="\u83b7\u53d6\u9886\u5bfc\u5f85\u529e\u6570\u76ee")
    public List<Map<String, Object>> getLeaderTodoCount() throws Exception {
        return this.bpmTaskManager.getLeaderCountByUserId(this.baseContext.getCurrentUserId());
    }

    @RequestMapping(value={"createBpmSaveOpinion"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539\u6682\u5b58\u7684\u5ba1\u6279\u610f\u89c1", httpMethod="POST", notes="\u65b0\u589e\u6216\u4fee\u6539\u6682\u5b58\u7684\u5ba1\u6279\u610f\u89c1")
    public CommonResult<String> createBpmSaveOpinion(@ApiParam(name="bpmSaveOpinion", value="\u5ba1\u6279\u610f\u89c1\u6682\u5b58\u4fe1\u606f") @RequestBody BpmSaveOpinion bpmSaveOpinion) {
        boolean result = this.bpmSaveOpinionManager.createBpmSaveOpinion(bpmSaveOpinion);
        if (!result) {
            return new CommonResult(false, "\u6682\u5b58\u5931\u8d25");
        }
        return new CommonResult(true, "\u6682\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"getBpmSaveOpinionByTeam"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u6d41\u7a0b\u5b9e\u4f8bID\u548c\u4efb\u52a1ID\u83b7\u53d6\u5ba1\u6279\u610f\u89c1", httpMethod="GET", notes="\u901a\u8fc7\u6d41\u7a0b\u5b9e\u4f8bID\u548c\u4efb\u52a1ID\u83b7\u53d6\u5ba1\u6279\u610f\u89c1")
    public CommonResult<String> getBpmSaveOpinionByTeam(@ApiParam(name="instId", value="\u6d41\u7a0b\u5b9e\u4f8bID", required=true) @RequestParam String instId, @ApiParam(name="taskId", value="\u6d41\u7a0b\u4efb\u52a1ID", required=true) @RequestParam String taskId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instId", instId);
        params.put("taskId", taskId);
        BpmSaveOpinion bpmSaveOpinion = this.bpmSaveOpinionManager.getBpmSaveOpinionByTeam(params);
        if (BeanUtils.isNotEmpty((Object)bpmSaveOpinion)) {
            return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", (Object)bpmSaveOpinion.getOpinion());
        }
        return new CommonResult(true, "\u83b7\u53d6\u5931\u8d25", (Object)"");
    }

    private boolean isAuth(String taskId, String leaderId) throws Exception {
        IUser currentUser = ContextUtil.getCurrentUser();
        if (currentUser.isAdmin()) {
            return true;
        }
        DefaultBpmTask task = this.bpmTaskManager.getByTaskId(taskId);
        if (BeanUtils.isNotEmpty((Object)task)) {
            Boolean hasPermTodo = false;
            List recievers = new ArrayList();
            List queryByBpmTask = this.bpmIdentityService.queryListByBpmTask((BpmTask)task);
            recievers = this.bpmIdentityExtractService.extractUser(queryByBpmTask);
            if (BeanUtils.isNotEmpty(recievers)) {
                for (IUser iUser : recievers) {
                    if (!currentUser.getUserId().equals(iUser.getUserId()) && (!StringUtil.isNotEmpty((String)leaderId) || !leaderId.equals(iUser.getUserId()))) continue;
                    hasPermTodo = true;
                    break;
                }
            }
            if (!hasPermTodo.booleanValue() && !this.iFlowService.isInRightMap(task.getProcDefKey(), task.getProcInstId())) {
                return false;
            }
        }
        return true;
    }

    @RequestMapping(value={"batchHandle"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5904\u7406\u4efb\u52a1", httpMethod="POST", notes="\u6279\u91cf\u5904\u7406\u4efb\u52a1")
    public CommonResult<HashMap<String, Object>> batchHandle(@ApiParam(name="requestMap", value="\u8bf7\u6c42\u4f53") @RequestBody Map<String, String> requestMap) throws Exception {
        String taskIds = requestMap.get("taskIds");
        String action = requestMap.get("action");
        String opinion = requestMap.get("opinion");
        String[] listIds = taskIds.split(",");
        String account = ContextUtil.getCurrentUser().getAccount();
        ArrayList<DefaultBpmTask> unHandleList = new ArrayList<DefaultBpmTask>();
        ArrayList<DefaultBpmTask> completeList = new ArrayList<DefaultBpmTask>();
        ArrayList unAuthList = new ArrayList();
        ArrayList<DefaultBpmTask> failedList = new ArrayList<DefaultBpmTask>();
        HashMap<String, String> failedMsgMap = new HashMap<String, String>();
        for (String taskId : listIds) {
            BpmNodeDef curNodeProperties = this.iFlowService.getCurNodeProperties(taskId, "", "");
            DefaultBpmTask defaultBpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
            BpmProcessInstance processInstance = this.bpmInstService.getProcessInstance(defaultBpmTask.getProcInstId());
            NodeProperties properties = curNodeProperties.getLocalProperties();
            if (BeanUtils.isNotEmpty((Object)curNodeProperties.getNodeProperties())) {
                properties = (NodeProperties)curNodeProperties.getNodeProperties().get(0);
            }
            if (!properties.isBatchHandleRevoke()) {
                unHandleList.add(defaultBpmTask);
                continue;
            }
            String procInstId = defaultBpmTask.getProcInstId();
            String formCategory = this.bpmInstFormManager.getInstFormCategory(defaultBpmTask.getProcInstId(), defaultBpmTask.getNodeId());
            DoNextParamObject doNextParamObject = new DoNextParamObject();
            doNextParamObject.setAccount(account);
            doNextParamObject.setTaskId(taskId);
            doNextParamObject.setOpinion(opinion);
            doNextParamObject.setActionName(action);
            DefaultBpmCheckOpinion checkOpinion = this.bpmCheckOpinionManager.getLastOpinionByProcId(defaultBpmTask.getProcInstId());
            doNextParamObject.setAgentLeaderId("0");
            doNextParamObject.setJumpType(properties.getJumpType());
            if (action.equals(DecideType.AGREE.value())) {
                BpmFormService bpmFormService = BpmFormFactory.getFormService((FormType)FormType.PC);
                FormModel formModel = bpmFormService.getByDefId(defaultBpmTask.getProcDefId(), defaultBpmTask.getTaskId(), processInstance, true);
                if (BeanUtils.isNotEmpty((Object)formModel)) {
                    doNextParamObject.setFormKey(formModel.getFormKey());
                }
            } else {
                doNextParamObject.setBackHandMode(requestMap.get("backHandMode"));
            }
            doNextParamObject.setNodeUsers("[]");
            doNextParamObject.setDestination("");
            doNextParamObject.setFormType(formCategory);
            doNextParamObject.setFiles("");
            doNextParamObject.setZfiles("");
            try {
                this.iFlowService.complete(doNextParamObject);
                completeList.add(defaultBpmTask);
            }
            catch (Exception e) {
                failedList.add(defaultBpmTask);
                failedMsgMap.put(defaultBpmTask.getTaskId(), e.getMessage());
            }
        }
        HashMap<String, Cloneable> result = new HashMap<String, Cloneable>();
        result.put("notAuth", unAuthList);
        result.put("complete", completeList);
        result.put("unHandleList", unHandleList);
        result.put("failedList", failedList);
        result.put("failedMsg", failedMsgMap);
        return new CommonResult(true, "\u5904\u7406\u5b8c\u6210", result);
    }

    @RequestMapping(value={"nextTask"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4e0b\u4e00\u4e2a\u4ee3\u529e\u4efb\u52a1", httpMethod="GET", notes="\u83b7\u53d6\u4e0b\u4e00\u4e2a\u4ee3\u529e\u4efb\u52a1")
    public CommonResult<DefaultBpmTask> nextTask(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49ID") @RequestParam String defId, @RequestParam String defKey) throws Exception {
        if (StringUtil.isEmpty((String)defKey)) {
            DefaultBpmDefinition defaultBpmDefinition = (DefaultBpmDefinition)this.bpmDefinitionManager.get((Serializable)((Object)defId));
            if (BeanUtils.isEmpty((Object)defaultBpmDefinition)) {
                throw new BaseException("\u4e0b\u4e00\u4e2a\u4efb\u52a1\u83b7\u53d6\u5931\u8d25\uff1a\u8282\u70b9\u4e3a\u7a7a");
            }
            defKey = defaultBpmDefinition.getDefKey();
        }
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("bt.PROC_DEF_KEY_", (Object)defKey, QueryOP.EQUAL, FieldRelation.AND);
        PageBean bean = new PageBean(Integer.valueOf(1), Integer.valueOf(1));
        queryFilter.setPageBean(bean);
        PageList<DefaultBpmTask> byDefKey = this.iFlowService.getTodoList(this.baseContext.getCurrentUserAccout(), (QueryFilter<DefaultBpmTask>)queryFilter).get();
        if (!byDefKey.getRows().isEmpty()) {
            return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", byDefKey.getRows().get(0));
        }
        return new CommonResult(true, "\u672a\u83b7\u53d6\u5230\u4efb\u4f55\u5f85\u529e", null);
    }

    private void setNoAuthFilter(QueryFilter queryFilter) {
        String ids = "";
        List list = this.bpmDefUserManager.getByUserMap("bpmDef", "task");
        IGroup ugroup = ContextUtil.getCurrentGroup();
        if (BeanUtils.isNotEmpty((Object)list)) {
            HashMap<String, String> userRightMap = new HashMap<String, String>();
            for (BpmDefUser bpmDefUser : list) {
                String type;
                List bpmDefAct;
                if (StringUtil.isNotEmpty((String)bpmDefUser.getAuthOrg())) {
                    bpmDefAct = this.bpmDefActManager.getByAuthorizeId(bpmDefUser.getAuthorizeId());
                    if (!BeanUtils.isNotEmpty((Object)bpmDefAct)) continue;
                    for (BpmDefAct bpm : bpmDefAct) {
                        type = bpm.getType();
                        if ("1".equals(type)) {
                            userRightMap.put(bpm.getDefKey(), StringUtil.isNotEmpty((String)bpmDefUser.getAuthOrg()) ? StringUtil.convertListToSingleQuotesString(new HashSet<String>(Arrays.asList(bpmDefUser.getAuthOrg().split(",")))) : null);
                        }
                        if (!"2".equals(type)) continue;
                        List defKeys = this.bpmDefinitionManager.queryByTypeId(Arrays.asList(bpm.getDefKey()));
                        for (String defKey : defKeys) {
                            userRightMap.put(defKey, StringUtil.isNotEmpty((String)bpmDefUser.getAuthOrg()) ? StringUtil.convertListToSingleQuotesString(new HashSet<String>(Arrays.asList(bpmDefUser.getAuthOrg().split(",")))) : null);
                        }
                    }
                    continue;
                }
                bpmDefAct = this.bpmDefActManager.getByAuthorizeId(bpmDefUser.getAuthorizeId());
                if (!BeanUtils.isNotEmpty((Object)bpmDefAct)) continue;
                for (BpmDefAct bpm : bpmDefAct) {
                    type = bpm.getType();
                    String orgId = null;
                    if (StringUtil.isNotEmpty((String)bpm.getRightContent())) {
                        try {
                            ObjectNode rightJson = (ObjectNode)JsonUtil.toJsonNode((String)bpm.getRightContent());
                            if (JsonUtil.getBoolean((ObjectNode)rightJson, (String)"i_org", (boolean)false)) {
                                orgId = BeanUtils.isNotEmpty((Object)ugroup) ? ugroup.getGroupId() : "-1";
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    bpm.getRightContent();
                    if ("1".equals(type)) {
                        userRightMap.put(bpm.getDefKey(), StringUtil.isNotEmpty(orgId) ? "'" + orgId + "'" : null);
                    }
                    if (!"2".equals(type)) continue;
                    List defKeys = this.bpmDefinitionManager.queryByTypeId(Arrays.asList(bpm.getDefKey()));
                    for (String defKey : defKeys) {
                        userRightMap.put(defKey, StringUtil.isNotEmpty((String)orgId) ? "'" + orgId + "'" : null);
                    }
                }
            }
            if (BeanUtils.isNotEmpty(userRightMap)) {
                Map maps = this.ucFeignService.getChildrenIds(userRightMap);
                Map rightMap = StringUtil.getMapStringByMapList((Map)maps);
                userRightMap.putAll(rightMap);
                List instanceIds = this.bpmProcessInstanceManager.getStringListByRightMap(userRightMap);
                if (BeanUtils.isNotEmpty((Object)instanceIds)) {
                    for (String id : instanceIds) {
                        ids = ids + id + ",";
                    }
                }
            }
        }
        queryFilter.addParams("instanceIds", (Object)ids);
    }

    @RequestMapping(value={"/filterUnBatchable"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8fc7\u6ee4\u975e\u6279\u91cf\u5904\u7406\u7c7b\u578b\u4efb\u52a1", httpMethod="GET", notes="\u8fc7\u6ee4\u975e\u6279\u91cf\u5904\u7406\u7c7b\u578b\u4efb\u52a1")
    public CommonResult<List<String>> filterUnBatchable(@ApiParam(name="taskIds", value="\u591a\u4e2aID\u7528\u9017\u53f7\u9694\u5f00") @RequestParam String taskIds) {
        if (StringUtil.isEmpty((String)taskIds)) {
            return new CommonResult(true, "", new ArrayList());
        }
        ArrayList<String> filterResult = new ArrayList<String>();
        for (String taskId : taskIds.split(",")) {
            try {
                BpmNodeDef curNodeProperties = this.iFlowService.getCurNodeProperties(taskId, "", "");
                NodeProperties localProperties = curNodeProperties.getLocalProperties();
                if (!localProperties.isBatchHandleRevoke()) continue;
                filterResult.add(taskId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new CommonResult(true, "", filterResult);
    }
}

