/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataAccess.aop;

import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.dataAccess.manager.DataAccessDefinedManager;
import com.artfess.uc.model.User;
import com.artfess.uc.util.ContextUtil;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DataAccessAspect {
    private static final Logger logger = LogManager.getLogger((String)"PermissionData");
    public static final String CREATE_BY_ = "CREATE_BY_";
    public static final String CREATE_ORG_ID_ = "CREATE_ORG_ID_";
    @Autowired
    @Lazy
    DataAccessDefinedManager dataAccessDefinedManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(* *..*Controller.*(..)) && @annotation(com.artfess.base.annotation.DataAccess)")
    public Object checkPermission(ProceedingJoinPoint joinPoint) throws Throwable {
        HttpServletRequest request;
        Object[] params;
        block15: {
            params = joinPoint.getArgs();
            request = HttpUtil.getRequest();
            if (request != null) break block15;
            Object object = joinPoint.proceed();
            return object;
        }
        try {
            Object object;
            String reqUri = request.getRequestURI();
            logger.debug(" \u8bf7\u6c42\u5730\u5740   " + reqUri);
            request.setAttribute("url", (Object)reqUri);
            List<Map<String, Object>> maps = this.dataAccessDefinedManager.getDataAccessDefinedList(reqUri);
            for (Object object2 : params) {
                if (!(object2 instanceof QueryFilter)) continue;
                QueryFilter filter = (QueryFilter)object2;
                for (Map<String, Object> item : maps) {
                    String type = item.get("access_Range_Type_").toString();
                    String accessRangeId = "";
                    if (item.get("access_Range_Id") != null) {
                        accessRangeId = item.get("access_Range_Id").toString();
                    }
                    if ("1".indexOf(type) != -1) {
                        String userId = AuthenticationUtil.getCurrentUserId();
                        filter.addFilter(CREATE_BY_, (Object)userId, QueryOP.EQUAL, FieldRelation.OR, "dataPermission");
                        continue;
                    }
                    if ("2".indexOf(type) != -1) {
                        List<User> list = ContextUtil.getCurrentUserUnder();
                        accessRangeId = AuthenticationUtil.getCurrentUserId();
                        if (list != null && list.size() > 0) {
                            for (User user : list) {
                                if (user == null) continue;
                                accessRangeId = accessRangeId + "," + user.getId();
                            }
                        }
                        filter.addFilter(CREATE_BY_, (Object)String.join((CharSequence)"','", accessRangeId), QueryOP.IN, FieldRelation.OR, "dataPermission");
                        continue;
                    }
                    if ("3".indexOf(type) != -1) {
                        if (!StringUtil.isNotEmpty((String)accessRangeId)) continue;
                        filter.addFilter(CREATE_ORG_ID_, (Object)String.join((CharSequence)"','", accessRangeId), QueryOP.IN, FieldRelation.OR, "dataPermission");
                        continue;
                    }
                    if ("4".indexOf(type) != -1) {
                        String subOrgIds = AuthenticationUtil.getCurrentUserSubOrgIds();
                        filter.addFilter(CREATE_ORG_ID_, (Object)String.join((CharSequence)"','", subOrgIds), QueryOP.IN, FieldRelation.OR, "dataPermission");
                        continue;
                    }
                    if ("5".indexOf(type) != -1) {
                        if (!StringUtil.isNotEmpty((String)accessRangeId)) continue;
                        filter.addFilter(CREATE_ORG_ID_, (Object)String.join((CharSequence)"','", accessRangeId), QueryOP.IN, FieldRelation.OR, "dataPermission");
                        continue;
                    }
                    if ("6".indexOf(type) == -1 || !StringUtil.isNotEmpty((String)accessRangeId)) continue;
                    filter.addFilter(CREATE_BY_, (Object)String.join((CharSequence)"','", accessRangeId), QueryOP.IN, FieldRelation.OR, "dataPermission");
                }
            }
            Object object3 = object = joinPoint.proceed();
            return object3;
        }
        catch (Exception e) {
            Object object;
            logger.info("\u73af\u7ed5\u5207\u9762\u65b9\u6cd5\u62a5\u9519\uff0c\u4e0d\u5f71\u54cd\u5b9e\u9645\u4e1a\u52a1" + e.getMessage());
            Object object4 = object = joinPoint.proceed();
            return object4;
        }
    }
}

