/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.util;

import com.artfess.base.feign.UCFeignService;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.api.context.ICurrentContext;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.User;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.springframework.context.annotation.Primary;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
@Primary
public class ContextUtil {
    private static ContextUtil contextUtil;
    private ICurrentContext currentContext;

    public void setCurrentContext(ICurrentContext _currentContext) {
        contextUtil = this;
        ContextUtil.contextUtil.currentContext = _currentContext;
    }

    public static User getCurrentUser() {
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            Assert.notNull((Object)authentication, (String)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a");
            Object principal = authentication.getPrincipal();
            if (principal instanceof User) {
                return (User)principal;
            }
            if (principal instanceof UserDetails) {
                UserDetails ud = (UserDetails)principal;
                User user = (User)JsonUtil.toBean((String)JsonUtil.toJson((Object)ud), User.class);
                return user;
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static String getCurrentUserId() {
        User user = ContextUtil.getCurrentUser();
        return BeanUtils.isEmpty((Object)user) ? null : user.getUserId();
    }

    public static List<String> getCurrentAndChildOrgIds() {
        String orgKind;
        ObjectNode orgObj;
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        String userId = ContextUtil.getCurrentUserId();
        if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(orgObj = service.getMainGroup(userId))) && (orgKind = orgObj.get("orgKind").asText()).equals("ogn")) {
            HashMap map = Maps.newHashMap();
            map.put("ids", orgObj.get("id").asText());
            Map childrenIds = service.getChildrenIds((Map)map);
            if (!CollectionUtils.isEmpty((Map)childrenIds)) {
                Set ids = (Set)childrenIds.get("ids");
                ArrayList<String> orgIds = new ArrayList<String>(ids);
                return orgIds;
            }
            return new ArrayList<String>();
        }
        return new ArrayList<String>();
    }

    public static String getCurrentUserAccount() {
        User user = ContextUtil.getCurrentUser();
        return BeanUtils.isEmpty((Object)user) ? null : user.getUsername();
    }

    public static String getCurrentUserName() {
        User user = ContextUtil.getCurrentUser();
        return BeanUtils.isEmpty((Object)user) ? null : user.getFullname();
    }

    public static List<User> getCurrentUserUnder() throws Exception {
        String userId = ContextUtil.getCurrentUserId();
        UserManager userManager = (UserManager)AppUtil.getBean(UserManager.class);
        List<User> list = userManager.getUnderUsersByUserId(userId);
        return list;
    }

    public static IGroup getCurrentGroup() {
        try {
            ObjectNode orgObj;
            UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
            String userId = ContextUtil.getCurrentUserId();
            if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(orgObj = service.getMainGroup(userId)))) {
                boolean isParent = orgObj.get("isParent").asBoolean();
                orgObj.put("isIsParent", isParent ? 1 : 0);
                orgObj.remove("isParent");
                IGroup org = (IGroup)JsonUtil.toBean((JsonNode)orgObj, Org.class);
                return org;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return null;
    }

    public static String getCurrentGroupId() {
        IGroup iGroup = ContextUtil.getCurrentGroup();
        if (BeanUtils.isNotEmpty((Object)iGroup)) {
            return iGroup.getGroupId();
        }
        return "";
    }

    public static String getCurrentOrgId() {
        ObjectNode orgObj;
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        String userId = ContextUtil.getCurrentUserId();
        if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(orgObj = service.getMainGroup(userId)))) {
            String orgKind = orgObj.get("orgKind").asText();
            if (orgKind.equals("ogn")) {
                return orgObj.get("id").asText();
            }
            if (orgKind.equals("dept")) {
                return ContextUtil.getParentOrgAttr(orgObj.get("parentId").asText(), "id");
            }
        }
        return "";
    }

    public static String getCurrentOrgName() {
        ObjectNode orgObj;
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        String userId = ContextUtil.getCurrentUserId();
        if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(orgObj = service.getMainGroup(userId)))) {
            String orgKind = orgObj.get("orgKind").asText();
            if (orgKind.equals("ogn")) {
                return orgObj.get("name").asText();
            }
            if (orgKind.equals("dept")) {
                return ContextUtil.getParentOrgAttr(orgObj.get("parentId").asText(), "name");
            }
        }
        return "";
    }

    public static String getParentOrgAttr(String parentId, String attrName) {
        try {
            UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
            ObjectNode parentOrgObj = service.getOrgByIdOrCode(parentId);
            if (BeanUtils.isNotEmpty((Object)parentOrgObj)) {
                String orgKind = parentOrgObj.get("orgKind").asText();
                if (orgKind.equals("ogn")) {
                    return parentOrgObj.get(attrName).asText();
                }
                if (orgKind.equals("dept")) {
                    String parentOrgParentId = parentOrgObj.get("parentId").asText();
                    return ContextUtil.getParentOrgAttr(parentOrgParentId, attrName);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String getCurrentDeptId() {
        String orgKind;
        ObjectNode orgObj;
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        String userId = ContextUtil.getCurrentUserId();
        if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(orgObj = service.getMainGroup(userId))) && (orgKind = orgObj.get("orgKind").asText()).equals("dept")) {
            return orgObj.get("id").asText();
        }
        return "";
    }

    public static String getCurrentDeptName() {
        String orgKind;
        ObjectNode orgObj;
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        String userId = ContextUtil.getCurrentUserId();
        if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(orgObj = service.getMainGroup(userId))) && (orgKind = orgObj.get("orgKind").asText()).equals("dept")) {
            return orgObj.get("name").asText();
        }
        return "";
    }

    public static String getCurrentOrgFullId() {
        ObjectNode orgObj;
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        String userId = ContextUtil.getCurrentUserId();
        if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(orgObj = service.getMainGroup(userId)))) {
            String orgFullId = orgObj.get("path").asText();
            return orgFullId;
        }
        return "";
    }

    public static String getCurrentOrgAddvcd() {
        ObjectNode orgObj;
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        String userId = ContextUtil.getCurrentUserId();
        if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(orgObj = service.getMainGroup(userId))) && orgObj.has("addvcd")) {
            return orgObj.get("addvcd").asText();
        }
        return "";
    }

    public static String getCurrentOrgAddvcdName() {
        ObjectNode orgObj;
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        String userId = ContextUtil.getCurrentUserId();
        if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(orgObj = service.getMainGroup(userId))) && orgObj.has("addvcdName")) {
            return orgObj.get("addvcdName").asText();
        }
        return "";
    }

    public static String getCurrentOrgAddvcdFull() {
        ObjectNode orgObj;
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        String userId = ContextUtil.getCurrentUserId();
        if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(orgObj = service.getMainGroup(userId))) && orgObj.has("addvcdFull")) {
            return orgObj.get("addvcdFull").asText();
        }
        return "";
    }

    public static Locale getLocale() {
        return ContextUtil.contextUtil.currentContext.getLocale();
    }

    public static void clearCurrentUser() {
        if (contextUtil != null) {
            ContextUtil.contextUtil.currentContext.clearCurrentUser();
        }
    }

    public static void setCurrentUser(IUser user) {
        Assert.isTrue((boolean)BeanUtils.isNotEmpty((Object)user), (String)"\u4f20\u5165\u7684\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Assert.isNull((Object)authentication, (String)"\u5f53\u524d\u767b\u5f55\u4e0a\u4e0b\u6587\u4e2d\u6709\u767b\u5f55\u7528\u6237\u65f6\u4e0d\u80fd\u8bbe\u7f6e\u7528\u6237");
        UsernamePasswordAuthenticationToken usernamePwdAuth = new UsernamePasswordAuthenticationToken((Object)user, null);
        SecurityContextHolder.getContext().setAuthentication((Authentication)usernamePwdAuth);
    }

    public static IUser getUserByAccount(String account) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)account), (String)"\u5fc5\u987b\u4f20\u5165\u7528\u6237\u8d26\u53f7");
        IUserService userServiceImpl = (IUserService)AppUtil.getBean(IUserService.class);
        IUser user = userServiceImpl.getUserByAccount(account);
        Assert.isTrue((boolean)BeanUtils.isNotEmpty((Object)user), (String)String.format("\u8d26\u53f7\u4e3a\uff1a%s\u7684\u7528\u6237\u4e0d\u5b58\u5728", account));
        return user;
    }

    public static void setCurrentUserByAccount(String account) {
        ContextUtil.setCurrentUser(ContextUtil.getUserByAccount(account));
    }

    public static void setCurrentOrg(IGroup group) {
        ContextUtil.contextUtil.currentContext.setCurrentGroup(group);
    }

    public static void setLocale(Locale locale) {
        ContextUtil.contextUtil.currentContext.setLocale(locale);
    }

    public static void cleanLocale() {
        if (contextUtil != null) {
            ContextUtil.contextUtil.currentContext.clearLocale();
        }
    }

    public static void clearAll() {
        ContextUtil.cleanLocale();
        ContextUtil.clearCurrentUser();
    }
}

