/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.persistence.manager.impl;

import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.datasource.DatabaseSwitchResult;
import com.artfess.base.exception.BaseException;
import com.artfess.base.groovy.GroovyScriptEngine;
import com.artfess.base.manager.CommonManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.template.impl.FreeMarkerEngine;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FilterJsonStructUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.MapUtil;
import com.artfess.base.util.SQLUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.form.enums.FieldControlType;
import com.artfess.form.model.FormTemplate;
import com.artfess.form.model.QuerySqldef;
import com.artfess.form.model.QueryView;
import com.artfess.form.persistence.dao.QueryViewDao;
import com.artfess.form.persistence.manager.FormTemplateManager;
import com.artfess.form.persistence.manager.QuerySqldefManager;
import com.artfess.form.persistence.manager.QueryViewManager;
import com.artfess.form.util.FreeMakerUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.impl.util.PermissionCalc;
import com.artfess.uc.api.impl.var.IContextVar;
import com.artfess.uc.api.model.IUser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="queryViewManager")
public class QueryViewManagerImpl
extends BaseManagerImpl<QueryViewDao, QueryView>
implements QueryViewManager {
    private static final String LOGIN_USER = "loginUser";
    private static final String LOGIN_USER_ORGS = "loginUserOrgs";
    private static final String LOGIN_USER_SUB_ORGS = "loginUserSubOrgs";
    private static final String CUSTOM_ORGS = "customOrgs";
    @Resource
    QuerySqldefManager querySqldefManager;
    @Resource
    GroovyScriptEngine groovyScriptEngine;
    @Resource
    JdbcTemplate jdbcTemplate;
    @Resource(name="formPermissionCalc")
    PermissionCalc permssionCalc;
    @Resource
    DatabaseContext databaseContext;
    @Resource
    FreeMarkerEngine freemarkEngine;
    @Resource
    FormTemplateManager bpmFormTemplateManager;
    @Resource
    CommonManager commomManager;

    @Override
    public List<QueryView> getBySqlAlias(String sqlAlias) {
        return ((QueryViewDao)this.baseMapper).getBySqlAlias(sqlAlias);
    }

    @Override
    @Transactional
    public void removeBySqlAlias(String sqlAlias) {
        ((QueryViewDao)this.baseMapper).removeBySqlAlias(sqlAlias);
    }

    @Override
    public QueryView getBySqlAliasAndAlias(String sqlAlias, String alias) {
        return ((QueryViewDao)this.baseMapper).getBySqlAliasAndAlias(sqlAlias, alias);
    }

    @Override
    public QueryView getByAlias(String alias) {
        return ((QueryViewDao)this.baseMapper).getByAlias(alias);
    }

    @Override
    public boolean listByAlias(String alias) {
        List<QueryView> queryViews = ((QueryViewDao)this.baseMapper).listByAlias(alias);
        return queryViews.size() <= 1;
    }

    @Override
    public String getShowSql(QueryView queryView, Map<String, Object> queryParams) throws Exception {
        if (queryView.getFilterType() == 2) {
            return this.executeScript(queryView.getFilter(), queryParams);
        }
        QuerySqldef querySqldef = this.querySqldefManager.getByAlias(queryView.getSqlAlias());
        return querySqldef.getSql();
    }

    @Override
    public String getFilterSql(short filterType, String filterField, String dsName, Map<String, Object> param) throws IOException {
        StringBuffer sb = new StringBuffer();
        String sql = "";
        Map curProfiles = this.permssionCalc.getCurrentProfiles();
        List<Map<String, String>> filters = this.getFilterPermission(filterField, curProfiles);
        ArrayNode jsonArray = (ArrayNode)JsonUtil.toJsonNode((String)filterField);
        ObjectNode json = JsonUtil.arrayToObject((ArrayNode)jsonArray, (String)"key");
        if (BeanUtils.isEmpty(filters)) {
            return sb.toString();
        }
        for (Map<String, String> map : filters) {
            ObjectNode jsonObject = (ObjectNode)json.get(map.get("filterKey"));
            int type = JsonUtil.getInt((ObjectNode)jsonObject, (String)"type", (int)0);
            if (2 == type) {
                return this.executeScript(jsonObject.get("condition").asText(), param);
            }
            if (1 == type) {
                String dbType = this.databaseContext.getDbTypeByAlias(dsName);
                sql = FilterJsonStructUtil.getSql((String)JsonUtil.getString((JsonNode)jsonObject, (String)"condition"), (String)dbType);
            } else if (3 == type) {
                sql = this.executeScript(jsonObject.get("condition").asText(), param);
            } else if (4 == type) {
                sql = this.getDataPermissionSql(jsonObject.get("condition").asText());
            }
            if (!StringUtil.isNotEmpty((String)sql)) continue;
            if (4 != type) {
                sb.append(" AND ");
            }
            sb.append(sql);
        }
        return sb.toString();
    }

    private List<Map<String, String>> getFilterPermission(String filterField, Map<String, Set<String>> curProfiles) throws IOException {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        if (StringUtil.isEmpty((String)filterField)) {
            return list;
        }
        ArrayNode jsonAry = (ArrayNode)JsonUtil.toJsonNode((String)filterField);
        for (Object obj : jsonAry) {
            JsonNode permission;
            ObjectNode json = (ObjectNode)obj;
            ArrayNode rights = json.get("right").isArray() ? (ArrayNode)json.get("right") : (ArrayNode)JsonUtil.toJsonNode((String)json.get("right").asText());
            boolean hasRight = false;
            Iterator iterator = rights.iterator();
            while (iterator.hasNext() && !(hasRight = this.permssionCalc.hasRight((permission = (JsonNode)iterator.next()).toString(), curProfiles))) {
            }
            if (!hasRight) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", JsonUtil.getString((JsonNode)json, (String)"name", (String)""));
            map.put("filterKey", JsonUtil.getString((JsonNode)json, (String)"key", (String)""));
            list.add(map);
        }
        return list;
    }

    @Override
    public String getDataPermissionSql(String dataPermission) throws IOException {
        StringBuffer sb = new StringBuffer();
        if (StringUtil.isNotEmpty((String)dataPermission)) {
            ArrayNode permissionArrayJson = (ArrayNode)JsonUtil.toJsonNode((String)dataPermission);
            HashSet<String> orgIds = new HashSet<String>();
            IUser currentUser = ContextUtil.getCurrentUser();
            for (JsonNode node : permissionArrayJson) {
                String inSql;
                HashSet<String> oidSet;
                Object oids;
                if (!BeanUtils.isNotEmpty((Object)node.get("field"))) continue;
                if (LOGIN_USER.equals(node.get("type").asText())) {
                    sb.append(" AND " + node.get("field").asText() + "='" + currentUser.getUserId() + "'");
                    continue;
                }
                if (LOGIN_USER_ORGS.equals(node.get("type").asText())) {
                    String currentUserOrgIds = currentUser.getAttrbuite("CURRENT_USER_ORGIDS");
                    if (!StringUtil.isNotEmpty((String)currentUserOrgIds)) continue;
                    oids = currentUserOrgIds.split(",");
                    oidSet = new HashSet<String>(Arrays.asList(oids));
                    inSql = StringUtil.convertListToSingleQuotesString(oidSet);
                    sb.append(" AND " + node.get("field").asText() + " in (" + inSql + ")");
                    orgIds.addAll(oidSet);
                    continue;
                }
                if (LOGIN_USER_SUB_ORGS.equals(node.get("type").asText())) {
                    String currentUserSubOrgIds = AuthenticationUtil.getCurrentUserSubOrgIds();
                    if (!StringUtil.isNotEmpty((String)currentUserSubOrgIds)) continue;
                    oids = currentUserSubOrgIds.split(",");
                    oidSet = new HashSet<String>(Arrays.asList(oids));
                    inSql = StringUtil.convertListToSingleQuotesString(oidSet);
                    sb.append(" AND " + node.get("field").asText() + " in (" + inSql + ")");
                    orgIds.addAll(oidSet);
                    continue;
                }
                if (!CUSTOM_ORGS.equals(node.get("type").asText())) continue;
                ArrayNode tmpArray = (ArrayNode)node.get("orgs");
                for (JsonNode tmpJsonNode : tmpArray) {
                    orgIds.add(tmpJsonNode.get("id").asText());
                }
                String inSql2 = StringUtil.convertListToSingleQuotesString(orgIds);
                sb.append(" AND " + node.get("field").asText() + " in (" + inSql2 + ")");
            }
        }
        return sb.toString();
    }

    @Override
    public void handleTemplate(QueryView queryView) throws Exception {
        FormTemplate template = this.bpmFormTemplateManager.getByTemplateAlias(queryView.getTemplateAlias());
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        ArrayNode showsJA = (ArrayNode)JsonUtil.toJsonNode((String)queryView.getShows());
        ArrayNode buttonsJA = (ArrayNode)JsonUtil.toJsonNode((String)queryView.getButtons());
        ArrayList<ObjectNode> navButtons = new ArrayList<ObjectNode>();
        ArrayList<ObjectNode> rowButtons = new ArrayList<ObjectNode>();
        for (int i = 0; i < buttonsJA.size(); ++i) {
            ObjectNode temp = (ObjectNode)buttonsJA.get(i);
            if (JsonUtil.getString((JsonNode)temp, (String)"hidden", (String)"0").equals("1")) continue;
            if (JsonUtil.getString((JsonNode)temp, (String)"inRow", (String)"0").equals("0")) {
                navButtons.add(temp);
                continue;
            }
            rowButtons.add(temp);
        }
        boolean showSummary = false;
        String defSortField = "";
        String defSortSeq = "";
        for (int i = 0; i < showsJA.size(); ++i) {
            ObjectNode temp = (ObjectNode)showsJA.get(i);
            if (temp.get("defaultSort").asText().equals("1")) {
                defSortField = JsonUtil.getString((JsonNode)temp, (String)"fieldName");
                defSortSeq = JsonUtil.getString((JsonNode)temp, (String)"sortSeq");
                break;
            }
            if (showSummary || !BeanUtils.isNotEmpty((Object)temp.get("summaryType")) || !"sum".equals(temp.get("summaryType").asText())) continue;
            showSummary = true;
        }
        FreeMakerUtil freeMakerUtil = new FreeMakerUtil();
        paramMap.put("util", freeMakerUtil);
        paramMap.put("queryView", (Object)queryView);
        paramMap.put("showMap", JsonUtil.arrayToObject((ArrayNode)showsJA, (String)"fieldName"));
        paramMap.put("navButtons", navButtons);
        paramMap.put("rowButtons", rowButtons);
        paramMap.put("sortField", defSortField);
        paramMap.put("sortSeq", defSortSeq);
        paramMap.put("showSummary", showSummary);
        paramMap.put("isIndistinct", queryView.getIsIndistinct());
        paramMap.put("conditionAllName", queryView.getConditionAllName());
        paramMap.put("conditionAllDesc", "\u8bf7\u8f93\u5165\u5173\u952e\u5b57  " + queryView.getConditionAllDesc());
        String html = this.freemarkEngine.parseByStringTemplate(template.getHtml(), paramMap);
        queryView.setTemplate(html);
    }

    @Override
    public PageList getShowData(String sqlAlias, String alias, QueryFilter queryFilter, boolean getAll, boolean initSearch) throws Exception {
        QueryView queryView = this.getBySqlAliasAndAlias(sqlAlias, alias);
        QuerySqldef querySqldef = this.querySqldefManager.getByAlias(sqlAlias);
        Map queryParams = queryFilter.getParams();
        if (queryFilter.getQuerys().size() > 0) {
            String dbType;
            String[] split;
            JsonNode cdt = JsonUtil.toJsonNode((String)queryView.getConditions());
            if (BeanUtils.isNotEmpty((Object)cdt) && BeanUtils.isNotEmpty((Object)(split = cdt.get(0).get("name").asText().split("\\."))) && split.length == 2) {
                Object tableName = "";
                List list = queryFilter.getQuerys();
                block11: for (int i = 0; i < list.size(); ++i) {
                    QueryField qd = (QueryField)list.get(i);
                    Iterator queryCriteria = qd.getProperty();
                    for (JsonNode jsonNode : cdt) {
                        String name = jsonNode.get("name").asText().replace(".", "_");
                        if (!name.equals(queryCriteria)) continue;
                        String[] splitName = jsonNode.get("name").asText().split("\\.");
                        tableName = splitName[0];
                        String table = ((String)((Object)queryCriteria)).substring(0, ((String)tableName).length());
                        String fieldName = ((String)((Object)queryCriteria)).substring(((String)tableName).length() + 1, ((String)((Object)queryCriteria)).length());
                        qd.setProperty(table + "." + fieldName);
                        continue block11;
                    }
                }
            }
            if ("oracle".equals(dbType = SQLUtil.getDbType())) {
                for (JsonNode jsonNode : cdt) {
                    Object fieldName;
                    String dataType = jsonNode.get("dataType").asText();
                    if (FieldControlType.DATE.key.equals(dataType)) {
                        fieldName = jsonNode.get("fieldName").asText();
                        for (QueryField query : queryFilter.getQuerys()) {
                            if (!query.getProperty().equals(fieldName)) continue;
                            query.setProperty("TO_CHAR(" + query.getProperty() + ")");
                        }
                    }
                    if (!"clob".equals(dataType)) continue;
                    fieldName = jsonNode.get("fieldName").asText();
                    for (QueryField query : queryFilter.getQuerys()) {
                        if (!query.getProperty().equals(fieldName)) continue;
                        query.setProperty("TO_CHAR(" + query.getProperty() + ")");
                    }
                }
            } else if ("dm".equals(dbType)) {
                for (JsonNode node : cdt) {
                    String dataType = node.get("dataType").asText();
                    if (!"clob".equals(dataType)) continue;
                    for (QueryField query : queryFilter.getQuerys()) {
                        if (!query.getProperty().equals(node.get("fieldName").asText())) continue;
                        query.setProperty("TO_CHAR(" + query.getProperty() + ") ");
                    }
                }
            }
        }
        PageList pageList = new PageList();
        if (initSearch) {
            String showSql = "";
            if (StringUtil.isNotEmpty((String)queryView.getShows())) {
                for (int i = 0; i < JsonUtil.toJsonNode((String)queryView.getShows()).size(); ++i) {
                    showSql = JsonUtil.toJsonNode((String)queryView.getShows()).get(i).get("name").toString().indexOf(".") != -1 ? showSql + JsonUtil.toJsonNode((String)queryView.getShows()).get(i).get("name") + " as " + JsonUtil.toJsonNode((String)queryView.getShows()).get(i).get("fieldName") + "," : showSql + JsonUtil.toJsonNode((String)queryView.getShows()).get(i).get("name") + ",";
                }
                showSql = showSql.substring(0, showSql.length() - 1);
            }
            String sql = this.getShowSql(queryView, queryParams);
            if (StringUtil.isNotEmpty((String)showSql)) {
                if (sql.split("from").length > 1) {
                    int indexOf = sql.indexOf("from");
                    if (indexOf != -1) {
                        sql = "select " + showSql.replaceAll("\"", "") + " " + sql.substring(indexOf);
                    }
                } else {
                    int indexOf = sql.indexOf("FROM");
                    if (indexOf != -1) {
                        sql = "SELECT " + showSql.replaceAll("\"", "") + " " + sql.substring(indexOf);
                    }
                }
            }
            if (StringUtil.isNotEmpty((String)queryView.getShows())) {
                List sorter = queryFilter.getSorter();
                HashSet<String> frontSortAttr = new HashSet<String>();
                for (FieldSort fieldSort : sorter) {
                    frontSortAttr.add(fieldSort.getProperty());
                }
                ArrayNode jsonNode = (ArrayNode)JsonUtil.toJsonNode((String)queryView.getShows());
                for (JsonNode obj : jsonNode) {
                    ObjectNode objectNode = (ObjectNode)obj;
                    if (!objectNode.hasNonNull("defaultSort") || 1 != objectNode.get("defaultSort").asInt() || frontSortAttr.contains(objectNode.get("name").asText()) || !objectNode.hasNonNull("sortSeq") || !StringUtil.isNotEmpty((String)objectNode.get("sortSeq").asText())) continue;
                    sorter.add(new FieldSort(objectNode.get("name").asText(), Direction.fromString((String)objectNode.get("sortSeq").asText().toUpperCase())));
                }
            }
            String filterSql = this.getFilterSql(queryView.getFilterType(), queryView.getFilter(), querySqldef.getDsName(), queryParams);
            queryFilter.withParam("filterSql", (Object)filterSql);
            try (DatabaseSwitchResult dResult = this.databaseContext.setDataSource(querySqldef.getDsName());){
                if (queryView.getNeedPage() == 0 || getAll) {
                    queryFilter.setPageBean(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
                }
                pageList = this.commomManager.queryByCustomSql(sql, queryFilter);
                this.handleShowData(queryView, pageList.getRows());
            }
            catch (Exception e) {
                throw new BaseException(e.getMessage(), (Throwable)e);
            }
        }
        return pageList;
    }

    private String executeScript(String script, Map<String, Object> param) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("param", param);
        vars.putAll(param);
        String str = this.groovyScriptEngine.executeString(this.replaceVar(script), vars);
        return str;
    }

    private String replaceVar(String str) {
        List comVarList = (List)AppUtil.getBean((String)"queryViewComVarList");
        for (IContextVar c : comVarList) {
            str = str.replace("[" + c.getAlias() + "]", c.getValue());
        }
        return "return \"" + str + "\" ;";
    }

    public void handleShowData(QueryView queryView, List list) throws IOException {
        ArrayNode showJA = (ArrayNode)JsonUtil.toJsonNode((String)queryView.getShows());
        HashMap<String, Map<String, Object>> cacheMap = new HashMap<String, Map<String, Object>>();
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            HashMap<String, String> tmp = new HashMap<String, String>();
            for (int j = 0; j < showJA.size(); ++j) {
                ObjectNode jo = (ObjectNode)showJA.get(j);
                String fieldName = jo.get("fieldName").asText();
                if (BeanUtils.isNotEmpty((Object)MapUtil.getIgnoreCase((Map)map, (String)fieldName, (Object)""))) {
                    tmp.put(fieldName, MapUtil.getIgnoreCase((Map)map, (String)fieldName, (Object)"").toString());
                } else {
                    tmp.put(fieldName, "");
                }
                if (JsonUtil.getString((JsonNode)jo, (String)"isVirtual", (String)"0").equals("0")) continue;
                String con = MapUtil.getIgnoreCase((Map)map, (String)jo.get("virtualFrom").asText()) + "";
                String str = jo.get("resultFrom").asText().replace("#CON#", con);
                Object val = this.getValFromCache(cacheMap, fieldName, con);
                if (BeanUtils.isEmpty((Object)val)) {
                    if (jo.get("resultFromType").asText().equals("script")) {
                        val = this.groovyScriptEngine.executeString(str, new HashMap());
                    } else if (jo.get("resultFromType").asText().equals("sql")) {
                        try {
                            Map m = this.jdbcTemplate.queryForMap(str);
                            Iterator iterator = m.keySet().iterator();
                            if (iterator.hasNext()) {
                                String k = (String)iterator.next();
                                val = m.get(k);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            val = "";
                        }
                    }
                    this.putValToCache(cacheMap, fieldName, con, val);
                }
                tmp.put(fieldName, val.toString());
            }
            list.set(i, tmp);
        }
    }

    private Object getValFromCache(Map<String, Map<String, Object>> cacheMap, String fieldName, String key) {
        Map<String, Object> map = cacheMap.get(fieldName);
        if (BeanUtils.isEmpty(map)) {
            return null;
        }
        return map.get(key);
    }

    private void putValToCache(Map<String, Map<String, Object>> cacheMap, String fieldName, String key, Object val) {
        Map<String, Object> map = cacheMap.get(fieldName);
        if (BeanUtils.isEmpty(map)) {
            map = new HashMap<String, Object>();
            cacheMap.put(fieldName, map);
        }
        map.put(key, val);
    }
}

