/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.jdbc;

import com.alibaba.druid.pool.DruidDataSource;
import com.artfess.base.datasource.impl.DefaultDatabaseContext;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.jdbc.JdbcDao;
import com.artfess.base.util.AppUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="JdbcDaoImpl")
public class JdbcDaoImpl
implements JdbcDao {
    private static final Logger log = LoggerFactory.getLogger(JdbcDaoImpl.class);
    private static Map<String, DruidDataSource> JdbcDruidDataSource = new HashMap<String, DruidDataSource>();

    @Override
    public JdbcTemplate initJdbcTemplate(String alias) {
        JdbcTemplate jdbcTemplate;
        try {
            if (StringUtils.isEmpty((CharSequence)alias)) {
                throw new ApplicationException("\u521b\u5efa\u5c5e\u6027\u4e0d\u80fd\u7a7a");
            }
            if (JdbcDruidDataSource.containsKey(alias)) {
                DruidDataSource druidDataSource = JdbcDruidDataSource.get(alias);
                jdbcTemplate = new JdbcTemplate((DataSource)druidDataSource);
            } else {
                DefaultDatabaseContext context = AppUtil.getBean(DefaultDatabaseContext.class);
                DruidDataSource druidDataSource = (DruidDataSource)context.getDataSourceByAlias(alias);
                jdbcTemplate = new JdbcTemplate((DataSource)druidDataSource);
                JdbcDruidDataSource.put(alias, druidDataSource);
            }
        }
        catch (Exception e) {
            throw new ApplicationException("\u521b\u5efa\u8fde\u63a5\u5931\u8d25");
        }
        return jdbcTemplate;
    }

    @Override
    public boolean checkConnection(String alias, String url, String userName, String pwd, String driver) {
        boolean isConnection = false;
        Connection con = null;
        try {
            Class.forName(driver);
            System.out.println("\u6570\u636e\u5e93\u9a71\u52a8\u52a0\u8f7d\u6210\u529f");
        }
        catch (ClassNotFoundException e) {
            log.error("\u6570\u636e\u5e93\u9a71\u52a8\u52a0\u8f7d\u5931\u8d25", (Object)e.getMessage());
        }
        try {
            con = DriverManager.getConnection(url, userName, pwd);
            isConnection = true;
            System.out.println("\u6570\u636e\u5e93\u8fde\u63a5\u6210\u529f");
        }
        catch (SQLException e) {
            log.error("\u6570\u636e\u5e93\u94fe\u63a5\u5931\u8d25", (Object)e.getMessage());
            if (JdbcDruidDataSource.containsKey(alias)) {
                JdbcDruidDataSource.get(alias).close();
            }
            throw new ApplicationException("\u6570\u636e\u5e93\u94fe\u63a5\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e1) {
                    log.error(e1.getMessage(), (Throwable)e1);
                }
            }
        }
        return isConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCache(String key) {
        DruidDataSource druidDataSource = JdbcDruidDataSource.get(key);
        try {
            if (druidDataSource != null && !druidDataSource.isClosed()) {
                druidDataSource.getConnection().commit();
                druidDataSource.getConnection().close();
                druidDataSource.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            JdbcDruidDataSource.remove(key);
        }
    }

    @Override
    public DataSource getDataSource(JdbcTemplate jdbcTemplate) {
        return jdbcTemplate.getDataSource();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void batchUpdate(JdbcTemplate jdbcTemplate, String[] sql) throws ApplicationException {
        jdbcTemplate.batchUpdate(sql);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public int[] batchUpdateData(JdbcTemplate jdbcTemplate, String sql, final List<Object[]> dataSet) throws ApplicationException {
        return jdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                Object[] objArr = (Object[])dataSet.get(i);
                for (int j = 0; j < objArr.length; ++j) {
                    if (objArr[j] != null && "null".equalsIgnoreCase(objArr[j].toString())) {
                        ps.setString(j + 1, "");
                        continue;
                    }
                    ps.setObject(j + 1, objArr[j]);
                }
            }

            public int getBatchSize() {
                return dataSet.size();
            }
        });
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void batchUpdate(JdbcTemplate jdbcTemplate, String sql, List<Object[]> dataSet) throws ApplicationException {
        this.a(sql, dataSet);
        jdbcTemplate.batchUpdate(new String[]{sql});
    }

    private String a(String sql, List<Object[]> dataSet) throws ApplicationException {
        String str = "";
        if (dataSet != null) {
            Object[] arrayOfObject2 = null;
            for (Object[] arrayOfObject2 : dataSet) {
            }
        } else {
            log.info(sql);
        }
        return str;
    }
}

