/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.application.config;

import com.artfess.activemq.model.JmsTableTypeConf;
import com.artfess.activemq.model.JmsTableTypeFiledDetail;
import com.artfess.application.jms.JmsHandler;
import com.artfess.application.jms.JmsMessageConsumer;
import com.artfess.application.jms.impl.DingTalkHandler;
import com.artfess.application.jms.impl.InnerHandler;
import com.artfess.application.jms.impl.MailHandler;
import com.artfess.application.jms.impl.SmsHandler;
import com.artfess.application.jms.impl.VoiceHandler;
import com.artfess.application.jms.impl.WxEnterpriseHandler;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class JmsHandlerConfig {
    @Resource
    MailHandler mailHandler;
    @Resource
    InnerHandler innerHandler;
    @Resource
    SmsHandler smsHandler;
    @Resource
    VoiceHandler voiceHandler;
    @Resource
    WxEnterpriseHandler wxEnterpriseHandler;
    @Resource
    DingTalkHandler dingTalkHandler;

    @Bean
    public List<JmsHandler> jmsHandList() {
        ArrayList<JmsHandler> list = new ArrayList<JmsHandler>();
        list.add(this.innerHandler);
        list.add(this.mailHandler);
        list.add(this.smsHandler);
        list.add(this.voiceHandler);
        list.add(this.wxEnterpriseHandler);
        list.add(this.dingTalkHandler);
        return list;
    }

    @Bean
    @ConditionalOnProperty(value={"jms.enable"}, matchIfMissing=true)
    public JmsMessageConsumer messageConsumer(List<JmsHandler> jmsHandList) {
        JmsMessageConsumer jmsReceiverEventListener = new JmsMessageConsumer();
        jmsReceiverEventListener.setJmsHandList(jmsHandList);
        return jmsReceiverEventListener;
    }

    @Bean(value={"portalTableTypeConf"})
    public JmsTableTypeConf TableTypeConf() {
        JmsTableTypeConf.AddTypeConf((String)"FILE_TYPE", (JmsTableTypeFiledDetail)new JmsTableTypeFiledDetail("portal_sys_file", "ID_", "", "TYPE_"));
        return null;
    }
}

