/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bo.instance.impl;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.bo.instance.BoDataHandler;
import com.artfess.bo.model.BoAttribute;
import com.artfess.bo.model.BoData;
import com.artfess.bo.model.BoDef;
import com.artfess.bo.model.BoEnt;
import com.artfess.bo.model.BoResult;
import com.artfess.bo.persistence.manager.BoDefManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

public abstract class AbstractBoDataHandler
implements BoDataHandler {
    @Resource
    BoDefManager boDefManager;

    public void setBoDefAlias(List<BoResult> resultList, String bodefAlias) {
        for (BoResult result : resultList) {
            result.setBoAlias(bodefAlias);
        }
    }

    @Override
    public BoData getByBoDefAlias(String bodefAlias) {
        BoDef boDef = this.boDefManager.getByAlias(bodefAlias);
        if (BeanUtils.isEmpty((Object)((Object)boDef))) {
            return null;
        }
        BoData boData = new BoData();
        boData.setBoDef(boDef);
        BoEnt boEnt = boDef.getBoEnt();
        Map<String, Object> row = this.getMapByBOEnt(boEnt);
        boData.setData(row);
        this.getCascadeByEnt(boEnt, boData);
        return boData;
    }

    public Map<String, Object> getMapByBOEnt(BoEnt boEnt) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<BoAttribute> list = boEnt.getBoAttrList();
        for (BoAttribute attr : list) {
            String val = attr.getDefaultValue();
            if (StringUtil.isEmpty((String)val)) {
                val = "";
            }
            map.put(attr.getName(), val);
        }
        return map;
    }

    private void getCascadeByEnt(BoEnt boEnt, BoData boData) {
        List<BoEnt> childEntList = boEnt.getChildEntList();
        if (BeanUtils.isEmpty(childEntList)) {
            return;
        }
        for (BoEnt childEnt : childEntList) {
            String key = childEnt.getName();
            if ("main".equals(boEnt.getType())) {
                boData.addInitDataMap(key, childEnt.getInitData());
                boData.setSubList(key, new ArrayList<BoData>());
            } else {
                Map<String, Object> subInitMap = boData.getInitDataMap().get(boEnt.getName());
                Map<String, Map<String, Object>> subInitDataMap = new HashMap<String, Map<String, Object>>();
                if (BeanUtils.isNotEmpty(subInitMap) && subInitMap.containsKey("initData")) {
                    subInitDataMap = (Map)subInitMap.get("initData");
                }
                subInitDataMap.put(childEnt.getName(), childEnt.getInitData());
                HashMap<String, Cloneable> subboEntMap = new HashMap<String, Cloneable>();
                subboEntMap.put("initData", (Cloneable)((Object)subInitDataMap));
                subboEntMap.put("sub_" + childEnt.getName(), new ArrayList());
                boData.getInitDataMap().get(boEnt.getName()).putAll(subboEntMap);
            }
            this.getCascadeByEnt(childEnt, boData);
        }
    }

    @Override
    public BoData getByBoDefCode(String bodefCode) {
        BoDef boDef = this.boDefManager.getByAlias(bodefCode);
        BoData boData = new BoData();
        boData.setBoDef(boDef);
        boData.setBoDefAlias(boDef.getAlias());
        BoEnt boEnt = boDef.getBoEnt();
        Map<String, Object> row = this.getMapByBOEnt(boEnt);
        boData.setData(row);
        this.getCascadeByEnt(boEnt, boData);
        return boData;
    }
}

