/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataShare.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.dataShare.dataShare.dao.BizShareCatalogsDao;
import com.artfess.dataShare.dataShare.manager.BizShareCatalogsManager;
import com.artfess.dataShare.dataShare.manager.BizShareTableManager;
import com.artfess.dataShare.dataShare.model.BizShareCatalogs;
import com.artfess.dataShare.dataShare.model.BizShareTable;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizShareCatalogsManagerImpl
extends BaseManagerImpl<BizShareCatalogsDao, BizShareCatalogs>
implements BizShareCatalogsManager {
    @Resource
    private BizShareTableManager tableManager;

    @Override
    @Transactional
    public String upTree(BizShareCatalogs shareCatalogs) {
        if (!this.validateCatalog(shareCatalogs)) {
            throw new ApplicationException("\u76ee\u5f55\u540d\u5b57\u3010" + shareCatalogs.getName() + "\u3011\u6216\u76ee\u5f55\u7f16\u53f7\u3010" + shareCatalogs.getCode() + "\u3011\u91cd\u590d\uff01");
        }
        BizShareCatalogs old = (BizShareCatalogs)this.get((Serializable)((Object)shareCatalogs.getId()));
        shareCatalogs.setHasChildren(old.getHasChildren());
        shareCatalogs.setIsDele(old.getIsDele());
        return this.updateTree(shareCatalogs, old.getName());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteById(String id) {
        BizShareCatalogs shareCatalogs = (BizShareCatalogs)this.get((Serializable)((Object)id));
        Integer count = this.getHasChildren(shareCatalogs);
        Assert.state((count == 0 ? 1 : 0) != 0, (String)"\u8be5\u76ee\u5f55\u4e0b\u6709\u5b50\u76ee\u5f55\uff0c\u5220\u9664\u5931\u8d25");
        int tableCount = this.tableManager.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizShareTable::getIsDele, (Object)"0")).eq(BizShareTable::getCatalogId, (Object)id));
        if (tableCount > 0) {
            throw new ApplicationException("\u8be5\u76ee\u5f55\u4e0b\u6709\u8d44\u6e90\u7ba1\u7406\uff0c\u5220\u9664\u5931\u8d25\uff01");
        }
        boolean result = this.removeById((Serializable)((Object)id));
        if (result) {
            this.refreshHasChildren(shareCatalogs);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean removeTree(String id, String parentId) {
        boolean result = false;
        BizShareCatalogs oldCatalog = (BizShareCatalogs)this.get((Serializable)((Object)id));
        BizShareCatalogs oldParent = (BizShareCatalogs)this.get((Serializable)((Object)oldCatalog.getParentId()));
        BizShareCatalogs newCatalog = (BizShareCatalogs)this.get((Serializable)((Object)id));
        newCatalog.setParentId(parentId);
        if (!this.validateCatalog(newCatalog)) {
            throw new ApplicationException("\u76ee\u5f55\u540d\u5b57\u3010" + newCatalog.getName() + "\u3011\u6216\u76ee\u5f55\u7f16\u53f7\u3010" + newCatalog.getCode() + "\u3011\u91cd\u590d\uff01");
        }
        BizShareCatalogs newParent = (BizShareCatalogs)this.get((Serializable)((Object)parentId));
        newCatalog.buildFullIdAndName(newParent);
        List children = ((BizShareCatalogsDao)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizShareCatalogs::getIsDele, (Object)"0")).eq(BizShareCatalogs::getParentId, (Object)newCatalog.getId()));
        for (BizShareCatalogs child : children) {
            child.buildFullIdAndName(newCatalog);
            this.updateById((Object)child);
        }
        if (this.updateTree(newCatalog, oldCatalog.getName()) != null) {
            oldParent.setHasChildren(oldParent.getHasChildren() - 1);
            result = this.updateById((Object)oldParent);
        }
        return result;
    }

    @Override
    public String saveTree(BizShareCatalogs shareCatalogs) {
        if (!this.validateCatalog(shareCatalogs)) {
            throw new ApplicationException("\u76ee\u5f55\u540d\u5b57\u3010" + shareCatalogs.getName() + "\u3011\u6216\u76ee\u5f55\u7f16\u53f7\u3010" + shareCatalogs.getCode() + "\u3011\u91cd\u590d\uff01");
        }
        return this.insertTree(shareCatalogs);
    }

    private boolean validateCatalog(BizShareCatalogs serviceCatalogs) {
        int count;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BizShareCatalogs::getParentId, (Object)serviceCatalogs.getParentId());
        queryWrapper.and(w -> ((LambdaQueryWrapper)((LambdaQueryWrapper)w.eq(BizShareCatalogs::getName, (Object)serviceCatalogs.getName())).or()).eq(BizShareCatalogs::getCode, (Object)serviceCatalogs.getCode()));
        if (BeanUtils.isNotEmpty((Object)serviceCatalogs.getId())) {
            queryWrapper.ne(BizShareCatalogs::getId, (Object)serviceCatalogs.getId());
        }
        return (count = this.count((Wrapper)queryWrapper)) <= 0;
    }

    @Transactional(rollbackFor={Exception.class})
    public void refreshHasChildren(BizShareCatalogs shareCatalogs) {
        BizShareCatalogs parent = (BizShareCatalogs)this.get((Serializable)((Object)shareCatalogs.getParentId()));
        if (parent == null) {
            return;
        }
        Integer hasChildren = this.getHasChildren(parent);
        parent.setHasChildren(hasChildren);
        this.update((Model)parent);
        this.refreshHasChildren(parent);
    }

    private Integer getHasChildren(BizShareCatalogs shareCatalogs) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BizShareCatalogs::getParentId, (Object)shareCatalogs.getId());
        Integer count = ((BizShareCatalogsDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
        return count;
    }
}

