/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataApi.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.dataShare.dataApi.dao.BizServiceCatalogsDao;
import com.artfess.dataShare.dataApi.manager.BizServiceApiManager;
import com.artfess.dataShare.dataApi.manager.BizServiceCatalogsManager;
import com.artfess.dataShare.dataApi.model.BizServiceApi;
import com.artfess.dataShare.dataApi.model.BizServiceCatalogs;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizServiceCatalogsManagerImpl
extends BaseManagerImpl<BizServiceCatalogsDao, BizServiceCatalogs>
implements BizServiceCatalogsManager {
    @Resource
    private BizServiceApiManager serviceApiManager;

    @Override
    @Transactional
    public String upTree(BizServiceCatalogs serviceCatalogs) {
        if (!this.validateCatalog(serviceCatalogs)) {
            throw new ApplicationException("\u76ee\u5f55\u540d\u5b57\u3010" + serviceCatalogs.getName() + "\u3011\u6216\u76ee\u5f55\u7f16\u53f7\u3010" + serviceCatalogs.getCode() + "\u3011\u91cd\u590d\uff01");
        }
        BizServiceCatalogs old = (BizServiceCatalogs)this.get((Serializable)((Object)serviceCatalogs.getId()));
        serviceCatalogs.setHasChildren(old.getHasChildren());
        serviceCatalogs.setIsDele(old.getIsDele());
        return this.updateTree(serviceCatalogs, old.getName());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteById(String id) {
        BizServiceCatalogs bizServiceCatalogs = (BizServiceCatalogs)this.get((Serializable)((Object)id));
        Integer count = this.getHasChildren(bizServiceCatalogs);
        Assert.state((count == 0 ? 1 : 0) != 0, (String)"\u8be5\u76ee\u5f55\u4e0b\u6709\u5b50\u76ee\u5f55\uff0c\u5220\u9664\u5931\u8d25");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BizServiceApi::getCatalogId, (Object)id);
        int apiCount = this.serviceApiManager.count((Wrapper)queryWrapper);
        if (apiCount > 0) {
            throw new ApplicationException("\u8be5\u76ee\u5f55\u4e0b\u6709\u63a5\u53e3\u7ba1\u7406\uff0c\u5220\u9664\u5931\u8d25\uff01");
        }
        boolean result = this.removeById((Serializable)((Object)id));
        if (result) {
            this.refreshHasChildren(bizServiceCatalogs);
        }
        return result;
    }

    @Override
    public String saveTree(BizServiceCatalogs serviceCatalogs) {
        if (!this.validateCatalog(serviceCatalogs)) {
            throw new ApplicationException("\u76ee\u5f55\u540d\u5b57\u3010" + serviceCatalogs.getName() + "\u3011\u6216\u76ee\u5f55\u7f16\u53f7\u3010" + serviceCatalogs.getCode() + "\u3011\u91cd\u590d\uff01");
        }
        return this.insertTree(serviceCatalogs);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean removeTree(String id, String parentId) {
        boolean result = false;
        BizServiceCatalogs oldCatalog = (BizServiceCatalogs)this.get((Serializable)((Object)id));
        BizServiceCatalogs oldParent = (BizServiceCatalogs)this.get((Serializable)((Object)oldCatalog.getParentId()));
        BizServiceCatalogs newCatalog = (BizServiceCatalogs)this.get((Serializable)((Object)id));
        newCatalog.setParentId(parentId);
        if (!this.validateCatalog(newCatalog)) {
            throw new ApplicationException("\u76ee\u5f55\u540d\u5b57\u3010" + newCatalog.getName() + "\u3011\u6216\u76ee\u5f55\u7f16\u53f7\u3010" + newCatalog.getCode() + "\u3011\u91cd\u590d\uff01");
        }
        BizServiceCatalogs newParent = (BizServiceCatalogs)this.get((Serializable)((Object)parentId));
        newCatalog.buildFullIdAndName(newParent);
        List children = ((BizServiceCatalogsDao)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizServiceCatalogs::getIsDele, (Object)"0")).eq(BizServiceCatalogs::getParentId, (Object)newCatalog.getId()));
        for (BizServiceCatalogs child : children) {
            child.buildFullIdAndName(newCatalog);
            this.updateById((Object)child);
        }
        if (this.updateTree(newCatalog, oldCatalog.getName()) != null) {
            oldParent.setHasChildren(oldParent.getHasChildren() - 1);
            result = this.updateById((Object)oldParent);
        }
        return result;
    }

    private boolean validateCatalog(BizServiceCatalogs serviceCatalogs) {
        int count;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BizServiceCatalogs::getParentId, (Object)serviceCatalogs.getParentId());
        queryWrapper.and(w -> ((LambdaQueryWrapper)((LambdaQueryWrapper)w.eq(BizServiceCatalogs::getName, (Object)serviceCatalogs.getName())).or()).eq(BizServiceCatalogs::getCode, (Object)serviceCatalogs.getCode()));
        if (BeanUtils.isNotEmpty((Object)serviceCatalogs.getId())) {
            queryWrapper.ne(BizServiceCatalogs::getId, (Object)serviceCatalogs.getId());
        }
        return (count = this.count((Wrapper)queryWrapper)) <= 0;
    }

    @Transactional(rollbackFor={Exception.class})
    public void refreshHasChildren(BizServiceCatalogs bizServiceCatalogs) {
        BizServiceCatalogs parent = (BizServiceCatalogs)this.get((Serializable)((Object)bizServiceCatalogs.getParentId()));
        if (parent == null) {
            return;
        }
        Integer hasChildren = this.getHasChildren(parent);
        parent.setHasChildren(hasChildren);
        this.update((Model)parent);
        this.refreshHasChildren(parent);
    }

    private Integer getHasChildren(BizServiceCatalogs bizServiceCatalogs) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BizServiceCatalogs::getParentId, (Object)bizServiceCatalogs.getId());
        Integer count = ((BizServiceCatalogsDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
        return count;
    }
}

