/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataCollect.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.dataShare.dataCollect.manager.BizClusterInfoManager;
import com.artfess.dataShare.dataCollect.manager.BizClusterInfoModeManager;
import com.artfess.dataShare.dataCollect.model.BizClusterInfo;
import com.artfess.dataShare.dataCollect.model.BizClusterInfoMode;
import com.artfess.dataShare.dataCollect.vo.BizClusterInfoVo;
import com.artfess.dataShare.dataCollect.vo.checkUserExistsVo;
import com.artfess.poi.util.ExcelUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/biz/dataCollect/clusterInfo/v1/"})
@Api(tags={"\u6570\u636e\u6c47\u805a-\u6570\u636e\u6c47\u805a\u65b9\u4fe1\u606f\u7ba1\u7406"})
@ApiGroup(group={"group_biz_dataShare"})
public class BizClusterInfoController
extends BaseController<BizClusterInfoManager, BizClusterInfo> {
    @Resource
    BizClusterInfoManager clusterInfoService;
    @Resource
    BizClusterInfoModeManager clusterInfoModeManager;

    @RequestMapping(value={"saveClusterInfo"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6570\u636e\u6c47\u805a\u65b9\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u6570\u636e\u6c47\u805a\u65b9\u4fe1\u606f")
    public CommonResult<String> saveClusterInfo(@ApiParam(name="role", value="\u6570\u636e\u6c47\u805a\u65b9\u4fe1\u606f\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody BizClusterInfoVo role) throws Exception {
        if (role.getIsDatabase().equals("1") && StringUtil.isEmpty((String)role.getDatabaseAlias())) {
            throw new ApplicationException("\u8bf7\u9009\u62e9\u4ea4\u6362\u6570\u636e\u6e90");
        }
        boolean exists = true;
        if (role.getIsDatabase().equals("1") && StringUtil.isEmpty((String)role.getId())) {
            exists = this.clusterInfoService.checkUserExists(role.getDatabaseAlias(), role.getDatabaseUser());
        }
        if (!exists) {
            return new CommonResult(false, "\u521b\u5efa\u7528\u6237\u3010" + role.getDatabaseUser() + "\u3011\u5df2\u7ecf\u5b58\u5728\u4e0d\u53ef\u4ee5\u521b\u5efa\uff01", (Object)"");
        }
        CommonResult<String> rtn = this.clusterInfoService.saveClusterInfo(role);
        return rtn;
    }

    @RequestMapping(value={"queryClusterInfo/{id}"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u6570\u636e\u6c47\u805a\u65b9\u4fe1\u606f", httpMethod="POST", notes="\u6839\u636eID\u67e5\u8be2\u6570\u636e\u6c47\u805a\u65b9\u4fe1\u606f")
    public BizClusterInfoVo queryClusterInfo(@ApiParam(name="id", value="\u6c47\u805a\u65b9ID", required=true) @PathVariable String id) throws Exception {
        BizClusterInfoVo vo = this.clusterInfoService.queryClusterInfo(id);
        return vo;
    }

    @RequestMapping(value={"checkUserExists"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9a8c\u8bc1\u521b\u5efa\u7684\u7528\u6237\u662f\u5426\u5b58\u5728", httpMethod="POST", notes="\u9a8c\u8bc1\u521b\u5efa\u7684\u7528\u6237\u662f\u5426\u5b58\u5728")
    public CommonResult<String> checkUserExists(@RequestBody checkUserExistsVo vo) throws Exception {
        boolean exists = this.clusterInfoService.checkUserExists(vo.getDbAlias(), vo.getUser());
        if (!exists) {
            return new CommonResult(false, "\u7528\u6237\u5df2\u7ecf\u5b58\u5728\u4e0d\u53ef\u4ee5\u521b\u5efa\uff01", (Object)"");
        }
        return new CommonResult(true, "\u9a8c\u8bc1\u6210\u529f\uff0c\u7528\u6237\u53ef\u4ee5\u521b\u5efa\uff01", (Object)"");
    }

    @RequestMapping(value={"downClusterInfo/{id}"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e0b\u8f7d\u94fe\u63a5\u6587\u4ef6", httpMethod="GET", notes="\u4e0b\u8f7d\u94fe\u63a5\u6587\u4ef6")
    public void saveClusterInfo(HttpServletResponse response, @ApiParam(name="id", value="\u6570\u636e\u6c47\u805a\u65b9\u4fe1\u606f\u53c2\u6570\u5bf9\u8c61", required=true) @PathVariable String id) throws Exception {
        BizClusterInfoMode info = (BizClusterInfoMode)((Object)this.clusterInfoModeManager.getById((Serializable)((Object)id)));
        ArrayList<Map> listMap = new ArrayList<Map>();
        listMap.add(JsonUtil.toMap((String)JsonUtil.toJson((Object)((Object)info))));
        LinkedHashMap<String, String> exportMap = new LinkedHashMap<String, String>();
        exportMap.put("databaseName", "\u5206\u914d\u6570\u636e\u5e93\u5b9e\u4f8b\u7684\u540d\u79f0");
        exportMap.put("databaseUser", "\u5206\u914d\u6570\u636e\u5e93\u7528\u6237");
        exportMap.put("databasePwd", "\u5206\u914d\u6570\u636e\u5e93\u5bc6\u7801");
        exportMap.put("databaseUrl", "\u5206\u914d\u6570\u636e\u5e93\u5730\u5740");
        exportMap.put("ak", "\u5206\u914d\u6570\u636e\u5e93\u5730\u5740");
        ArrayList<BizClusterInfoMode> list = new ArrayList<BizClusterInfoMode>();
        list.add(info);
        HSSFWorkbook exportFile = ExcelUtil.exportExcel((String)"\u6570\u636e\u5e93\u94fe\u63a5\u6587\u4ef6", (int)22, exportMap, listMap);
        ExcelUtil.downloadExcel((HSSFWorkbook)exportFile, (String)"\u6570\u636e\u5e93\u94fe\u63a5\u6587\u4ef6", (HttpServletResponse)response);
    }
}

