/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.algorithm.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.dataShare.algorithm.dao.BizAlgorithmVersionDao;
import com.artfess.dataShare.algorithm.manager.BizAlgorithmReasonManager;
import com.artfess.dataShare.algorithm.manager.BizAlgorithmRelationManager;
import com.artfess.dataShare.algorithm.manager.BizAlgorithmVersionManager;
import com.artfess.dataShare.algorithm.model.BizAlgorithmReason;
import com.artfess.dataShare.algorithm.model.BizAlgorithmVersion;
import com.artfess.dataShare.algorithm.vo.TaskVersionVo;
import com.artfess.dataShare.util.YouBianCodeUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizAlgorithmVersionManagerImpl
extends BaseManagerImpl<BizAlgorithmVersionDao, BizAlgorithmVersion>
implements BizAlgorithmVersionManager {
    @Resource
    BizAlgorithmReasonManager reasonManager;
    @Resource
    BizAlgorithmRelationManager relationManager;
    @Resource
    BizAlgorithmVersionDao versionDao;

    @Override
    @Transactional
    public void saveTaskVersion(TaskVersionVo vo) throws Exception {
        BizAlgorithmVersion version = vo.getVersion();
        if (1 == vo.getSaveAS()) {
            List<BizAlgorithmReason> reasons = this.reasonManager.queryByVersionId(version.getId());
            String newId = UniqueIdUtil.getSuid();
            version.setId(newId);
            this.save((Object)version);
            HashMap<String, String> idMaps = new HashMap<String, String>();
            for (BizAlgorithmReason item : reasons) {
                String oldId = item.getId();
                item.setId(null);
                item.setTaskVersonId(newId);
                if (null != idMaps.get(item.getParentId())) {
                    item.setParentId((String)idMaps.get(item.getParentId()));
                } else {
                    item.setParentId("-1");
                }
                this.reasonManager.saveReason(item);
                idMaps.put(oldId, item.getId());
            }
        } else if (null == version) {
            List<BizAlgorithmReason> reasons = vo.getReasonList();
            for (BizAlgorithmReason item : reasons) {
                this.reasonManager.saveReason(item);
            }
        } else {
            this.saveOrUpdate((Object)version);
            String versionId = version.getId();
            String taskId = version.getTaskId();
            List<BizAlgorithmReason> reasons = vo.getReasonList();
            for (BizAlgorithmReason item : reasons) {
                item.setTaskId(taskId);
                item.setTaskVersonId(versionId);
                this.reasonManager.saveReason(item);
            }
        }
    }

    @Override
    public TaskVersionVo queryVersion(String id) throws Exception {
        BizAlgorithmVersion version = (BizAlgorithmVersion)((Object)this.getById((Serializable)((Object)id)));
        List<BizAlgorithmReason> reasons = this.reasonManager.queryByVersionId(id);
        TaskVersionVo vo = new TaskVersionVo();
        vo.setVersion(version);
        vo.setReasonList(reasons);
        return vo;
    }

    @Override
    public String getNewVersionCode(String id) throws Exception {
        String maxVersionCode = this.versionDao.getMaxVersionCode(id);
        if (StringUtil.isEmpty((String)maxVersionCode)) {
            return "1.0";
        }
        return YouBianCodeUtil.getNewMaxCode(maxVersionCode);
    }

    @Override
    @Transactional
    public String saveAsTaskVersion(String versionId) throws Exception {
        BizAlgorithmVersion version = (BizAlgorithmVersion)((Object)this.getById((Serializable)((Object)versionId)));
        if (null == version) {
            throw new ApplicationException("\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u7248\u672c\u3002");
        }
        String newId = UniqueIdUtil.getSuid();
        version.setId(newId);
        version.setVersionCode(this.getNewVersionCode(version.getTaskId()));
        this.save((Object)version);
        List<BizAlgorithmReason> reasons = this.reasonManager.queryByVersionId(versionId);
        HashMap<String, String> idMaps = new HashMap<String, String>();
        for (BizAlgorithmReason item : reasons) {
            String oldId = item.getId();
            item.setId(null);
            item.setTaskVersonId(newId);
            if (null != idMaps.get(item.getParentId())) {
                item.setParentId((String)idMaps.get(item.getParentId()));
            } else {
                item.setParentId("-1");
            }
            this.reasonManager.saveReason(item);
            idMaps.put(oldId, item.getId());
        }
        return newId;
    }
}

