/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.activiti.util;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;

public class FontUtil {
    private static final String FONT_PATH = "fonts/simsun.ttf";
    private static Font dynamicFont = null;

    public static Boolean isExist(String fontName) {
        if (StringUtil.isEmpty((String)fontName)) {
            return false;
        }
        if (GraphicsEnvironment.isHeadless()) {
            return false;
        }
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = e.getAvailableFontFamilyNames();
        for (int i = 0; i < fontNames.length; ++i) {
            String curFontName = fontNames[i];
            if (!fontName.equals(curFontName)) continue;
            return true;
        }
        return false;
    }

    public static Font getFont(String fontName, Integer style, Integer size) {
        if (FontUtil.isExist(fontName).booleanValue()) {
            return new Font(fontName, (int)style, size);
        }
        try {
            if (BeanUtils.isEmpty((Object)dynamicFont)) {
                InputStream resourceAsStream = FontUtil.class.getClassLoader().getResourceAsStream(FONT_PATH);
                if (BeanUtils.isEmpty((Object)resourceAsStream)) {
                    throw new IOException("\u672a\u52a0\u8f7d\u5230\u5b57\u4f53\u6587\u4ef6\uff1afonts/simsun.ttf");
                }
                dynamicFont = Font.createFont(0, resourceAsStream);
                float parseFloat = Float.parseFloat(size.toString());
                dynamicFont = dynamicFont.deriveFont(parseFloat);
            }
            return dynamicFont;
        }
        catch (FontFormatException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

