/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.util;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.StreamGobbler;
import com.artfess.base.exception.ApplicationException;
import com.artfess.cssc.util.SshUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.jsoup.helper.StringUtil;

public class RemoteExecuteCommandUtil {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static String DEFAULTCHART = "UTF-8";
    private Connection conn;
    private String ip;
    private Integer port;
    private String userName;
    private String userPwd;

    public RemoteExecuteCommandUtil(String ip, Integer port, String userName, String userPwd) {
        this.ip = ip;
        this.port = port;
        this.userName = userName;
        this.userPwd = userPwd;
    }

    public RemoteExecuteCommandUtil() {
    }

    public Boolean login() throws Exception {
        boolean flg = false;
        try {
            this.conn = this.port == null || this.port == 0 ? new Connection(this.ip) : new Connection(this.ip, this.port.intValue());
            this.conn.connect();
            flg = this.conn.authenticateWithPassword(this.userName, this.userPwd);
        }
        catch (IOException e) {
            throw new ApplicationException("\u8fdc\u7a0b\u8fde\u63a5\u670d\u52a1\u5668\u5931\u8d25", (Throwable)e);
        }
        return flg;
    }

    public String execute(String cmd) throws Exception {
        String result = "";
        Session session = null;
        try {
            if (this.login().booleanValue()) {
                session = this.conn.openSession();
                session.execCommand(cmd);
                int i = session.getState();
                System.out.println(i);
                result = this.processStdout(session.getStdout(), DEFAULTCHART);
                if (StringUtil.isBlank((String)result)) {
                    result = this.processStdout(session.getStderr(), DEFAULTCHART);
                }
                this.conn.close();
                session.close();
            }
        }
        catch (IOException e) {
            throw new ApplicationException("\u547d\u4ee4\u6267\u884c\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (this.conn != null) {
                this.conn.close();
            }
            if (session != null) {
                session.close();
            }
        }
        return result;
    }

    private String processStdout(InputStream in, String charset) throws Exception {
        StreamGobbler stdout = new StreamGobbler(in);
        StringBuffer buffer = new StringBuffer();
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            isr = new InputStreamReader((InputStream)stdout, charset);
            br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                buffer.append(line).append(LINE_SEPARATOR);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new ApplicationException("\u4e0d\u652f\u6301\u7684\u7f16\u7801\u5b57\u7b26\u96c6\u5f02\u5e38", (Throwable)e);
        }
        catch (IOException e) {
            throw new ApplicationException("\u8bfb\u53d6\u5931\u8d25", (Throwable)e);
        }
        finally {
            br.close();
            isr.close();
            stdout.close();
        }
        return buffer.toString();
    }

    public static void main(String[] args) throws Exception {
        String linuxIP = "139.9.184.105";
        String usrName = "root";
        Integer port = 22;
        String passwd = "Cqartfess@qwe!@#";
        String cmd = "python3  -u /disk_dev/csscModel/model1/interf.py >test.log 2>&1 &";
        SshUtil sshUtil = SshUtil.getSftpUtil(linuxIP, port, usrName, passwd);
        System.exit(sshUtil.exec(cmd, "/disk_dev/csscModel/model1") ? 0 : 1);
    }
}

