/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.scada.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.cssc.scada.dao.ScadaFaultDao;
import com.artfess.cssc.scada.manager.ScadaFaultManager;
import com.artfess.cssc.scada.model.ScadaFault;
import com.artfess.cssc.scada.params.ScadaFaultVo;
import com.artfess.poi.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ScadaFaultManagerImpl
extends BaseManagerImpl<ScadaFaultDao, ScadaFault>
implements ScadaFaultManager {
    @Override
    @Transactional
    public boolean insertScadaFault(ScadaFault scadaFault) {
        if (BeanUtils.isNotEmpty((Object)((Object)scadaFault))) {
            if (StringUtil.isEmpty((String)scadaFault.getType())) {
                throw new RequiredException("\u6dfb\u52a0scada\u6545\u969c\u4ee3\u7801\u5bf9\u7167\u5931\u8d25\uff0c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtil.isEmpty((String)scadaFault.getCode())) {
                throw new RequiredException("\u6dfb\u52a0scada\u6545\u969c\u4ee3\u7801\u5bf9\u7167\u5931\u8d25\uff0c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtil.isEmpty((String)scadaFault.getName())) {
                throw new RequiredException("\u6dfb\u52a0scada\u6545\u969c\u4ee3\u7801\u5bf9\u7167\u5931\u8d25\uff0c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (this.checkSameFault(scadaFault)) {
                throw new RequiredException("\u6dfb\u52a0scada\u6545\u969c\u4ee3\u7801\u5bf9\u7167\u5931\u8d25\uff0c" + scadaFault.getType() + "\u7c7b\u578b\u7684\u3010" + scadaFault.getCode() + "\u3011\u7f16\u7801\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            Integer result = ((ScadaFaultDao)this.baseMapper).insert((Object)scadaFault);
            return null != result && result >= 1;
        }
        return false;
    }

    @Override
    @Transactional
    public boolean updateScadaFault(ScadaFault scadaFault) {
        if (BeanUtils.isNotEmpty((Object)((Object)scadaFault))) {
            if (StringUtil.isEmpty((String)scadaFault.getType())) {
                throw new RequiredException("\u4fee\u6539scada\u6545\u969c\u4ee3\u7801\u5bf9\u7167\u5931\u8d25\uff0c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtil.isEmpty((String)scadaFault.getCode())) {
                throw new RequiredException("\u4fee\u6539scada\u6545\u969c\u4ee3\u7801\u5bf9\u7167\u5931\u8d25\uff0c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtil.isEmpty((String)scadaFault.getName())) {
                throw new RequiredException("\u4fee\u6539scada\u6545\u969c\u4ee3\u7801\u5bf9\u7167\u5931\u8d25\uff0c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (this.checkSameFault(scadaFault)) {
                throw new RequiredException("\u4fee\u6539scada\u6545\u969c\u4ee3\u7801\u5bf9\u7167\u5931\u8d25\uff0c" + scadaFault.getType() + "\u7c7b\u578b\u7684\u3010" + scadaFault.getCode() + "\u3011\u7f16\u7801\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            Integer result = ((ScadaFaultDao)this.baseMapper).updateById((Object)scadaFault);
            return null != result && result >= 1;
        }
        return false;
    }

    @Override
    public ScadaFault queryByCode(String type, String code) {
        if (StringUtil.isEmpty((String)type)) {
            throw new RequiredException("\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtil.isEmpty((String)code)) {
            throw new RequiredException("\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return ((ScadaFaultDao)this.baseMapper).queryByCode(type, code);
    }

    @Override
    @Transactional
    public void importData(MultipartFile file) throws Exception {
        List list = ExcelUtil.readExcel(ScadaFaultVo.class, (MultipartFile)file);
        if (BeanUtils.isNotEmpty((Object)list)) {
            if (!this.validateAllRole(list)) {
                String message = "\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5excel\u6570\u636e\u662f\u5426\u6b63\u786e\u3002";
                throw new BaseException(message);
            }
            for (ScadaFaultVo scadaFaultVo : list) {
                ScadaFault scadaFault = ((ScadaFaultDao)this.baseMapper).queryByCode(scadaFaultVo.getType(), scadaFaultVo.getCode());
                if (!BeanUtils.isEmpty((Object)((Object)scadaFault))) continue;
                ScadaFault nScadaFault = ScadaFaultVo.parse(scadaFaultVo);
                nScadaFault.setId(UniqueIdUtil.getSuid());
                this.create((Model)nScadaFault);
            }
        }
    }

    private boolean validateAllRole(List<ScadaFaultVo> list) {
        for (ScadaFaultVo scadaFaultVo : list) {
            if (!StringUtil.isEmpty((String)scadaFaultVo.getName()) && !StringUtil.isEmpty((String)scadaFaultVo.getCode()) && !BeanUtils.isEmpty((Object)scadaFaultVo.getType())) continue;
            return false;
        }
        return true;
    }

    private boolean checkSameFault(ScadaFault scadaFault) {
        if (BeanUtils.isNotEmpty((Object)((Object)scadaFault))) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"type_", (Object)scadaFault.getType());
            queryWrapper.eq((Object)"code_", (Object)scadaFault.getCode());
            queryWrapper.ne(StringUtils.isNotBlank((CharSequence)scadaFault.getId()), (Object)"ID_", (Object)scadaFault.getId());
            int num = ((ScadaFaultDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
            return num != 0;
        }
        throw new RequiredException("\u6545\u969c\u5bf9\u7167\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }
}

