/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.model.manager.impl;

import com.artfess.base.exception.RequiredException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.cssc.base.manager.FanInfoManager;
import com.artfess.cssc.base.manager.SystemInfoManager;
import com.artfess.cssc.base.model.FanInfo;
import com.artfess.cssc.base.model.SystemInfo;
import com.artfess.cssc.model.dao.OrderDecisionDao;
import com.artfess.cssc.model.manager.OrderDecisionManager;
import com.artfess.cssc.model.manager.OrderInfoManager;
import com.artfess.cssc.model.model.OrderDecision;
import com.artfess.cssc.model.model.OrderInfo;
import com.artfess.cssc.model.params.OrderReceiveDTO;
import com.artfess.cssc.util.HttpsUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class OrderDecisionManagerImpl
extends BaseManagerImpl<OrderDecisionDao, OrderDecision>
implements OrderDecisionManager {
    @Value(value="${orderDecision.url}")
    private String url;
    @Resource
    SystemInfoManager systemInfoManager;
    @Resource
    FanInfoManager fanInfoManager;
    @Resource
    OrderInfoManager orderInfoManager;

    @Override
    @Transactional
    public boolean receiveOrder(OrderReceiveDTO orderReceive) {
        if (BeanUtils.isNotEmpty((Object)orderReceive)) {
            if (StringUtil.isEmpty((String)orderReceive.getDemandSysCode())) {
                throw new RequiredException("\u547d\u4ee4\u63a5\u6536\u5931\u8d25\uff0c\u7f3a\u5931\u7cfb\u7edf\u7f16\u7801\uff01");
            }
            if (StringUtil.isEmpty((String)orderReceive.getOrderCode())) {
                throw new RequiredException("\u547d\u4ee4\u63a5\u6536\u5931\u8d25\uff0c\u7f3a\u5931\u6307\u4ee4\u7f16\u7801\uff01");
            }
            OrderInfo orderInfo = this.orderInfoManager.getByCode(orderReceive.getOrderCode());
            if (BeanUtils.isEmpty((Object)((Object)orderInfo))) {
                throw new RequiredException("\u547d\u4ee4\u63a5\u6536\u5931\u8d25\uff0c\u6307\u4ee4\u9519\u8bef\uff0c\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u3010" + orderReceive.getOrderCode() + "\u3011\u7684\u6307\u4ee4\uff01");
            }
            if (StringUtil.isEmpty((String)orderReceive.getOrderParams())) {
                throw new RequiredException("\u547d\u4ee4\u63a5\u6536\u5931\u8d25\uff0c\u7f3a\u5931\u6307\u4ee4\u53c2\u6570\uff01");
            }
            List<String> fans = orderReceive.getFanCodeList();
            if (CollectionUtils.isEmpty(fans)) {
                throw new RequiredException("\u547d\u4ee4\u63a5\u6536\u5931\u8d25\uff0c\u7f3a\u5931\u673a\u7ec4\u7f16\u7801\u96c6\u5408\uff01");
            }
            SystemInfo systemInfo = this.systemInfoManager.getByCode(orderReceive.getDemandSysCode());
            if (BeanUtils.isEmpty((Object)((Object)systemInfo))) {
                throw new RequiredException("\u547d\u4ee4\u63a5\u6536\u5931\u8d25\uff0c\u7cfb\u7edf\u7f16\u7801\u9519\u8bef\uff0c\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u3010" + orderReceive.getDemandSysCode() + "\u3011\u7684\u7cfb\u7edf\uff01");
            }
            ArrayList<OrderDecision> list = new ArrayList<OrderDecision>();
            for (String fanCode : fans) {
                FanInfo fanInfo = this.fanInfoManager.getByFanCode(fanCode);
                if (BeanUtils.isNotEmpty((Object)((Object)fanInfo))) {
                    OrderDecision orderDecision = new OrderDecision();
                    orderDecision.setDemandTime(LocalDateTime.now());
                    orderDecision.setDemandSysCode(systemInfo.getSysCode());
                    orderDecision.setDemandSysName(systemInfo.getSysName());
                    orderDecision.setFanCode(fanInfo.getFanCode());
                    orderDecision.setFanName(fanInfo.getFanName());
                    orderDecision.setOrderCode(orderReceive.getOrderCode());
                    orderDecision.setOrderName(orderInfo.getOrderName());
                    orderDecision.setOrderParams(orderReceive.getOrderParams());
                    orderDecision.setOrderParamsType(orderInfo.getOrderType());
                    list.add(orderDecision);
                    continue;
                }
                throw new RequiredException("\u547d\u4ee4\u63a5\u6536\u5931\u8d25\uff0c\u673a\u7ec4\u7f16\u7801\u3010" + fanCode + "\u3011\u9519\u8bef\uff0c\u4e0d\u5b58\u5728\uff01");
            }
            return this.saveBatch(list);
        }
        return false;
    }

    @Override
    @Transactional
    public boolean decisionOrder(String orderReceiveId, Integer decisionState) {
        if (StringUtil.isEmpty((String)orderReceiveId)) {
            throw new RequiredException("\u547d\u4ee4\u51b3\u7b56\u5931\u8d25\uff0c\u7f3a\u5931ID\uff01");
        }
        if (decisionState != null) {
            throw new RequiredException("\u547d\u4ee4\u51b3\u7b56\u5931\u8d25\uff0c\u7f3a\u5931\u51b3\u7b56\u72b6\u6001\uff01");
        }
        OrderDecision orderDecision = (OrderDecision)((Object)this.getById((Serializable)((Object)orderReceiveId)));
        if (BeanUtils.isEmpty((Object)((Object)orderDecision))) {
            throw new RequiredException("\u547d\u4ee4\u51b3\u7b56\u5931\u8d25\uff0c\u51b3\u7b56ID\u9519\u8bef\uff01");
        }
        orderDecision.setDecisionTime(LocalDateTime.now());
        orderDecision.setDecisionState(decisionState);
        Integer result = ((OrderDecisionDao)this.baseMapper).updateById((Object)orderDecision);
        return null != result && result >= 1;
    }

    @Override
    public boolean executeOrder() throws Exception {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"decision_state_", (Object)1);
        queryWrapper.eq((Object)"execute_state_", (Object)0);
        List list = ((OrderDecisionDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        HashMap map = new HashMap();
        for (OrderDecision orderDecision : list) {
            Set<OrderDecision> set;
            String order = orderDecision.getOrderCode();
            String param = orderDecision.getOrderParams();
            String key = order + "_" + param;
            if (map.containsKey(key)) {
                set = (Set)map.get(key);
                set.add(orderDecision);
                continue;
            }
            set = new HashSet();
            set.add(orderDecision);
            map.put(key, set);
        }
        for (String key : map.keySet()) {
            Set set = (Set)map.get(key);
            ArrayList<String> fan = new ArrayList<String>();
            String orderId = "";
            String orderType = "";
            String orderParam = "";
            for (OrderDecision orderDecision : set) {
                fan.add(orderDecision.getFanCode());
                orderId = orderDecision.getOrderCode();
                orderType = orderDecision.getOrderParamsType();
                orderParam = orderDecision.getOrderParams();
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("orderId", orderId);
            param.put("factoryId", "1");
            param.put("wts", fan);
            param.put("orderParams", orderParam);
            param.put("interval", 5L);
            param.put("sync", true);
            param.put("passWd", "123456");
            param.put("type", orderType);
            System.out.println(((Object)param).toString());
            String resultJson = HttpsUtil.post(this.url, param, "application/json", 0, 0, "");
            System.out.println(resultJson);
        }
        return true;
    }

    @Override
    public boolean executeOrderById(String id) throws Exception {
        OrderDecision orderDecision = (OrderDecision)((Object)this.getById((Serializable)((Object)id)));
        if (BeanUtils.isNotEmpty((Object)((Object)orderDecision))) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            ArrayList<String> fan = new ArrayList<String>();
            fan.add(orderDecision.getFanCode());
            String orderId = orderDecision.getOrderCode();
            String orderType = orderDecision.getOrderParamsType();
            String orderParam = orderDecision.getOrderParams();
            param.put("orderId", orderId);
            param.put("factoryId", "1");
            param.put("wts", fan);
            param.put("orderParams", orderParam);
            param.put("interval", 5L);
            param.put("sync", true);
            param.put("passWd", "123456");
            param.put("type", orderType);
            System.out.println(((Object)param).toString());
            String resultJson = HttpsUtil.post(this.url, param, "application/json", 0, 0, "");
            System.out.println(resultJson);
            return true;
        }
        return false;
    }

    @Override
    @Transactional
    public boolean resultOrder(String orderReceiveId, Integer executeState, String executeResult) {
        if (StringUtil.isEmpty((String)orderReceiveId)) {
            throw new RequiredException("\u7f3a\u5931ID\uff01");
        }
        if (executeState != null) {
            throw new RequiredException("\u7f3a\u5931\u6267\u884c\u72b6\u6001\uff01");
        }
        OrderDecision orderDecision = (OrderDecision)((Object)this.getById((Serializable)((Object)orderReceiveId)));
        if (BeanUtils.isEmpty((Object)((Object)orderDecision))) {
            throw new RequiredException("ID\u9519\u8bef\uff01");
        }
        orderDecision.setExecuteTime(LocalDateTime.now());
        orderDecision.setExecuteState(executeState);
        orderDecision.setExecuteResult(executeResult);
        Integer result = ((OrderDecisionDao)this.baseMapper).updateById((Object)orderDecision);
        return null != result && result >= 1;
    }
}

