/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.model.manager.impl;

import com.artfess.base.cache.CacheManager;
import com.artfess.base.cache.ICache;
import com.artfess.base.cache.setting.CacheSetting;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.webSocket.SubroutineManage;
import com.artfess.cssc.model.dao.ModelActuatorDao;
import com.artfess.cssc.model.manager.ModelActuatorManager;
import com.artfess.cssc.model.model.ModelActuator;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ModelActuatorManagerImpl
extends BaseManagerImpl<ModelActuatorDao, ModelActuator>
implements ModelActuatorManager,
SubroutineManage {
    @Resource
    CacheManager cacheManager;
    private static final CacheSetting cacheSetting = CacheSetting.buildDefault((String)"\u6267\u884c\u5668\u72b6\u6001");

    @Override
    @Transactional
    public boolean insertModelActuator(ModelActuator modelActuator) {
        if (BeanUtils.isNotEmpty((Object)((Object)modelActuator))) {
            if (StringUtil.isEmpty((String)modelActuator.getActuatorCode())) {
                throw new RequiredException("\u6dfb\u52a0\u6267\u884c\u5668\u4fe1\u606f\u5931\u8d25\uff0c\u6267\u884c\u5668\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtil.isEmpty((String)modelActuator.getActuatorIp())) {
                throw new RequiredException("\u6dfb\u52a0\u6267\u884c\u5668\u4fe1\u606f\u5931\u8d25\uff0c\u6267\u884c\u5668IP\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (modelActuator.getActuatorPort() == null || modelActuator.getActuatorPort() <= 0) {
                throw new RequiredException("\u6dfb\u52a0\u6267\u884c\u5668\u4fe1\u606f\u5931\u8d25\uff0c\u6267\u884c\u5668\u7aef\u53e3\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (this.checkSameCode(modelActuator.getActuatorCode(), modelActuator.getId())) {
                throw new RequiredException("\u6dfb\u52a0\u6267\u884c\u5668\u4fe1\u606f\u5931\u8d25\uff0c\u6267\u884c\u5668\u7f16\u7801\u3010" + modelActuator.getActuatorCode() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            modelActuator.setActuatorStatus("NONE");
            Integer result = ((ModelActuatorDao)this.baseMapper).insert((Object)modelActuator);
            return null != result && result >= 1;
        }
        return false;
    }

    @Override
    @Transactional
    public boolean updateModelActuator(ModelActuator modelActuator) {
        if (BeanUtils.isNotEmpty((Object)((Object)modelActuator))) {
            if (StringUtil.isEmpty((String)modelActuator.getActuatorCode())) {
                throw new RequiredException("\u4fee\u6539\u6267\u884c\u5668\u4fe1\u606f\u5931\u8d25\uff0c\u6267\u884c\u5668\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtil.isEmpty((String)modelActuator.getActuatorIp())) {
                throw new RequiredException("\u4fee\u6539\u6267\u884c\u5668\u4fe1\u606f\u5931\u8d25\uff0c\u6267\u884c\u5668IP\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (modelActuator.getActuatorPort() == null || modelActuator.getActuatorPort() <= 0) {
                throw new RequiredException("\u4fee\u6539\u6267\u884c\u5668\u4fe1\u606f\u5931\u8d25\uff0c\u6267\u884c\u5668\u7aef\u53e3\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (this.checkSameCode(modelActuator.getActuatorCode(), modelActuator.getId())) {
                throw new RequiredException("\u4fee\u6539\u6267\u884c\u5668\u4fe1\u606f\u5931\u8d25\uff0c\u6267\u884c\u5668\u7f16\u7801\u3010" + modelActuator.getActuatorCode() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            Integer result = ((ModelActuatorDao)this.baseMapper).updateById((Object)modelActuator);
            return null != result && result >= 1;
        }
        return false;
    }

    @Override
    @Transactional
    public boolean updateStatusByHeartbeat(String code, String status) {
        if (StringUtil.isEmpty((String)code)) {
            throw new RequiredException("\u4fee\u6539\u5b50\u7a0b\u5e8f\u72b6\u6001\u5931\u8d25\uff0c\u5b50\u7a0b\u5e8f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ICache cache = this.cacheManager.getCache("", cacheSetting);
        String state = (String)cache.get((Object)("BIZ:SUBROUTINE:" + code), String.class);
        if (StringUtil.isEmpty((String)state) || !state.toUpperCase().equals(status.toUpperCase())) {
            state = status;
            UpdateWrapper updateWrapper = new UpdateWrapper();
            ((UpdateWrapper)updateWrapper.set((Object)"actuator_status_", (Object)state)).eq((Object)"actuator_code_", (Object)code);
            Integer result = ((ModelActuatorDao)this.baseMapper).update(null, (Wrapper)updateWrapper);
            cache.put((Object)("BIZ:SUBROUTINE:" + code), (Object)state);
            return null != result && result >= 1;
        }
        return true;
    }

    @Override
    public ModelActuator getNormalModelActuatorById(String id) {
        if (StringUtil.isEmpty((String)id)) {
            throw new RequiredException("\u6267\u884c\u5668id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"id_", (Object)id);
        queryWrapper.eq((Object)"actuator_status_", (Object)"NORMAL");
        ModelActuator modelActuator = (ModelActuator)((Object)((ModelActuatorDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
        return modelActuator;
    }

    private boolean checkSameCode(String code, String id) {
        Assert.hasText((String)code, (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"actuator_code_", (Object)code);
        queryWrapper.ne(StringUtil.isNotEmpty((String)id), (Object)"ID_", (Object)id);
        int num = ((ModelActuatorDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
        return num != 0;
    }
}

