/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.model.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.SQLUtil;
import com.artfess.cssc.model.manager.OrderDecisionManager;
import com.artfess.cssc.model.model.OrderDecision;
import com.artfess.cssc.model.params.OrderReceiveDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6307\u4ee4\u51b3\u7b56\u63a7\u5236"})
@ApiGroup(group={"group_biz"})
@RestController
@RequestMapping(value={"/biz/model/order/v1/"})
public class OrderDecisionController
extends BaseController<OrderDecisionManager, OrderDecision> {
    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<OrderDecision> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<OrderDecision> queryFilter) {
        String dbType = SQLUtil.getDbType();
        if (dbType.equals("postgresql")) {
            List querys = queryFilter.getQuerys();
            ArrayList<Timestamp> objects = new ArrayList<Timestamp>();
            for (QueryField query : querys) {
                if (query.getProperty().indexOf("Time") == -1 || !List.class.isInstance(query.getValue())) continue;
                for (String v : (List)query.getValue()) {
                    objects.add(Timestamp.valueOf(v));
                }
                query.setValue(objects);
            }
        }
        return ((OrderDecisionManager)this.baseService).query(queryFilter);
    }

    @PostMapping(value={"/receiveOrder"})
    @ApiOperation(value="\u63a5\u6536\u4e1a\u52a1\u7cfb\u7edf\u6307\u4ee4\u9700\u6c42\u63a5\u53e3")
    public CommonResult<String> receiveOrder(@ApiParam(name="orderReceive", value="\u63a5\u6536\u7684\u6307\u4ee4\u4fe1\u606f") @RequestBody OrderReceiveDTO orderReceive) {
        boolean result = ((OrderDecisionManager)this.baseService).receiveOrder(orderReceive);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PostMapping(value={"/executeOrder"})
    @ApiOperation(value="\u6267\u884c\u6307\u4ee4\u63a5\u53e3")
    public CommonResult<String> executeOrder() throws Exception {
        boolean result = ((OrderDecisionManager)this.baseService).executeOrder();
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PostMapping(value={"/executeOrderById"})
    @ApiOperation(value="\u6267\u884c\u6307\u4ee4\u63a5\u53e3")
    public CommonResult<String> executeOrderById(@ApiParam(name="id", value="id") @RequestParam String id) throws Exception {
        boolean result = ((OrderDecisionManager)this.baseService).executeOrderById(id);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }
}

