/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.scada.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cssc.scada.manager.PointSystemManager;
import com.artfess.cssc.scada.model.PointSystem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/biz/scada/pointSystem/v1/"})
@Api(tags={"Scada\u70b9\u4f4d\u91c7\u96c6\u914d\u7f6e"})
@ApiGroup(group={"group_biz"})
public class PointSystemController
extends BaseController<PointSystemManager, PointSystem> {
    @RequestMapping(value={"queryPointSystemPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6scada\u70b9\u4f4d\u914d\u7f6e\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6scada\u70b9\u4f4d\u914d\u7f6e\u5217\u8868")
    public PageList<PointSystem> queryPointSystemPage(@ApiParam(name="filter", value="\u67e5\u8be2\u53c2\u6570", required=true) @RequestBody QueryFilter filter) throws Exception {
        PageList<PointSystem> query = ((PointSystemManager)this.baseService).queryPointSystemPage((QueryFilter<PointSystem>)filter);
        return query;
    }

    @RequestMapping(value={"savePointSystems"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u4e1a\u52a1\u7cfb\u7edfscada\u70b9\u4f4d\u91c7\u96c6\u914d\u7f6e", httpMethod="POST", notes="\u4fdd\u5b58\u4e1a\u52a1\u7cfb\u7edfscada\u70b9\u4f4d\u91c7\u96c6\u914d\u7f6e")
    public CommonResult<String> saveFanParams(@ApiParam(name="sysId", value="\u4e1a\u52a1\u7cfb\u7edfid", required=true) @RequestParam String sysId, @ApiParam(name="configType", value="\u914d\u7f6e\u7c7b\u578b\uff081\uff1a\u98ce\u573a\u914d\u7f6e\uff0c2\uff1a\u73af\u7ebf\u914d\u7f6e\uff0c3\uff1a\u673a\u7ec4\u914d\u7f6e\uff09", required=true) @RequestParam Integer configType, @ApiParam(name="lineId", value="\u73af\u7ebfID", required=false) @RequestParam String lineId, @ApiParam(name="fanType", value="\u673a\u7ec4\u7c7b\u578b", required=false) @RequestParam String fanType, @ApiParam(name="pointIdList", value="\u70b9\u4f4dID", required=true) @RequestBody List<String> pointIdList) throws Exception {
        CommonResult<String> result = ((PointSystemManager)this.baseService).insertPointSystem(sysId, configType, lineId, fanType, pointIdList);
        return result;
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        boolean result = ((PointSystemManager)this.baseService).removeById((Serializable)((Object)id));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        ((PointSystemManager)this.baseService).saveScadaPointCache();
        return new CommonResult();
    }

    @DeleteMapping(value={"/"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        boolean result = ((PointSystemManager)this.baseService).removeByIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        ((PointSystemManager)this.baseService).saveScadaPointCache();
        return new CommonResult();
    }

    @RequestMapping(value={"saveScadaPointCache"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u7f13\u5b58", httpMethod="POST", notes="\u4fdd\u5b58\u7f13\u5b58")
    public CommonResult<String> saveScadaPointCache() throws Exception {
        ((PointSystemManager)this.baseService).saveScadaPointCache();
        return new CommonResult();
    }

    @RequestMapping(value={"/import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u70b9\u4f4d\u5bfc\u5165", httpMethod="POST", notes="\u70b9\u4f4d\u5bfc\u5165")
    public CommonResult<String> importData(@ApiParam(name="sysId", value="\u4e1a\u52a1\u7cfb\u7edfid", required=true) @RequestParam String sysId, @ApiParam(name="configType", value="\u914d\u7f6e\u7c7b\u578b\uff081\uff1a\u98ce\u573a\u914d\u7f6e\uff0c2\uff1a\u73af\u7ebf\u914d\u7f6e\uff0c3\uff1a\u673a\u7ec4\u914d\u7f6e\uff09", required=true) @RequestParam Integer configType, @ApiParam(name="lineId", value="\u73af\u7ebfID", required=false) @RequestParam String lineId, @ApiParam(name="fanType", value="\u673a\u7ec4\u7c7b\u578b", required=false) @RequestParam String fanType, @ApiParam(name="file", value="\u4e0a\u4f20\u7684\u6587\u4ef6\u6d41") @RequestBody MultipartFile file) throws Exception {
        CommonResult<String> commonResult = ((PointSystemManager)this.baseService).importData(sysId, configType, lineId, fanType, file);
        return commonResult;
    }
}

