import { isArrayFn } from '../../../utils/common'
export default {
    props: {
        beautifyTable: { default: false, type: Boolean }, // 美化表格，修改了样式
        showDialogIcon: { default: true, type: Boolean }, // 是否显示操作字段的上下移动按钮(侧滑框)
        moveDownIcon: { default: '', type: String }, // 下移按钮的图标(侧滑框)
        moveUpIcon: { default: '', type: String }, // 上移按钮的图标(侧滑框)
        showOverflow: { type: [Boolean, String], default: null },
        showHeaderOverflow: { type: [Boolean, String], default: null },
        showFooterOverflow: { type: [Boolean, String], default: null },
        data: {type: Array, default: () => []}, // 表格数据
        columns: Array,
        height: [String, Number],
        maxHeight: [String, Number],
        scrollY: {type: Object, default: () => { return {gt: 0, oSize: 0} }},
        scrollX: {type: Object, default: () => { return {gt: 0, oSize: 0} }},
        widthResize: Boolean,
        mergeCells: Array,
        validConfig: Object, // 校验配置项
        rules: Object,// 校验规则配置项
        checkboxConfig: Object, // 复选框配置项
        expandConfig: Object, // 展开行配置项
        editConfig: [Boolean, Object], // 编辑配置项
        treeConfig: [Boolean, Object],// 树形结构配置项
        sortConfig:Object, // 排序相关的配置
        indexConfig: Object, // 序号
        keyboardConfig: Object, // 键盘按键
        mouseConfig: Object,
        keepSource: Boolean,
        dialogData: {type: Array, default: () => []}, // 选择显示字段数组
        stripe: {default: false, type: Boolean}, // 是否为斑马纹
        size: {default: null, type: String}, // Table 的尺寸
        showHeader: {default: true, type: Boolean}, // 是否显示表头
        emptyText: {default: '暂无数据', type: String}, // 空数据时显示的文本内容
        border: {default: true, type: [Boolean, String]}, // 是否显示纵向边框
        showSummary: {default: false, type: Boolean}, // 是否需要合计
        summaryMethod: Function, // 自定义的合计计算方法
        fieldSort: { default: true, type: Boolean }, // 字段排序
        rowKey: Boolean, // 是否需要为每一行的 VNode 设置 key 属性（非特殊情况下没必要设置）
        columnKey: Boolean, // 是否需要为每一列的 VNode 设置 key 属性（非特殊情况下不需要使用, 常用于拖拽列）
        rowId: String, // 自定义行数据唯一主键的字段名（行数据必须要有唯一主键，默认自动生成）
        highlightCurrentRow: { default: true, type: Boolean }, // 是否要高亮当前行
        showAmend: { default: false, type: Boolean }, // 是否显示修改字段名按钮(侧滑框)
        amendBtnIcon: { default: '', type: String }, // 修改字段按钮的图标(侧滑框)
        fieldTitle: { default: '选择显示字段', type: String }, // 弹框的标题(侧滑框)
        spanMethod: Function, // 合并行或列的计算方法
        rowClassName: [String, Function], // 行的 className 的回调方法，也可以使用字符串为所有行设置一个固定的 className。
        rowStyle: [Object, Function], // 行的 style 的回调方法
        cellClassName: [String, Function], // 行单元格的 className 的回调方法
        cellStyle: [Object, Function], // 行单元格的 style 的回调方法
        headerRowClassName: [String, Function], // 表头行的 className 的回调方法
        headerRowStyle: [Object, Function], // 表头行的 style 的回调方法
        headerCellClassName: [String, Function], // 表头单元格的 className 的回调方法
        headerCellStyle: [Object, Function], // 表头单元格的 style 的回调方法
        paginationShow: {default: false, type: Boolean}, // 是否需要分页器
        total: {default: 0, type: Number}, // 总条数
        pagerCount: { default: 5, type: Number }, // 页码按钮的数量，当总页数超过该值时会折叠
        pageSize:{ default: 10, type: Number }, // 每页条数
        currentPage: { default: 1, type: Number }, // 当前页
        pageSizes: { default: () => [10, 20, 30, 50], type: Array }, // 每页显示个数选择器的选项设置
        layout: { default: 'total, sizes, prev, pager, next, jumper', type: String } // 分页组件布局，子组件名用逗号分隔
    },
    methods: {
        // 分页器的事件
        handleSizeChange (val) {
            this.newPageSize = val
            this.$emit('handlePageSize', { size: this.newPageSize, page: this.newcurrentPage })
        },
        handleCurrentChange (val) {
            this.newcurrentPage = val
            this.$emit('handlePageSize', { size: this.newPageSize, page: this.newcurrentPage })
        },
        // 打开自定义字段框
        plDialogOpens () {
            this._times = null
            this.$refs.plDialog.style.width = 300 + 'px'
            this._times = setTimeout(() => {
                this.plDialogFals = true
            }, 200)
            // 创建节点（主要用来弹出menu窗口时，不让起点击外面）
            this.aBox = document.createElement('div')
            this.aBox.className = 'modal-backdrop'
            this.aBox.style.display = 'block'
            this.aBox.onclick = () => {
                this.closeModal()
            }
            document.body.appendChild(this.aBox)
        },
        // 关闭自定义字段框（取消选择）
        closeModal () {
            this.plDialogFals = false
            clearTimeout(this._times)
            this.$refs.plDialog.style.width = 0 + 'px'
            this.aBox.style.display = 'none'
            this.clearNode()
            this.newDialogData = JSON.parse(JSON.stringify(this.dialogData))
        },
        // 确认按钮
        confirmField () {
            this.$emit('show-field', this.newDialogData)
            this.plDialogFals = false
            clearTimeout(this._times)
            this.$refs.plDialog.style.width = 0 + 'px'
            this.aBox.style.display = 'none'
            this.clearNode()
        },
        // 重置按钮
        reset () {
            this.$emit('reset', this.newDialogData)
            this.plDialogFals = false
            clearTimeout(this._times)
            this.$refs.plDialog.style.width = 0 + 'px'
            this.aBox.style.display = 'none'
            this.clearNode()
        },
        // 修改字段名按钮事件
        amendField (item, index) {
            this.$emit('amend-field', item, index)
        },
        // 删除节点
        clearNode () {
            // 删除节点
            let parent = this.aBox ? this.aBox.parentNode : ''
            parent && parent.removeChild(this.aBox)
            let doms = document.getElementsByClassName('modal-backdrop')
            if (doms.length > 0) {
                document.body.removeChild(doms[0])
            }
            this.aBox = null
        },

        // 表格方法

        // 合计的方法summaryMethod
        footerMethod (param) {
            if (typeof this.summaryMethod === 'function' && this.summaryMethod) {
                return this.summaryMethod(param)
            } else {
                return []
            }
        },
        // 合并行或列的计算方法
        arraySpanMethod (objs) {
            // 是否有条件开启合并列
            if (typeof this.spanMethod === 'function') {
                return this.spanMethod(objs)
            } else {
                return null
            }
        },
        // 用于单选表格，设定某一行为选中行
        setCurrentRow (row) {
            if (row) {
                this.$refs.singleTable.setCurrentRow(row);
            } else {
                this.$refs.singleTable.setCurrentRow();
            }
        },
        // 用于多选表格，切换某一行的选中状态，如果使用了第二个参数，则是设置这一行选中与否（selected 为 true 则选中）
        toggleRowSelection (rows) {
            if (rows && isArrayFn(rows)) {
                this.newtoggleRowSelections(rows)
            } else {
                console.error('数据格式需要一个数组')
            }
        },
        // 用于多选表格，切换某一行的选中状态
        newtoggleRowSelections (datas) {
            if (datas.length > 0 && this.$refs.singleTable) {
                datas.forEach(item => {
                    if (item.selected) {
                        this.$refs.singleTable.setCheckboxRow(item.row, item.selected)
                    } else if (item.selected === false) {
                        this.$refs.singleTable.setCheckboxRow(item.row, false)
                    } else if (item.selected === undefined) {
                        this.$refs.singleTable.toggleCheckboxRow(item.row)
                    }
                })
                // 当选择项发生变化时会触发该事件
                const data = this.$refs.singleTable.getCheckboxRecords()
                this.$emit('selection-change', data)
            }
        },
        // 用于多选表格，切换所有行的选中状态
        toggleAllSelection (checked = true) {
            if (this.$refs.singleTable) {
                this.$refs.singleTable.setAllCheckboxRow(checked)
                // 当选择项发生变化时会触发该事件
                const data = this.$refs.singleTable.getCheckboxRecords()
                this.$emit('selection-change', data)
            } else {
                console.error('toggleAllSelection方法为找到，可能表格未加载完毕')
            }
        },
        // 用于多选表格，清空用户的选择
        clearSelection () {
            if (this.$refs.singleTable) {
                this.$refs.singleTable.clearCheckboxRow()
                // 当选择项发生变化时会触发该事件
                const data = this.$refs.singleTable.getCheckboxRecords()
                this.$emit('selection-change', data)
            } else {
                console.error('clearSelection方法为找到，可能表格未加载完毕')
            }
        },
        // 用于清空排序条件，数据会恢复成未排序的状态
        clearSort () {
            this.$refs.singleTable.clearSort()
        },
        // 不传入参数时用于清空所有过滤条件，数据会恢复成未过滤的状态
        clearFilter (columnKey) {
            this.$refs.singleTable.clearFilter(columnKey)
        },
        // 根据列明找出列
        getColumnByField (field) {
            return this.$refs.singleTable.getColumnByField(field)
        },
        // 手动对 Table 进行排序
        sort (prop, order) {
            this.$refs.singleTable.sort(prop, order)
        },
        // 对 Table 进行重新布局。当 Table 或其祖先元素由隐藏切换为显示时，可能需要调用此方法
        doLayout () {
            this.$refs.singleTable.recalculate()
        },
        // 让表格滚动条回到顶部，和左侧
        pagingScrollTopLeft (top = 0, left = 0) {
            this.$refs.singleTable.scrollTo(left, top)
        },
        // 则滚动到对应的行
        scrollToRow (row) {
            this.$refs.singleTable.scrollToRow(row)
        },
        // 设置表格数据
        reloadData (data) {
            return this.$refs.singleTable.reloadData(data)
        },
        loadData (data) {
            return this.$refs.singleTable.loadData(data)
        },
        // 设置列数据
        reloadColumn (data) {
            return this.$refs.singleTable.reloadColumn(data)
        },
        loadColumn (data) {
            return this.$refs.singleTable.loadColumn(data)
        },
        refreshColumn () {
            this.$refs.singleTable.refreshColumn()
        },
        // 激活编辑状态
        setActiveRow (row) {
            this.$refs.singleTable.setActiveRow(row)
        },
        // 激活单元格编辑
        setActiveCell (row, field) {
            this.$refs.singleTable.setActiveCell(row, field)
        },
        // 往表格插入临时数据（不支持树结构），从指定位置插入一行或多行；第二个参数：row 指定位置、null从第一行插入、-1 从最后插入
        insertRow (records, row) {
           return this.$refs.singleTable.insertAt(records, row)
        },
        // 用于 edit-config，获取插入的临时数据
        getInsertRecords () {
            return this.$refs.singleTable.getInsertRecords()
        },
        // 用于 type=checkbox，获取已选中的行数据
        getCheckboxRecords () {
           return this.$refs.singleTable.getCheckboxRecords()
        },
        // 获取表格数据集（获取插入）
        getRecordset () {
            const { insertRecords } = this.$refs.singleTable.getRecordset()
            return insertRecords
        },
        // 返回一个plx-table实例
        tableExample () {
            if (this.$refs.singleTable) {
                return this.$refs.singleTable
            }
        },
        // 获取表格列
        getTableColumn () {
            return this.$refs.singleTable.getTableColumn()
        },
        // 获取表格列对应的索引值
        getColumnIndex (column) {
            return this.$refs.singleTable.getColumnIndex(column)
        },
        // 更新列状态
        updateStatus (scope) {
            this.$refs.singleTable.updateStatus(scope)
        },
        // 删除指定行数据
        remove (rows) {
            this.$refs.singleTable.remove(rows)
        },
        // 删除复选框选中的行数据（不支持树结构）
        removeCheckboxRow () {
            this.$refs.singleTable.removeCheckboxRow()
        },
        // 获取已经修改的数据
        getUpdateRecords () {
            return this.$refs.singleTable.getUpdateRecords()
        },
        // 行数据是否改变
        isUpdateByRow (row) {
            return this.$refs.singleTable.isUpdateByRow(row)
        },
        // 判断复选框行数据是否被选中
        isCheckedByCheckboxRow (row) {
            return this.$refs.singleTable.isCheckedByCheckboxRow(row)
        },
        // 更新行数据
        reloadRow (rows, record, field) {
            return this.$refs.singleTable.reloadRow(rows, record, field)
        },
        // 行是否激活状态
        isActiveByRow (row) {
            return this.$refs.singleTable.isActiveByRow(row)
        },
        // 手动清除单元格激活状态
        clearActived () {
            return this.$refs.singleTable.clearActived()
        },
        //还原表格数据
        revertData (row) {
            return this.$refs.singleTable.revertData(row)
        },
        // 手动更新尾部
        updateFooter () {
            return this.$refs.singleTable.updateFooter()
        },
        // 用于 filters，修改筛选列表
        setFilter (column, options) {
           return this.$refs.singleTable.setFilter(column, options)
        },
        // 手动处理数据（对于手动更改了排序、筛选...等条件后需要重新处理数据时可能会用到）
        updateData () {
            return this.$refs.singleTable.updateData()
        },
        // 用于 type=expand，切换展开行的状态
        toggleRowExpand (row) {
            return this.$refs.singleTable.toggleRowExpand(row)
        },
        // 用于 expand-config，设置展开行，二个参数设置这一行展开与否
        setRowExpand (rows, checked) {
            return this.$refs.singleTable.setRowExpand(rows, checked)
        },
        // 用于 expand-config，设置所有行的展开与否（如果是关闭所有行，可以使用 clearRowExpand 快速清除）
        setAllRowExpand (checked) {
            return this.$refs.singleTable.setAllRowExpand(checked)
        },
        // 用于 type=expand，手动清空展开行状态，数据会恢复成未展开的状态
        clearRowExpand () {
            return this.$refs.singleTable.clearRowExpand()
        },
        // 展开所有
        setAllTreeExpand (checked) {
            return this.$refs.singleTable.setAllTreeExpand(checked)
        },
        // 关闭展开
        clearTreeExpand () {
            return this.$refs.singleTable.clearTreeExpand()
        },
        // 获取已展开
        getTreeExpandRecords () {
            return this.$refs.singleTable.getTreeExpandRecords()
        },
        // 切换展开树形节点的状态
        toggleTreeExpand (row) {
            return this.$refs.singleTable.toggleTreeExpand(row)
        },
        // 设置展开树形节点，二个参数设置这一行展开与否
        setTreeExpand (rows, checked) {
            return this.$refs.singleTable.setTreeExpand(rows, checked)
        },
        // 判断当前节点是否展开
        isTreeExpandByRow (row) {
            return this.$refs.singleTable.isTreeExpandByRow(row)
        },
        // 刷新滚动条
        refreshScroll () {
            this.$refs.singleTable.refreshScroll()
        },
        async validate (rows) {
            if (rows) {
                return await this.$refs.singleTable.validate(rows).catch(err=> err)
            } else {
                return await this.$refs.singleTable.validate().catch(err=> err)
            }
        },
        async fullValidate(rows) {
            if (rows) {
                return await this.$refs.singleTable.fullValidate(rows).catch(err=> err)
            } else {
                return await this.$refs.singleTable.fullValidate().catch(err=> err)
            }
        },
        clearValidate () {
            return this.$refs.singleTable.clearValidate()
        },
        // 获取表格数据
        getTableData () {
            return this.$refs.singleTable.getTableData()
        },
        getRowById (rowid) {
            return this.$refs.singleTable.getRowById(rowid)
        },


        // 表格事件

        // 表格滚动时会触发该事件
        tableBodyScroll ({type,fixed,scrollTop,scrollLeft,isX,isY, $event}) {
            let obj = {type,fixed,scrollTop,scrollLeft,isX,isY}
            // 当表格滚动暴露滚动事件
            this.$emit('table-body-scroll', obj, $event)
        },
        // 当用户手动勾选全选 Checkbox 时触发的事件	selection
        selectAll () {
            const data = this.$refs.singleTable.getCheckboxRecords()
            this.$emit('select-all', data)
            // 当选择项发生变化时会触发该事件
            this.$emit('selection-change', data)
        },
        // 当用户手动勾选数据行的 Checkbox 时触发的事件
        plSelect ({row}) {
            const data = this.$refs.singleTable.getCheckboxRecords()
            this.$emit('select', data, row)
            // 当选择项发生变化时会触发该事件
            this.$emit('selection-change', data)
        },
        // 只对 type=radio 有效，当手动勾选并且值发生改变时触发的事件
        radioChange ({row,rowIndex,$rowIndex,column,columnIndex,$columnIndex,cell}) {
            this.$emit('radio-change', row, column)
        },
        // 当表格的排序条件发生变化的时候会触发该事件
        sortChange ({column,property,order}) {
            let objs = {column, prop: property, order}
            this.$emit('sort-change', objs)
        },
        // 当表格的当前行发生变化的时候会触发该事件
        currentChange ({row}) {
            this.$emit('current-change', row)
        },
        // 当用户对某一行展开或者关闭的时候会触发该事件
        expChang ({ expanded, row, rowIndex, $rowIndex, column, columnIndex, $columnIndex, $event }) {
            this.$emit('expand-change', {expanded, row, rowIndex, $rowIndex, column, columnIndex, $columnIndex, $event})
        },
        // 当表格的筛选条件发生变化的时候会触发该事件
        filterChange ({ column, property, values, datas, filters, $event }) {
            this.$emit('filter-change', { column, property, values, datas, filters, $event })
        },
        // 当单元格 hover 进入时会触发该事件
        cellMouseEnter ({row,rowIndex,$rowIndex,column,columnIndex,$columnIndex,cell, $event}) {
            this.$emit('cell-mouse-enter', row, column, cell, $event)
        },
        // 当单元格 hover 退出时会触发该事件
        cellMouseLeave ({row,rowIndex,$rowIndex,column,columnIndex,$columnIndex,cell, $event}) {
            this.$emit('cell-mouse-leave', row, column, cell, $event)
        },
        // 当某个单元格被点击时会触发该事件
        cellClick ({row,rowIndex,$rowIndex,column,columnIndex,$columnIndex,cell, $event}) {
            this.$emit('cell-click', row, column, cell, $event)
            // row-click	当某一行被点击时会触发该事件	row, event, column
            // 只有当点击的单元格不是复选框才触发行事件！
            if (column.type !== 'checkbox') {
                this.$emit('row-click', row, column, $event)
            }
        },
        // 当某个单元格被双击击时会触发该事件
        cellDblclick ({row,rowIndex,$rowIndex,column,columnIndex,$columnIndex,cell, $event}) {
            this.$emit('cell-dblclick', row, column, cell, $event)
            // 当某一行被双击时会触发该事件
            this.$emit('row-dblclick', row, column, $event)
        },
        // 单元格被鼠标右键点击时触发该事件
        rowContextmenu ({type,row,rowIndex,column,columnIndex,cell, $event}) {
            this.$emit('row-contextmenu', row, column, $event)
        },
        // 当某一列的表头被点击时会触发该事件
        headerClick ({triggerResizable,triggerSort,triggerFilter,$rowIndex,column,columnIndex,$event}) {
            this.$emit('header-click', column, $event)
        },
        // 当某一列的表头被鼠标右键点击时触发该事件	column, $event
        headerContextmenu ({ type, column, columnIndex, $event }) {
            this.$emit('header-contextmenu', column, $event)
        },
        // 当拖动表头改变了列的宽度的时候会触发该事件(newWidth, oldWidth, column, $event)
        headerDragend ({$rowIndex, column, columnIndex, $columnIndex, fixed, isHidden, $event}) {
            let obj = {$rowIndex, column, columnIndex, $columnIndex, fixed, isHidden, $event}
            this.$emit('header-dragend', obj)
        },
        // 单元格编辑状态下被关闭时会触发该事件
        editClosed ({ row, rowIndex, $rowIndex, column, columnIndex, $columnIndex }) {
            this.$emit('edit-closed', { row, rowIndex, $rowIndex, column, columnIndex, $columnIndex })
        },
        // 单元格被激活编辑时会触发该事件
        editActived ({ row, rowIndex, $rowIndex, column, columnIndex, $columnIndex }) {
            this.$emit('edit-actived', { row, rowIndex, $rowIndex, column, columnIndex, $columnIndex })
        },
        editDisabled ({ row, rowIndex, $rowIndex, column, columnIndex, $columnIndex }) {
            this.$emit('edit-disabled', { row, rowIndex, $rowIndex, column, columnIndex, $columnIndex })
        },
        // 当树节点展开或收起时会触发该事件
        toggleTreeExpandEv (row) {
            this.$emit('toggle-tree-expand', row)
        },
        // 键盘按下事件
        keydown ({ $event }) {
            this.$emit('keydown', {$event})
        },
        // 当前被激活的单元格
        editCurrentlyActive ({row, column, cell}) {
            this.$emit('edit-currently-active', {row, column, cell})
        }
    },
}
