/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.base.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.device.base.manager.AppraiseInfoManager;
import com.artfess.device.base.model.AppraiseInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7ee9\u6548\u8003\u6838-\u8003\u6838\u60c5\u51b5"})
@RequestMapping(value={"/device/appraiseInfo/"})
@ApiGroup(group={"device_biz"})
public class AppraiseInfoController
extends BaseController<AppraiseInfoManager, AppraiseInfo> {
    private static final Logger log = LoggerFactory.getLogger(AppraiseInfoController.class);

    @PutMapping(value={"/closeInfo"})
    @ApiOperation(value="\u53d8\u66f4\u7ed3\u7b97\u72b6\u6001")
    public CommonResult<String> closeInfo(@ApiParam(name="infoId", value="\u8003\u6838\u60c5\u51b5ID") @RequestBody @Validated(value={UpdateGroup.class}) String infoId) {
        boolean result = ((AppraiseInfoManager)this.baseService).closeInfo(infoId);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u53d8\u66f4\u7ed3\u7b97\u72b6\u6001\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/getExaminees"})
    @ApiOperation(value="\u83b7\u53d6\u88ab\u8003\u6838\u8005\u5217\u8868", notes="\u4f20\u5165\u7c7b\u578b\u3001\u5e74\u4efd\u3001\u6807\u9898 \u83b7\u53d6\u6ca1\u6709\u8003\u6838\u8fc7\u8be5\u9879\u8003\u6838\u7684\u8003\u6838\u5bf9\u8c61\u5217\u8868")
    public CommonResult<List<String>> getExaminees(@ApiParam(name="infoId", value="\u8003\u6838\u60c5\u51b5ID") @RequestBody AppraiseInfo dto) {
        List<String> result = ((AppraiseInfoManager)this.baseService).getExaminees(dto);
        return new CommonResult(true, "", result);
    }
}

