/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.manager.impl;

import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.bpm.persistence.dao.BpmDefAuthorizeDao;
import com.artfess.bpm.persistence.manager.BpmDefActManager;
import com.artfess.bpm.persistence.manager.BpmDefAuthorizeManager;
import com.artfess.bpm.persistence.manager.BpmDefAuthorizeTypeManager;
import com.artfess.bpm.persistence.manager.BpmDefUserManager;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.manager.BpmSecretaryManageManager;
import com.artfess.bpm.persistence.manager.CurrentUserService;
import com.artfess.bpm.persistence.model.AuthorizeRight;
import com.artfess.bpm.persistence.model.BpmDefAct;
import com.artfess.bpm.persistence.model.BpmDefAuthorize;
import com.artfess.bpm.persistence.model.BpmDefAuthorizeType;
import com.artfess.bpm.persistence.model.BpmDefUser;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BpmDefAuthorizeManagerImpl
extends BaseManagerImpl<BpmDefAuthorizeDao, BpmDefAuthorize>
implements BpmDefAuthorizeManager {
    @Resource
    private BpmDefUserManager bpmDefUserManager;
    @Resource
    private BpmDefActManager bpmDefActManager;
    @Resource
    private BpmDefAuthorizeTypeManager bpmDefAuthorizeTypeManager;
    @Resource
    private BpmDefAuthorizeManager bpmDefAuthorizeManager;
    @Resource
    private BpmDefinitionManager defaultBpmDefinitionManager;
    @Resource(name="bpmCurrentUserService")
    private CurrentUserService currentUserService;
    @Resource
    private BpmDefinitionManager bpmDefinitionManager;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    BpmSecretaryManageManager bpmSecretaryManageManager;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;

    @Override
    public PageList<BpmDefAuthorize> getAuthorizeListByFilter(QueryFilter queryFilter) {
        PageList list = this.query(queryFilter);
        return list;
    }

    @Override
    public BpmDefAuthorize getAuthorizeById(String id) {
        BpmDefAuthorize bpmDefAuthorize = this.getAuthorizeById(id, true);
        return bpmDefAuthorize;
    }

    @Override
    public BpmDefAuthorize getAuthorizeById(String id, boolean isNeedjson) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("authorizeId", id);
        params.put("objType", "bpmDef");
        BpmDefAuthorize bpmDefAuthorize = (BpmDefAuthorize)this.bpmDefAuthorizeManager.get((Serializable)((Object)id));
        List<BpmDefAuthorizeType> bpmDefAuthorizeTypeList = this.bpmDefAuthorizeTypeManager.getAll(params);
        bpmDefAuthorize.setBpmDefAuthorizeTypeList(bpmDefAuthorizeTypeList);
        List<BpmDefUser> bpmDefUserList = this.bpmDefUserManager.getAll(params);
        bpmDefAuthorize.setBpmDefUserList(bpmDefUserList);
        List<BpmDefAct> bpmDefActList = this.bpmDefActManager.getAll(params);
        bpmDefAuthorize.setBpmDefActList(bpmDefActList);
        if (isNeedjson) {
            String ownerNameJson = this.toOwnerNameJson(bpmDefUserList);
            bpmDefAuthorize.setOwnerNameJson(ownerNameJson);
            String multipe = bpmDefAuthorize.getMultiple();
            String defNameJson = this.toDefNameJson(bpmDefActList);
            if ("1".equals(multipe)) {
                bpmDefAuthorize.setDefNameJson(defNameJson);
            }
            if ("2".equals(multipe)) {
                bpmDefAuthorize.setDefAllNameJson(defNameJson);
            }
        }
        return bpmDefAuthorize;
    }

    @Override
    @Transactional
    public void deleteAuthorizeByIds(String[] lAryId) {
        for (String id : lAryId) {
            this.bpmDefAuthorizeManager.remove((Serializable)((Object)id));
            this.bpmDefAuthorizeTypeManager.delByAuthorizeId(id);
            this.bpmDefUserManager.delByAuthorizeId(id, "bpmDef");
            this.bpmDefActManager.delByAuthorizeId(id);
        }
    }

    @Override
    @Transactional
    public String saveOrUpdateAuthorize(BpmDefAuthorize bpmDefAuthorize) throws IOException {
        String authorizeId = bpmDefAuthorize.getId();
        if (StringUtil.isNotEmpty((String)authorizeId)) {
            this.bpmDefAuthorizeManager.update((Model)bpmDefAuthorize);
            this.bpmDefAuthorizeTypeManager.delByAuthorizeId(authorizeId);
            this.bpmDefUserManager.delByAuthorizeId(authorizeId, "bpmDef");
            this.bpmDefActManager.delByAuthorizeId(authorizeId);
        } else {
            authorizeId = UniqueIdUtil.getSuid();
            bpmDefAuthorize.setId(authorizeId);
            this.bpmDefAuthorizeManager.create((Model)bpmDefAuthorize);
        }
        String authorizeTypes = bpmDefAuthorize.getAuthorizeTypes();
        List<BpmDefAuthorizeType> bpmDefAuthorizeTypeList = this.toBpmDefAuthorizeTypeList(authorizeTypes, authorizeId);
        for (BpmDefAuthorizeType bpmDefAuthorizeType : bpmDefAuthorizeTypeList) {
            this.bpmDefAuthorizeTypeManager.create((Model)bpmDefAuthorizeType);
        }
        String myOwnerNameJson = bpmDefAuthorize.getOwnerNameJson();
        List<BpmDefUser> bpmDefUserList = this.toBpmDefUserList(myOwnerNameJson, authorizeId);
        for (BpmDefUser bpmDefUser : bpmDefUserList) {
            bpmDefUser.setObjType("bpmDef");
            this.bpmDefUserManager.create((Model)bpmDefUser);
        }
        String myDefNameJson = "";
        if (bpmDefAuthorize.getMultiple().equals("1")) {
            myDefNameJson = bpmDefAuthorize.getDefNameJson();
        }
        if (bpmDefAuthorize.getMultiple().equals("2")) {
            myDefNameJson = bpmDefAuthorize.getDefAllNameJson();
        }
        List<BpmDefAct> bpmDefActList = this.toBpmDefActList(myDefNameJson, authorizeId);
        for (BpmDefAct bpmDefAct : bpmDefActList) {
            bpmDefAct.setType(bpmDefAuthorize.getMultiple());
            this.bpmDefActManager.create((Model)bpmDefAct);
        }
        return authorizeId;
    }

    private List<BpmDefAuthorizeType> toBpmDefAuthorizeTypeList(String authorizeTypes, String authorizeId) throws IOException {
        ArrayList<BpmDefAuthorizeType> authTypeList = new ArrayList<BpmDefAuthorizeType>();
        if (StringUtil.isEmpty((String)authorizeTypes)) {
            return authTypeList;
        }
        ObjectNode jsonObject = (ObjectNode)JsonUtil.toJsonNode((String)authorizeTypes);
        Iterator fields = jsonObject.fields();
        while (fields.hasNext()) {
            Map.Entry ent = (Map.Entry)fields.next();
            boolean blnSet = ((JsonNode)ent.getValue()).asBoolean();
            if (!blnSet) continue;
            BpmDefAuthorizeType authType = new BpmDefAuthorizeType();
            authType.setId(UniqueIdUtil.getSuid());
            authType.setAuthorizeId(authorizeId);
            authType.setAuthorizeType((String)ent.getKey());
            authTypeList.add(authType);
        }
        return authTypeList;
    }

    private String toOwnerNameJson(List<BpmDefUser> bpmDefUsers) {
        if (BeanUtils.isEmpty(bpmDefUsers)) {
            return "[]";
        }
        HashMap map = new HashMap();
        Map<String, String> userTypeMap = this.currentUserService.getUserTypeMap(CurrentUserService.DEFAULT_OBJECT_RIGHTTYPE_BEAN);
        for (BpmDefUser user : bpmDefUsers) {
            List<BpmDefUser> list;
            String string = user.getRightType();
            if (map.containsKey(string)) {
                list = (List)map.get(string);
                list.add(user);
                continue;
            }
            list = new ArrayList();
            list.add(user);
            map.put(string, list);
        }
        ArrayNode jsonArray = JsonUtil.getMapper().createArrayNode();
        for (Map.Entry<String, List<BpmDefUser>> entry : map.entrySet()) {
            ObjectNode json = this.userEntToJson(entry, userTypeMap);
            jsonArray.add((JsonNode)json);
        }
        return jsonArray.toString();
    }

    private ObjectNode userEntToJson(Map.Entry<String, List<BpmDefUser>> entry, Map<String, String> userTypeMap) {
        ObjectNode jsonObj = JsonUtil.getMapper().createObjectNode();
        String type = entry.getKey();
        String title = userTypeMap.get(type);
        jsonObj.put("type", type);
        jsonObj.put("title", title);
        if (type.equals("everyone")) {
            return jsonObj;
        }
        List<BpmDefUser> list = entry.getValue();
        String ids = "";
        String names = "";
        String authOrg = "";
        String authOrgName = "";
        for (int i = 0; i < list.size(); ++i) {
            BpmDefUser user = list.get(i);
            if (i == 0) {
                ids = ids + user.getOwnerId();
                names = names + user.getOwnerName();
            } else {
                ids = ids + "," + user.getOwnerId();
                names = names + "," + user.getOwnerName();
            }
            authOrg = user.getAuthOrg();
            authOrgName = user.getAuthOrgName();
        }
        jsonObj.put("id", ids);
        jsonObj.put("name", names);
        jsonObj.put("authOrg", authOrg);
        jsonObj.put("authOrgName", authOrgName);
        return jsonObj;
    }

    private List<BpmDefUser> toBpmDefUserList(String ownNameJson, String authorizeId) throws IOException {
        ArrayList<BpmDefUser> userList = new ArrayList<BpmDefUser>();
        if (StringUtil.isEmpty((String)ownNameJson)) {
            return userList;
        }
        ArrayNode aryJson = (ArrayNode)JsonUtil.toJsonNode((String)ownNameJson);
        for (Object obj : aryJson) {
            ObjectNode jsonObject = (ObjectNode)obj;
            List<BpmDefUser> list = this.getList(jsonObject, authorizeId);
            userList.addAll(list);
        }
        return userList;
    }

    private List<BpmDefUser> getList(ObjectNode json, String authorizeId) {
        ArrayList<BpmDefUser> bpmDefUsers = new ArrayList<BpmDefUser>();
        String type = json.get("type").asText();
        String authOrg = "";
        String authOrgName = "";
        if (BeanUtils.isNotEmpty((Object)json.get("authOrg"))) {
            authOrg = json.get("authOrg").asText();
        }
        if (BeanUtils.isNotEmpty((Object)json.get("authOrgName"))) {
            authOrgName = json.get("authOrgName").asText();
        }
        if ("everyone".equals(type)) {
            BpmDefUser defUser = new BpmDefUser();
            defUser.setId(UniqueIdUtil.getSuid());
            defUser.setAuthorizeId(authorizeId);
            defUser.setRightType(type);
            defUser.setAuthOrg(authOrg);
            defUser.setAuthOrgName(authOrgName);
            bpmDefUsers.add(defUser);
        } else {
            String ids = json.get("id").asText();
            String names = json.get("name").asText();
            String[] aryId = ids.split(",");
            String[] aryName = names.split(",");
            for (int i = 0; i < aryId.length; ++i) {
                BpmDefUser defUser = new BpmDefUser();
                defUser.setId(UniqueIdUtil.getSuid());
                defUser.setAuthorizeId(authorizeId);
                defUser.setRightType(type);
                defUser.setOwnerId(aryId[i]);
                defUser.setOwnerName(aryName[i]);
                defUser.setAuthOrg(authOrg);
                defUser.setAuthOrgName(authOrgName);
                bpmDefUsers.add(defUser);
            }
        }
        return bpmDefUsers;
    }

    public String toDefNameJson(List<BpmDefAct> defActList) {
        if (BeanUtils.isEmpty(defActList)) {
            return "[]";
        }
        ArrayNode jsonArray = JsonUtil.getMapper().createArrayNode();
        HashMap<String, String> sysTypeMap = null;
        for (BpmDefAct act : defActList) {
            ObjectNode jsonObj = JsonUtil.getMapper().createObjectNode();
            jsonObj.put("defKey", act.getDefKey());
            jsonObj.put("defName", act.getDefName());
            if ("1".equals(act.getType())) {
                DefaultBpmDefinition definition = this.defaultBpmDefinitionManager.getMainByDefKey(act.getDefKey(), false);
                if (BeanUtils.isNotEmpty((Object)definition)) {
                    jsonObj.put("defName", definition.getName());
                }
            } else {
                if (sysTypeMap == null) {
                    SystemConfigFeignService service = (SystemConfigFeignService)AppUtil.getBean(SystemConfigFeignService.class);
                    QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
                    queryFilter.addFilter("type_group_key_", (Object)"FLOW_TYPE", QueryOP.EQUAL);
                    ObjectNode allFlowType = service.getAllSysType(queryFilter);
                    sysTypeMap = new HashMap<String, String>();
                    if (BeanUtils.isNotEmpty((Object)allFlowType) && BeanUtils.isNotEmpty((Object)allFlowType.get("rows"))) {
                        for (JsonNode jsonNode : allFlowType.get("rows")) {
                            sysTypeMap.put(jsonNode.get("id").asText(), jsonNode.get("name").asText());
                        }
                    }
                }
                if (BeanUtils.isNotEmpty(sysTypeMap.get(act.getDefKey()))) {
                    jsonObj.put("defName", (String)sysTypeMap.get(act.getDefKey()));
                }
            }
            jsonObj.put("right", act.getRightContent());
            jsonArray.add((JsonNode)jsonObj);
        }
        return jsonArray.toString();
    }

    private List<BpmDefAct> toBpmDefActList(String defNameJson, String authorizeId) throws IOException {
        ArrayList<BpmDefAct> myBpmDefActList = new ArrayList<BpmDefAct>();
        if (StringUtil.isEmpty((String)defNameJson)) {
            return myBpmDefActList;
        }
        ArrayNode myJsonArray = (ArrayNode)JsonUtil.toJsonNode((String)defNameJson);
        for (int i = 0; i < myJsonArray.size(); ++i) {
            ObjectNode jsonObject = (ObjectNode)myJsonArray.get(i);
            BpmDefAct bpmDefAct = new BpmDefAct();
            String defKey = jsonObject.get("defKey").asText();
            bpmDefAct.setDefKey(defKey);
            String defName = jsonObject.get("defName").asText();
            bpmDefAct.setDefName(defName);
            String rightContent = JsonUtil.toJson((Object)jsonObject.get("right"));
            bpmDefAct.setRightContent(rightContent);
            bpmDefAct.setId(UniqueIdUtil.getSuid());
            bpmDefAct.setAuthorizeId(authorizeId);
            myBpmDefActList.add(bpmDefAct);
        }
        return myBpmDefActList;
    }

    @Override
    public Map<String, Object> getActRightByUserId(String userId, String authorizeType, boolean isRight, boolean isMyDef) throws IOException {
        Map<String, Set<String>> userRightMap = this.currentUserService.getUserRightMap();
        Map<String, String> userRightMapStr = this.currentUserService.getMapStringByMayList(userRightMap);
        return this.getActRightByRightMapAndUserId(userId, authorizeType, isRight, isMyDef, userRightMapStr);
    }

    @Override
    public Map<String, Object> getActRightByRightMapAndUserId(String userId, String authorizeType, boolean isRight, boolean isMyDef, Map<String, String> userRightMapStr) throws IOException {
        List<BpmDefAct> list;
        List<String> myDefKeys;
        String defKeys = "";
        HashMap<String, ObjectNode> authorizeRightMap = new HashMap<String, ObjectNode>();
        if (isMyDef && (myDefKeys = this.defaultBpmDefinitionManager.queryByCreateBy(userId)) != null && myDefKeys.size() > 0) {
            for (String defKey : myDefKeys) {
                defKeys = defKeys + "'" + defKey + "',";
                if (!isRight) continue;
                authorizeRightMap.put(defKey, AuthorizeRight.getCreateRight());
            }
        }
        if ((list = this.bpmDefActManager.getActRightByUserMap(userRightMapStr, authorizeType, null)).size() > 0) {
            for (BpmDefAct bpmDefAct : list) {
                String type = bpmDefAct.getType();
                String defKey = "";
                String rightContent = "";
                ObjectNode authorizeRight = null;
                if (type.equals("1")) {
                    defKey = bpmDefAct.getDefKey();
                    defKeys = defKeys + "'" + defKey + "',";
                    if (!isRight) continue;
                    rightContent = bpmDefAct.getRightContent();
                    authorizeRight = (ObjectNode)authorizeRightMap.get(defKey);
                    if (authorizeRight != null) {
                        AuthorizeRight.mergeJson(authorizeRight, rightContent);
                    } else {
                        authorizeRight = (ObjectNode)JsonUtil.toJsonNode((String)rightContent);
                        authorizeRightMap.put(defKey, authorizeRight);
                    }
                }
                if (!type.equals("2")) continue;
                List<String> typeIds = Arrays.asList(bpmDefAct.getDefKey());
                List<String> typeDefKeys = this.defaultBpmDefinitionManager.queryByTypeId(typeIds);
                if (typeDefKeys != null && typeDefKeys.size() > 0) {
                    for (String def : typeDefKeys) {
                        if (!isRight) continue;
                        rightContent = bpmDefAct.getRightContent();
                        authorizeRight = (ObjectNode)authorizeRightMap.get(def);
                        if (authorizeRight != null) {
                            AuthorizeRight.mergeJson(authorizeRight, rightContent);
                        } else {
                            authorizeRight = (ObjectNode)JsonUtil.toJsonNode((String)rightContent);
                            authorizeRightMap.put(def, authorizeRight);
                        }
                        defKey = defKey + "'" + def + "',";
                    }
                }
                if (!StringUtil.isNotEmpty((String)defKey)) continue;
                defKeys = defKeys + defKey;
            }
        }
        if (StringUtil.isNotEmpty((String)defKeys)) {
            defKeys = defKeys.substring(0, defKeys.length() - 1);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("defKeys", defKeys);
        resultMap.put("authorizeRightMap", authorizeRightMap);
        return resultMap;
    }

    @Override
    public ObjectNode getRight(String flowKey, String authorizeType) throws IOException {
        Map<String, Set<String>> userRightMap = this.currentUserService.getUserRightMap();
        Map<String, String> userRightMapStr = this.currentUserService.getMapStringByMayList(userRightMap);
        ObjectNode resultJson = null;
        List<BpmDefAct> list = this.bpmDefActManager.getActRightByUserMap(userRightMapStr, authorizeType, flowKey);
        if (BeanUtils.isEmpty(list)) {
            return null;
        }
        for (BpmDefAct bpmDefAct : list) {
            String rightContent = bpmDefAct.getRightContent();
            if (resultJson != null) {
                AuthorizeRight.mergeJson(resultJson, rightContent);
                continue;
            }
            resultJson = (ObjectNode)JsonUtil.toJsonNode((String)rightContent);
        }
        return resultJson;
    }

    @Override
    public Boolean getStartRightByUserIdAndDefId(String userId, String defId, String leadId, String instId) throws Exception {
        if (StringUtil.isNotEmpty((String)instId)) {
            DefaultBpmProcessInstance byBpmnInstId = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
            if (BeanUtils.isEmpty((Object)byBpmnInstId)) {
                return false;
            }
            String createBy = byBpmnInstId.getCreateBy();
            return createBy.equals(userId) || createBy.equals(leadId);
        }
        DefaultBpmDefinition defaultBpmDefinition = this.bpmDefinitionManager.getById(defId);
        String defKey = defaultBpmDefinition.getDefKey();
        if (StringUtil.isNotEmpty((String)leadId) && !leadId.equals("0")) {
            Map<String, Set<String>> shareDefsBySecretaryId = this.bpmSecretaryManageManager.getShareDefsBySecretaryId(userId, "1");
            Set<String> set = shareDefsBySecretaryId.get(leadId);
            for (String string : set) {
                if (!defKey.equals(string)) continue;
                return true;
            }
            return false;
        }
        String bpmDefAuthorizeRightType = "start";
        Map<String, Object> actRightMap = this.bpmDefAuthorizeManager.getActRightByUserId(userId, bpmDefAuthorizeRightType, true, true);
        Map map = (Map)actRightMap.get("authorizeRightMap");
        if (BeanUtils.isNotEmpty((Object)map) && BeanUtils.isNotEmpty(map.get(defaultBpmDefinition.getDefKey()))) {
            return true;
        }
        return false;
    }

    private boolean isIdInList(String id, String ids) {
        if (StringUtil.isEmpty((String)id) || StringUtil.isEmpty((String)ids)) {
            return false;
        }
        if (id.equals(ids)) {
            return true;
        }
        for (String id1 : ids.split(",")) {
            if (!id1.equals(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IPage getAuthDetailPage(QueryFilter queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage convert2iPage = this.convert2IPage(pageBean);
        return ((BpmDefAuthorizeDao)this.baseMapper).getAuthDetailPage((IPage<BpmDefAuthorize>)convert2iPage, (Wrapper<BpmDefAuthorize>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }
}

