/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.AreaLevelEnum;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.sysConfig.persistence.manager.SysAreasManager;
import com.artfess.sysConfig.persistence.model.SysAreas;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/sysAreas/v1"})
@Api(tags={"\u884c\u653f\u533a\u5212"})
@ApiGroup(group={"group_system"})
public class SysAreasController
extends BaseController<SysAreasManager, SysAreas> {
    @Resource
    SysAreasManager sysAreasManager;

    @PostMapping(value={"slicedQuerySysAreas"})
    @ApiOperation(value="\u884c\u653f\u533a\u5212\u5206\u9875\u67e5\u8be2", httpMethod="POST", notes="\u884c\u653f\u533a\u5212\u5206\u9875\u67e5\u8be2")
    public PageList<SysAreas> slicedQueryActuator(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysAreas> queryFilter) throws Exception {
        return this.sysAreasManager.query(queryFilter);
    }

    @RequestMapping(value={"querySysAreas"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e0d\u5206\u9875\u67e5\u8be2\u884c\u653f\u533a\u5212", httpMethod="POST", notes="\u4e0d\u5206\u9875\u67e5\u8be2\u884c\u653f\u533a\u5212")
    public List<SysAreas> queryActuator(@ApiParam(name="sysAreas", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody SysAreas sysAreas) throws Exception {
        return this.sysAreasManager.queryAreasEntity(sysAreas);
    }

    @RequestMapping(value={"saveSysAreas"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u884c\u653f\u533a\u5212\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u884c\u653f\u533a\u5212\u4fe1\u606f")
    public CommonResult<String> saveSysAreas(@ApiParam(name="sysAreas", value="\u884c\u653f\u533a\u5212\u5bf9\u8c61") @RequestBody SysAreas sysAreas) throws Exception {
        String msg = this.sysAreasManager.saveSysAreas(sysAreas);
        return new CommonResult(true, msg);
    }

    @RequestMapping(value={"updateSequence"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u6392\u5e8f\u53f7", httpMethod="POST", notes="\u6279\u91cf\u4fee\u6539\u6392\u5e8f\u53f7")
    public CommonResult<String> updateSequence(@ApiParam(name="params", value="\u6392\u5e8f\u53c2\u6570\uff1aKey\uff1aID\uff0cValue\uff1a\u6392\u5e8f\u53f7") @RequestBody HashMap<String, Integer> params) throws Exception {
        this.sysAreasManager.updateSequence(params);
        return new CommonResult(true, "\u6392\u5e8f\u5b8c\u6210");
    }

    @RequestMapping(value={"deleteBatch"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", httpMethod="POST", notes="\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteBatch(@ApiParam(name="ids", value="Id\u96c6\u5408\uff0c\u4ee5,\u9694\u5f00") @RequestParam String ids) throws Exception {
        this.sysAreasManager.deleteBatch(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"townTree"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4e61\u9547\u4e0b\u62c9\u6811", httpMethod="POST", notes="\u83b7\u53d6\u4e61\u9547\u4e0b\u62c9\u6811")
    public CommonResult<String> townTree(@ApiParam(name="sysAreas", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody SysAreas sysAreas) throws Exception {
        sysAreas.setLevels(AreaLevelEnum.townLevels());
        List array = ((SysAreasManager)this.baseService).tree(sysAreas);
        return CommonResult.success((Object)array, (String)"");
    }
}

