/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.webSocket;

import cn.hutool.json.JSONUtil;
import com.artfess.base.conf.NettyConfig;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DateUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.webSocket.WebScoketMsg;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ChannelHandler.Sharable
public class WebSocketHandler
extends SimpleChannelInboundHandler<TextWebSocketFrame> {
    private static final Logger log = LoggerFactory.getLogger(WebSocketHandler.class);
    public static int online;
    private WebSocketServerHandshaker handshaker;

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        log.info("\u3010webSocket\u3011\uff1ahandlerAdded \u88ab\u8c03\u7528" + ctx.channel().id().asLongText());
        NettyConfig.getChannelGroup().add((Object)ctx.channel());
        online = NettyConfig.getChannelGroup().size();
        log.info("\u3010webSocket\u3011\uff1a" + ctx.channel().remoteAddress() + "\u4e0a\u7ebf\u4e86!");
        log.info("\u3010webSocket\u3011\uff1a========\u4e0a\u7ebf\u7ebf\uff1a\u5728\u7ebf\u4eba\u6570\uff1a" + online + "!========");
        ctx.channel().id();
        log.info("\u3010webSocket\u3011\uff1a========" + ctx.channel().id() + "!========");
    }

    protected void channelRead0(ChannelHandlerContext ctx, TextWebSocketFrame frame) throws Exception {
        String jsrAccounts;
        String message;
        TextWebSocketFrame txFrame = frame;
        log.info("\u3010webSocket\u3011\uff1a\u670d\u52a1\u5668\u63a5\u6536\u5230\uff1a{}", (Object)("\u6765\u81ea\uff1a\u3010" + ctx.channel().remoteAddress() + "\u3011 \u7684\u6570\u636e\uff1a" + txFrame.text()));
        WebScoketMsg msgContent = (WebScoketMsg)JSONUtil.toBean((String)txFrame.text(), WebScoketMsg.class);
        String messageType = msgContent.getMessageType().toString();
        String account = msgContent.getSender();
        if (StringUtil.isNotEmpty(account)) {
            Set<ChannelId> channelIdList = NettyConfig.getUserChanIdMap().get(account);
            if (BeanUtils.isNotEmpty(channelIdList)) {
                channelIdList.add(ctx.channel().id());
            } else {
                channelIdList = new LinkedHashSet<ChannelId>();
                channelIdList.add(ctx.channel().id());
                NettyConfig.getUserChanIdMap().put(account, channelIdList);
            }
        }
        if (messageType.equals("ping")) {
            message = msgContent.getMessage();
            String id = ctx.channel().id().asShortText();
            if (StringUtil.isNotEmpty(message) && StringUtil.isNotEmpty(id)) {
                NettyConfig.getSubroutineChanIdMap().put(id, message);
            }
            ObjectNode obj = JsonUtil.getMapper().createObjectNode();
            obj.put("msgTxt", "\u5fc3\u8df3\u54cd\u5e94\u65f6\u95f4\uff1a" + DateUtils.now());
            ctx.channel().writeAndFlush((Object)new TextWebSocketFrame(obj.toString()));
        } else if (messageType.equals("topic")) {
            message = msgContent.getMessage();
            NettyConfig.getChannelGroup().writeAndFlush((Object)new TextWebSocketFrame(message));
        } else if (messageType.equals("msg") && StringUtil.isNotEmpty(jsrAccounts = msgContent.getReceiver())) {
            String[] accountStr;
            for (String jsraccount : accountStr = jsrAccounts.split(",")) {
                Set<ChannelId> channelIdList = NettyConfig.getUserChanIdMap().get(jsraccount);
                if (!BeanUtils.isNotEmpty(channelIdList)) continue;
                for (ChannelId chanId : channelIdList) {
                    Channel userChannel = NettyConfig.getChannelGroup().find(chanId);
                    if (userChannel == null) continue;
                    userChannel.writeAndFlush((Object)new TextWebSocketFrame(msgContent.getMessage()));
                }
            }
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        log.trace("\u3010webSocket\u3011\uff1ahandlerRemoved \u88ab\u8c03\u7528" + ctx.channel().id().asLongText());
        NettyConfig.getChannelGroup().remove((Object)ctx.channel());
        online = NettyConfig.getChannelGroup().size();
        this.removeUserId(ctx);
        log.trace("\u3010webSocket\u3011\uff1a========\u4e0b\u7ebf\uff1a\u5728\u7ebf\u4eba\u6570\uff1a" + online + "!========");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("\u3010webSocket\u3011\uff1a\u5f02\u5e38\uff1a{}", (Object)cause.getMessage(), (Object)cause);
        NettyConfig.getChannelGroup().remove((Object)ctx.channel());
        this.removeUserId(ctx);
        ctx.close();
    }

    private void removeUserId(ChannelHandlerContext ctx) {
        AttributeKey key = AttributeKey.valueOf((String)"account");
        String account = (String)ctx.channel().attr(key).get();
        if (StringUtil.isNotEmpty(account)) {
            Set<ChannelId> channelIdList = NettyConfig.getUserChanIdMap().get(account);
            if (BeanUtils.isNotEmpty(channelIdList)) {
                channelIdList.remove(ctx.channel().id());
            }
            if (channelIdList.size() == 0) {
                NettyConfig.getUserChanIdMap().remove(account);
            }
        }
        NettyConfig.getSubroutineChanIdMap().remove(ctx.channel().id().asShortText());
        log.info("\u3010webSocket\u3011\uff1a" + ctx.channel().remoteAddress() + "\u65ad\u5f00\u8fde\u63a5!");
    }

    public void sendUserNotLoginMsg(ChannelHandlerContext ctx) {
        ChannelFuture future = ctx.writeAndFlush((Object)new CloseWebSocketFrame(WebSocketCloseStatus.POLICY_VIOLATION, "\u672a\u767b\u5f55\uff01"));
        future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }
}

